/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.function.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.function.GetCurrUserId;
import kd.bos.entity.function.RemoveTailZero;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprList;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.FunDef;
import kd.bos.formula.excel.MapExecuteContext;
import kd.bos.formula.excel.NamedExpr;
import kd.bos.formula.excel.Paren;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.functions.Avg;
import kd.bos.formula.functions.Count;
import kd.bos.formula.functions.Max;
import kd.bos.formula.functions.Min;
import kd.bos.formula.functions.Sum;
import kd.bos.ksql.util.LRUCacheMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.function.helper.HRFunctionCacheEntity;
import kd.hr.hbp.business.service.formula.cal.FormulaAnalysis;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.ScopeTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HRFunctionHelper {
    private static final Log logger = LogFactory.getLog(HRFunctionHelper.class);
    private static final Map<String, Set<String>> traceExprMap = new LRUCacheMap(1024, 0.75f);
    private static HashMap<String, UDFunction> mapFunc = Maps.newHashMapWithExpectedSize((int)16);
    private static final HRBaseServiceHelper HRCS_FUNCTION_TYPE_HELPER = HRBaseServiceHelper.create("hrcs_functiontype");
    private static final HRBaseServiceHelper HRCS_FUNCTION_HELPER = new HRBaseServiceHelper("hrcs_function");
    private static final HRBaseServiceHelper APP_HELPER = new HRBaseServiceHelper("bos_devportal_bizapp");
    private static Set<String> platformFunctions = Sets.newHashSetWithExpectedSize((int)16);
    private static Map<String, HRFunctionCacheEntity> defineFunctions = Maps.newHashMapWithExpectedSize((int)16);
    private static final long FUNC_CACHE_TIME_OUT = 1800000L;

    public static HashMap<String, UDFunction> getMapFunc() {
        return mapFunc;
    }

    public static void initFunction(Set<String> funcNameSet, String ctxPre) throws Exception {
        if (funcNameSet == null || funcNameSet.size() == 0) {
            return;
        }
        Set<Object> funcNames = Sets.newHashSetWithExpectedSize((int)16);
        funcNames.addAll(funcNameSet);
        funcNames = funcNames.stream().filter(funcName -> !platformFunctions.contains(funcName.toUpperCase(Locale.ROOT))).collect(Collectors.toSet());
        if (funcNames.size() == 0) {
            return;
        }
        if ((funcNames = funcNames.stream().filter(funcName -> {
            HRFunctionCacheEntity cacheEntity = defineFunctions.get(ctxPre + funcName);
            if (cacheEntity == null) {
                return Boolean.TRUE;
            }
            if (System.currentTimeMillis() - 1800000L < cacheEntity.getCurrentTimeMillis()) {
                cacheEntity.setCurrentTimeMillis(System.currentTimeMillis());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }).collect(Collectors.toSet())).size() == 0) {
            return;
        }
        DynamicObject[] dynamicObjects = HRFunctionHelper.getFunctionArrayByFuncKeys(funcNames);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject func : dynamicObjects) {
            String funcExp = func.getString("funcexp");
            if (StringUtils.isEmpty((CharSequence)funcExp)) continue;
            String funcExpSha = FormulaAnalysis.shaStr(func.getString("funcexp"));
            if (defineFunctions.values().stream().anyMatch(defineFunction -> funcExpSha.equals(defineFunction.getFuncExpSha()))) continue;
            FunctionItem functionItem = FunctionItem.buildFunctionItem(func);
            functionItem.setDefine(ctxPre + functionItem.getDefine());
            UDFunction udFunction = FormulaAnalysis.getFunctionExecuteInstance(functionItem);
            mapFunc.put(udFunction.getName(), udFunction);
            defineFunctions.put(ctxPre + udFunction.getName(), new HRFunctionCacheEntity(ctxPre + udFunction.getName(), funcExpSha, System.currentTimeMillis()));
        }
    }

    public static Object executeFunction(String fcExecuteCode, Map<String, Object> params) throws Exception {
        if (StringUtils.isEmpty((CharSequence)fcExecuteCode)) {
            throw new KDBizException("fcExecuteCode isEmpty");
        }
        Expr expr = ExprParser.parse((String)fcExecuteCode);
        return HRFunctionHelper.executeFunction(fcExecuteCode, expr, params);
    }

    public static Object executeFunction(String fcExecuteCode, Expr expr, Map<String, Object> params) throws Exception {
        if (expr == null) {
            throw new KDBizException("expr isEmpty");
        }
        MapExecuteContext contextLocal = params != null ? new MapExecuteContext(params) : new MapExecuteContext();
        HashSet funcNames = null;
        RequestContext ctx = RequestContext.get();
        String ctxPre = ctx.getTenantId() + ctx.getAccountId();
        funcNames = traceExprMap.get(ctx.getTraceId() + fcExecuteCode);
        if (funcNames == null) {
            funcNames = Sets.newHashSetWithExpectedSize((int)16);
            HRFunctionHelper.parseFuncName(expr, funcNames);
            traceExprMap.put(ctx.getTraceId() + fcExecuteCode, funcNames);
            HRFunctionHelper.initFunction(funcNames, ctxPre);
        }
        if (funcNames.size() == 0) {
            return expr.execute((ExecuteContext)contextLocal);
        }
        funcNames.stream().forEach(funcName -> {
            if (mapFunc.containsKey(funcName)) {
                contextLocal.addUDFunction(mapFunc.get(funcName));
            }
        });
        return expr.execute((ExecuteContext)contextLocal);
    }

    private static void parseFuncName(Expr expr, Set<String> funcNames) {
        if (expr == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            BinaryExpr binaryExpr = (BinaryExpr)expr;
            Expr left = binaryExpr.getLeft();
            HRFunctionHelper.parseFuncName(left, funcNames);
            Expr right = binaryExpr.getRight();
            HRFunctionHelper.parseFuncName(right, funcNames);
        } else if (expr instanceof ExprList) {
            ExprList exprList = (ExprList)expr;
            if (exprList.list != null) {
                for (Expr expr1 : exprList.list) {
                    HRFunctionHelper.parseFuncName(expr1, funcNames);
                }
            }
        } else if (expr instanceof FunCall) {
            FunCall funCall = (FunCall)expr;
            funcNames.add(funCall.getName());
            if (funCall.getParams() != null) {
                for (Expr expr1 : funCall.getParams()) {
                    HRFunctionHelper.parseFuncName(expr1, funcNames);
                }
            }
        } else if (expr instanceof NamedExpr) {
            NamedExpr namedExpr = (NamedExpr)expr;
            funcNames.add(namedExpr.getName());
            HRFunctionHelper.parseFuncName(namedExpr.getExpr(), funcNames);
        } else if (expr instanceof Paren) {
            Paren paren = (Paren)expr;
            HRFunctionHelper.parseFuncName(paren.getExpr(), funcNames);
        }
    }

    public static Optional<FunctionItem> getFunctionItem(List<FunctionItem> groupFuncs, String funcID) {
        if (CollectionUtils.isEmpty(groupFuncs) || StringUtils.isEmpty((CharSequence)funcID)) {
            return Optional.empty();
        }
        ArrayList functionItems = Lists.newArrayListWithCapacity((int)10);
        groupFuncs.stream().forEach(groupFunc -> functionItems.addAll(groupFunc.getChildren()));
        Optional<FunctionItem> functionItemOptional = functionItems.stream().filter(functionItem -> functionItem.getId().equalsIgnoreCase(funcID)).findFirst();
        return functionItemOptional;
    }

    public static Optional<List<FunctionItem>> getFuncItemList(String appNumber) {
        if (StringUtils.isEmpty((CharSequence)appNumber)) {
            return Optional.empty();
        }
        return HRFunctionHelper.changeDyArrayToTreeItemList(HRFunctionHelper.getFunctionArrByAppNumber(appNumber));
    }

    public static Optional<List<TreeNodeItem>> getFuncTreeItemList(String appNumber) {
        if (StringUtils.isEmpty((CharSequence)appNumber)) {
            return Optional.empty();
        }
        return Optional.of(HRFunctionHelper.changeDyArrayToTreeItems(HRFunctionHelper.getFunctionArrByAppNumber(appNumber)));
    }

    private static Optional<List<TreeNode>> getFuncNodeList(String appNumber) {
        return HRFunctionHelper.changeDyArrayToTreeNodeList(HRFunctionHelper.getFunctionArrByAppNumber(appNumber));
    }

    private static Optional<List<FunctionItem>> changeDyArrayToTreeItemList(DynamicObject[] functionDys) {
        ArrayList nodeTree = Lists.newArrayListWithCapacity((int)10);
        Map<String, List<DynamicObject>> funcMap = Arrays.stream(functionDys).collect(Collectors.groupingBy(functionDy -> functionDy.getString("group.number")));
        for (Map.Entry<String, List<DynamicObject>> group : funcMap.entrySet()) {
            DynamicObject groupObject = (DynamicObject)group.getValue().stream().findAny().get();
            if (Objects.isNull(groupObject)) continue;
            FunctionItem groupNode = new FunctionItem();
            groupNode.setId(group.getKey());
            groupNode.setItemCategory("FC");
            groupNode.setName(((DynamicObject)group.getValue().stream().findAny().get()).getString("group.name"));
            groupNode.setHasChild(true);
            if (CollectionUtils.isEmpty((Collection)group.getValue())) continue;
            ArrayList functionItems = Lists.newArrayListWithExpectedSize((int)group.getValue().size());
            for (DynamicObject function : group.getValue()) {
                functionItems.add(FunctionItem.buildFunctionItem(function));
            }
            groupNode.setChildren(functionItems);
            nodeTree.add(groupNode);
        }
        return Optional.of(nodeTree);
    }

    private static Optional<List<TreeNode>> changeDyArrayToTreeNodeList(DynamicObject[] functionDys) {
        Map<String, List<DynamicObject>> funcMap = Arrays.stream(functionDys).collect(Collectors.groupingBy(functionDy -> functionDy.getString("group.number")));
        ArrayList nodes = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<String, List<DynamicObject>> group : funcMap.entrySet()) {
            TreeNode tn1 = new TreeNode(null, group.getKey(), ((DynamicObject)group.getValue().stream().findAny().get()).getString("group.name"), true);
            tn1.setIsOpened(true);
            if (CollectionUtils.isEmpty((Collection)group.getValue())) continue;
            for (DynamicObject function : group.getValue()) {
                TreeNode tn2 = new TreeNode(group.getKey(), function.getString("funkey"), function.getString("name"), false);
                tn2.setLeaf(true);
                tn1.addChild(tn2);
            }
            nodes.add(tn1);
        }
        return Optional.of(nodes);
    }

    public static DynamicObject[] getFunctionArrByAppNumber(String appNumber) {
        logger.info("appNumber:{}", (Object)appNumber);
        ArrayList functionTypeIds = HRFunctionHelper.queryHRComFunctionTypeIds();
        functionTypeIds = CollectionUtils.isNotEmpty(functionTypeIds) ? functionTypeIds : Lists.newArrayListWithExpectedSize((int)16);
        HashSet appIds = Sets.newHashSetWithExpectedSize((int)16);
        String appId = AppMetadataCache.getAppInfoByNumber((String)appNumber).getId();
        appIds.add(appId);
        QFilter filter = new QFilter("masterid", "=", (Object)appId);
        DynamicObjectCollection dyColl = APP_HELPER.queryOriginalCollection("id", new QFilter[]{filter});
        if (dyColl != null && dyColl.size() > 0) {
            appIds.addAll(dyColl.stream().map(dy -> dy.getString("id")).collect(Collectors.toSet()));
        }
        functionTypeIds.addAll((Collection)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)("select fid as \"id\" from t_hrcs_fttypeappscope where fbasedataid in(" + appIds.stream().map(obj -> "?").collect(Collectors.joining(",")) + ") "), (Object[])appIds.toArray(), rs -> {
            ArrayList<Long> arrayList = new ArrayList<Long>(16);
            while (rs.next()) {
                arrayList.add(rs.getLong("id"));
            }
            return arrayList;
        }));
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)4);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("group.id", "in", new HashSet(functionTypeIds)));
        String queryField = "id,name,uniqueCode,funkey,define,group.number,group.name,funcdatatype,params.paramdatatype,params.paramname,params.paramdesc,description,example";
        return HRCS_FUNCTION_HELPER.query(queryField, filters.toArray(new QFilter[0]), "group.id asc,group.number asc,number asc");
    }

    public static DynamicObject[] getFunctionArrayByFuncKeys(Set<String> funcKeys) {
        logger.info("funcKeys:{}", funcKeys);
        QFilter qFilter = new QFilter("funkey", "in", funcKeys);
        String queryField = "id,name,uniqueCode,funcexp,funkey,define,group.number,funcdatatype,params.paramdatatype,params.paramname,params.paramdesc,importentry.importcode";
        return HRCS_FUNCTION_HELPER.query(queryField, new QFilter[]{qFilter});
    }

    public static List<Long> queryHRComFunctionTypeIds() {
        return HRCS_FUNCTION_TYPE_HELPER.queryTranPropList("id", new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("rgfscopetype", "=", (Object)ScopeTypeEnum.GENERAL.getValue())}, "id", Long.class);
    }

    public static List<TreeNodeItem> changeDyArrayToTreeItems(DynamicObject[] functionDys) {
        HashMap funcTypeMap = Maps.newHashMapWithExpectedSize((int)functionDys.length);
        ArrayList nodeItems = Lists.newArrayListWithExpectedSize((int)(functionDys.length * 2));
        for (DynamicObject func : functionDys) {
            nodeItems.add(FunctionItem.buildFunctionItem(func));
            funcTypeMap.put(func.getString("group.number"), func.getString("group.name"));
        }
        for (Map.Entry entry : funcTypeMap.entrySet()) {
            TreeNodeItem nodeItem = new TreeNodeItem("FC", (String)entry.getKey(), "FC", (String)entry.getValue());
            nodeItems.add(nodeItem);
        }
        return nodeItems;
    }

    static {
        Sum sum = new Sum();
        Max max = new Max();
        Min min = new Min();
        Avg avg = new Avg();
        Count count = new Count();
        RemoveTailZero removeTailZero = new RemoveTailZero();
        GetCurrUserId getCurrUserId = new GetCurrUserId();
        mapFunc.put(sum.getName(), (UDFunction)sum);
        mapFunc.put(max.getName(), (UDFunction)max);
        mapFunc.put(min.getName(), (UDFunction)min);
        mapFunc.put(avg.getName(), (UDFunction)avg);
        mapFunc.put(count.getName(), (UDFunction)count);
        mapFunc.put(removeTailZero.getName(), (UDFunction)removeTailZero);
        mapFunc.put(getCurrUserId.getName(), (UDFunction)getCurrUserId);
        platformFunctions.addAll(Arrays.asList(FunDef.getAllFuncNames()));
        platformFunctions.add(sum.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(max.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(min.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(avg.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(count.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(removeTailZero.getName().toUpperCase(Locale.ROOT));
        platformFunctions.add(getCurrUserId.getName().toUpperCase(Locale.ROOT));
    }
}

