/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.function.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;

public abstract class AbstractFunctionExecuteService {
    private static final Map<String, Expr> exprMap = Maps.newHashMapWithExpectedSize((int)16);
    private static final int CACHE_MAX_VAL = 100;

    public Expr parseExpr(String expression) {
        return this.getExprFromCacheMap(expression);
    }

    public Object execute(String expression, Map<String, Object> variableMap) {
        try {
            return this.executeExpr(expression, variableMap);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object execute(String expression, Expr expr, Map<String, Object> variableMap) {
        try {
            return this.executeExpr(expression, expr, variableMap);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object preExecute(String expression, Map<String, Object> variableMap) throws Exception {
        return this.executeExpr(expression, variableMap);
    }

    private Object executeExpr(String expression, Map<String, Object> variableMap) throws Exception {
        Expr expr = this.getExprFromCacheMap(expression);
        if (variableMap != null) {
            variableMap = this.trimVariableMap(variableMap);
        }
        return HRFunctionHelper.executeFunction(expression, expr, variableMap);
    }

    private Object executeExpr(String expression, Expr expr, Map<String, Object> variableMap) throws Exception {
        if (variableMap != null) {
            variableMap = this.trimVariableMap(variableMap);
        }
        return HRFunctionHelper.executeFunction(expression, expr, variableMap);
    }

    private Expr getExprFromCacheMap(String expression) {
        Expr expr = exprMap.get(expression);
        if (expr == null) {
            String executeExpr = AbstractFunctionExecuteService.trimExpression(expression);
            expr = ExprParser.parse((String)executeExpr);
            if (exprMap.size() >= 100) {
                exprMap.clear();
            }
            exprMap.put(expression, expr);
        }
        return expr;
    }

    public void clearCache() {
        exprMap.clear();
    }

    public static Expr getExpr(String expression) {
        String executeExpr = AbstractFunctionExecuteService.trimExpression(expression);
        return ExprParser.parse((String)executeExpr);
    }

    private static String trimExpression(String expression) {
        HashSet<String> variables = new HashSet<String>();
        StringBuilder varSb = new StringBuilder();
        boolean flag = false;
        for (int i = 0; i < expression.length(); ++i) {
            char ex = expression.charAt(i);
            if (ex != '$' && flag) {
                varSb.append(ex);
            }
            if (ex == '$') {
                boolean bl = flag = !flag;
            }
            if (flag || varSb.length() <= 0) continue;
            variables.add(varSb.toString());
            varSb = new StringBuilder();
        }
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            String var;
            String newVar = var = (String)iterator.next();
            if (var.contains("\u03b4")) {
                newVar = var.replace('\u03b4', '_');
            }
            expression = expression.replaceAll("\\$" + var + "\\$", newVar);
        }
        return expression;
    }

    private Map<String, Object> trimVariableMap(Map<String, Object> variableMap) {
        HashMap newVariableMap = Maps.newHashMapWithExpectedSize((int)variableMap.size());
        for (Map.Entry<String, Object> varEntry : variableMap.entrySet()) {
            String fieldAlias = varEntry.getKey();
            if (fieldAlias.contains("\u03b4")) {
                fieldAlias = fieldAlias.replace('\u03b4', '_');
            }
            newVariableMap.put(fieldAlias, varEntry.getValue());
        }
        return newVariableMap;
    }
}

