/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.facade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.AbstractAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.HistoryLongNumberChangeModel;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.HRTypesContainer;

public class OrgStructureLongNumberChangeFacade {
    private static final String STRUCTLONGNUMBER = "structlongnumber";
    private String hisEntityNumber;
    private String longNumber;
    private String handleService;
    private HRBaseServiceHelper hisServiceHelper;
    private Map<String, String> otherServiceMap;
    private String mainEntityField;
    private Map<String, String> otherServiceVidField;

    public OrgStructureLongNumberChangeFacade(String hisEntityNumber, String structLongNumber, String handleService) {
        this.hisEntityNumber = hisEntityNumber;
        this.longNumber = structLongNumber;
        this.handleService = handleService;
        this.hisServiceHelper = new HRBaseServiceHelper(hisEntityNumber);
    }

    public OrgStructureLongNumberChangeFacade(HistoryLongNumberChangeModel model) {
        this.hisEntityNumber = model.getHisEntityNumber();
        this.longNumber = model.getLongNumberField();
        this.handleService = model.getHandleService();
        this.hisServiceHelper = new HRBaseServiceHelper(this.hisEntityNumber);
        this.otherServiceMap = model.getOtherServiceMap();
        this.mainEntityField = model.getMainEntityField();
        this.otherServiceVidField = model.getOtherServiceVidField();
    }

    public void batchAddNewDataHis(List<DynamicObject> oldHisDyList, List<DynamicObject> hisDyList) {
        ArrayList<String> oldStructLongNumberList = new ArrayList<String>();
        HashMap<String, String> newStructLongNumberMap = new HashMap<String, String>();
        HashMap<String, Long> structLongNumberCeMap = new HashMap<String, Long>();
        HashMap<String, Date> oldStructLongNumebrBsedMap = new HashMap<String, Date>();
        HashMap<Long, Date> boBsedMap = new HashMap<Long, Date>();
        HashMap<Long, Long> boParentMap = new HashMap<Long, Long>();
        HashMap<Long, Long> boCeMap = new HashMap<Long, Long>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<Long> boList = new ArrayList<Long>();
        this.valOldHisDyList(oldHisDyList, hisDyList, oldStructLongNumberList, newStructLongNumberMap, structLongNumberCeMap, oldStructLongNumebrBsedMap, boBsedMap, boParentMap, boCeMap, parentIdList, boList);
        Map<String, List<DynamicObject>> subHisDynMap = this.getSubStructHisDysByStructLongNumber(oldStructLongNumberList, oldStructLongNumebrBsedMap);
        ArrayList<DynamicObject> newSubHisDynMap = new ArrayList<DynamicObject>();
        this.valSubHisDynMap(newStructLongNumberMap, structLongNumberCeMap, oldStructLongNumebrBsedMap, subHisDynMap, newSubHisDynMap);
        AbstractAttachService abstractAttachService = (AbstractAttachService)HRTypesContainer.createInstance((String)this.handleService);
        abstractAttachService.initHistoryProp(this.hisEntityNumber, "", "", "vid");
        abstractAttachService.batchAddNewDataHis(hisDyList);
        ArrayList<DynamicObject> newHisDynList = new ArrayList<DynamicObject>();
        Map<Long, List<DynamicObject>> parentDynListMap = this.getEffectedStrutHisDysByOrgId(parentIdList);
        List<DynamicObject> hisDynList = this.getStructHisDysByBo(boList, boBsedMap);
        this.valHisDynList(boParentMap, boCeMap, newHisDynList, parentDynListMap, hisDynList);
        this.hisServiceHelper.updateDatas(hisDyList.toArray(new DynamicObject[0]));
    }

    private void valHisDynList(Map<Long, Long> boParentMap, Map<Long, Long> boCeMap, List<DynamicObject> newHisDynList, Map<Long, List<DynamicObject>> parentDynListMap, List<DynamicObject> hisDynList) {
        hisDynList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            Date bsed = hisDyn.getDate("bsed");
            String oldStructLongNumber = hisDyn.getString(this.longNumber);
            List parentDynList = (List)parentDynListMap.get(bo);
            parentDynList.forEach(parentDyn -> {
                Date parentBsed = parentDyn.getDate("bsed");
                if (bsed.compareTo(parentBsed) == 0) {
                    DynamicObject newHisDyc = HistoryEntityUtils.copyHisDynamicObjectWithIgnoreKeySet(hisDyn, null);
                    String parentStructLongNumber = parentDyn.getString(this.longNumber);
                    String structNumber = HRStringUtils.substringBeforeLast((String)oldStructLongNumber, (String)"!");
                    String structLongNumber = parentStructLongNumber + "!" + structNumber;
                    newHisDyc.set("parent", boParentMap.get(bo));
                    newHisDyc.set(this.longNumber, (Object)structLongNumber);
                    newHisDynList.add(newHisDyc);
                }
            });
            hisDyn.set("datastatus", (Object)"-3");
            hisDyn.set("de", boCeMap.get(bo));
        });
    }

    private void valSubHisDynMap(Map<String, String> newStructLongNumberMap, Map<String, Long> structLongNumberCeMap, Map<String, Date> oldStructLongNumebrBsedMap, Map<String, List<DynamicObject>> subHisDynMap, List<DynamicObject> newSubHisDynMap) {
        subHisDynMap.forEach((oldStrucuLongNumber, dycList) -> {
            String structLongNumber = (String)newStructLongNumberMap.get(oldStrucuLongNumber);
            Long ce = (Long)structLongNumberCeMap.get(structLongNumber);
            Date bsed = (Date)oldStructLongNumebrBsedMap.get(oldStrucuLongNumber);
            dycList.forEach(dyc -> {
                DynamicObject newDyc = HistoryEntityUtils.copyHisDynamicObject(dyc);
                String subStructLongNumber = newDyc.getString(this.longNumber);
                String newSubStructLongNumber = HRStringUtils.replace((String)subStructLongNumber, (String)oldStrucuLongNumber, (String)structLongNumber);
                newDyc.set(this.longNumber, (Object)newSubStructLongNumber);
                newDyc.set("ce", (Object)ce);
                newDyc.set("bsed", (Object)bsed);
                newSubHisDynMap.add(newDyc);
            });
        });
    }

    private void valOldHisDyList(List<DynamicObject> oldHisDyList, List<DynamicObject> hisDyList, List<String> oldStructLongNumberList, Map<String, String> newStructLongNumberMap, Map<String, Long> structLongNumberCeMap, Map<String, Date> oldStructLongNumebrBsedMap, Map<Long, Date> boBsedMap, Map<Long, Long> boParentMap, Map<Long, Long> boCeMap, List<Long> parentIdList, List<Long> boList) {
        oldHisDyList.forEach(oldHisDyn -> {
            String oldStructLongNumber = oldHisDyn.getString(this.longNumber);
            oldStructLongNumberList.add(oldStructLongNumber);
            Long oldBo = oldHisDyn.getLong("bo");
            boList.add(oldBo);
            hisDyList.forEach(hisDyn -> {
                Long bo = hisDyn.getLong("bo");
                if (oldBo.equals(bo)) {
                    Long ce = hisDyn.getLong("ce");
                    String structLongNumber = hisDyn.getString(this.longNumber);
                    Date bsed = hisDyn.getDate("bsed");
                    Long parentId = hisDyn.getLong("parent.id");
                    newStructLongNumberMap.put(oldStructLongNumber, structLongNumber);
                    structLongNumberCeMap.put(structLongNumber, ce);
                    oldStructLongNumebrBsedMap.put(oldStructLongNumber, bsed);
                    boBsedMap.put(bo, bsed);
                    boParentMap.put(bo, parentId);
                    parentIdList.add(parentId);
                    boCeMap.put(bo, ce);
                }
            });
        });
    }

    public void batchModifyAndEffectDatas(List<DynamicObject> oldHisDyList, List<DynamicObject> newHisDyList) {
        this.saveAndEffectDataHis(oldHisDyList, newHisDyList, "-1");
    }

    public void batchSaveAndEffectDataHis(List<DynamicObject> oldHisDyList, List<DynamicObject> newHisDyList) {
        this.saveAndEffectDataHis(oldHisDyList, newHisDyList, "2");
    }

    public void batchSaveAndEffectOtherDataHis(List<DynamicObject> hisDyList) {
        this.saveAndEffectOtherDataHis(hisDyList, "2");
    }

    public void batchModifyAndEffectOtherDatas(List<DynamicObject> hisDyList) {
        this.saveAndEffectOtherDataHis(hisDyList, "-1");
    }

    private void saveAndEffectDataHis(List<DynamicObject> oldHisDyList, List<DynamicObject> newHisDyList, String operateKey) {
        ArrayList oldParentStructLongNumberList = Lists.newArrayListWithExpectedSize((int)oldHisDyList.size());
        HashMap newStructLongNumberMap = Maps.newHashMapWithExpectedSize((int)newHisDyList.size());
        HashMap newStructLongNumberCeMap = Maps.newHashMapWithExpectedSize((int)newHisDyList.size());
        HashMap structLongNumebrBsedMap = Maps.newHashMapWithExpectedSize((int)newHisDyList.size());
        this.valOldHisDyList(oldHisDyList, newHisDyList, oldParentStructLongNumberList, newStructLongNumberMap, newStructLongNumberCeMap, structLongNumebrBsedMap);
        if (oldParentStructLongNumberList.isEmpty()) {
            return;
        }
        QFilter structFilter = null;
        for (String structLongNumebr : oldParentStructLongNumberList) {
            if (structFilter == null) {
                structFilter = new QFilter(STRUCTLONGNUMBER, "like", (Object)(structLongNumebr + "%"));
                continue;
            }
            structFilter.or(new QFilter(STRUCTLONGNUMBER, "like", (Object)(structLongNumebr + "%")));
        }
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] oldStructDynArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, structFilter});
        ArrayList newStructDynList = Lists.newArrayListWithExpectedSize((int)oldStructDynArray.length);
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)oldStructDynArray.length);
        HashMap boBsedMap = Maps.newHashMapWithExpectedSize((int)oldStructDynArray.length);
        HashMap boMainEntityIdMap = Maps.newHashMapWithExpectedSize((int)oldStructDynArray.length);
        List<String> fieldNames = HistoryEntityUtils.getFieldsNameList(this.hisEntityNumber);
        if (fieldNames.contains(this.mainEntityField)) {
            Arrays.stream(oldStructDynArray).forEach(oldStructDyn -> {
                Long bo = oldStructDyn.getLong("bo");
                Long mainEntityId = HistoryEntityUtils.getDynamicObjectFieldId(oldStructDyn, this.mainEntityField);
                boMainEntityIdMap.put(bo, mainEntityId);
            });
        } else {
            Arrays.stream(oldStructDynArray).forEach(oldStructDyn -> {
                Long bo = oldStructDyn.getLong("bo");
                boMainEntityIdMap.put(bo, bo);
            });
        }
        this.valOldParentStructLongNumber(oldParentStructLongNumberList, newStructLongNumberMap, newStructLongNumberCeMap, structLongNumebrBsedMap, oldStructDynArray, newStructDynList, boList, boBsedMap);
        AbstractAttachService abstractAttachService = (AbstractAttachService)HRTypesContainer.createInstance((String)this.handleService);
        abstractAttachService.initHistoryProp(this.hisEntityNumber, "", "", "vid");
        if (newStructDynList.size() > 0) {
            abstractAttachService.batchSaveAndEffectDataHis(newStructDynList);
        }
    }

    private void valOldParentStructLongNumber(List<String> oldParentStructLongNumberList, Map<String, String> newStructLongNumberMap, Map<String, Long> newStructLongNumberCeMap, Map<String, Date> structLongNumebrBsedMap, DynamicObject[] oldStructDynArray, List<DynamicObject> newStructDynList, List<Long> boList, Map<Long, Date> boBsedMap) {
        oldParentStructLongNumberList.forEach(oldParentStructLongNumber -> {
            String newParentStructLongNumber = (String)newStructLongNumberMap.get(oldParentStructLongNumber);
            Long ce = (Long)newStructLongNumberCeMap.get(newParentStructLongNumber);
            Date bsed = (Date)structLongNumebrBsedMap.get(newParentStructLongNumber);
            Arrays.stream(oldStructDynArray).forEach(oldStructDyn -> {
                String structLongNumber = oldStructDyn.getString(STRUCTLONGNUMBER);
                Long bo = oldStructDyn.getLong("bo");
                if (HRStringUtils.startsWithIgnoreCase((String)structLongNumber, (String)oldParentStructLongNumber)) {
                    DynamicObject newDyc = HistoryEntityUtils.copyHisDynamicObject(oldStructDyn);
                    String newStructLongNumber = HRStringUtils.replace((String)structLongNumber, (String)oldParentStructLongNumber, (String)newParentStructLongNumber);
                    newDyc.set(STRUCTLONGNUMBER, (Object)newStructLongNumber);
                    newDyc.set("level", (Object)newStructLongNumber.split("!").length);
                    newDyc.set("ce", (Object)ce);
                    newDyc.set("bsed", (Object)bsed);
                    newStructDynList.add(newDyc);
                    boList.add(bo);
                    boBsedMap.put(bo, bsed);
                }
            });
        });
    }

    private void valOldHisDyList(List<DynamicObject> oldHisDyList, List<DynamicObject> newHisDyList, List<String> oldParentStructLongNumberList, Map<String, String> newStructLongNumberMap, Map<String, Long> newStructLongNumberCeMap, Map<String, Date> structLongNumebrBsedMap) {
        oldHisDyList.forEach(oldHisDy -> {
            Long oldBo = oldHisDy.getLong("bo");
            String oldParentStructLongNumber = oldHisDy.getString(STRUCTLONGNUMBER) + '!';
            oldParentStructLongNumberList.add(oldParentStructLongNumber);
            newHisDyList.forEach(newHisDy -> {
                Long newBo = newHisDy.getLong("bo");
                if (oldBo.equals(newBo)) {
                    Long ce = newHisDy.getLong("ce");
                    String parentStructLongNumber = newHisDy.getString(STRUCTLONGNUMBER) + '!';
                    Date bsed = newHisDy.getDate("bsed");
                    newStructLongNumberMap.put(oldParentStructLongNumber, parentStructLongNumber);
                    newStructLongNumberCeMap.put(parentStructLongNumber, ce);
                    structLongNumebrBsedMap.put(parentStructLongNumber, bsed);
                }
            });
        });
    }

    private void saveAndEffectOtherDataHis(List<DynamicObject> hisDyList, String operateKey) {
        if (hisDyList == null || hisDyList.size() == 0) {
            return;
        }
        ArrayList oldParentStructLongNumList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        hisDyList.forEach(hisDyn -> {
            String oldParentStructLongNumber = hisDyn.getString(STRUCTLONGNUMBER) + '!';
            oldParentStructLongNumList.add(oldParentStructLongNumber);
        });
        QFilter structFieldFilter = null;
        structFieldFilter = this.getqFilter(oldParentStructLongNumList, structFieldFilter);
        QFilter statusFieldFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] oldStructDys = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{statusFieldFilter, structFieldFilter});
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)oldStructDys.length);
        HashMap boBsedMap = Maps.newHashMapWithExpectedSize((int)oldStructDys.length);
        HashMap boMainEntityIdMap = Maps.newHashMapWithExpectedSize((int)oldStructDys.length);
        Arrays.stream(oldStructDys).forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            Long mainEntityId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.mainEntityField);
            Date bsed = hisDyn.getDate("bsed");
            boList.add(bo);
            boBsedMap.put(bo, bsed);
            boMainEntityIdMap.put(bo, mainEntityId);
        });
        HashMap dynMap = Maps.newHashMapWithExpectedSize((int)this.otherServiceMap.size());
        for (Map.Entry<String, String> entry : this.otherServiceMap.entrySet()) {
            this.putDynMap(boList, boBsedMap, boMainEntityIdMap, dynMap, entry);
        }
        for (Map.Entry<String, String> entry : this.otherServiceMap.entrySet()) {
            String entityNumber = entry.getKey();
            String service = entry.getValue();
            AbstractAttachService attachService = (AbstractAttachService)HRTypesContainer.createInstance((String)service);
            attachService.initHistoryProp(entityNumber, "", "", this.otherServiceVidField.get(entityNumber));
            this.batchSaveHis(attachService, dynMap, entityNumber, operateKey);
        }
    }

    private void putDynMap(List<Long> boList, Map<Long, Date> boBsedMap, Map<Long, Long> boMainEntityIdMap, Map<String, List<DynamicObject>> dynMap, Map.Entry<String, String> entry) {
        String entityNumber = entry.getKey();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)boList.size());
        List<String> fieldNameList = HistoryEntityUtils.getFieldsNameList(entityNumber);
        String mainFiled = "";
        mainFiled = fieldNameList.contains(this.mainEntityField) ? this.mainEntityField : "bo";
        for (Long bo : boList) {
            Date bsed = boBsedMap.get(bo);
            DynamicObject dyn = serviceHelper.generateEmptyDynamicObject();
            dyn.set("bo", (Object)bo);
            dyn.set("bsed", (Object)bsed);
            dyn.set(mainFiled, (Object)boMainEntityIdMap.get(bo));
            dynList.add(dyn);
        }
        dynMap.put(entityNumber, dynList);
    }

    private QFilter getqFilter(List<String> oldParentStructLongNumList, QFilter structFieldFilter) {
        for (String structLongNumebr : oldParentStructLongNumList) {
            if (structFieldFilter == null) {
                structFieldFilter = new QFilter(STRUCTLONGNUMBER, "like", (Object)(structLongNumebr + "%"));
                continue;
            }
            structFieldFilter.or(new QFilter(STRUCTLONGNUMBER, "like", (Object)(structLongNumebr + "%")));
        }
        return structFieldFilter;
    }

    private void batchSaveHis(AbstractAttachService attachService, Map<String, List<DynamicObject>> dynMap, String entityNumber, String operateKey) {
        List<DynamicObject> dynList = dynMap.get(entityNumber);
        if (dynList.size() == 0) {
            return;
        }
        if (HRStringUtils.equals((String)"2", (String)operateKey)) {
            attachService.batchSaveAndEffectDataHis(dynMap.get(entityNumber));
        } else {
            attachService.batchModifyAndEffectBoDatas(dynMap.get(entityNumber));
        }
    }

    private Map<String, List<DynamicObject>> getSubStructHisDysByStructLongNumber(List<String> structLongNumebrList, Map<String, Date> oldStructLongNumebrBsedMap) {
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0"});
        QFilter strucLongNumberFilter = null;
        for (String structLongNumber : structLongNumebrList) {
            if (strucLongNumberFilter == null) {
                strucLongNumberFilter = new QFilter(this.longNumber, "like", (Object)(structLongNumber + "!"));
                continue;
            }
            strucLongNumberFilter.or(new QFilter(this.longNumber, "like", (Object)(structLongNumber + "!")));
        }
        String filedNames = HistoryEntityUtils.getFieldsNamesString(this.hisEntityNumber);
        DynamicObject[] hisDys = this.hisServiceHelper.query(filedNames, new QFilter[]{statusFilter, strucLongNumberFilter}, "bsed desc");
        ArrayList<Long> boList = new ArrayList<Long>();
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        this.structLongNumer(structLongNumebrList, oldStructLongNumebrBsedMap, hisDys, boList, result);
        return result;
    }

    private void structLongNumer(List<String> structLongNumebrList, Map<String, Date> oldStructLongNumebrBsedMap, DynamicObject[] hisDys, List<Long> boList, Map<String, List<DynamicObject>> result) {
        structLongNumebrList.forEach(structLongNumber -> {
            Date bsed = (Date)oldStructLongNumebrBsedMap.get(structLongNumber);
            ArrayList hisDynList = new ArrayList();
            Arrays.stream(hisDys).forEach(hisDyn -> {
                Date subBsed;
                int index;
                String subStructLongNumber = hisDyn.getString(this.longNumber);
                Long subBo = hisDyn.getLong("bo");
                if (!boList.contains(subBo) && (index = subStructLongNumber.indexOf(structLongNumber + "!")) == 0 && bsed.compareTo(subBsed = hisDyn.getDate("bsed")) >= 0) {
                    boList.add(subBo);
                    hisDynList.add(hisDyn);
                }
            });
            result.put((String)structLongNumber, hisDynList);
        });
    }

    private List<DynamicObject> getStructHisDysByBo(List<Long> boList, Map<Long, Date> boBsedMap) {
        ArrayList<DynamicObject> hisDynList = new ArrayList<DynamicObject>();
        QFilter boFilter = new QFilter("bo", "in", boList);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0"});
        String filedNames = HistoryEntityUtils.getFieldsNamesString(this.hisEntityNumber);
        DynamicObject[] hisDys = this.hisServiceHelper.query(filedNames, new QFilter[]{boFilter, statusFilter});
        Arrays.stream(hisDys).forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            Date bsed = hisDyn.getDate("bsed");
            if (bsed.compareTo((Date)boBsedMap.get(bo)) > 0) {
                hisDynList.add((DynamicObject)hisDyn);
            }
        });
        return hisDynList;
    }

    private Map<Long, List<DynamicObject>> getEffectedStrutHisDysByOrgId(List<Long> orgIdList) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        QFilter boFilter = new QFilter("adminorg", "in", orgIdList);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"0");
        String filedNames = HistoryEntityUtils.getFieldsNamesString(this.hisEntityNumber);
        DynamicObject[] hisDys = this.hisServiceHelper.query(filedNames, new QFilter[]{boFilter, statusFilter});
        Arrays.stream(hisDys).forEach(hisDyn -> {
            Long orgId = hisDyn.getLong("adminorg.id");
            ArrayList<DynamicObject> hisDynList = (ArrayList<DynamicObject>)result.get(orgId);
            if (hisDynList == null) {
                hisDynList = new ArrayList<DynamicObject>();
            }
            hisDynList.add((DynamicObject)hisDyn);
            result.put(orgId, hisDynList);
        });
        return result;
    }
}

