/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.OrgStructureTimeSeqAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;

public class AdminOrgStructreTimeSeqAttachService
extends OrgStructureTimeSeqAttachService {
    @Override
    protected String getEntityNumber(String hisEntityNumber) {
        return "haos_adminstruct";
    }

    @Override
    protected String getMainEntityField() {
        return "adminorg";
    }

    @Override
    protected String getOrgBaseInfoHisEntitNumber() {
        return "haos_adminorghis";
    }

    @Override
    protected void afterSaveAndEffectBoDataHis(List<DynamicObject> hisDyList) {
        super.afterSaveAndEffectBoDataHis(hisDyList);
        this.updateParentValue(hisDyList);
    }

    @Override
    protected void afterSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
        super.afterSaveAndEffectDataHis(hisDyList);
        this.updateParentValue(hisDyList);
    }

    private void updateParentValue(List<DynamicObject> hisDyList) {
        ArrayList orgIdList = new ArrayList();
        HashMap orgParentIdMap = new HashMap();
        hisDyList.forEach(hisDyn -> {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getMainEntityField());
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getParentField());
            orgIdList.add(orgId);
            orgParentIdMap.put(orgId, parentId);
        });
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        DynamicObject[] orgDys = serviceHelper.query("parent, id", new QFilter[]{idFilter});
        Arrays.stream(orgDys).forEach(orgDyn -> {
            Long orgId = orgDyn.getLong("id");
            orgDyn.set("parent", orgParentIdMap.get(orgId));
        });
        serviceHelper.updateDatas(orgDys);
    }

    @Override
    protected void beforeUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
        DynamicObject[] childOrgDynArrays;
        HashMap childIdParentIdMap = new HashMap(16);
        HashMap childIdAdminIdMap = new HashMap(16);
        HashSet<Long> idSets = new HashSet<Long>();
        for (DynamicObject orgDyn : hisDyList) {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(orgDyn, this.getMainEntityField());
            idSets.add(orgId);
            QFilter idFilter = new QFilter("adminorg", "=", (Object)orgId);
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "3"});
            DynamicObject orgInfo = this.hisServiceHelper.queryOne("structlongnumber", new QFilter[]{idFilter, statusFilter});
            if (ObjectUtils.isEmpty((Object)orgInfo)) continue;
            StringBuilder sql = new StringBuilder(" select fvid,fadminorgid,fparentid from t_haos_adminstructhis where fdatastatus =3 and fstructlongnumber like ");
            sql.append("'").append(orgInfo.getString("structlongnumber")).append("!%'");
            DataSet rs = HRDBUtil.queryDataSet((String)" hr_haos_adminstructhistimeseq ", (DBRoute)new DBRoute("haos"), (String)sql.toString(), (Object[])new Object[0]);
            Throwable throwable = null;
            try {
                rs.forEach(data -> {
                    childIdParentIdMap.put(data.getLong("fvid"), data.getLong("fparentid"));
                    childIdAdminIdMap.put(data.getLong("fvid"), data.getLong("fadminorgid"));
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        for (DynamicObject dyn : childOrgDynArrays = this.getChildOrgDynArrays(hisDyList)) {
            Long hisId = dyn.getLong("id");
            dyn.set("adminorg", childIdParentIdMap.get(hisId));
            dyn.set("parent", childIdParentIdMap.get(hisId));
        }
        for (DynamicObject dyn : childOrgDynArrays) {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(dyn, this.getMainEntityField());
            if (idSets.contains(orgId)) continue;
            hisDyList.add(dyn);
        }
        super.beforeAddNewBoDataHis(hisDyList);
    }

    private DynamicObject[] getChildOrgDynArrays(List<DynamicObject> hisDyList) {
        List orgIds = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).map(hisDyn -> HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getMainEntityField())).collect(Collectors.toList());
        QFilter idFilter = new QFilter("adminorg", "in", orgIds);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "3"});
        Object[] orgInfos = this.hisServiceHelper.query("structlongnumber,adminorg", new QFilter[]{idFilter, statusFilter});
        if (ObjectUtils.isEmpty((Object[])orgInfos)) {
            return new DynamicObject[0];
        }
        QFilter structFieldFilter = null;
        for (Object orgInfo : orgInfos) {
            if (structFieldFilter == null) {
                structFieldFilter = new QFilter("structlongnumber", "like", (Object)orgInfo.getString("structlongnumber").concat("!").concat("%"));
                continue;
            }
            structFieldFilter.or(new QFilter("structlongnumber", "like", (Object)orgInfo.getString("structlongnumber").concat("!").concat("%")));
        }
        return this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{structFieldFilter, new QFilter("datastatus", "=", (Object)"3")});
    }
}

