/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.AbstractAttachService;
import kd.hr.hbp.business.servicehelper.HRHistoryHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommonNonTimeSeqAttachService
extends AbstractAttachService {
    private static final String HRMP_HBP_BUSINESS = "hrmp-hbp-business";
    private static final Log logger = LogFactory.getLog(CommonNonTimeSeqAttachService.class);
    private static final String EVENT_ID_IN_S_BO_IN_S = "eventId in:%s,bo in:%s";

    private String getCommonBoSeo() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5bo\u5f53\u524d\u8868\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonNonTimeSeqAttachService_8", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    @Override
    public void batchAddNewBoDataHis(List<DynamicObject> hisDynList) {
        this.beforeAddNewBoDataHis(hisDynList);
        String errorInfo = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        Date dateNow = new Date();
        hisDynList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)Boolean.TRUE);
        });
        this.hisServiceHelper.save(hisDynList.toArray(new DynamicObject[hisDynList.size()]));
    }

    @Override
    public void batchSaveAndEffectBoDataHis(List<DynamicObject> hisDynList) {
        this.beforeAddNewBoDataHis(hisDynList);
        String errorMessage = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errorMessage)) {
            throw new KDBizException(errorMessage);
        }
        Date dateCurr = new Date();
        hisDynList.forEach(hisDyn -> {
            this.setHisField((DynamicObject)hisDyn, dateCurr);
            this.setSysField((DynamicObject)hisDyn, dateCurr);
            hisDyn.set("ee", (Object)hisDyn.getLong("ce"));
            hisDyn.set("eedt", (Object)dateCurr);
            hisDyn.set("datastatus", (Object)"1");
            hisDyn.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDyn, dateCurr);
        });
        this.hisServiceHelper.save(hisDynList.toArray(new DynamicObject[hisDynList.size()]));
        DynamicObjectCollection currentColl = new DynamicObjectCollection();
        hisDynList.forEach(hisDyn -> {
            DynamicObject currentDyn = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDyn);
            currentDyn.set("id", hisDyn.get("bo"));
            currentColl.add((Object)currentDyn);
        });
        this.serviceHelper.save(currentColl);
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDynList) {
        String errMsg = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errMsg)) {
            throw new KDBizException(errMsg);
        }
        List boList = hisDynList.stream().map(dy -> dy.getLong("bo")).collect(Collectors.toList());
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        DynamicObject[] oldHisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{dataStatusFilter, oldHisDyFilter});
        Arrays.stream(oldHisDynArr).forEach(dyn -> dyn.set("islastversion", (Object)Boolean.FALSE));
        this.hisServiceHelper.update(oldHisDynArr);
        Date dateNow = new Date();
        hisDynList.forEach(dy -> {
            this.setHisField((DynamicObject)dy, dateNow);
            this.setSysField((DynamicObject)dy, dateNow);
            dy.set("isnewbo", (Object)Boolean.FALSE);
        });
        this.hisServiceHelper.save(hisDynList.toArray(new DynamicObject[hisDynList.size()]));
    }

    @Override
    public void batchDiscardBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)Boolean.TRUE);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, newHisDyFilter});
        Arrays.stream(newHisDyArr).forEach(dy -> dy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
    }

    @Override
    public void batchDiscardDataHis(List<Long> eventIdList) {
        QFilter newHisDynamicFilter = new QFilter("ce", "in", eventIdList);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)Boolean.FALSE);
        DynamicObject[] newHisDynamicArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDynamicFilter, boFilter});
        Arrays.stream(newHisDynamicArray).forEach(dynamic -> dynamic.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDynamicArray);
        List boList = Arrays.stream(newHisDynamicArray).map(dynamic -> dynamic.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDynamicFilter = new QFilter("bo", "in", boList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] oldHisDynamicArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDynamicFilter, dataStatusFilter});
        Arrays.stream(oldHisDynamicArray).forEach(dynamic -> dynamic.set("islastversion", (Object)Boolean.TRUE));
        this.hisServiceHelper.update(oldHisDynamicArray);
    }

    @Override
    public void batchEffectBoDataHis(List<Long> eventIdList) {
        QFilter newHisDynamicFilter = new QFilter("ce", "in", eventIdList);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)Boolean.TRUE);
        newHisDynamicFilter.and(boFilter);
        QFilter seFilter = HRHistoryHelper.getScheduleEffectHisFilter();
        newHisDynamicFilter.and(seFilter);
        DynamicObject[] newhisDynamicArray = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, newHisDynamicFilter});
        this.updateNewHisDy(newhisDynamicArray);
        DynamicObjectCollection currCollection = new DynamicObjectCollection();
        for (DynamicObject hisDyamic : newhisDynamicArray) {
            DynamicObject currentDynamic = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDyamic);
            currentDynamic.set("id", hisDyamic.get("bo"));
            currCollection.add((Object)currentDynamic);
        }
        this.serviceHelper.save(currCollection);
    }

    @Override
    public void batchEffectDataHis(List<Long> eventIds) {
        QFilter dataStatusFilter;
        DynamicObject[] newHisDynamicArr = this.getDynamicObjects(eventIds);
        Map<Long, Long> boCeNewHisDynamicMap = Arrays.stream(newHisDynamicArr).collect(Collectors.toMap(newHisDynamic -> newHisDynamic.getLong("bo"), newHisDynamicObject -> newHisDynamicObject.getLong("ce")));
        List<Long> boIdList = Arrays.stream(newHisDynamicArr).map(dynamicObject -> dynamicObject.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boIdList);
        DynamicObject[] oldHisDynamicArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter, dataStatusFilter = new QFilter("datastatus", "=", (Object)"1")});
        if (oldHisDynamicArr == null || oldHisDynamicArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String boIdInfo = StringUtils.join((Object[])boIdList.toArray(), (String)",");
            String ceInfo = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IN_S_BO_IN_S, ceInfo, boIdInfo));
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonNonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkBoList(boIdList, oldHisDynamicArr, "bo", ResManager.loadKDString((String)"\u8be5bo\u5931\u6548\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonNonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        QFilter idFieldFilter = new QFilter("id", "in", boIdList);
        DynamicObject[] currentDynamicArray = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFieldFilter});
        if (currentDynamicArray == null || currentDynamicArray.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String ceInfo = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String boIdInfo = StringUtils.join((Object[])boIdList.toArray(), (String)",");
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(boIdList, currentDynamicArray, "id", this.getCommonBoSeo());
        this.updateOldDy(boCeNewHisDynamicMap, oldHisDynamicArr);
        this.updateNewHisDy(newHisDynamicArr);
        this.updateCurrentDy(newHisDynamicArr, currentDynamicArray);
    }

    private DynamicObject[] getDynamicObjects(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)Boolean.FALSE);
        newHisDyFilter.and(boFilter);
        QFilter seFilter = HRHistoryHelper.getScheduleEffectHisFilter();
        newHisDyFilter.and(seFilter);
        return this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter, boFilter});
    }

    private void updateNewHisDy(DynamicObject[] newHisDynamicArr) {
        Date dateNow = new Date();
        Arrays.stream(newHisDynamicArr).forEach(dy -> {
            dy.set("ee", (Object)dy.getLong("ce"));
            dy.set("eedt", (Object)dateNow);
            dy.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)dy, dateNow);
        });
        this.hisServiceHelper.update(newHisDynamicArr);
    }

    private void updateOldDy(Map<Long, Long> boCeNewHisDynamicMap, DynamicObject[] oldHisDynamicArr) {
        Arrays.stream(oldHisDynamicArr).forEach(dy -> {
            long bo = dy.getLong("bo");
            dy.set("lde", boCeNewHisDynamicMap.get(bo));
            dy.set("datastatus", (Object)"-2");
        });
        this.hisServiceHelper.update(oldHisDynamicArr);
    }

    private void updateCurrentDy(DynamicObject[] newHisDynamicArr, DynamicObject[] currentDynamicArray) {
        Arrays.stream(newHisDynamicArr).forEach(hisDy -> Arrays.stream(currentDynamicArray).filter(curDy -> hisDy.getLong("bo") == curDy.getLong("id")).forEach(curDy -> {
            HRDynamicObjectUtils.copy((DynamicObject)HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy), (DynamicObject)curDy);
            curDy.set("id", (Object)hisDy.getLong("bo"));
        }));
        this.serviceHelper.update(currentDynamicArray);
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDynList) {
        String errorInfo = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List<Long> schBoList = this.checkSEDataHisExists(hisDynList);
        if (schBoList != null && schBoList.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoList.toArray(), (String)",");
            logger.error("bo in:" + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonNonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> boList = hisDynList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        List hisDyCe = hisDynList.stream().map(hisDy -> hisDy.getLong("ce")).collect(Collectors.toList());
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            String ceStr = StringUtils.join((Object[])hisDyCe.toArray(), (String)",");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonNonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkBoList(boList, oldHisDyArr, "bo", ResManager.loadKDString((String)"\u8be5bo\u5931\u6548\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonNonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        QFilter idFilter = new QFilter("id", "in", boList);
        DynamicObject[] currentDynArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDynArr == null || currentDynArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String ceStr = StringUtils.join((Object[])hisDyCe.toArray(), (String)",");
            String boIdStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            throw new KDBizException(this.getCommonBoSeo());
        }
        this.checkBoList(boList, currentDynArr, "id", this.getCommonBoSeo());
        Date dateCurr = this.updateOldDyArr(hisDynList, oldHisDyArr);
        this.saveHis(hisDynList, dateCurr);
        this.updateCurrentArr(hisDynList, currentDynArr);
    }

    @NotNull
    private Date updateOldDyArr(List<DynamicObject> hisDynList, DynamicObject[] oldHisDyArr) {
        Map<Long, Long> hisDynBoCeMap = hisDynList.stream().collect(Collectors.toMap(hisDyn -> hisDyn.getLong("bo"), hisDyn -> hisDyn.getLong("ce")));
        Date dateCurr = new Date();
        Arrays.stream(oldHisDyArr).forEach(oldHisDyn -> {
            long boId = oldHisDyn.getLong("bo");
            oldHisDyn.set("lme", hisDynBoCeMap.get(boId));
            oldHisDyn.set("lmedt", (Object)dateCurr);
            oldHisDyn.set("lde", hisDynBoCeMap.get(boId));
            oldHisDyn.set("datastatus", (Object)"-2");
        });
        this.hisServiceHelper.update(oldHisDyArr);
        return dateCurr;
    }

    private void saveHis(List<DynamicObject> hisDynList, Date dateCurr) {
        hisDynList.forEach(hisDyn -> {
            this.setHisField((DynamicObject)hisDyn, dateCurr);
            this.setSysField((DynamicObject)hisDyn, dateCurr);
            hisDyn.set("isnewbo", (Object)"0");
            hisDyn.set("ee", hisDyn.get("ce"));
            hisDyn.set("eedt", (Object)dateCurr);
            hisDyn.set("datastatus", (Object)"1");
            hisDyn.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDyn, dateCurr);
        });
        this.hisServiceHelper.save(hisDynList.toArray(new DynamicObject[hisDynList.size()]));
    }

    private void updateCurrentArr(List<DynamicObject> hisDynList, DynamicObject[] currentDynArr) {
        Map hisDyBoMap = hisDynList.stream().collect(Collectors.toMap(hisDyn -> hisDyn.getLong("bo"), Function.identity()));
        Arrays.stream(currentDynArr).forEach(currentDy -> {
            long currentId = currentDy.getLong("id");
            DynamicObject newDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), (DynamicObject)hisDyBoMap.get(currentId));
            HRDynamicObjectUtils.copy((DynamicObject)newDy, (DynamicObject)currentDy);
            currentDy.set("id", (Object)currentId);
        });
        this.serviceHelper.update(currentDynArr);
    }

    protected String getErrorInfoByMulDy(List<DynamicObject> hisDyList) {
        ArrayList<String> errorInfoList = new ArrayList<String>();
        if (hisDyList == null || hisDyList.size() == 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonNonTimeSeqAttachService_4", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        } else {
            List repeatData;
            for (DynamicObject hisDy : hisDyList) {
                if (hisDy.getLong("bo") == 0L) {
                    errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u5bf9\u5e94\u7684\u4e1a\u52a1\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonNonTimeSeqAttachService_5", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                    break;
                }
                if (hisDy.getLong("ce") != 0L) continue;
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u521b\u5efa\u4e8b\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonNonTimeSeqAttachService_6", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if ((repeatData = hisDyList.stream().map(dy -> dy.getDynamicObjectType().getName()).distinct().collect(Collectors.toList())).size() != 1) {
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u5386\u53f2\u6570\u636e\u5fc5\u987b\u6765\u81ea\u540c\u4e00\u5b9e\u4f53\uff01", (String)"CommonNonTimeSeqAttachService_7", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
        }
        StringBuilder errorInfo = new StringBuilder();
        this.appendErrorInfo(hisDyList, errorInfoList, errorInfo);
        return errorInfo.toString();
    }

    private void appendErrorInfo(List<DynamicObject> hisDyList, List<String> errorInfoList, StringBuilder errorInfo) {
        List<String> bizErrorInfoList = this.getBizErrorInfo(hisDyList);
        if (bizErrorInfoList != null && bizErrorInfoList.size() > 0) {
            errorInfoList.addAll(bizErrorInfoList);
        }
        if (errorInfoList.size() > 0) {
            int size = errorInfoList.size();
            for (int i = 0; i < size; ++i) {
                errorInfo.append('(').append(i).append(')').append(errorInfoList.get(i)).append(System.lineSeparator());
            }
        }
    }

    private void checkBoList(List<Long> oldBoList, DynamicObject[] currentDynArr, String fieldName, String errMsg) {
        List currentIdList = Arrays.stream(currentDynArr).map(currentDy -> currentDy.getLong(fieldName)).collect(Collectors.toList());
        List diffIdAndBo = oldBoList.stream().filter(oldBo -> !currentIdList.contains(oldBo)).collect(Collectors.toList());
        if (diffIdAndBo != null && diffIdAndBo.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " checkBoList currentDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])diffIdAndBo.toArray(), (String)",");
            logger.error("bo in:" + boIdStr);
            throw new KDBizException(errMsg);
        }
    }

    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void beforeAddNewDataHis(List<DynamicObject> hisDyList) {
    }
}

