/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.history.helper.OrgHistoryHelper;
import kd.hr.hbp.business.history.service.AbstractAttachService;
import kd.hr.hbp.business.servicehelper.HRHistoryHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonTimeSeqAttachService
extends AbstractAttachService {
    private static final Log logger = LogFactory.getLog(CommonTimeSeqAttachService.class);
    private static final String HRMP_HBP_BUSINESS = "hrmp-hbp-business";
    private static final String BRLED = "brled";
    private static final String BRLEDT = "brledt";
    private static final String BO_IN = "bo in:";
    private static final String EVENT_ID_IS_S_BO_IS_S = "eventId is:%s,bo is:%s";
    private static final String BO_IS = "bo is:";

    private String getBoNotExist() {
        return ResManager.loadKDString((String)"\u8be5bo\u65e7\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonTimeSeqAttachService_13", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    private String getBoDataNotExist() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5bo\u5f53\u524d\u8868\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonTimeSeqAttachService_14", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]);
    }

    @Override
    public void batchAddNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewBoDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        Date dateNow = new Date();
        hisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)true);
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
    }

    @Override
    public void batchSaveAndEffectBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewBoDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        this.checkPreparEffectDateBeforeEffectDataHis(hisDyList.toArray(new DynamicObject[0]));
        Date dateNow = new Date();
        hisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)true);
            hisDy.set("ee", (Object)hisDy.getLong("ce"));
            hisDy.set("eedt", (Object)dateNow);
            hisDy.set("datastatus", (Object)"1");
            hisDy.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField((DynamicObject)hisDy, dateNow);
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        hisDyList.forEach(hisDy -> {
            DynamicObject currentDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy);
            currentDy.set("id", hisDy.get("bo"));
            currentCollection.add((Object)currentDy);
        });
        this.serviceHelper.save(currentCollection);
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDyList) {
        this.beforeSaveAndEffectDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        this.checkPreparEffectDateBeforeEffectDataHis(hisDyList.toArray(new DynamicObject[0]));
        this.saveAndNewDataHis(hisDyList, "-1");
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        Map<Long, Long> boCeNewHisDyMap = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), newHisDy -> newHisDy.getLong("ce")));
        List<Long> schBoList = this.checkSEDataHisExists(hisDyList);
        if (schBoList != null && schBoList.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchAddNewDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoList.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonTimeSeqAttachService_5", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List boList = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchAddNewDataHis oldHisDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(this.getBoNotExist());
        }
        Date dateNow = new Date();
        Arrays.stream(oldHisDyArr).forEach(oldHisDy -> {
            oldHisDy.set("islastversion", (Object)false);
            oldHisDy.set("lme", boCeNewHisDyMap.get(oldHisDy.getLong("bo")));
            oldHisDy.set("lmedt", (Object)dateNow);
        });
        this.hisServiceHelper.update(oldHisDyArr);
        hisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)false);
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
    }

    @Override
    public void batchDiscardBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        newHisDyFilter.and(boFilter);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchDiscardBoDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId in:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5e9f\u5f03\u7684\u65b0bo\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_7", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        Arrays.stream(newHisDyArr).forEach(newHisDy -> newHisDy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
    }

    @Override
    public void batchDiscardDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)false);
        newHisDyFilter.and(boFilter);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchDiscardDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId in:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5e9f\u5f03\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_8", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        Arrays.stream(newHisDyArr).forEach(newHisDy -> newHisDy.set("datastatus", (Object)"-1"));
        this.hisServiceHelper.update(newHisDyArr);
        List boList = Arrays.stream(newHisDyArr).map(newHisDy -> newHisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", boList);
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(datastatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchDiscardDataHis oldHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String boStr = StringUtils.join((Object[])boList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IS_S_BO_IS_S, eventStr, boStr));
            throw new KDBizException(this.getBoNotExist());
        }
        Arrays.stream(oldHisDyArr).forEach(oldHisDy -> oldHisDy.set("isnewbo", (Object)true));
        this.hisServiceHelper.update(oldHisDyArr);
    }

    @Override
    public void batchEffectBoDataHis(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)true);
        newHisDyFilter.and(boFilter);
        QFilter seFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "3"});
        newHisDyFilter.and(seFilter);
        DynamicObject[] newHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectBoDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId is:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u751f\u6548\u7684\u65b0bo\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_9", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.beforeEffectBoDataHis(newHisDyArr);
        this.checkPreparEffectDateBeforeEffectDataHis(newHisDyArr);
        Date dateNow = new Date();
        Arrays.stream(newHisDyArr).forEach(newHisDy -> {
            newHisDy.set("ee", (Object)newHisDy.getLong("ce"));
            newHisDy.set("eedt", (Object)dateNow);
            newHisDy.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)newHisDy, dateNow);
        });
        this.hisServiceHelper.update(newHisDyArr);
        DynamicObjectCollection currentCollection = new DynamicObjectCollection();
        Arrays.stream(newHisDyArr).forEach(newHisDy -> {
            long bo = newHisDy.getLong("bo");
            DynamicObject currentDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), newHisDy);
            currentDy.set("id", (Object)bo);
            currentCollection.add((Object)currentDy);
        });
        this.serviceHelper.save(currentCollection);
    }

    @Override
    public void batchEffectDataHis(List<Long> eventIds) {
        DynamicObject[] newHisDyArr = this.getnewDyArr(eventIds);
        if (newHisDyArr == null || newHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis newHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            logger.error("eventId is:" + eventStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u53ef\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_10", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> oldBoList = Arrays.stream(newHisDyArr).map(newHisDy -> newHisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", oldBoList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis oldHisDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String oldBoStr = StringUtils.join((Object[])oldBoList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IS_S_BO_IS_S, eventStr, oldBoStr));
            throw new KDBizException(this.getBoNotExist());
        }
        this.checkBoList(oldBoList, oldHisDyArr, "bo", this.getBoNotExist());
        QFilter idFilter = new QFilter("id", "in", oldBoList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (currentDyArr == null || currentDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchEffectDataHis currentDyArr ERROR!");
            String eventStr = StringUtils.join((Object[])eventIds.toArray(), (String)",");
            String oldBoStr = StringUtils.join((Object[])oldBoList.toArray(), (String)",");
            logger.error(String.format(Locale.ROOT, EVENT_ID_IS_S_BO_IS_S, eventStr, oldBoStr));
            throw new KDBizException(this.getBoDataNotExist());
        }
        this.checkBoList(oldBoList, currentDyArr, "id", this.getBoDataNotExist());
        Date dateNow = new Date();
        this.beforeLoseEffectDataHis(oldHisDyArr);
        this.updateoldDyArr(newHisDyArr, oldHisDyArr, dateNow);
        this.updateNewHis(newHisDyArr, dateNow);
        this.updateDyArr(newHisDyArr, currentDyArr);
    }

    private void updateoldDyArr(DynamicObject[] newHisDyArr, DynamicObject[] oldHisDyArr, Date dateNow) {
        Map boNewHisDyMap = Arrays.stream(newHisDyArr).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), Function.identity()));
        Arrays.stream(oldHisDyArr).forEach(oldHisDy -> {
            long bo = oldHisDy.getLong("bo");
            DynamicObject newHisDy = (DynamicObject)boNewHisDyMap.get(bo);
            oldHisDy.set("lee", (Object)newHisDy.getLong("ce"));
            oldHisDy.set("leedt", (Object)dateNow);
            oldHisDy.set("bsled", (Object)newHisDy.getDate("bsed"));
            oldHisDy.set(BRLED, (Object)dateNow);
            oldHisDy.set(BRLEDT, (Object)dateNow.getTime());
            oldHisDy.set("datastatus", (Object)"2");
        });
        this.hisServiceHelper.update(oldHisDyArr);
    }

    private void updateNewHis(DynamicObject[] newHisDyArr, Date dateNow) {
        this.beforeEffectDataHis(newHisDyArr);
        Arrays.stream(newHisDyArr).forEach(newHisDy -> {
            newHisDy.set("ee", (Object)newHisDy.getLong("ce"));
            newHisDy.set("eedt", (Object)dateNow);
            newHisDy.set("datastatus", (Object)"1");
            this.setActualField((DynamicObject)newHisDy, dateNow);
        });
        this.hisServiceHelper.update(newHisDyArr);
    }

    private void updateDyArr(DynamicObject[] newHisDyArr, DynamicObject[] currentDyArr) {
        Arrays.stream(newHisDyArr).forEach(hisDy -> Arrays.stream(currentDyArr).filter(curDy -> hisDy.getLong("bo") == curDy.getLong("id")).forEach(curDy -> {
            HRDynamicObjectUtils.copy((DynamicObject)HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy), (DynamicObject)curDy, this.getCopyIgnoreKeySet());
            curDy.set("id", (Object)hisDy.getLong("bo"));
        }));
        this.serviceHelper.update(currentDyArr);
    }

    private DynamicObject[] getnewDyArr(List<Long> eventIds) {
        QFilter newHisDyFilter = new QFilter("ce", "in", eventIds);
        QFilter boFilter = new QFilter("isnewbo", "=", (Object)false);
        newHisDyFilter.and(boFilter);
        QFilter seFilter = new QFilter("datastatus", "=", (Object)"0");
        newHisDyFilter.and(seFilter);
        return this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{newHisDyFilter});
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
        this.beforeSaveAndEffectDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        this.checkPreparEffectDateBeforeEffectDataHis(hisDyList.toArray(new DynamicObject[0]));
        ArrayList<Long> boList = new ArrayList<Long>();
        HashMap<Long, Date> bsedMap = new HashMap<Long, Date>();
        HashMap hisDynMap = new HashMap();
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            Date date = hisDyn.getDate("bsed");
            boList.add(bo);
            bsedMap.put(bo, date);
            hisDynMap.put(bo, hisDyn);
        });
        OrgHistoryHelper orgServiceHelper = new OrgHistoryHelper(null, null);
        Map<Long, DynamicObject> dynMap = orgServiceHelper.getHistoryDatasByBoWithBsed(this.hisServiceHelper.getEntityName(), boList, bsedMap);
        ArrayList<DynamicObject> savaAndNewDataHisList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> modifyDataHisList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> modifyNewBoDataHisList = new ArrayList<DynamicObject>();
        boList.forEach(bo -> {
            DynamicObject oldDyn = (DynamicObject)dynMap.get(bo);
            if (oldDyn != null) {
                Date oldBsed = oldDyn.getDate("bsed");
                Date bsed = ((DynamicObject)hisDynMap.get(bo)).getDate("bsed");
                Long oldBsedTime = oldBsed.getTime();
                Long bsedTime = bsed.getTime();
                if (HRStringUtils.equals((String)"1", (String)oldDyn.getString("datastatus")) && !oldBsedTime.equals(bsedTime)) {
                    savaAndNewDataHisList.add((DynamicObject)hisDynMap.get(bo));
                } else {
                    modifyDataHisList.add((DynamicObject)hisDynMap.get(bo));
                }
            } else {
                modifyNewBoDataHisList.add((DynamicObject)hisDynMap.get(bo));
            }
        });
        if (savaAndNewDataHisList.size() > 0) {
            this.saveAndNewDataHis(savaAndNewDataHisList, "2");
        }
        if (modifyDataHisList.size() > 0) {
            this.modifyDataHis(modifyDataHisList, dynMap);
        }
        if (modifyNewBoDataHisList.size() > 0) {
            this.modifyNewBoDataHis(modifyNewBoDataHisList);
        }
    }

    private void saveAndNewDataHis(List<DynamicObject> hisDyList, String operate) {
        List<Long> schBoList = this.checkSEDataHisExists(hisDyList);
        if (schBoList != null && schBoList.size() > 0) {
            logger.warn(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis checkSEDataHisExists ERROR!");
            String boIdStr = StringUtils.join((Object[])schBoList.toArray(), (String)",");
            logger.warn(BO_IS + boIdStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f85\u751f\u6548\u7684\u6570\u636e\u7248\u672c\u3002", (String)"CommonTimeSeqAttachService_5", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        List<Long> oldBoList = hisDyList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", oldBoList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        if (oldHisDyArr == null || oldHisDyArr.length == 0) {
            logger.warn(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.warn(BO_IS + oldBoStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_12", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        this.checkBoList(oldBoList, oldHisDyArr, "bo", this.getBoNotExist());
        this.beforeLoseEffectDataHis(oldHisDyArr);
        Map<Long, DynamicObject> boHisDyMap = hisDyList.stream().collect(Collectors.toMap(hisDy -> hisDy.getLong("bo"), Function.identity()));
        QFilter idFilter = new QFilter("id", "in", oldBoList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        this.validateCurrentDyArr(oldBoList, currentDyArr);
        this.checkBoList(oldBoList, currentDyArr, "id", this.getBoDataNotExist());
        Date dateNow = new Date();
        this.updateOldAndNewHis(hisDyList, operate, oldHisDyArr, boHisDyMap, dateNow);
        this.updateCurrentArr(boHisDyMap, currentDyArr);
    }

    private void updateOldAndNewHis(List<DynamicObject> hisDyList, String operate, DynamicObject[] oldHisDyArr, Map<Long, DynamicObject> boHisDyMap, Date dateNow) {
        Map<Long, Long> boCeNewHisDyMap = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), newHisDy -> newHisDy.getLong("ce")));
        for (DynamicObject oldHisDy : oldHisDyArr) {
            long bo = oldHisDy.getLong("bo");
            DynamicObject hisDy = boHisDyMap.get(bo);
            Date newBsed = hisDy.getDate("bsed");
            long eventId = hisDy.getLong("ce");
            oldHisDy.set("lme", (Object)boCeNewHisDyMap.get(oldHisDy.getLong("bo")));
            oldHisDy.set("lmedt", (Object)dateNow);
            if (HRStringUtils.equals((String)operate, (String)"2")) {
                this.setInvalidDynamicObject(oldHisDy, eventId, newBsed, dateNow);
            } else if (HRStringUtils.equals((String)operate, (String)"-1")) {
                this.setDiscardDynamicObject(oldHisDy, eventId, newBsed, dateNow);
            }
            this.setModifyField(oldHisDy, dateNow);
        }
        this.hisServiceHelper.update(oldHisDyArr);
        for (DynamicObject hisDy : hisDyList) {
            this.setHisField(hisDy, dateNow);
            this.setSysField(hisDy, dateNow);
            hisDy.set("isnewbo", (Object)"0");
            hisDy.set("ee", (Object)hisDy.getLong("ce"));
            hisDy.set("eedt", (Object)dateNow);
            hisDy.set("datastatus", (Object)"1");
            hisDy.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField(hisDy, dateNow);
        }
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
    }

    private void updateCurrentArr(Map<Long, DynamicObject> boHisDyMap, DynamicObject[] currentDyArr) {
        Arrays.stream(currentDyArr).forEach(currentDy -> {
            long id = currentDy.getLong("id");
            DynamicObject hisDy = (DynamicObject)boHisDyMap.get(id);
            DynamicObject newDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy);
            HRDynamicObjectUtils.copy((DynamicObject)newDy, (DynamicObject)currentDy, this.getCopyIgnoreKeySet());
            currentDy.set("id", (Object)id);
        });
        this.serviceHelper.update(currentDyArr);
    }

    @Override
    public void batchSaveNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeAddNewBoDataHis(hisDyList);
        String errorInfo = this.getErrorInfoByMulDy(hisDyList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        Date dateNow = new Date();
        hisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)true);
            hisDy.set("datastatus", (Object)"3");
        });
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[hisDyList.size()]));
    }

    private void validateCurrentDyArr(List<Long> oldBoList, DynamicObject[] currentDyArr) {
        if (currentDyArr == null || currentDyArr.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.error(BO_IS + oldBoStr);
            throw new KDBizException(this.getBoDataNotExist());
        }
    }

    @Override
    public void batchUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
        this.beforeUpdateNewBoDataHis(hisDyList);
        this.hisServiceHelper.save(hisDyList.toArray(new DynamicObject[0]));
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        HashMap boHisDyMap = Maps.newHashMapWithExpectedSize((int)hisDyList.size());
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            boHisDyMap.put(bo, hisDyn);
            boList.add(bo);
        });
        QFilter idFilter = new QFilter("id", "in", (Object)boList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        Arrays.stream(currentDyArr).forEach(currentDy -> {
            long id = currentDy.getLong("id");
            DynamicObject hisDy = (DynamicObject)boHisDyMap.get(id);
            DynamicObject newDy = HRHistoryHelper.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDy);
            HRDynamicObjectUtils.copy((DynamicObject)newDy, (DynamicObject)currentDy);
            currentDy.set("id", (Object)id);
        });
        this.serviceHelper.save(currentDyArr);
    }

    protected Set<String> getCopyIgnoreKeySet() {
        HashSet keySet = Sets.newHashSetWithExpectedSize((int)20);
        keySet.add("creator");
        keySet.add("createtime");
        keySet.add("multilanguagetext");
        return keySet;
    }

    private void setInvalidDynamicObject(DynamicObject oldHisDy, Long eventId, Date bsled, Date dateNow) {
        oldHisDy.set("lee", (Object)eventId);
        oldHisDy.set("leedt", (Object)dateNow);
        oldHisDy.set("bsled", (Object)bsled);
        oldHisDy.set(BRLED, (Object)dateNow);
        oldHisDy.set(BRLEDT, (Object)System.currentTimeMillis());
        oldHisDy.set("datastatus", (Object)"2");
    }

    private void setDiscardDynamicObject(DynamicObject oldHisDy, Long eventId, Date bsled, Date dateNow) {
        oldHisDy.set("de", (Object)eventId);
        oldHisDy.set("dedt", (Object)dateNow);
        oldHisDy.set("datastatus", (Object)"-1");
    }

    private void modifyDataHis(List<DynamicObject> modifyDataHisList, Map<Long, DynamicObject> oldHisDynMap) {
        ArrayList<DynamicObject> oldHisDynLsit = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> oldHisDynCopyLsit = new ArrayList<DynamicObject>();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.hisServiceHelper.getEntityName());
        Date dateNow = new Date();
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)modifyDataHisList.size());
        HashMap newDynMap = Maps.newHashMapWithExpectedSize((int)modifyDataHisList.size());
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)3);
        ignoreKeys.add("creator");
        ignoreKeys.add("createtime");
        this.changeDataHis(modifyDataHisList, oldHisDynMap, oldHisDynLsit, oldHisDynCopyLsit, mainEntityType, dateNow, boList, newDynMap, ignoreKeys);
        this.hisServiceHelper.save(oldHisDynCopyLsit.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(oldHisDynLsit.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(modifyDataHisList.toArray(new DynamicObject[0]));
        QFilter idFilter = new QFilter("id", "in", (Object)boList);
        DynamicObject[] currentDyArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (boList.size() > 0 && (currentDyArr == null || currentDyArr.length == 0)) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String oldBoStr = StringUtils.join((Iterable)boList, (String)",");
            logger.error(BO_IS + oldBoStr);
            throw new KDBizException(this.getBoDataNotExist());
        }
        this.checkBoList(boList, currentDyArr, "id", this.getBoDataNotExist());
        this.updateCurrentArr(newDynMap, currentDyArr);
    }

    private void changeDataHis(List<DynamicObject> modifyDataHisList, Map<Long, DynamicObject> oldHisDynMap, List<DynamicObject> oldHisDynLsit, List<DynamicObject> oldHisDynCopyLsit, MainEntityType mainEntityType, Date dateNow, List<Long> boList, Map<Long, DynamicObject> newDynMap, Set<String> ignoreKeys) {
        modifyDataHisList.forEach(modifyDataHis -> {
            Long bsedTime;
            Long bo = modifyDataHis.getLong("bo");
            Long ce = modifyDataHis.getLong("ce");
            Date bsed = modifyDataHis.getDate("bsed");
            DynamicObject oldHisDyn = (DynamicObject)oldHisDynMap.get(bo);
            Date oldBsled = oldHisDyn.getDate("bsled");
            Date oldBsed = oldHisDyn.getDate("bsed");
            Long lee = oldHisDyn.getLong("lee");
            Date leeDt = oldHisDyn.getDate("leedt");
            String status = oldHisDyn.getString("datastatus");
            Long oldBsedTime = oldBsed.getTime();
            if (!oldBsedTime.equals(bsedTime = Long.valueOf(bsed.getTime()))) {
                DynamicObject oldHisDynCopy = new DynamicObject((DynamicObjectType)mainEntityType);
                HRDynamicObjectUtils.copy((DynamicObject)oldHisDyn, (DynamicObject)oldHisDynCopy, (Set)ignoreKeys);
                oldHisDynCopy.set("lme", (Object)ce);
                oldHisDynCopy.set("bsled", (Object)bsed);
                this.setSysField(oldHisDynCopy, dateNow);
                oldHisDynCopyLsit.add(oldHisDynCopy);
            }
            oldHisDyn.set("datastatus", (Object)"-2");
            oldHisDyn.set("lme", (Object)ce);
            this.setModifyField(oldHisDyn, dateNow);
            oldHisDynLsit.add(oldHisDyn);
            this.setHisField((DynamicObject)modifyDataHis, dateNow);
            this.setSysField((DynamicObject)modifyDataHis, dateNow);
            this.setActualField((DynamicObject)modifyDataHis, dateNow);
            modifyDataHis.set("bsled", (Object)oldBsled);
            modifyDataHis.set("lee", (Object)lee);
            modifyDataHis.set("leedt", (Object)leeDt);
            modifyDataHis.set("datastatus", (Object)status);
            modifyDataHis.set(BRLED, oldHisDyn.get(BRLED));
            modifyDataHis.set(BRLEDT, oldHisDyn.get(BRLEDT));
            modifyDataHis.set("ee", (Object)oldHisDyn.getLong("ce"));
            modifyDataHis.set("eedt", (Object)dateNow);
            if (oldBsedTime.equals(bsedTime)) {
                modifyDataHis.set("isnewbo", oldHisDyn.get("isnewbo"));
            } else {
                modifyDataHis.set("isnewbo", (Object)false);
            }
            if (HRStringUtils.equals((String)"1", (String)status)) {
                boList.add(bo);
                newDynMap.put(bo, (DynamicObject)modifyDataHis);
            }
        });
    }

    private void modifyNewBoDataHis(List<DynamicObject> modifyNewBoDataHisList) {
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)modifyNewBoDataHisList.size());
        HashMap dataHisMap = Maps.newHashMapWithExpectedSize((int)modifyNewBoDataHisList.size());
        modifyNewBoDataHisList.forEach(modifyNewBoData -> {
            Long bo = modifyNewBoData.getLong("bo");
            boList.add(bo);
            dataHisMap.put(bo, modifyNewBoData);
        });
        QFilter boFilter = new QFilter("bo", "in", (Object)boList);
        QFilter newBoFilter = new QFilter("isnewbo", "=", (Object)true);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        DynamicObject[] oldBoDatas = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, newBoFilter, statusFilter});
        Date dateNow = new Date();
        ArrayList newDataHisList = Lists.newArrayListWithExpectedSize((int)modifyNewBoDataHisList.size());
        ArrayList oldBoLists = Lists.newArrayListWithExpectedSize((int)oldBoDatas.length);
        Arrays.stream(oldBoDatas).forEach(oldBoData -> {
            Long oldBo = oldBoData.getLong("bo");
            if (!oldBoLists.contains(oldBo)) {
                oldBoLists.add(oldBo);
                Long oldCe = oldBoData.getLong("ce");
                Date oldBsed = oldBoData.getDate("bsed");
                oldBoData.set("isnewbo", (Object)Boolean.FALSE);
                DynamicObject modifyNewBoData = (DynamicObject)dataHisMap.get(oldBo);
                this.setHisField(modifyNewBoData, dateNow);
                this.setSysField(modifyNewBoData, dateNow);
                this.setActualField(modifyNewBoData, dateNow);
                modifyNewBoData.set("islastversion", (Object)Boolean.FALSE);
                modifyNewBoData.set("bsled", (Object)oldBsed);
                modifyNewBoData.set("lme", (Object)oldCe);
                modifyNewBoData.set("lmedt", (Object)oldBsed);
                modifyNewBoData.set("lee", (Object)oldCe);
                modifyNewBoData.set("leedt", (Object)oldBsed);
                modifyNewBoData.set(BRLED, (Object)dateNow);
                modifyNewBoData.set(BRLEDT, (Object)dateNow.getTime());
                modifyNewBoData.set("isnewbo", (Object)Boolean.TRUE);
                modifyNewBoData.set("datastatus", (Object)"2");
                newDataHisList.add(modifyNewBoData);
            }
        });
        this.hisServiceHelper.update(oldBoDatas);
        this.hisServiceHelper.save(newDataHisList.toArray(new DynamicObject[0]));
    }

    protected String getErrorInfoByMulDy(List<DynamicObject> hisDyList) {
        ArrayList<String> errorInfoList = new ArrayList<String>();
        if (hisDyList == null || hisDyList.size() == 0) {
            errorInfoList.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CommonTimeSeqAttachService_0", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        } else {
            this.validateHisDyList(hisDyList, errorInfoList);
            List repeatData = hisDyList.stream().map(dy -> dy.getDynamicObjectType().getName()).distinct().collect(Collectors.toList());
            if (repeatData.size() != 1) {
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u5386\u53f2\u6570\u636e\u5fc5\u987b\u6765\u81ea\u540c\u4e00\u5b9e\u4f53\uff01", (String)"CommonTimeSeqAttachService_4", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            }
        }
        StringBuilder errorInfo = new StringBuilder();
        List<String> bizErrorInfoList = this.getBizErrorInfo(hisDyList);
        if (bizErrorInfoList != null && bizErrorInfoList.size() > 0) {
            errorInfoList.addAll(bizErrorInfoList);
        }
        if (errorInfoList.size() > 0) {
            int size = errorInfoList.size();
            for (int i = 0; i < size; ++i) {
                errorInfo.append("(").append(i).append(")").append((String)errorInfoList.get(i)).append(System.lineSeparator());
            }
        }
        return errorInfo.toString();
    }

    private void validateHisDyList(List<DynamicObject> hisDyList, List<String> errorInfoList) {
        for (DynamicObject hisDy : hisDyList) {
            if (hisDy.getLong("bo") == 0L) {
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u5bf9\u5e94\u7684\u4e1a\u52a1\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if (hisDy.getLong("ce") == 0L) {
                errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u521b\u5efa\u4e8b\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_2", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
                break;
            }
            if (hisDy.getDate("bsed") != null) continue;
            errorInfoList.add(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u7248\u672c\u7684\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"CommonTimeSeqAttachService_3", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
            break;
        }
    }

    private void checkBoList(List<Long> oldBoList, DynamicObject[] currentDyArr, String fieldName, String errorMessage) {
        List currentIdList = Arrays.stream(currentDyArr).map(currentDy -> currentDy.getLong(fieldName)).collect(Collectors.toList());
        List diffIdAndBo = oldBoList.stream().filter(bo -> !currentIdList.contains(bo)).collect(Collectors.toList());
        if (diffIdAndBo != null && diffIdAndBo.size() > 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " checkBoList currentDyArr ERROR!");
            String boIdStr = StringUtils.join((Object[])diffIdAndBo.toArray(), (String)",");
            logger.error(BO_IN + boIdStr);
            throw new KDBizException(errorMessage);
        }
    }

    protected void beforeLoseEffectDataHis(DynamicObject[] hisDyArr) {
    }

    protected void beforeEffectBoDataHis(DynamicObject[] hisDyArr) {
    }

    protected void beforeEffectDataHis(DynamicObject[] hisDyArr) {
    }

    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
    }

    protected void beforeAddNewDataHis(List<DynamicObject> hisDyList) {
    }

    protected void beforeSaveAndEffectDataHis(List<DynamicObject> hisDyCol) {
    }

    protected void beforeUpdateNewBoDataHis(List<DynamicObject> hisDyList) {
    }
}

