/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.history.model.HistoryEntityModel;
import kd.hr.hbp.common.util.HRStringUtils;

public class HistoryEntityRegister {
    private static final Log logger = LogFactory.getLog(HistoryEntityRegister.class);
    private static final String APP_KEY = "hbp";
    private static final String CACHE_KEY_PREFIX = "hmp_historyregister_";

    public static List<HistoryEntityModel> getEntityHistoryList(String entityType) {
        String modelString = "";
        try {
            modelString = (String)HRAppCache.get((String)APP_KEY).get(CACHE_KEY_PREFIX + entityType, String.class);
        }
        catch (Exception ex) {
            logger.error("get entityHistoryList cache error:" + ex);
        }
        ArrayList<HistoryEntityModel> modelList = null;
        if (!HRStringUtils.isEmpty((String)modelString) && (modelList = SerializationUtils.fromJsonStringToList((String)modelString, HistoryEntityModel.class)) != null && modelList.size() > 0) {
            return modelList;
        }
        modelList = new ArrayList<HistoryEntityModel>();
        DynamicObject[] historyRegisterInfos = HistoryEntityRegister.getHistoryRegisterInfos(entityType);
        if (historyRegisterInfos != null && historyRegisterInfos.length > 0) {
            for (DynamicObject historyRegisterInfo : historyRegisterInfos) {
                HistoryEntityModel historyEntityModel = new HistoryEntityModel();
                historyEntityModel.setEntityType(HistoryEntityUtils.getDynamicObjectFieldId(historyRegisterInfo, "entitytype").toString());
                historyEntityModel.setHisInfoName(historyRegisterInfo.getString("hisinfoname"));
                historyEntityModel.setHisEntityNumber(historyRegisterInfo.getString("hisentitynumber"));
                historyEntityModel.setBsedFieldName(historyRegisterInfo.getString("bsedfieldname"));
                historyEntityModel.setBsledFieldName(historyRegisterInfo.getString("bsledfieldname"));
                historyEntityModel.setModeType(historyRegisterInfo.getString("modetype"));
                historyEntityModel.setHistoryType(historyRegisterInfo.getString("historytype"));
                historyEntityModel.setHisHandlerName(historyRegisterInfo.getString("hishandlername"));
                historyEntityModel.setIndex(historyRegisterInfo.getString("index"));
                historyEntityModel.setHisVerFieldName(historyRegisterInfo.getString("hisverfieldname"));
                modelList.add(historyEntityModel);
            }
        }
        String nodesJson = SerializationUtils.toJsonString(modelList);
        HRAppCache.get((String)APP_KEY).put(CACHE_KEY_PREFIX + entityType, (Object)nodesJson);
        return modelList;
    }

    public static HistoryEntityModel getEntityHistoryByEntityNumber(String entityType, String hisEntityNumber) {
        List<HistoryEntityModel> models = HistoryEntityRegister.getEntityHistoryList(entityType);
        for (HistoryEntityModel model : models) {
            if (!HRStringUtils.equals((String)hisEntityNumber, (String)model.getHisEntityNumber())) continue;
            return model;
        }
        return null;
    }

    private static DynamicObject[] getHistoryRegisterInfos(String entityType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_historyregister");
        QFilter entityFilter = new QFilter("entityType", "=", (Object)Long.valueOf(entityType));
        String selectField = "entitytype, hisinfoname, hisentitynumber, bsedfieldname, bsledfieldname, modetype, historytype, hishandlername, index, hisverfieldname";
        return serviceHelper.queryOriginalArray(selectField, new QFilter[]{entityFilter}, "index");
    }
}

