/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.history.service.CompositionTimeSeqAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgBaseInfoTimeSeqAttachService
extends CompositionTimeSeqAttachService {
    public OrgBaseInfoTimeSeqAttachService() {
        this.isMainPart = true;
    }

    @Override
    protected String getEntityNumber(String hisEntityNumber) {
        return "haos_adminorgmasterdata";
    }

    @Override
    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
        hisDyList.forEach(hisDyn -> {
            String enable;
            String structNumber = hisDyn.getString("structnumber");
            if (HRStringUtils.isEmpty((String)structNumber)) {
                hisDyn.set("structnumber", (Object)this.genStructNumber());
            }
            if (HRStringUtils.isEmpty((String)(enable = hisDyn.getString("enable")))) {
                hisDyn.set("enable", (Object)"2");
            }
        });
    }

    @Override
    protected void beforeEffectBoDataHis(DynamicObject[] hisDyArr) {
        Arrays.stream(hisDyArr).forEach(hisDyn -> hisDyn.set("number", (Object)CodeRuleServiceHelper.getNumber((String)this.serviceHelper.getEntityName(), (DynamicObject)hisDyn, null)));
    }

    @Override
    protected void afterSaveAndEffectBoDataHis(List<DynamicObject> hisDyList) {
        super.afterAddNewBoDataHis(hisDyList);
        this.setOrgStatus(hisDyList.toArray(new DynamicObject[0]));
    }

    @Override
    protected void afterSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
        super.afterSaveAndEffectDataHis(hisDyList);
        ArrayList orgIds = new ArrayList();
        hisDyList.forEach(hisDyn -> {
            Long orgId = hisDyn.getLong("bo");
            orgIds.add(orgId);
        });
        QFilter orgIdFilter = new QFilter("adminorg", "in", orgIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminstruct");
        DynamicObject[] structInfos = serviceHelper.query("adminorg.id, parent.id", new QFilter[]{orgIdFilter});
        HashMap orgParentIdMap = new HashMap();
        Arrays.stream(structInfos).forEach(structInfo -> {
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(structInfo, "adminorg");
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId(structInfo, "parent");
            orgParentIdMap.put(orgId, parentId);
        });
        serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
        QFilter idFilter = new QFilter("id", "in", orgIds);
        DynamicObject[] orgDys = serviceHelper.query("parent, id", new QFilter[]{idFilter});
        Arrays.stream(orgDys).forEach(orgDyn -> {
            Long orgId = orgDyn.getLong("id");
            orgDyn.set("parent", orgParentIdMap.get(orgId));
        });
        serviceHelper.updateDatas(orgDys);
    }

    @Override
    protected void afterEffectBoDataHis(List<Long> eventIds) {
        super.afterEffectBoDataHis(eventIds);
        QFilter ceFilter = new QFilter("ce", "in", eventIds);
        DynamicObject[] hisDys = this.hisServiceHelper.query("bo", new QFilter[]{ceFilter});
        this.setOrgStatus(hisDys);
    }

    private void setOrgStatus(DynamicObject[] hisDys) {
        ArrayList boList = new ArrayList();
        Arrays.stream(hisDys).forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            boList.add(bo);
        });
        QFilter boFilter = new QFilter("id", "in", boList);
        DynamicObject[] dys = this.serviceHelper.query("status", new QFilter[]{boFilter});
        Arrays.stream(dys).forEach(dyn -> {
            String status = dyn.getString("status");
            if (HRStringUtils.isEmpty((String)status)) {
                dyn.set("status", (Object)"C");
            }
        });
        this.serviceHelper.updateDatas(dys);
    }

    private String genStructNumber() {
        return ORM.create().genStringId("haos_adminorghr");
    }

    @Override
    protected Set<String> getSpecialIgnoreKeySet() {
        HashSet<String> set = new HashSet<String>();
        set.add("status");
        set.add("establishmentdate");
        set.add("parent");
        return set;
    }

    @Override
    protected String getHisBoField() {
        return "bo";
    }
}

