/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.CompositionTimeSeqAttachService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.jetbrains.annotations.NotNull;

public class OrgLongNumberTimeSeqAttachService
extends CompositionTimeSeqAttachService {
    private static final String STRUCTNUMBER = "structnumber";
    private static final String STRUCTLONGNUMBER = "structlongnumber";

    public OrgLongNumberTimeSeqAttachService() {
        this.isMainPart = false;
    }

    @Override
    protected String getEntityNumber(String hisEntityNum) {
        return "haos_adminstruct";
    }

    protected String getStructHisPageNumber() {
        return "haos_adminstructhis";
    }

    protected String getMainHisPageNumber() {
        return "haos_adminorghis";
    }

    @Override
    protected Set<String> getSpecialIgnoreKeySet() {
        HashSet<String> keyHashSet = new HashSet<String>();
        keyHashSet.add("fullname");
        keyHashSet.add("sortcode");
        keyHashSet.add("parent");
        keyHashSet.add("isleaf");
        keyHashSet.add(STRUCTLONGNUMBER);
        return keyHashSet;
    }

    @Override
    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
        super.beforeAddNewBoDataHis(hisDyList);
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        hisDyList.forEach(historyDynamic -> {
            Long bo = historyDynamic.getLong("bo");
            boList.add(bo);
        });
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.getStructHisPageNumber());
        QFilter boFilter = new QFilter("bo", "in", (Object)boList);
        DynamicObject[] orgStructDynamicArray = hrBaseServiceHelper.query("bo, structlongnumber", new QFilter[]{boFilter});
        HashSet<String> structNumberHashSet = new HashSet<String>();
        HashMap<Long, String> boStructLongNumberMap = new HashMap<Long, String>();
        this.orgStructDyn(orgStructDynamicArray, structNumberHashSet, boStructLongNumberMap);
        hrBaseServiceHelper = new HRBaseServiceHelper(this.getMainHisPageNumber());
        QFilter structLongNumberField = new QFilter(STRUCTNUMBER, "in", structNumberHashSet);
        DynamicObject[] orgHisDys = hrBaseServiceHelper.query("number, structnumber", new QFilter[]{structLongNumberField});
        Map<String, String> structNumberMap = this.getStringStringMap(orgHisDys);
        this.hisDyn(hisDyList, boStructLongNumberMap, structNumberMap);
    }

    private void hisDyn(List<DynamicObject> hisDyList, Map<Long, String> boStructLongNumberMap, Map<String, String> structNumberMap) {
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            String structLongNum = (String)boStructLongNumberMap.get(bo);
            String[] structNums = HRStringUtils.split((String)structLongNum, (String)"!");
            String longNum = "";
            for (String structNumber : structNums) {
                longNum = HRStringUtils.isEmpty((String)longNum) ? (String)structNumberMap.get(structNumber) : longNum + "!" + (String)structNumberMap.get(structNumber);
            }
            hisDyn.set("longnumber", (Object)longNum);
        });
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDynList) {
        this.saveAndEffectDataHis(hisDynList, "2");
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDynList) {
        this.saveAndEffectDataHis(hisDynList, "-1");
    }

    private void saveAndEffectDataHis(List<DynamicObject> hisDynList, String operateKey) {
        this.checkPreparEffectDateBeforeEffectDataHis(hisDynList.toArray(new DynamicObject[0]));
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)hisDynList.size());
        hisDynList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            boList.add(bo);
        });
        HRBaseServiceHelper hrBaseServiceHelpers = new HRBaseServiceHelper(this.getStructHisPageNumber());
        QFilter boFilter = new QFilter("bo", "in", (Object)boList);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] orgStructDynamicArray = hrBaseServiceHelpers.query("bo, structlongnumber", new QFilter[]{boFilter, statusFilter});
        HashSet<String> structNumbers = new HashSet<String>();
        HashMap<Long, String> boStructLongNumberMap = new HashMap<Long, String>();
        this.orgStructDyn(orgStructDynamicArray, structNumbers, boStructLongNumberMap);
        hrBaseServiceHelpers = new HRBaseServiceHelper(this.getMainHisPageNumber());
        QFilter structLongNumberField = new QFilter(STRUCTNUMBER, "in", structNumbers);
        DynamicObject[] orgHisDys = hrBaseServiceHelpers.query("number, structnumber", new QFilter[]{structLongNumberField, statusFilter});
        Map<String, String> structNumberMap = this.getStringStringMap(orgHisDys);
        HashMap hisDynMap = Maps.newHashMapWithExpectedSize((int)hisDynList.size());
        this.hisDynMap(hisDynList, boStructLongNumberMap, structNumberMap, hisDynMap);
        DynamicObject[] oldHisDynamicArrs = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, statusFilter});
        ArrayList oldHisDynList = Lists.newArrayListWithExpectedSize((int)oldHisDynamicArrs.length);
        ArrayList newHisDynList = Lists.newArrayListWithExpectedSize((int)oldHisDynamicArrs.length);
        ArrayList newBoList = Lists.newArrayListWithExpectedSize((int)oldHisDynamicArrs.length);
        this.addNewBoList(hisDynMap, oldHisDynamicArrs, oldHisDynList, newHisDynList, newBoList);
        QFilter idFilter = new QFilter("id", "in", (Object)newBoList);
        DynamicObject[] currentDynArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        Date dateNow = new Date();
        Map<Long, Long> boCeNewHisDynMap = Arrays.stream(hisDynList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), newHisDy -> newHisDy.getLong("ce")));
        for (DynamicObject oldHisDyn : oldHisDynList) {
            this.oldHisDyn(operateKey, hisDynMap, dateNow, boCeNewHisDynMap, oldHisDyn);
        }
        this.hisServiceHelper.update(oldHisDynList.toArray(new DynamicObject[0]));
        for (DynamicObject hisDyn2 : newHisDynList) {
            this.setHisDyn(dateNow, hisDyn2);
        }
        this.hisServiceHelper.save(newHisDynList.toArray(new DynamicObject[0]));
        this.currentDyn(hisDynMap, currentDynArr);
        this.serviceHelper.update(currentDynArr);
        this.afterSaveAndEffectDataHis(newHisDynList);
    }

    @NotNull
    private Map<String, String> getStringStringMap(DynamicObject[] orgHisDys) {
        HashMap<String, String> structNumberMap = new HashMap<String, String>();
        Arrays.stream(orgHisDys).forEach(orgHisDyn -> {
            String structNumber = orgHisDyn.getString(STRUCTNUMBER);
            String number = orgHisDyn.getString("number");
            structNumberMap.put(structNumber, number);
        });
        return structNumberMap;
    }

    private void setHisDyn(Date dateNow, DynamicObject hisDyn) {
        this.setHisField(hisDyn, dateNow);
        this.setSysField(hisDyn, dateNow);
        hisDyn.set("isnewbo", (Object)"0");
        hisDyn.set("ee", (Object)hisDyn.getLong("ce"));
        hisDyn.set("eedt", (Object)dateNow);
        hisDyn.set("datastatus", (Object)"1");
        hisDyn.set("id", (Object)this.genHistoryObjectInfoId());
        this.setActualField(hisDyn, dateNow);
    }

    private void currentDyn(Map<Long, DynamicObject> hisDynMap, DynamicObject[] currentDynArr) {
        Arrays.stream(currentDynArr).forEach(currentDynamic -> {
            long id = currentDynamic.getLong("id");
            DynamicObject hisDy = (DynamicObject)hisDynMap.get(id);
            currentDynamic.set("longnumber", (Object)hisDy.getString("longnumber"));
            currentDynamic.set("id", (Object)id);
        });
    }

    private void oldHisDyn(String operateKey, Map<Long, DynamicObject> hisDynMap, Date dateNow, Map<Long, Long> boCeNewHisDynMap, DynamicObject oldHisDyn) {
        long bo = oldHisDyn.getLong("bo");
        DynamicObject hisDyn = hisDynMap.get(bo);
        Date newBsed = hisDyn.getDate("bsed");
        long eventId = hisDyn.getLong("ce");
        oldHisDyn.set("lme", (Object)boCeNewHisDynMap.get(oldHisDyn.getLong("bo")));
        oldHisDyn.set("lmedt", (Object)dateNow);
        if (HRStringUtils.equals((String)operateKey, (String)"2")) {
            this.setInvalidDynamicObject(oldHisDyn, eventId, newBsed, dateNow);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"-1")) {
            this.setDiscardDynamicObject(oldHisDyn, eventId, newBsed, dateNow);
        }
    }

    private void addNewBoList(Map<Long, DynamicObject> hisDynMap, DynamicObject[] oldHisDynamicArrs, List<DynamicObject> oldHisDynList, List<DynamicObject> newHisDynList, List<Long> newBoList) {
        Arrays.stream(oldHisDynamicArrs).forEach(oldHisDynamic -> {
            String longNumber;
            Long bo = oldHisDynamic.getLong("bo");
            DynamicObject hisDyn = (DynamicObject)hisDynMap.get(bo);
            String oldLongNumber = oldHisDynamic.getString("longnumber");
            if (!HRStringUtils.equals((String)oldLongNumber, (String)(longNumber = hisDyn.getString("longnumber")))) {
                oldHisDynList.add((DynamicObject)oldHisDynamic);
                newHisDynList.add(hisDyn);
                newBoList.add(bo);
            }
        });
    }

    private void hisDynMap(List<DynamicObject> hisDynList, Map<Long, String> boStructLongNumberMap, Map<String, String> structNumberMap, Map<Long, DynamicObject> hisDynMap) {
        hisDynList.forEach(hisDynamic -> {
            Long bo = hisDynamic.getLong("bo");
            String structLongNumber = (String)boStructLongNumberMap.get(bo);
            String[] structNumberArr = HRStringUtils.split((String)structLongNumber, (String)"!");
            String longNumber = "";
            for (String structNum : structNumberArr) {
                longNumber = HRStringUtils.isEmpty((String)longNumber) ? (String)structNumberMap.get(structNum) : longNumber + "!" + (String)structNumberMap.get(structNum);
            }
            hisDynamic.set("longnumber", (Object)longNumber);
            hisDynMap.put(bo, (DynamicObject)hisDynamic);
        });
    }

    private void orgStructDyn(DynamicObject[] orgStructDynamicArray, Set<String> structNumbers, Map<Long, String> boStructLongNumberMap) {
        Arrays.stream(orgStructDynamicArray).forEach(orgStructDynamic -> {
            Long bo = orgStructDynamic.getLong("bo");
            String structLongNum = orgStructDynamic.getString(STRUCTLONGNUMBER);
            boStructLongNumberMap.put(bo, structLongNum);
            String[] structNums = HRStringUtils.split((String)structLongNum, (String)"!");
            Arrays.stream(structNums).forEach(structNum -> structNumbers.add((String)structNum));
        });
    }

    private void setInvalidDynamicObject(DynamicObject oldHisDyn, Long eventId, Date bsled, Date currDate) {
        oldHisDyn.set("lee", (Object)eventId);
        oldHisDyn.set("leedt", (Object)currDate);
        oldHisDyn.set("bsled", (Object)bsled);
        oldHisDyn.set("brled", (Object)currDate);
        oldHisDyn.set("brledt", (Object)System.currentTimeMillis());
        oldHisDyn.set("datastatus", (Object)"2");
    }

    private void setDiscardDynamicObject(DynamicObject oldHisDyn, Long eventId, Date bsled, Date currDate) {
        oldHisDyn.set("de", (Object)eventId);
        oldHisDyn.set("dedt", (Object)currDate);
        oldHisDyn.set("datastatus", (Object)"-1");
    }
}

