/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.service.CompositionTimeSeqAttachService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.jetbrains.annotations.NotNull;

public class OrgSortCodeTimeSeqAttachService
extends CompositionTimeSeqAttachService {
    private static final String STRUCTLONGNUMBER = "structlongnumber";
    private static final String STRUCTNUMBER = "structnumber";
    private static final String SORTCODE = "sortcode";

    public OrgSortCodeTimeSeqAttachService() {
        this.isMainPart = false;
    }

    @Override
    protected String getEntityNumber(String hisEntityNumberStr) {
        return "haos_adminstruct";
    }

    protected String getStructHisPageNumber() {
        return "haos_adminstructhis";
    }

    protected String getMainHisPageNumber() {
        return "haos_adminorghis";
    }

    @Override
    protected Set<String> getSpecialIgnoreKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("fullname");
        keySet.add("longnumber");
        keySet.add("parent");
        keySet.add("level");
        keySet.add("isleaf");
        keySet.add(STRUCTLONGNUMBER);
        return keySet;
    }

    @Override
    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
        super.beforeAddNewBoDataHis(hisDyList);
        ArrayList boList = new ArrayList();
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            boList.add(bo);
        });
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getStructHisPageNumber());
        QFilter boFilter = new QFilter("bo", "in", boList);
        DynamicObject[] orgStructDyns = serviceHelper.query("bo, structlongnumber", new QFilter[]{boFilter});
        HashSet<String> structNumberSet = new HashSet<String>();
        HashMap<Long, String> boStructLongNumberMap = new HashMap<Long, String>();
        this.putNumberSet(orgStructDyns, structNumberSet, boStructLongNumberMap);
        serviceHelper = new HRBaseServiceHelper(this.getMainHisPageNumber());
        QFilter structLongNumberField = new QFilter(STRUCTNUMBER, "in", structNumberSet);
        DynamicObject[] orgHisDys = serviceHelper.query("index, structnumber", new QFilter[]{structLongNumberField});
        HashMap structNumberIndexMap = new HashMap();
        Arrays.stream(orgHisDys).forEach(orgHisDyn -> {
            String structNumber = orgHisDyn.getString(STRUCTNUMBER);
            String index = this.changeNumberToThree(orgHisDyn.getString("index"));
            structNumberIndexMap.put(structNumber, index);
        });
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            String structLongNumber = (String)boStructLongNumberMap.get(bo);
            String[] structNumbers = HRStringUtils.split((String)structLongNumber, (String)"!");
            String sortCode = "";
            for (String structNumber : structNumbers) {
                sortCode = HRStringUtils.isEmpty((String)sortCode) ? (String)structNumberIndexMap.get(structNumber) : sortCode + "!" + (String)structNumberIndexMap.get(structNumber);
            }
            hisDyn.set(SORTCODE, (Object)sortCode);
        });
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDynamicList) {
        this.saveAndEffectDataHis(hisDynamicList, "2");
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDynamicList) {
        this.saveAndEffectDataHis(hisDynamicList, "-1");
    }

    private void saveAndEffectDataHis(List<DynamicObject> hisDynamicList, String operateKey) {
        this.checkPreparEffectDateBeforeEffectDataHis(hisDynamicList.toArray(new DynamicObject[0]));
        ArrayList boList = Lists.newArrayListWithExpectedSize((int)hisDynamicList.size());
        hisDynamicList.forEach(hisDynamic -> {
            Long bo = hisDynamic.getLong("bo");
            boList.add(bo);
        });
        HRBaseServiceHelper baseServiceHelpers = new HRBaseServiceHelper(this.getStructHisPageNumber());
        QFilter boFilter = new QFilter("bo", "in", (Object)boList);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] orgStructDynamicArr = baseServiceHelpers.query("bo, structlongnumber", new QFilter[]{boFilter, statusFilter});
        HashSet<String> structNumberSet = new HashSet<String>();
        HashMap<Long, String> boStructLongNumberMap = new HashMap<Long, String>();
        this.putNumberSet(orgStructDynamicArr, structNumberSet, boStructLongNumberMap);
        baseServiceHelpers = new HRBaseServiceHelper(this.getMainHisPageNumber());
        QFilter structLongNumField = new QFilter(STRUCTNUMBER, "in", structNumberSet);
        DynamicObject[] orgHisDys = baseServiceHelpers.query("index, structnumber", new QFilter[]{structLongNumField, statusFilter});
        HashMap<String, String> structNumberMap = new HashMap<String, String>();
        Arrays.stream(orgHisDys).forEach(orgHisDyn -> {
            String structNumber = orgHisDyn.getString(STRUCTNUMBER);
            String number = orgHisDyn.getString("index");
            structNumberMap.put(structNumber, this.changeNumberToThree(number));
        });
        Map<Long, DynamicObject> hisDynMap = this.getHisDynMap(hisDynamicList, boStructLongNumberMap, structNumberMap);
        DynamicObject[] oldHisDyArrs = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, statusFilter});
        ArrayList oldHisDynamicList = Lists.newArrayListWithExpectedSize((int)oldHisDyArrs.length);
        ArrayList newHisDynamicList = Lists.newArrayListWithExpectedSize((int)oldHisDyArrs.length);
        ArrayList newBoList = Lists.newArrayListWithExpectedSize((int)oldHisDyArrs.length);
        this.valNewBo(hisDynMap, oldHisDyArrs, oldHisDynamicList, newHisDynamicList, newBoList);
        QFilter idFilter = new QFilter("id", "in", (Object)newBoList);
        DynamicObject[] currentDynamics = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        Date dateCurr = new Date();
        this.updateOldHisDy(hisDynamicList, operateKey, hisDynMap, oldHisDynamicList, dateCurr);
        this.updateCurrentDy(hisDynMap, newHisDynamicList, currentDynamics, dateCurr);
        this.afterSaveAndEffectDataHis(newHisDynamicList);
    }

    private void putNumberSet(DynamicObject[] orgStructDynamicArr, Set<String> structNumberSet, Map<Long, String> boStructLongNumberMap) {
        Arrays.stream(orgStructDynamicArr).forEach(orgStructDynamic -> {
            Long bo = orgStructDynamic.getLong("bo");
            String structLongNumber = orgStructDynamic.getString(STRUCTLONGNUMBER);
            boStructLongNumberMap.put(bo, structLongNumber);
            String[] structNumberArr = HRStringUtils.split((String)structLongNumber, (String)"!");
            Arrays.stream(structNumberArr).forEach(structNumber -> structNumberSet.add((String)structNumber));
        });
    }

    @NotNull
    private Map<Long, DynamicObject> getHisDynMap(List<DynamicObject> hisDynamicList, Map<Long, String> boStructLongNumberMap, Map<String, String> structNumberMap) {
        HashMap hisDynMap = Maps.newHashMapWithExpectedSize((int)hisDynamicList.size());
        hisDynamicList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            String structLongNumber = (String)boStructLongNumberMap.get(bo);
            String[] structNumbers = HRStringUtils.split((String)structLongNumber, (String)"!");
            String sortcode = "";
            for (String structNumber : structNumbers) {
                sortcode = HRStringUtils.isEmpty((String)sortcode) ? (String)structNumberMap.get(structNumber) : sortcode + "!" + (String)structNumberMap.get(structNumber);
            }
            hisDyn.set(SORTCODE, (Object)sortcode);
            hisDynMap.put(bo, hisDyn);
        });
        return hisDynMap;
    }

    private void valNewBo(Map<Long, DynamicObject> hisDynMap, DynamicObject[] oldHisDyArrs, List<DynamicObject> oldHisDynamicList, List<DynamicObject> newHisDynamicList, List<Long> newBoList) {
        Arrays.stream(oldHisDyArrs).forEach(oldHisDyn -> {
            String sortCode;
            Long bo = oldHisDyn.getLong("bo");
            DynamicObject hisDynamic = (DynamicObject)hisDynMap.get(bo);
            String oldSortCode = oldHisDyn.getString(SORTCODE);
            if (!HRStringUtils.equals((String)oldSortCode, (String)(sortCode = hisDynamic.getString(SORTCODE)))) {
                oldHisDynamicList.add((DynamicObject)oldHisDyn);
                newHisDynamicList.add(hisDynamic);
                newBoList.add(bo);
            }
        });
    }

    private void updateOldHisDy(List<DynamicObject> hisDynamicList, String operateKey, Map<Long, DynamicObject> hisDynMap, List<DynamicObject> oldHisDynamicList, Date dateCurr) {
        Map<Long, Long> boCeNewHisDynamicMap = Arrays.stream(hisDynamicList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHisDy -> newHisDy.getLong("bo"), newHisDy -> newHisDy.getLong("ce")));
        for (DynamicObject oldHisDynamic : oldHisDynamicList) {
            long bo = oldHisDynamic.getLong("bo");
            DynamicObject hisDynamic = hisDynMap.get(bo);
            Date newBsed = hisDynamic.getDate("bsed");
            long eventId = hisDynamic.getLong("ce");
            oldHisDynamic.set("lme", (Object)boCeNewHisDynamicMap.get(oldHisDynamic.getLong("bo")));
            oldHisDynamic.set("lmedt", (Object)dateCurr);
            if (HRStringUtils.equals((String)operateKey, (String)"2")) {
                this.setInvalidDynamicObject(oldHisDynamic, eventId, newBsed, dateCurr);
                continue;
            }
            if (!HRStringUtils.equals((String)operateKey, (String)"-1")) continue;
            this.setDiscardDynamicObject(oldHisDynamic, eventId, newBsed, dateCurr);
        }
        this.hisServiceHelper.update(oldHisDynamicList.toArray(new DynamicObject[0]));
    }

    private void updateCurrentDy(Map<Long, DynamicObject> hisDynMap, List<DynamicObject> newHisDynamicList, DynamicObject[] currentDynamics, Date dateCurr) {
        for (DynamicObject hisDynamic : newHisDynamicList) {
            this.setHisField(hisDynamic, dateCurr);
            this.setSysField(hisDynamic, dateCurr);
            hisDynamic.set("isnewbo", (Object)"0");
            hisDynamic.set("ee", (Object)hisDynamic.getLong("ce"));
            hisDynamic.set("eedt", (Object)dateCurr);
            hisDynamic.set("datastatus", (Object)"1");
            hisDynamic.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField(hisDynamic, dateCurr);
        }
        this.hisServiceHelper.save(newHisDynamicList.toArray(new DynamicObject[0]));
        Arrays.stream(currentDynamics).forEach(currentDyn -> {
            long id = currentDyn.getLong("id");
            DynamicObject hisDy = (DynamicObject)hisDynMap.get(id);
            currentDyn.set(SORTCODE, hisDy.get(SORTCODE));
            currentDyn.set("id", (Object)id);
        });
        this.serviceHelper.update(currentDynamics);
    }

    private void setInvalidDynamicObject(DynamicObject oldHisDynamic, Long eventId, Date bsled, Date dateNow) {
        oldHisDynamic.set("lee", (Object)eventId);
        oldHisDynamic.set("leedt", (Object)dateNow);
        oldHisDynamic.set("bsled", (Object)bsled);
        oldHisDynamic.set("brled", (Object)dateNow);
        oldHisDynamic.set("brledt", (Object)System.currentTimeMillis());
        oldHisDynamic.set("datastatus", (Object)"2");
    }

    private void setDiscardDynamicObject(DynamicObject oldHisDynamic, Long eventId, Date bsled, Date dateNow) {
        oldHisDynamic.set("de", (Object)eventId);
        oldHisDynamic.set("dedt", (Object)dateNow);
        oldHisDynamic.set("datastatus", (Object)"-1");
    }

    private String changeNumberToThree(String number) {
        int length = number.length();
        if (length == 1) {
            number = "00" + number;
        } else if (number.length() == 2) {
            number = "0" + number;
        }
        return number;
    }
}

