/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.history.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.facade.OrgStructureLongNumberChangeFacade;
import kd.hr.hbp.business.history.helper.OrgHistoryHelper;
import kd.hr.hbp.business.history.service.CompositionTimeSeqAttachService;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.history.model.HistoryLongNumberChangeModel;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class OrgStructureTimeSeqAttachService
extends CompositionTimeSeqAttachService {
    private static final Log logger = LogFactory.getLog(OrgStructureTimeSeqAttachService.class);
    private static final String HRMP_HBP_BUSINESS = "hrmp-hbp-business";
    private static final String STRUCTLONGNUMBER = "structlongnumber";

    public OrgStructureTimeSeqAttachService() {
        this.isMainPart = true;
    }

    @Override
    protected String getEntityNumber(String hisEntityNumber) {
        return "haos_adminorgmdstruct";
    }

    protected String getMainEntityField() {
        return "org";
    }

    protected String getParentField() {
        return "parent";
    }

    protected String getOrgBaseInfoHisEntitNumber() {
        return "";
    }

    @Override
    protected void beforeAddNewBoDataHis(List<DynamicObject> hisDyList) {
        super.beforeAddNewBoDataHis(hisDyList);
        List<Long> parentIds = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).map(hisDyn -> HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getParentField())).collect(Collectors.toList());
        List<Long> orgIds = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).map(hisDyn -> HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getMainEntityField())).collect(Collectors.toList());
        parentIds.remove(0L);
        this.setStructLongNumberToHisDyn(orgIds, parentIds, hisDyList);
    }

    @Override
    public void batchAddNewDataHis(List<DynamicObject> hisDynList) {
        this.beforeAddNewDataHis(hisDynList);
        String errorInfo = this.getErrorInfoByMulDy(hisDynList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List<Long> boList = hisDynList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        Map<Long, Date> boDateMap = this.getLongDateMap(hisDynList);
        OrgHistoryHelper historyHelper = new OrgHistoryHelper("", "");
        List<DynamicObject> oldHisDyList = historyHelper.getEntityHistoryDatasBeforeTargetDate(this.hisServiceHelper.getEntityName(), boList, boDateMap);
        ArrayList<DynamicObject> newHisDyList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateOldHisDyList = new ArrayList<DynamicObject>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        HashMap<Long, Long> orgParentIdMap = new HashMap<Long, Long>();
        this.orgByparentOrgChanged(hisDynList, oldHisDyList, newHisDyList, updateOldHisDyList, parentIdList, orgIdList, orgParentIdMap);
        this.setStructLongNumberToHisDyn(orgIdList, parentIdList, newHisDyList);
        DynamicObject[] oldHisDyArr = updateOldHisDyList.toArray(new DynamicObject[0]);
        Arrays.stream(oldHisDyArr).forEach(oldHisDy -> oldHisDy.set("islastversion", (Object)false));
        if (oldHisDyArr.length > 0) {
            this.hisServiceHelper.update(oldHisDyArr);
        }
        Date dateNow = new Date();
        newHisDyList.forEach(hisDy -> {
            this.setHisField((DynamicObject)hisDy, dateNow);
            this.setSysField((DynamicObject)hisDy, dateNow);
            hisDy.set("isnewbo", (Object)false);
        });
        if (newHisDyList.size() > 0) {
            this.hisServiceHelper.save(newHisDyList.toArray(new DynamicObject[hisDynList.size()]));
        }
        this.afterAddNewDataHis(newHisDyList);
    }

    private void orgByparentOrgChanged(List<DynamicObject> hisDynList, List<DynamicObject> oldHisDyList, List<DynamicObject> newHisDyList, List<DynamicObject> updateOldHisDyList, List<Long> parentIdList, List<Long> orgIdList, Map<Long, Long> orgParentIdMap) {
        oldHisDyList.forEach(oldHisDy -> {
            Long bo = oldHisDy.getLong("bo");
            hisDynList.forEach(hisDy -> {
                Long parentId;
                Long oldParentId;
                Long newBo = hisDy.getLong("bo");
                if (bo.equals(newBo) && !(oldParentId = HistoryEntityUtils.getDynamicObjectFieldId(oldHisDy, this.getParentField())).equals(parentId = HistoryEntityUtils.getDynamicObjectFieldId(hisDy, this.getParentField()))) {
                    newHisDyList.add((DynamicObject)hisDy);
                    updateOldHisDyList.add((DynamicObject)oldHisDy);
                    parentIdList.add(parentId);
                    Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(hisDy, this.getMainEntityField());
                    orgParentIdMap.put(orgId, parentId);
                    orgIdList.add(orgId);
                }
            });
        });
    }

    @Override
    public void batchModifyAndEffectBoDatas(List<DynamicObject> hisDyList) {
        this.saveAndEffectDataHis(hisDyList, "-1");
    }

    @Override
    public void batchSaveAndEffectDataHis(List<DynamicObject> hisDyList) {
        this.saveAndEffectDataHis(hisDyList, "2");
    }

    private void saveAndEffectDataHis(List<DynamicObject> historyDynamicList, String operateKey) {
        this.beforeSaveAndEffectDataHis(historyDynamicList);
        String errorInfo = this.getErrorInfoByMulDy(historyDynamicList);
        if (!HRStringUtils.isEmpty((String)errorInfo)) {
            throw new KDBizException(errorInfo);
        }
        List<Long> oldBoList = historyDynamicList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        QFilter oldHisDyFilter = new QFilter("bo", "in", oldBoList);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        oldHisDyFilter.and(dataStatusFilter);
        DynamicObject[] oldHisDyArrs = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{oldHisDyFilter});
        this.validateoOldHistDyArr(oldBoList, oldHisDyArrs);
        this.checkBoList(oldBoList, oldHisDyArrs, "bo", ResManager.loadKDString((String)"\u8be5bo\u65e7\u7684\u6570\u636e\u7248\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonTimeSeqAttachService_6", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        Map<Long, DynamicObject> boHisDynMap = historyDynamicList.stream().collect(Collectors.toMap(hisDy -> hisDy.getLong("bo"), Function.identity()));
        List<Long> boList = historyDynamicList.stream().map(hisDy -> hisDy.getLong("bo")).collect(Collectors.toList());
        Map<Long, Date> boDateMap = this.getLongDateMap(historyDynamicList);
        OrgHistoryHelper historyHelper = new OrgHistoryHelper("", "");
        List<DynamicObject> oldHisDynList = historyHelper.getEntityHistoryDatasBeforeTargetDate(this.hisServiceHelper.getEntityName(), boList, boDateMap);
        ArrayList newHisDynList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        ArrayList updateOldHisDyList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        ArrayList parentIdList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        ArrayList newBoList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        ArrayList oldHisBoList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        HashMap<Long, Long> orgParentIdMap = new HashMap<Long, Long>();
        this.orgByParent(historyDynamicList, oldHisDynList, newHisDynList, updateOldHisDyList, parentIdList, orgIdList, newBoList, oldHisBoList, orgParentIdMap);
        this.modifyNewBoDataHis(oldHisBoList, historyDynamicList);
        this.setStructLongNumberToHisDyn(orgIdList, parentIdList, newHisDynList);
        DynamicObject[] oldHisDyns = updateOldHisDyList.toArray(new DynamicObject[0]);
        this.beforeLoseEffectDataHis(oldHisDyns);
        QFilter idFilter = new QFilter(this.getMainEntityField(), "in", (Object)orgIdList);
        DynamicObject[] currentDynArr = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        this.errorInfo(oldBoList, orgIdList, currentDynArr);
        this.checkBoList(newBoList, currentDynArr, "id", ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5bo\u5f53\u524d\u8868\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonTimeSeqAttachService_11", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        Date dateCurr = new Date();
        Map<Long, Long> boCeNewHisDynMap = Arrays.stream(historyDynamicList.toArray(new DynamicObject[0])).collect(Collectors.toMap(newHistoryDynamic -> newHistoryDynamic.getLong("bo"), newHistoryDynamic -> newHistoryDynamic.getLong("ce")));
        this.updateOldHis(operateKey, boHisDynMap, oldHisDyns, dateCurr, boCeNewHisDynMap);
        this.saveNewList(newHisDynList, dateCurr);
        this.updateCurrentArr(boHisDynMap, currentDynArr);
        this.afterSaveAndEffectDataHis(newHisDynList);
        this.addNewHis(oldHisDynList, newHisDynList, newBoList);
        this.afterStructLongNumberChanged(updateOldHisDyList, newHisDynList, newHisDynList);
    }

    @NotNull
    private Map<Long, Date> getLongDateMap(List<DynamicObject> historyDynamicList) {
        return historyDynamicList.stream().collect(Collectors.toMap(hisDy -> hisDy.getLong("bo"), hisDy -> hisDy.getDate("bsed")));
    }

    private void errorInfo(List<Long> oldBoList, List<Long> orgIdList, DynamicObject[] currentDynArr) {
        if (orgIdList.size() > 0 && (currentDynArr == null || currentDynArr.length == 0)) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis currentDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.error("bo is:" + oldBoStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8be5bo\u5f53\u524d\u8868\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01", (String)"CommonTimeSeqAttachService_11", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void updateCurrentArr(Map<Long, DynamicObject> boHisDynMap, DynamicObject[] currentDynArr) {
        Arrays.stream(currentDynArr).forEach(currentDyn -> {
            long id = currentDyn.getLong("id");
            DynamicObject hisDyn = (DynamicObject)boHisDynMap.get(id);
            DynamicObject newDyn = this.genCurrentDynamicObject(this.serviceHelper.getEntityName(), hisDyn);
            HRDynamicObjectUtils.copy((DynamicObject)newDyn, (DynamicObject)currentDyn, this.getSpecialIgnoreKeySet());
            currentDyn.set("id", (Object)id);
        });
        this.serviceHelper.update(currentDynArr);
    }

    private void addNewHis(List<DynamicObject> oldHisDynList, List<DynamicObject> newHisDynList, List<Long> newBoList) {
        ArrayList noChangeHisDynList = Lists.newArrayListWithExpectedSize((int)oldHisDynList.size());
        oldHisDynList.forEach(oldHisDyn -> {
            Long oldBo = oldHisDyn.getLong("bo");
            if (!newBoList.contains(oldBo)) {
                noChangeHisDynList.add(oldHisDyn);
            }
        });
        newHisDynList.addAll(noChangeHisDynList);
    }

    private void saveNewList(List<DynamicObject> newHisDynList, Date dateCurr) {
        for (DynamicObject hisDy : newHisDynList) {
            this.setHisField(hisDy, dateCurr);
            this.setSysField(hisDy, dateCurr);
            hisDy.set("isnewbo", (Object)"0");
            hisDy.set("ee", (Object)hisDy.getLong("ce"));
            hisDy.set("eedt", (Object)dateCurr);
            hisDy.set("datastatus", (Object)"1");
            hisDy.set("id", (Object)this.genHistoryObjectInfoId());
            this.setActualField(hisDy, dateCurr);
        }
        this.hisServiceHelper.save(newHisDynList.toArray(new DynamicObject[newHisDynList.size()]));
    }

    private void updateOldHis(String operateKey, Map<Long, DynamicObject> boHisDynMap, DynamicObject[] oldHisDyns, Date dateCurr, Map<Long, Long> boCeNewHisDynMap) {
        for (DynamicObject oldHisDyn : oldHisDyns) {
            long bo = oldHisDyn.getLong("bo");
            DynamicObject historyDynamic = boHisDynMap.get(bo);
            Date newBsed = historyDynamic.getDate("bsed");
            long eventId = historyDynamic.getLong("ce");
            oldHisDyn.set("lme", (Object)boCeNewHisDynMap.get(oldHisDyn.getLong("bo")));
            oldHisDyn.set("lmedt", (Object)dateCurr);
            if (HRStringUtils.equals((String)operateKey, (String)"2")) {
                this.setInvalidDynamicObject(oldHisDyn, eventId, newBsed, dateCurr);
                continue;
            }
            if (!HRStringUtils.equals((String)operateKey, (String)"-1")) continue;
            this.setDiscardDynamicObject(oldHisDyn, eventId, newBsed, dateCurr);
        }
        this.hisServiceHelper.update(oldHisDyns);
    }

    private void orgByParent(List<DynamicObject> historyDynamicList, List<DynamicObject> oldHisDynList, List<DynamicObject> newHisDynList, List<DynamicObject> updateOldHisDyList, List<Long> parentIdList, List<Long> orgIdList, List<Long> newBoList, List<Long> oldHisBoList, Map<Long, Long> orgParentIdMap) {
        oldHisDynList.forEach(oldHisDy -> {
            Long bo = oldHisDy.getLong("bo");
            oldHisBoList.add(bo);
            historyDynamicList.forEach(hisDy -> {
                Long parentId;
                Long oldParentId;
                Long newBo = hisDy.getLong("bo");
                if (bo.equals(newBo) && !(oldParentId = HistoryEntityUtils.getDynamicObjectFieldId(oldHisDy, this.getParentField())).equals(parentId = HistoryEntityUtils.getDynamicObjectFieldId(hisDy, this.getParentField()))) {
                    newHisDynList.add((DynamicObject)hisDy);
                    updateOldHisDyList.add((DynamicObject)oldHisDy);
                    parentIdList.add(parentId);
                    Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(hisDy, this.getMainEntityField());
                    orgParentIdMap.put(orgId, parentId);
                    orgIdList.add(orgId);
                    newBoList.add(newBo);
                }
            });
        });
    }

    private void modifyNewBoDataHis(List<Long> oldHisBoList, List<DynamicObject> hisDyList) {
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        ArrayList parentIdList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        ArrayList newHisDyList = Lists.newArrayListWithExpectedSize((int)hisDyList.size());
        hisDyList.forEach(hisDyn -> {
            Long bo = hisDyn.getLong("bo");
            if (!oldHisBoList.contains(bo)) {
                orgIdList.add(bo);
                Long parentId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, "parent");
                parentIdList.add(parentId);
                newHisDyList.add(hisDyn);
            }
        });
        this.setStructLongNumberToHisDyn(orgIdList, parentIdList, newHisDyList);
        super.modifyNewBoDataHis(newHisDyList);
    }

    protected void afterStructLongNumberChanged(List<DynamicObject> updateOldHisDyList, List<DynamicObject> newHisDyList, List<DynamicObject> hisDyList) {
        HistoryLongNumberChangeModel model = new HistoryLongNumberChangeModel();
        model.setHandleService("kd.hr.hbp.business.history.service.OrgStructureLongNumberChangeService");
        model.setHisEntityNumber(this.hisServiceHelper.getEntityName());
        model.setLongNumberField(STRUCTLONGNUMBER);
        model.setMainEntityField(this.getMainEntityField());
        HashMap otherServiceMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap otherServiceVidField = Maps.newHashMapWithExpectedSize((int)3);
        otherServiceMap.put("haos_orglongnumhis", "kd.hr.hbp.business.history.service.OrgLongNumberTimeSeqAttachService");
        otherServiceVidField.put("haos_orglongnumhis", "longnumbervid");
        otherServiceMap.put("haos_orgsortcodehis", "kd.hr.hbp.business.history.service.OrgSortCodeTimeSeqAttachService");
        otherServiceVidField.put("haos_orgsortcodehis", "sortcodevid");
        model.setOtherServiceMap((Map)otherServiceMap);
        model.setOtherServiceVidField((Map)otherServiceVidField);
        logger.debug("*************** afterAddNewDataHis-begin ********");
        OrgStructureLongNumberChangeFacade facade = new OrgStructureLongNumberChangeFacade(model);
        facade.batchSaveAndEffectDataHis(updateOldHisDyList, newHisDyList);
        facade.batchSaveAndEffectOtherDataHis(hisDyList);
        logger.debug("*************** afterAddNewDataHis-end ********");
    }

    private void validateoOldHistDyArr(List<Long> oldBoList, DynamicObject[] oldHisDyArrs) {
        if (oldHisDyArrs == null || oldHisDyArrs.length == 0) {
            logger.error(this.hisServiceHelper.getEntityName() + " batchSaveAndEffectDataHis oldHisDyArr ERROR!");
            String oldBoStr = StringUtils.join(oldBoList, (String)",");
            logger.error("bo is:" + oldBoStr);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u5931\u6548\u7684\u6570\u636e\u7248\u672c\uff01", (String)"CommonTimeSeqAttachService_12", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void setInvalidDynamicObject(DynamicObject oldHisDy, Long eventId, Date bsledDate, Date currentDate) {
        oldHisDy.set("lee", (Object)eventId);
        oldHisDy.set("leedt", (Object)currentDate);
        oldHisDy.set("bsled", (Object)bsledDate);
        oldHisDy.set("brled", (Object)currentDate);
        oldHisDy.set("brledt", (Object)System.currentTimeMillis());
        oldHisDy.set("datastatus", (Object)"2");
    }

    private void setDiscardDynamicObject(DynamicObject oldHistoryDynamic, Long eventId, Date bsled, Date currentDate) {
        oldHistoryDynamic.set("de", (Object)eventId);
        oldHistoryDynamic.set("dedt", (Object)currentDate);
        oldHistoryDynamic.set("datastatus", (Object)"-1");
    }

    protected void afterAddNewDataHis(List<DynamicObject> oldHisDyList, List<DynamicObject> hisDyList) {
        logger.debug("*************** afterAddNewDataHis-begin ********");
        OrgStructureLongNumberChangeFacade facade = new OrgStructureLongNumberChangeFacade(this.hisServiceHelper.getEntityName(), STRUCTLONGNUMBER, "kd.hr.hbp.business.history.service.OrgStructureLongNumberChangeService");
        facade.batchAddNewDataHis(oldHisDyList, hisDyList);
        logger.debug("*************** afterAddNewDataHis-end ********");
    }

    private Map<Long, String> getParentStructLongNumberMap(List<Long> parentIds, Map<Long, String> orgStructNumberMap, List<DynamicObject> hisDyList) {
        if (parentIds.size() == 0) {
            return new HashMap<Long, String>();
        }
        QFilter idFilter = new QFilter(this.getMainEntityField(), "in", parentIds);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "3"});
        DynamicObject[] parentInfos = this.hisServiceHelper.queryOriginalArray("structlongnumber," + this.getMainEntityField(), new QFilter[]{idFilter, statusFilter});
        Map<Long, String> parentStructLongNumberMap = Arrays.stream(parentInfos).collect(Collectors.toMap(parentInfo -> HistoryEntityUtils.getDynamicObjectFieldId(parentInfo, this.getMainEntityField()), parentInfo -> parentInfo.getString(STRUCTLONGNUMBER)));
        Map<Long, Long> orgParentIdMap = Arrays.stream(hisDyList.toArray(new DynamicObject[0])).collect(Collectors.toMap(hisDyn -> HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getMainEntityField()), hisDyn -> HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getParentField())));
        parentIds.forEach(parentId -> {
            if (parentStructLongNumberMap.get(parentId) == null || orgParentIdMap.containsKey(parentId)) {
                String parentStructLongNumber = this.getParetStructLongNumber((Long)parentId, orgParentIdMap, parentStructLongNumberMap, orgStructNumberMap, 0);
                parentStructLongNumberMap.put((Long)parentId, parentStructLongNumber);
            }
        });
        return parentStructLongNumberMap;
    }

    private String getParetStructLongNumber(Long orgId, Map<Long, Long> orgParentIdMap, Map<Long, String> parentStructLongNumberMap, Map<Long, String> orgStructNumberMap, int level) {
        if (level > 15) {
            logger.error("max level, root structnumber can not find!");
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u6709\u8bef\u3002", (String)"OrgStructureTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        Long parentId = orgParentIdMap.get(orgId);
        String structNumber = orgStructNumberMap.get(orgId);
        if (structNumber == null) {
            logger.error("no structnumber with orgId: " + orgId);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u6709\u8bef\u3002", (String)"OrgStructureTimeSeqAttachService_1", (String)HRMP_HBP_BUSINESS, (Object[])new Object[0]));
        }
        String parentStructLongNumber = parentStructLongNumberMap.get(parentId);
        if (HRStringUtils.isEmpty((String)parentStructLongNumber) || orgParentIdMap.containsKey(parentId)) {
            parentStructLongNumber = this.getParetStructLongNumber(parentId, orgParentIdMap, parentStructLongNumberMap, orgStructNumberMap, level + 1);
        }
        return parentStructLongNumber + "!" + structNumber;
    }

    private Map<Long, String> getOrgStructNumberMap(List<Long> orgIds) {
        if (orgIds.size() == 0) {
            return new HashMap<Long, String>();
        }
        QFilter idFilter = new QFilter("bo", "in", orgIds);
        QFilter statusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "3"});
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getOrgBaseInfoHisEntitNumber());
        DynamicObject[] orgInfos = serviceHelper.query("structnumber, bo, number", new QFilter[]{idFilter, statusFilter});
        Map<Long, String> orgStructNumberMap = Arrays.stream(orgInfos).collect(Collectors.toMap(orgInfo -> orgInfo.getLong("bo"), orgInfo -> orgInfo.getString("structnumber")));
        return orgStructNumberMap;
    }

    private void setStructLongNumberToHisDyn(List<DynamicObject> hisDyList, Map<Long, String> parentStructLongNumberMap, Map<Long, String> orgStructNumberMap) {
        hisDyList.forEach(hisDyn -> {
            Long parentId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getParentField());
            Long orgId = HistoryEntityUtils.getDynamicObjectFieldId(hisDyn, this.getMainEntityField());
            String structLongNumber = "";
            structLongNumber = orgId.equals(100000L) ? (String)orgStructNumberMap.get(orgId) : (String)parentStructLongNumberMap.get(parentId) + "!" + (String)orgStructNumberMap.get(orgId);
            hisDyn.set(STRUCTLONGNUMBER, (Object)structLongNumber);
            String[] structLongNumbers = HRStringUtils.split((String)structLongNumber, (String)"!");
            hisDyn.set("level", (Object)structLongNumbers.length);
        });
    }

    protected void setStructLongNumberToHisDyn(List<Long> orgIdList, List<Long> parentIdList, List<DynamicObject> hisDynList) {
        Map<Long, String> orgStructNumberMap = this.getOrgStructNumberMap(orgIdList);
        Map<Long, String> parentStructLongNumberMap = this.getParentStructLongNumberMap(parentIdList, orgStructNumberMap, hisDynList);
        this.setStructLongNumberToHisDyn(hisDynList, parentStructLongNumberMap, orgStructNumberMap);
    }

    @Override
    public List<Long> checkSEDataHisExists(List<DynamicObject> hisDynamicObjectList) {
        return new ArrayList<Long>();
    }

    @Override
    protected Set<String> getSpecialIgnoreKeySet() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("sortcode");
        keySet.add("fullname");
        keySet.add("longnumber");
        return keySet;
    }
}

