/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.init.AbstractConsumerHandleService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public abstract class AbstractInitDomainDataService
extends AbstractConsumerHandleService {
    private static final Log LOG = LogFactory.getLog(AbstractInitDomainDataService.class);
    private static final String COMPLETED = "2";
    private static final String VERIFIED = "1";
    private static final String PROCESSING = "0";
    protected static final String INIT_DATASOURCE = "initdatasource";
    protected static final String INIT_BATCH = "initbatch";
    protected static final String INIT_STATUS = "initstatus";
    private static final String SOURCE_STATUS = "sourceStatus";
    private static final String TARGET_STATUS = "targetStatus";
    private String sourceStatus;
    private String targetStatus;
    private static final int PAGE_SIZE = 200000;
    private int pageCount;
    private int count;
    private HRBaseServiceHelper hrBaseServiceHelper;
    private Map<String, List<Long>> bizIdMap;

    @Override
    public void changeStatus() {
        this.initPage(this.getChangeStatusQFilters());
        if (this.count == 0) {
            LOG.warn("total count is zero");
            return;
        }
        String entityCode = this.getInitInParam().getEntityNumber();
        this.hrBaseServiceHelper = new HRBaseServiceHelper(entityCode);
        for (int pageIndex = 0; pageIndex < this.pageCount; ++pageIndex) {
            DynamicObject[] dynamicObjectList = this.queryPageCollection(entityCode, INIT_STATUS, this.getChangeStatusQFilters(), 0, 200000);
            LOG.info("pageIndex={}, length={}", (Object)(pageIndex + 1), (Object)dynamicObjectList.length);
            this.setStatus(dynamicObjectList);
            this.hrBaseServiceHelper.save(dynamicObjectList);
        }
    }

    private DynamicObject[] queryPageCollection(String entityCode, String selectProperties, QFilter[] qFilters, int pageIndex, int pageSize) {
        return BusinessDataServiceHelper.load((String)entityCode, (String)selectProperties, (QFilter[])qFilters, (String)"id", (int)pageIndex, (int)pageSize);
    }

    private void setStatus(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set(INIT_STATUS, (Object)this.targetStatus);
        }
    }

    private void initPage(QFilter[] qFilters) {
        String entityCode = this.getInitInParam().getEntityNumber();
        this.hrBaseServiceHelper = new HRBaseServiceHelper(entityCode);
        this.count = this.hrBaseServiceHelper.count(entityCode, qFilters);
        this.pageCount = (int)Math.ceil((double)this.count / 200000.0);
    }

    private QFilter[] getChangeStatusQFilters() {
        return new QFilter[]{new QFilter(INIT_BATCH, "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter(INIT_STATUS, "=", (Object)this.sourceStatus)};
    }

    protected void setInitDefalutValue(List<DynamicObject> entityDycList) {
        entityDycList.forEach(dy -> {
            dy.set(INIT_DATASOURCE, (Object)VERIFIED);
            dy.set(INIT_BATCH, (Object)this.getInitInParam().getBatchNumber());
            dy.set(INIT_STATUS, (Object)PROCESSING);
        });
    }

    @Override
    public void changeSuccessStatus() {
        this.sourceStatus = VERIFIED;
        this.targetStatus = COMPLETED;
        this.changeStatus();
    }

    @Override
    public void changeProcessingStatus() {
        this.sourceStatus = VERIFIED;
        this.targetStatus = PROCESSING;
        this.changeStatus();
    }

    @Override
    public void changeValidatedStatus() {
        this.sourceStatus = PROCESSING;
        this.targetStatus = VERIFIED;
        this.changeStatus();
    }

    @Override
    public void rollback() {
        this.hrBaseServiceHelper = new HRBaseServiceHelper(this.getInitInParam().getEntityNumber());
        if (this.isRollbackSelected()) {
            this.rollbackSelectedData();
            return;
        }
        this.rollbackAll();
    }

    protected void rollbackAll() {
        this.hrBaseServiceHelper.deleteByFilter(this.getRollbackQFilterArr());
    }

    protected boolean isRollbackSelected() {
        return (Boolean)Optional.ofNullable(this.getInitInParam().getOther()).map(other -> other.get("isSelected")).orElse(false);
    }

    protected List<QFilter> getRollbackQFilters() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter(INIT_BATCH, "=", (Object)this.getInitInParam().getBatchNumber()), new QFilter(INIT_STATUS, "in", (Object)Sets.newHashSet((Object[])new String[]{PROCESSING, VERIFIED}))});
    }

    private QFilter[] getRollbackQFilterArr() {
        return this.getRollbackQFilters().toArray(new QFilter[0]);
    }

    protected void rollbackSelectedData() {
        DynamicObject[] dynamicObjects = this.hrBaseServiceHelper.queryOriginalArray("id", this.getRollbackSelectedQFilters());
        List<Object> idList = Stream.of(dynamicObjects).map(it -> it.get("id")).collect(Collectors.toList());
        this.hrBaseServiceHelper.delete(idList.toArray());
        this.rollbackSelecthandle(idList);
    }

    protected void rollbackSelecthandle(List<Object> idList) {
        for (Object id : idList) {
            String idStr = String.valueOf(id);
            List<Long> midIdList = this.getBizIdMap().get(idStr);
            if (CollectionUtils.isEmpty(midIdList)) continue;
            midIdList.stream().forEach(midId -> this.getInitOutParam().addSuccessMsg(midId, idStr, ""));
        }
    }

    protected QFilter[] getRollbackSelectedQFilters() {
        List<QFilter> qFilterList = this.getRollbackQFilters();
        qFilterList.add(this.getRollbackSelectFilter());
        return qFilterList.toArray(new QFilter[0]);
    }

    protected QFilter getRollbackSelectFilter() {
        String pkCode;
        this.bizIdMap = this.getBizIdMapByExecTaskId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getInitInParam().getEntityNumber());
        if (entityType.getProperty(pkCode = entityType.getPrimaryKey().getName()) instanceof LongProp) {
            return new QFilter(pkCode, "in", this.bizIdMap.keySet().stream().map(Long::parseLong).collect(Collectors.toSet()));
        }
        return new QFilter(pkCode, "in", this.bizIdMap.keySet());
    }

    protected Map<String, Object> getInfoWithDynamicObject() {
        return this.getMidTableInfo("getInfoWithDynamicObject");
    }

    protected <T> T getBizParam(String bizKey) {
        Map bizParamMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hric", (String)"IInitBizParamsService", (String)"getBizParamByNumber", (Object[])new Object[]{bizKey});
        if (!((Boolean)bizParamMap.get("success")).booleanValue()) {
            LOG.error("get param error : {}", (Object)bizParamMap);
            throw new KDBizException((String)bizParamMap.get("errorMsg"));
        }
        return (T)bizParamMap.get("data");
    }

    protected Map<String, Object> getInfoWithMap() {
        return this.getMidTableInfo("getInfoWithMap");
    }

    protected Map<String, List<Long>> getBizIdMapByExecTaskId() {
        return (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hric", (String)"IInitMidTableService", (String)"getBizIdMapByExecTaskId", (Object[])new Object[]{this.getInitInParam().getExecTaskId()});
    }

    private Map<String, Object> getMidTableInfo(String method) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("execTaskId", this.getInitInParam().getExecTaskId());
        return (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hric", (String)"IInitMidTableService", (String)method, (Object[])new Object[]{paramMap});
    }

    public String getSourceStatus() {
        return this.sourceStatus;
    }

    public String getTargetStatus() {
        return this.targetStatus;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getCount() {
        return this.count;
    }

    protected Map<String, List<Long>> getBizIdMap() {
        return this.bizIdMap;
    }
}

