/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.application.newhismodel.IHisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HisModelSingleEntityInitOpServiceImpl
extends AbstractInitDomainDataService {
    private static Log LOG = LogFactory.getLog(HisModelSingleEntityInitOpServiceImpl.class);
    protected IHisModelController hisModelController = HisModelController.getInstance();
    private Map<String, Object> result;
    private Map<Object, Set<Long>> idMapping;
    private List<DynamicObject> entityDycList;

    @Override
    public void validate() {
        LOG.warn("this method should not be invoke");
    }

    @Override
    public void save() {
        this.setUseTranscationMsg(false);
        this.result = this.getInfoWithDynamicObject();
        this.entityDycList = (List)this.result.get("data");
        this.idMapping = (Map)this.result.get("idmapping");
        LOG.info("idMapping_data(bizId-[midtableid]): " + this.idMapping);
        this.dealDynData(this.entityDycList);
        this.setInitDefalutValue(this.entityDycList);
        this.callOp();
    }

    private void callOp() {
        try (TXHandle tx = TX.requiresNew();){
            this.callDeleteService(new QFilter("id", "in", this.idMapping.keySet()));
        }
        OperateOption operateOption = OperateOption.create();
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.getInitInParam().getEntityNumber(), (DynamicObject[])this.entityDycList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        this.buildInitOutParam(result);
    }

    private void buildInitOutParam(OperationResult result) {
        boolean success = result.isSuccess();
        HashMap<Long, Set<String>> errMap = new HashMap<Long, Set<String>>();
        boolean isBatchFail = false;
        ValidateResultCollection validateResult = result.getValidateResult();
        List<Object> successPkIdList = new ArrayList();
        if (success) {
            successPkIdList = result.getSuccessPkIds().stream().map(id -> (Long)id).collect(Collectors.toList());
        } else if (validateResult != null && !CollectionUtils.isEmpty((Collection)validateResult.getValidateErrors())) {
            List allErrorInfo = ((ValidateResult)validateResult.getValidateErrors().get(0)).getAllErrorInfo();
            allErrorInfo.forEach(err -> {
                Long pkValue = (Long)err.getPkValue();
                final String message = err.getMessage();
                if (errMap.containsKey(pkValue)) {
                    ((Set)errMap.get(pkValue)).add(message);
                } else {
                    errMap.put(pkValue, new HashSet<String>(){
                        private static final long serialVersionUID = -4112219459382526700L;
                        {
                            this.add(message);
                        }
                    });
                }
            });
            successPkIdList = result.getSuccessPkIds().stream().map(id -> (Long)id).collect(Collectors.toList());
        } else {
            isBatchFail = true;
            this.getInitOutParam().addExtendInfo("errorMsg", (Object)result.getMessage());
        }
        this.buildInitOutParam(errMap, successPkIdList, isBatchFail);
    }

    protected void dealDynData(List<DynamicObject> dyns) {
        this.setDefalutValueFromMeta(dyns);
    }

    private void setDefalutValueFromMeta(List<DynamicObject> dyns) {
        if (!ObjectUtils.isEmpty(dyns)) {
            DataEntityPropertyCollection pros = dyns.get(0).getDataEntityType().getProperties();
            dyns.stream().forEach(dyn -> pros.forEach(pro -> {
                FieldProp pp;
                if (pro instanceof FieldProp && (pp = (FieldProp)pro).isMustInput() && !ObjectUtils.isEmpty((Object)pp.getDefValue()) && ObjectUtils.isEmpty((Object)dyn.get(pro.getName()))) {
                    dyn.set(pro.getName(), pp.getDefValue());
                }
            }));
        }
    }

    private void buildInitOutParam(HashMap<Long, Set<String>> errMap, List<Long> successPkIdList, boolean isBatchFail) {
        successPkIdList.stream().forEach(bizId -> {
            Set<Long> longSet = this.idMapping.get(bizId);
            if (longSet == null) {
                return;
            }
            longSet.forEach(midId -> this.getInitOutParam().addSuccessMsg(midId, String.valueOf(bizId), ""));
        });
        errMap.entrySet().forEach(entry -> {
            Set<Long> longSet = this.idMapping.get(entry.getKey());
            longSet.forEach(midId -> this.getInitOutParam().addErrorMsg(midId, StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)";")));
        });
        if (HRMapUtils.isEmpty(errMap) && HRCollUtil.isEmpty(successPkIdList)) {
            LOG.warn("sync history data not return pk!");
        }
        this.getInitOutParam().setSuccess(!isBatchFail);
    }

    @Override
    public void rollback() {
        if (this.isRollbackSelected()) {
            this.callDeleteService(this.getRollbackSelectFilter());
        } else {
            this.callDeleteService(this.getBatchNumberFilter());
        }
    }

    private QFilter getBatchNumberFilter() {
        return new QFilter("initbatch", "=", (Object)this.getInitInParam().getBatchNumber());
    }

    private void callDeleteService(QFilter qFilter) {
        QFilter[] qFilters = this.buildRollbackQFilter(qFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(this.getInitInParam().getEntityNumber());
        Object[] dynamicObjects = hrBaseServiceHelper.query("id, boid", qFilters);
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        this.hisModelController.deleteBo(this.buildHisBaseBo((DynamicObject[])dynamicObjects));
        if (this.isRollbackSelected()) {
            this.rollbackSelecthandle(Arrays.stream(dynamicObjects).map(dyn -> dyn.get("id")).collect(Collectors.toList()));
        }
    }

    private HisBaseBo buildHisBaseBo(DynamicObject[] dynamicObjects) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(this.getInitInParam().getEntityNumber());
        List<Long> boidList = Stream.of(dynamicObjects).map(it -> it.getLong("boid")).distinct().collect(Collectors.toList());
        hisBaseBo.setBoIdList(boidList);
        return hisBaseBo;
    }

    private QFilter[] buildRollbackQFilter(QFilter qFilter) {
        List<QFilter> qFilterList = this.getRollbackQFilters();
        qFilterList.add(qFilter);
        return qFilterList.toArray(new QFilter[0]);
    }
}

