/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.log;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.hr.hbp.business.log.FieldModifyInfo;

public class EntityModifyInfo
extends LinkedHashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_KEY_ID = "k";
    private static final String KEY_CAPTION = "c";
    private static final String KEY_FLAG = "f";
    @JsonIgnore
    private EntityModifyInfo parent;
    @JsonIgnore
    private String fieldName;

    public EntityModifyInfo() {
    }

    public EntityModifyInfo(String keyID, String caption) {
        this.put(KEY_KEY_ID, keyID);
        this.put(KEY_CAPTION, caption);
    }

    public String getKeyID() {
        return (String)this.get(KEY_KEY_ID);
    }

    public void setKeyID(String keyID) {
        this.put(KEY_KEY_ID, keyID);
    }

    public String getCaption() {
        return (String)this.get(KEY_CAPTION);
    }

    public void setCaption(String caption) {
        this.put(KEY_CAPTION, caption);
    }

    public String getFlag() {
        return (String)this.get(KEY_FLAG);
    }

    public void setFlag(String flag) {
        this.put(KEY_FLAG, flag);
    }

    @JsonIgnore
    public List<FieldModifyInfo> getFields() {
        return this.values().stream().filter(o -> o instanceof FieldModifyInfo).map(o -> (FieldModifyInfo)o).collect(Collectors.toList());
    }

    public void addField(String fieldName, FieldModifyInfo info) {
        info.setEntity(this);
        info.setFieldName(fieldName);
        this.put(fieldName, info);
    }

    public void addChild(String fieldName, EntityModifyInfo child) {
        LinkedList<EntityModifyInfo> entityModifyInfos = (LinkedList<EntityModifyInfo>)this.get(fieldName);
        if (entityModifyInfos == null) {
            entityModifyInfos = new LinkedList<EntityModifyInfo>();
            this.put(fieldName, entityModifyInfos);
        }
        entityModifyInfos.add(child);
        child.setFieldName(fieldName);
        child.setParent(this);
    }

    @JsonIgnore
    public EntityModifyInfo getParent() {
        return this.parent;
    }

    @JsonIgnore
    public void setParent(EntityModifyInfo parent) {
        this.parent = parent;
    }

    @JsonIgnore
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonIgnore
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public boolean isEmpty() {
        boolean bExistFields = this.entrySet().stream().anyMatch(e -> e.getValue() instanceof FieldModifyInfo);
        if (bExistFields) {
            return false;
        }
        boolean bExistEntries = this.entrySet().stream().anyMatch(e -> e.getValue() instanceof LinkedList);
        return !bExistEntries;
    }
}

