/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.multimpt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.impt.ImportDataSave;
import kd.bos.form.impt.SingleBillResult;
import kd.bos.orm.util.CollectionUtils;

public class HRImportDataSave
extends ImportDataSave {
    protected ApiResult buildApiResult(IDataModel model, List<SingleBillResult> convResults, Set<String> pkIds, OperationResult saveResult) {
        if (this.requestData.containsKey("data")) {
            return this.handleContainData(convResults, saveResult);
        }
        ApiResult apiResult = new ApiResult();
        ArrayList<Map> billResults = new ArrayList<Map>();
        if (saveResult == null) {
            for (SingleBillResult item : convResults) {
                billResults.add(SingleBillResult.toMap((SingleBillResult)item));
            }
            apiResult.setSuccess(false);
            apiResult.setData(billResults);
        } else {
            HashSet<String> successIds = new HashSet<String>();
            Map fromDB = new HashMap();
            BillEntityType mainType = (BillEntityType)model.getDataEntityType();
            IDataEntityProperty numberProp = StringUtils.isBlank((CharSequence)mainType.getBillNo()) ? null : mainType.findProperty(mainType.getBillNo());
            MainOrgProp orgProp = mainType.getMainOrgProperty();
            if (saveResult.getSuccessPkIds() != null) {
                for (Object pk : saveResult.getSuccessPkIds()) {
                    if (pk == null) continue;
                    successIds.add(pk.toString());
                }
                fromDB = this.loadSuccessObjs(saveResult.getSuccessPkIds(), mainType, numberProp, (IDataEntityProperty)orgProp);
            }
            ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>();
            HashMap<String, List<IOperateInfo>> billErrors = new HashMap<String, List<IOperateInfo>>();
            this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors);
            int successCount = successIds.size();
            Iterator<SingleBillResult> var15 = convResults.iterator();
            while (var15.hasNext()) {
                SingleBillResult item = this.handleConvertResult(successIds, fromDB, numberProp, orgProp, opFailInfos, billErrors, var15);
                billResults.add(SingleBillResult.toMap((SingleBillResult)item));
            }
            if (successCount == billResults.size()) {
                apiResult.setSuccess(true);
            } else {
                apiResult.setSuccess(false);
            }
            apiResult.setData(billResults);
        }
        return apiResult;
    }

    private ApiResult handleContainData(List<SingleBillResult> convResults, OperationResult saveResult) {
        if (saveResult != null && saveResult.isSuccess()) {
            return ApiResult.success((Object)saveResult);
        }
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(false);
        if (saveResult != null) {
            apiResult.setData((Object)saveResult);
        } else if (convResults.size() > 0) {
            apiResult.setMessage(convResults.get(0).getMessage());
            apiResult.setData((Object)SingleBillResult.toMap((SingleBillResult)convResults.get(0)));
        }
        return apiResult;
    }

    private SingleBillResult handleConvertResult(Set<String> successIds, Map fromDB, IDataEntityProperty numberProp, MainOrgProp orgProp, List<IOperateInfo> opFailInfos, Map<String, List<IOperateInfo>> billErrors, Iterator var15) {
        SingleBillResult item = (SingleBillResult)var15.next();
        DynamicObject obj = null;
        if (this.isIdExist(item.getId(), successIds) || item.isSuccess() && !this.isIdExist(item.getId(), billErrors.keySet()) && CollectionUtils.isEmpty(opFailInfos)) {
            successIds.remove(item.getId().toString());
            item.setSuccess(true);
            obj = (DynamicObject)fromDB.get(item.getId().toString());
            if (obj != null) {
                DynamicObject org;
                if (numberProp != null) {
                    item.setNumber((String)numberProp.getValue((Object)obj));
                }
                if (orgProp != null && (org = (DynamicObject)orgProp.getValue((Object)obj)) != null) {
                    item.setOrgNumber(org.getString("number"));
                }
            }
        } else {
            item.setSuccess(false);
            if (this.isIdExist(item.getId(), billErrors.keySet())) {
                item.setData(billErrors.get(item.getId().toString()));
            } else {
                item.setData(opFailInfos);
            }
        }
        return item;
    }
}

