/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.multimpt;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.export.ExcelWriter;
import kd.bos.mvc.export.ExportSheetStyle;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.service.metadata.export.ExportWriterFormat;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class MultiSheetListDataExporter
extends ExcelWriter {
    public static final String DROP_DOWN_SHEET_PREX = "DDM_";
    private static final Log log = LogFactory.getLog(ListDataExporter.class);
    private static final String[] SOURCES = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String LINE_BREAKS = System.getProperty("line.separator");
    private ExportSheetStyle styles;
    private int headerOffset = 0;

    public MultiSheetListDataExporter() {
        this.wb = new SXSSFWorkbook(-1);
        this.wb.setCompressTempFiles(true);
    }

    private static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, Map<Integer, String> propDisplayNames, int preOffset, boolean fillParent, String tempCode) {
        SXSSFRow entityRow = MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)0);
        SXSSFRow commentRow = MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)1);
        SXSSFRow nameRow = MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)2);
        if (format.getHideFieldRow().booleanValue()) {
            entityRow.setHidden(Boolean.TRUE);
            commentRow.setHidden(Boolean.TRUE);
            nameRow.setHidden(Boolean.TRUE);
        }
        int titleRowIndex = fillParent ? 0 : 3;
        SXSSFRow titleRow = MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)titleRowIndex);
        CellStyle cellStyle = format.displayName != null && format.displayName.startsWith("*") ? styles.getTextHighLightStyle() : styles.getTitleStyle();
        String headContent = format.displayName + "#" + format.name;
        String rowOneContent = headContent + "#" + tempCode;
        MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)entityRow, (int)(format.col + preOffset), (CellStyle)cellStyle).setCellValue(rowOneContent);
        int offset = preOffset;
        offset = MultiSheetListDataExporter.doWrite(wb, sheet, dropdownSheet, styles, format, propDisplayNames, fillParent, commentRow, nameRow, titleRowIndex, titleRow, offset);
        for (ExportWriterFormat wr : format.next) {
            offset += MultiSheetListDataExporter.writeHeader(wb, sheet, dropdownSheet, styles, wr, propDisplayNames, preOffset, fillParent, tempCode);
        }
        return offset;
    }

    private static int doWrite(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportSheetStyle styles, ExportWriterFormat format, Map<Integer, String> propDisplayNames, boolean fillParent, SXSSFRow commentRow, SXSSFRow nameRow, int titleRowIndex, SXSSFRow titleRow, int offset) {
        for (int i = 0; i < format.fields.size(); ++i) {
            String substring;
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            boolean mustInput = false;
            int defaultColWidth = 0;
            String captionTemp = "";
            if (property != null) {
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                Object inputType = property.get("InputType");
                if (!"id".equals(inputType) && !"pid".equals(inputType)) {
                    if (inputType instanceof JSONArray) {
                        MultiSheetListDataExporter.jsonArrayHandler(sheet, dropdownSheet, format, offset, property, (JSONArray)inputType);
                    } else if ("date".equals(inputType)) {
                        defaultColWidth = 60;
                        sheet.setDefaultColumnStyle(format.col + offset, styles.getDateStyle());
                    } else if ("datetime".equals(inputType)) {
                        defaultColWidth = 80;
                        sheet.setDefaultColumnStyle(format.col + offset, styles.getDatetimeStyle());
                    } else if ("time".equals(inputType)) {
                        CellStyle cs = wb.createCellStyle();
                        cs.setDataFormat(wb.createDataFormat().getFormat("H:mm:ss"));
                        sheet.setDefaultColumnStyle(format.col + offset, cs);
                    } else if ("decimal".equals(inputType)) {
                        sheet.setDefaultColumnStyle(format.col + offset, styles.getDecimalStyle(wb, (Map)null));
                    } else {
                        if ("basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType)) {
                            offset = MultiSheetListDataExporter.splitColumn(wb, sheet, nameRow, titleRow, commentRow, styles, format, property, fieldName, offset, titleRowIndex, propDisplayNames, mustInput, fillParent, defaultColWidth);
                            continue;
                        }
                        sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                    }
                } else {
                    fieldName = fieldName.replace('.', '_');
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                }
                captionTemp = MultiSheetListDataExporter.writeComment(wb, commentRow, format, styles, property, offset);
            }
            String caption = MultiSheetListDataExporter.getPropertyString(wb, styles, format, fillParent, nameRow, offset, fieldName, property, mustInput);
            MultiSheetListDataExporter.handlerOffSet(wb, sheet, styles, format, titleRowIndex, titleRow, offset, property, mustInput, defaultColWidth, caption);
            String string = substring = captionTemp.contains(LINE_BREAKS) ? captionTemp.substring(0, captionTemp.indexOf(LINE_BREAKS)) : captionTemp;
            if (substring.length() > caption.length()) {
                Integer colWidth = Objects.isNull(property) ? Integer.valueOf(0) : property.get("ColWidth");
                int designatedColWidth = colWidth instanceof Integer ? colWidth : 0;
                sheet.setColumnWidth(format.col + offset, MultiSheetListDataExporter.calcColumnWidth(substring, defaultColWidth, designatedColWidth));
            }
            ++offset;
        }
        return offset;
    }

    private static String getPropertyString(SXSSFWorkbook wb, ExportSheetStyle styles, ExportWriterFormat format, boolean fillParent, SXSSFRow nameRow, int offset, String fieldName, Map<String, Object> property, boolean mustInput) {
        String caption = "";
        if (property != null) {
            String displayName = (String)property.get("DisplayName");
            String entityDescription = (String)property.get("EntityDescription");
            if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((CharSequence)entityDescription)) {
                displayName = entityDescription;
            }
            caption = (mustInput ? "*" : "") + displayName;
        }
        if (!fillParent) {
            MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)nameRow, (int)(format.col + offset), (CellStyle)styles.getTitleStyle()).setCellValue(fieldName);
        }
        return caption;
    }

    private static void handlerOffSet(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportWriterFormat format, int titleRowIndex, SXSSFRow titleRow, int offset, Map<String, Object> property, boolean mustInput, int defaultColWidth, String caption) {
        int formatCol = Objects.isNull(format) ? 0 : format.col;
        SXSSFCell cell = MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)titleRow, (int)(formatCol + offset), (CellStyle)(mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default")));
        cell.setCellValue(caption);
        if (null != property && null != sheet) {
            Object colWidth = property.get("ColWidth");
            int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
            sheet.setColumnWidth(formatCol + offset, MultiSheetListDataExporter.calcColumnWidth(caption, defaultColWidth, designatedColWidth));
        }
        if (property != null && property.containsKey("InputDesc")) {
            String tip = (String)property.getOrDefault("InputDesc", "");
            MultiSheetListDataExporter.bindCellTip(sheet, cell, formatCol + offset, titleRowIndex, tip);
        }
    }

    private static void jsonArrayHandler(SXSSFSheet sheet, SXSSFSheet dropdownSheet, ExportWriterFormat format, int offset, Map<String, Object> property, JSONArray inputType) {
        ArrayList<String> items = new ArrayList<String>();
        inputType.forEach(obj -> items.add(obj.toString().split("#", -1)[0]));
        if (!items.isEmpty() && !"MulComboProp".equals(property.get("PropType"))) {
            int currCol = format.col + offset;
            for (int j = 0; j < items.size(); ++j) {
                MultiSheetListDataExporter.getRow((SXSSFSheet)dropdownSheet, (int)j).createCell(currCol).setCellValue((String)items.get(j));
            }
            MultiSheetListDataExporter.createDropdownList(sheet, currCol, items, dropdownSheet.getSheetName());
        }
    }

    private static int splitColumn(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFRow nameRow, SXSSFRow titleRow, SXSSFRow commentRow, ExportSheetStyle styles, ExportWriterFormat format, Map<String, Object> property, String fieldName, int offset, int titleRowIndex, Map<Integer, String> propDisplayNames, boolean mustInput, boolean fillParent, int defaultColWidth) {
        List splitCols = (List)format.flexColumn.get(fieldName);
        List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
        List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
        if (splitCols != null) {
            for (int j = 0; j < splitCols.size(); ++j) {
                Object colWidth;
                int colIndex = format.col + offset;
                String splitColDisplayName = (String)splitColDisplayNames.get(j);
                if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((Object)property.get("EntityDescription"))) {
                    splitColDisplayName = MultiSheetListDataExporter.getEntityDescription((String)splitCols.get(j), (String)property.get("EntityDescription"), splitColDisplayName);
                }
                propDisplayNames.put(colIndex, splitColDisplayName);
                String caption = (j == 0 && mustInput ? "*" : "") + splitColDisplayName;
                sheet.setDefaultColumnStyle(colIndex, styles.getTextStyle());
                if (!fillParent) {
                    MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)nameRow, (int)(format.col + offset), (CellStyle)styles.getTitleStyle()).setCellValue((String)splitCols.get(j));
                }
                SXSSFCell cell = MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)titleRow, (int)colIndex, (CellStyle)(j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle("default")));
                cell.setCellValue(caption);
                if (j < splitColDesc.size()) {
                    MultiSheetListDataExporter.bindCellTip(sheet, cell, format.col + offset, titleRowIndex, (String)splitColDesc.get(j));
                }
                int designatedColWidth = (colWidth = property.get("ColWidth")) instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(format.col + offset, MultiSheetListDataExporter.calcColumnWidth(caption, defaultColWidth, designatedColWidth));
                if (j == 0) {
                    String substring;
                    String comment = MultiSheetListDataExporter.writeComment(wb, commentRow, format, styles, property, offset);
                    String string = substring = comment.contains(LINE_BREAKS) ? comment.substring(0, comment.indexOf(LINE_BREAKS)) : comment;
                    if (substring.length() > caption.length()) {
                        sheet.setColumnWidth(format.col + offset, MultiSheetListDataExporter.calcColumnWidth(substring, defaultColWidth, designatedColWidth));
                    }
                }
                ++offset;
            }
        }
        return offset;
    }

    private static String getEntityDescription(String splitCol, String EntityDescription, String splitColDisplayName) {
        if (!EntityDescription.contains("#")) {
            return EntityDescription;
        }
        String[] split = splitCol.split("\\.");
        String key = split[split.length - 1];
        String[] splitEntityDescription = EntityDescription.split("#");
        for (int index = 0; index < splitEntityDescription.length; ++index) {
            if (!splitEntityDescription[index].startsWith(key)) continue;
            return splitEntityDescription[index].replaceFirst(key, "");
        }
        return splitColDisplayName;
    }

    public static void createDropdownList(SXSSFSheet sheet, int currCol, List<String> items, String dropDownSheetName) {
        String currColLabel = MultiSheetListDataExporter.getColumnLabel(currCol + 1);
        String strFormula = String.format(Locale.ROOT, dropDownSheetName + "!$%s$%d:$%s$%d", currColLabel, 1, currColLabel, items.size());
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(4, 10000, currCol, currCol);
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String getDropDownSheetName(String tag) {
        String dropDownSheetName = DROP_DOWN_SHEET_PREX + tag;
        if (dropDownSheetName.length() > 31) {
            return dropDownSheetName.substring(0, 31);
        }
        return dropDownSheetName;
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (!StringUtils.isBlank((CharSequence)tip) && null != sheet) {
            SXSSFDrawing sxssfDrawing = sheet.createDrawingPatriarch();
            Comment comment = sxssfDrawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
            comment.setString((RichTextString)new XSSFRichTextString(tip));
            cell.setCellComment(comment);
        }
    }

    private static String writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        String inputDesc = (String)property.get("DisplayName");
        if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((CharSequence)entityDesc)) {
            entityDesc = inputDesc;
        }
        if (format.col + offset == 0) {
            entityDesc = MultiSheetListDataExporter.buildTips(format, commentRow, entityDesc, property).toString();
            CellStyle textHighLightStyle = styles.getTextHighLightStyle();
            textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
            textHighLightStyle.setWrapText(true);
            MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)commentRow, (int)0, (CellStyle)textHighLightStyle).setCellValue(entityDesc);
        } else if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            MultiSheetListDataExporter.createCell((SXSSFWorkbook)wb, (SXSSFRow)commentRow, (int)(format.col + offset), (CellStyle)styles.getTitleStyle()).setCellValue(entityDesc);
        } else {
            entityDesc = "";
        }
        return entityDesc;
    }

    private static StringBuilder buildTips(ExportWriterFormat format, SXSSFRow commentRow, String entityDesc, Map<String, Object> property) {
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        tips.add(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"MultiSheetListDataExporter_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"MultiSheetListDataExporter_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        if (format.getEnableSetNull().booleanValue()) {
            tips.add(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"MultiSheetListDataExporter_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            tips.add("-----------");
            tips.add(entityDesc);
        }
        int radit = MultiSheetListDataExporter.addTips(strb, tips);
        Optional maxLengthStr = tips.stream().max((o1, o2) -> o1.length() > o2.length() ? 1 : -1);
        commentRow.setHeightInPoints((float)radit * commentRow.getSheet().getDefaultRowHeightInPoints());
        Object colWidth = property.get("ColWidth");
        int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
        commentRow.getSheet().setColumnWidth(0, MultiSheetListDataExporter.calcColumnWidth(maxLengthStr.orElse(""), 0, designatedColWidth));
        return strb;
    }

    private static int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append(LINE_BREAKS);
        }
        strb.delete(strb.length() - LINE_BREAKS.length(), strb.length());
        return tips.size();
    }

    private static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(SOURCES[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(SOURCES[remainder]);
        }
        return sb.reverse().toString();
    }

    private static int calcColumnWidth(String caption, int defColWidth, int designatedColWidth) {
        int colWidth;
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        boolean var3 = false;
        try {
            colWidth = Math.max(256 * defColWidth / 8 * 2, 256 * (caption.getBytes("GBK").length + 12));
        }
        catch (UnsupportedEncodingException var5) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
        }
        return Math.min(colWidth, 51200);
    }

    public SXSSFSheet getSheet(String sheetName) {
        return this.wb.getSheet(sheetName);
    }

    public void addSheet(String sheetName, List<ExportWriterFormat> formats, boolean fillParent, boolean isMainEntity, String tempCode) {
        int dropdownItemsSheetIndex;
        this.styles = new ExportSheetStyle(this.wb, formats.get((int)0).name);
        SXSSFSheet sheet = this.wb.createSheet(sheetName);
        String dropdownSheetName = MultiSheetListDataExporter.getDropDownSheetName(formats.get((int)0).name);
        SXSSFSheet dropdownSheet = this.wb.createSheet(dropdownSheetName);
        HashMap<Integer, String> propDisplayNames = new HashMap<Integer, String>();
        for (ExportWriterFormat format : formats) {
            MultiSheetListDataExporter.writeHeader(this.wb, sheet, dropdownSheet, this.styles, format, propDisplayNames, this.headerOffset, fillParent, tempCode);
        }
        if (this.styles.getEntities() == null || this.styles.getFieldnames() == null) {
            this.styles.reference(MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)(fillParent ? 2 : 0)), MultiSheetListDataExporter.getRow((SXSSFSheet)sheet, (int)(fillParent ? 0 : 2)));
        }
        if ((dropdownItemsSheetIndex = this.wb.getSheetIndex(dropdownSheetName)) >= 0) {
            this.wb.setSheetHidden(dropdownItemsSheetIndex, true);
        }
        if (fillParent) {
            sheet.removeRow((Row)sheet.getRow(1));
            sheet.removeRow((Row)sheet.getRow(2));
        }
    }

    public void flush(SXSSFSheet sheet) throws IOException {
        sheet.flushRows();
    }

    public void clear(SXSSFSheet sheet) {
        try {
            this.flush(sheet);
        }
        catch (IOException var2) {
            log.error((Throwable)var2);
        }
        CTWorksheet ctSheet = this.wb.getXSSFWorkbook().getSheet(sheet.getSheetName()).getCTWorksheet();
        ctSheet.getDimension().setRef("A1:" + MultiSheetListDataExporter.getColumnLabel(this.headerOffset) + sheet.getPhysicalNumberOfRows());
    }
}

