/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.openservicehelper.hrpi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HRPIReviseLogServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRPIReviseLogServiceHelper.class);

    public static Map<Long, String> queryAbstractByIdList(String reviseLogEntityNum, List<Long> reviseLogIdList) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIReviseLogService", (String)"queryAbstractByIdList", (Object[])new Object[]{reviseLogEntityNum, reviseLogIdList});
    }

    public static DynamicObject generateLogDetailDyn(String logEntityName, Long reviseLogId) {
        return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIReviseLogService", (String)"generateLogDetailDynByEntityAndLogId", (Object[])new Object[]{logEntityName, reviseLogId});
    }

    public static List<DynamicObject> generateReviseLogDynList(String logEntityNumber, Map<String, Object> dataMap) {
        String entityNumber = (String)dataMap.get("entityNumber");
        List reviseBoList = (List)dataMap.get("reviseBoList");
        HRBaseServiceHelper logEntityNumberHelper = new HRBaseServiceHelper(logEntityNumber);
        ArrayList dynList = Lists.newArrayListWithExpectedSize((int)reviseBoList.size());
        for (Map reviseBoMap : reviseBoList) {
            Long personId = (Long)reviseBoMap.get("person");
            Long employeeId = (Long)reviseBoMap.get("employee");
            Long depEmpId = (Long)reviseBoMap.get("depemp");
            Long cmpEmpId = (Long)reviseBoMap.get("cmpemp");
            Long empPosOrgRelId = (Long)reviseBoMap.get("empPosOrgRel");
            Long reviseBoId = (Long)reviseBoMap.get("reviseBo");
            List reviseLogList = (List)reviseBoMap.get("reviseLogList");
            Map reviseLogMap = (Map)reviseLogList.get(0);
            Long reviseBeforeId = (Long)reviseLogMap.get("reviseBefore");
            Date reviseDate = (Date)reviseLogMap.get("reviseDate");
            Long reviseAfterId = (Long)reviseLogMap.get("reviseAfter");
            String reviseType = (String)reviseLogMap.get("reviseType");
            LOGGER.info("person={},employee={},depemp={},empposorgrel={},revisenumber={},reviseBoId={},reviseBeforeId={},reviseAfterId={}", new Object[]{personId, employeeId, depEmpId, empPosOrgRelId, reviseBoId, reviseBeforeId, reviseAfterId});
            DynamicObject logEntityDyn = logEntityNumberHelper.generateEmptyDynamicObject();
            long id = ORM.create().genLongId(entityNumber);
            logEntityDyn.set("id", (Object)id);
            logEntityDyn.set("revisetype", (Object)reviseType);
            logEntityDyn.set("revisedate", (Object)reviseDate);
            logEntityDyn.set("revisenumber", (Object)entityNumber);
            logEntityDyn.set("revisebo", (Object)reviseBoId);
            logEntityDyn.set("revisebefore", (Object)reviseBeforeId);
            logEntityDyn.set("reviseafter", (Object)reviseAfterId);
            logEntityDyn.set("person", (Object)personId);
            logEntityDyn.set("employee", (Object)employeeId);
            logEntityDyn.set("depemp", (Object)depEmpId);
            logEntityDyn.set("cmpemp", (Object)cmpEmpId);
            logEntityDyn.set("empposorgrel", (Object)empPosOrgRelId);
            dynList.add(logEntityDyn);
        }
        return dynList;
    }

    public static void saveReviseLogDyn(List<DynamicObject> logEntityDynList) {
        if (logEntityDynList.size() == 0) {
            return;
        }
        ArrayList toBeSaveDynList = Lists.newArrayListWithExpectedSize((int)(logEntityDynList.size() * 2));
        Set reviseBoIdSet = logEntityDynList.stream().map(dyn -> dyn.getLong("revisebo")).collect(Collectors.toSet());
        String entityName = logEntityDynList.get(0).getDynamicObjectType().getName();
        QFilter reviseBoIdFilter = new QFilter("revisebo", "in", reviseBoIdSet);
        HRBaseServiceHelper commonServiceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] logEntityDynArrFromDB = commonServiceHelper.loadDynamicObjectArray(new QFilter[]{reviseBoIdFilter});
        HRBaseServiceHelper logEntityHelper = new HRBaseServiceHelper(entityName);
        Map<Long, List<DynamicObject>> reviseBoIdVsLogDynArrList = Arrays.stream(logEntityDynArrFromDB).collect(Collectors.groupingBy(dyn -> dyn.getLong("revisebo")));
        for (DynamicObject logEntityDyn : logEntityDynList) {
            toBeSaveDynList.add(logEntityDyn);
            long reviseBoId = logEntityDyn.getLong("revisebo");
            List<DynamicObject> logEntityDynListFroBo = reviseBoIdVsLogDynArrList.get(reviseBoId);
            if (CollectionUtils.isEmpty(logEntityDynListFroBo)) {
                LOGGER.info("saveReviseLogDyn continue;");
                continue;
            }
            Collections.sort(logEntityDynListFroBo, Comparator.comparing(o -> o.getDate("revisedate")));
            DynamicObject lastDyn = logEntityDynListFroBo.get(logEntityDynListFroBo.size() - 1);
            lastDyn.set("reviseafter", (Object)logEntityDyn.getLong("revisebefore"));
            toBeSaveDynList.add(lastDyn);
        }
        logEntityHelper.save(toBeSaveDynList.toArray(new DynamicObject[0]));
    }
}

