/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.formula.excel.Expr;
import kd.hr.hbp.business.function.service.ReportFunctionExecuteService;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.util.QueryEntityUtil;

@ExcludeFromJacocoGeneratedReport
public class CalculateFieldMap
extends MapFunction {
    private static final long serialVersionUID = -2482848028357790158L;
    private List<HRComplexObjFieldInfo> calFieldList;
    private final Map<String, DynamicProperty> transferFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private final Map<String, Expr> exprCache = new HashMap<String, Expr>(16);
    private final ReportFunctionExecuteByCache reportFunctionExecuteByCache;
    private RowMeta resultRowMeta;
    private RowMeta sourceRowMeta;
    private String mainEntityNumber;
    private Map<String, String> relEntityMap;
    private Field[] sourceFields;
    private HRComplexObjContext context;

    public CalculateFieldMap(List<HRComplexObjFieldInfo> calFieldList, RowMeta sourceRowMeta, String mainEntityNumber, Map<String, String> relEntityMap, List<HRComplexObjFieldInfo> allFields, HRComplexObjContext context) {
        this.calFieldList = calFieldList;
        this.sourceRowMeta = sourceRowMeta;
        this.resultRowMeta = this.getResultRowMeta();
        this.mainEntityNumber = mainEntityNumber;
        this.relEntityMap = relEntityMap;
        this.sourceFields = this.sourceRowMeta.getFields();
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(context, allFields);
        this.context = context;
        this.initConvertFullField();
    }

    private void initConvertFullField() {
        Set existsKey = Arrays.stream(this.sourceFields).map(Field::getAlias).collect(Collectors.toSet());
        for (int i = 0; i < this.calFieldList.size(); ++i) {
            HRComplexObjFieldInfo fieldInfo = this.calFieldList.get(i);
            Set refFieldAliasSet = fieldInfo.getRefFieldAliasSet();
            for (String key : refFieldAliasSet) {
                DynamicProperty property;
                if (!existsKey.contains(key) || (property = new EntityPropParseUtil().getDynamicProperty(this.mainEntityNumber, this.relEntityMap, key)) == null || !QueryEntityUtil.checkEntityEnumProp((Object)property)) continue;
                this.transferFieldMap.put(key, property);
            }
        }
    }

    public Object[] map(Row row) {
        Object[] newRow = new Object[this.resultRowMeta.getFieldCount()];
        for (int i = 0; i < this.sourceFields.length; ++i) {
            newRow[i] = row.get(this.sourceFields[i].getAlias());
        }
        Set existsKey = Arrays.stream(this.sourceFields).map(Field::getAlias).collect(Collectors.toSet());
        for (int i = this.sourceFields.length; i < newRow.length; ++i) {
            HRComplexObjFieldInfo fieldInfo = this.calFieldList.get(i - this.sourceFields.length);
            String formula = fieldInfo.getFullPath();
            Expr expr = this.getExpr(formula);
            Set refFieldAliasSet = fieldInfo.getRefFieldAliasSet();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            for (String key : refFieldAliasSet) {
                Object fieldValue = null;
                if (existsKey.contains(key)) {
                    fieldValue = this.transferFieldMap.containsKey(key) ? QueryEntityUtil.getEntityProp((Object)this.transferFieldMap.get(key), (Object)row.get(key), null, (HRComplexObjContext)this.context) : row.get(key);
                }
                paramMap.putIfAbsent(key, fieldValue);
            }
            newRow[i] = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, formula, expr, paramMap);
        }
        return newRow;
    }

    private Expr getExpr(String formula) {
        Expr expr = this.exprCache.get(formula);
        if (expr == null) {
            expr = ReportFunctionExecuteService.getInstance().parseExpr(formula);
            this.exprCache.put(formula, expr);
        }
        return expr;
    }

    public final RowMeta getResultRowMeta() {
        Field[] sourceFields = this.sourceRowMeta.getFields();
        Field[] resultFields = Arrays.copyOf(sourceFields, sourceFields.length + this.calFieldList.size());
        for (int i = sourceFields.length; i < resultFields.length; ++i) {
            Field field;
            HRComplexObjFieldInfo fieldInfo = this.calFieldList.get(i - sourceFields.length);
            String alias = fieldInfo.getAlias();
            resultFields[i] = field = new Field(alias, AlgoDataTypeTransUtil.getDataType(fieldInfo.getDataType()));
        }
        return new RowMeta(resultFields);
    }
}

