/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExtendSortService {
    private static final Log LOGGER = LogFactory.getLog(ExtendSortService.class);
    private final Map<String, Long> allPkCache;
    private final HRBaseServiceHelper customSortHelper = new HRBaseServiceHelper("hrptmc_customsort");
    private final HRBaseServiceHelper commonSortHelper = new HRBaseServiceHelper("hrptmc_commonsort");

    public ExtendSortService() {
        this.allPkCache = new HashMap<String, Long>(16);
    }

    public void initAllPK4Cache(Set<Long> rptPks, Set<Long> rptFieldPks) {
        DynamicObject[] dynamicObjects;
        QFilter rptQfilter = new QFilter("rptmanage", "in", rptPks);
        QFilter rptFieldQfilter = new QFilter("rptfieldid", "in", rptFieldPks);
        QFilter[] qFilters = new QFilter[]{rptQfilter, rptFieldQfilter};
        for (DynamicObject dynamicObject : dynamicObjects = this.customSortHelper.queryOriginalArray("id,rptmanage,rptfieldid", qFilters)) {
            this.allPkCache.put(dynamicObject.getString("rptmanage") + ":" + dynamicObject.getString("rptfieldid"), dynamicObject.getLong("id"));
        }
    }

    public Long getCustomSortPk(Long rptPk, Long rptFieldPk) {
        Long pk = this.allPkCache.get(rptPk + ":" + rptFieldPk);
        if (pk == null) {
            QFilter rptQfilter = new QFilter("rptmanage", "=", (Object)rptPk);
            QFilter rptFieldQfilter = new QFilter("rptfieldid", "=", (Object)rptFieldPk);
            QFilter[] qFilters = new QFilter[]{rptQfilter, rptFieldQfilter};
            DynamicObject dynamicObject = this.customSortHelper.queryOriginalOne("id,rptmanage,rptfieldid", qFilters);
            if (dynamicObject != null) {
                pk = dynamicObject.getLong("id");
                this.allPkCache.put(dynamicObject.getString("rptmanage") + ":" + dynamicObject.getString("rptfieldid"), pk);
            }
        }
        return pk;
    }

    public Long getCommonSortPk(String entityNumber, String field, String localId) {
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
        qFilter.and(new QFilter("entityfield", "=", (Object)field));
        if (HRStringUtils.isNotEmpty((String)localId)) {
            qFilter.and(new QFilter("locale", "=", (Object)localId));
        }
        DynamicObject dynamicObject = this.commonSortHelper.queryOriginalOne("id,valuetype", qFilter.toArray());
        Long commonPk = null;
        if (dynamicObject != null) {
            commonPk = dynamicObject.getLong("id");
        }
        return commonPk;
    }

    public String getBizSortEntityByDbRouteKey(String dbRouteKey, String sortType) {
        return this.getBizSortEntityDynamicObject(null, dbRouteKey, sortType, "entity");
    }

    public String getBizSortTableByDbRouteKey(String dbRouteKey, String sortType) {
        return this.getBizSortEntityDynamicObject(null, dbRouteKey, sortType, "table");
    }

    public String getBizSortTableByDbRouteKey(String appNumber, String dbRouteKey, String sortType) {
        return this.getBizSortEntityDynamicObject(appNumber, dbRouteKey, sortType, "table");
    }

    private String getBizSortEntityDynamicObject(String appNumber, String dbRouteKey, String sortType, String type) {
        List<String> allDBRoutes;
        String result = this.getBizSortEntityDynamicObject(Collections.singletonList(dbRouteKey), sortType, type);
        if (HRStringUtils.isEmpty((String)result) && HRStringUtils.isNotEmpty((String)appNumber) && (allDBRoutes = this.querySameCloudAllDBRoute(appNumber)).size() > 1 && this.allInOne(allDBRoutes)) {
            result = this.getBizSortEntityDynamicObject(allDBRoutes, sortType, type);
            LOGGER.info(" query bizsortentity by same appNumber : {}, dbroute: {}, sorttable: {}", new Object[]{appNumber, dbRouteKey, result});
        }
        return result;
    }

    private String getBizSortEntityDynamicObject(List<String> dbRouteKeys, String sortType, String type) {
        QFilter sortTypeFilter;
        String result = null;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrptmc_bizsortentity");
        QFilter dbRouteKeyFilter = dbRouteKeys.size() == 1 ? new QFilter("dbroutekey", "=", (Object)dbRouteKeys.get(0)) : new QFilter("dbroutekey", "in", dbRouteKeys);
        QFilter[] qFilters = new QFilter[]{dbRouteKeyFilter, sortTypeFilter = new QFilter("sorttype", "=", (Object)sortType)};
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(qFilters);
        if (dynamicObject != null) {
            result = "entity".equals(type) ? dynamicObject.getString("sortentity") : dynamicObject.getString("sorttable");
        }
        return result;
    }

    private boolean allInOne(List<String> allDBRoutes) {
        DBConfigUtil dbConfigUtil = new DBConfigUtil();
        String sharingId = null;
        for (String allDBRoute : allDBRoutes) {
            String curSharingId = dbConfigUtil.getDBConfigSharingId(allDBRoute);
            if (sharingId == null) {
                sharingId = curSharingId;
            }
            if (HRStringUtils.equals((String)sharingId, (String)curSharingId)) continue;
            return false;
        }
        return true;
    }

    private List<String> querySameCloudAllDBRoute(String appNumber) {
        String sql = "SELECT DISTINCT T1.FDBROUTE FROM T_META_BIZAPP T1 WHERE EXISTS ( SELECT 1 FROM T_META_BIZAPP T2 WHERE T2.FNUMBER = ? AND T1.FBIZCLOUDID = T2.FBIZCLOUDID)";
        return (List)HRDBUtil.query((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{appNumber}, rs -> {
            ArrayList<String> allData = new ArrayList<String>(10);
            while (rs.next()) {
                allData.add(rs.getString("FDBROUTE"));
            }
            return allData;
        });
    }

    public boolean checkSortTable(String dbRouteKey, String bizSortTable) {
        String confirmSql = "select top 1 fid,fstring,flong,findex,fentitysortfieldid from " + bizSortTable;
        try {
            HRDBUtil.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)confirmSql, (Object[])new Object[0], rs -> null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

