/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.CalculateFieldMap;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.algox.func.algo.FieldTransferVirtualMapFunction;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.business.virtulentity.IVirtualEntityService;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.SummaryQueryResultInfo;
import kd.hr.hbp.common.model.virtulentity.TotalRowValueInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualEntityQueryParamInfo;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.model.virtulentity.dimvalue.DimensionValueInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;
import org.apache.commons.lang3.StringUtils;

public class ReportQueryPlanByService
extends IReportQueryPlan {
    private static final Log LOGGER = LogFactory.getLog(ReportQueryPlanByService.class);
    private IVirtualEntityService virtualEntityService;

    public ReportQueryPlanByService(HRComplexObjContext context) {
        super(context);
        this.initVirtualEntityService(context);
    }

    private void initVirtualEntityService(HRComplexObjContext context) {
        if (!context.getVirtualEntity().booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u53c2\u6570\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        String virtualEntityQueryService = context.getVirtualEntityQueryService();
        if (context.getVirtualEntityQueryParamInfo() == null || HRStringUtils.isEmpty((String)virtualEntityQueryService)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u53c2\u6570\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        try {
            this.virtualEntityService = (IVirtualEntityService)Class.forName(virtualEntityQueryService).newInstance();
        }
        catch (Exception e) {
            LOGGER.error("VirtualEntity Query Param error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u670d\u52a1\u7c7b\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    @Override
    public DataSet queryDataSet() {
        long startTime = System.currentTimeMillis();
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = this.getContext().getVirtualEntityQueryParamInfo();
        if (virtualEntityQueryParamInfo.getStart() < 0) {
            virtualEntityQueryParamInfo.setStart(0);
        }
        LOGGER.info("ReportQueryPlanByService queryDataSet param {}", (Object)virtualEntityQueryParamInfo);
        SummaryQueryParamInfo summaryQueryParamInfo = virtualEntityQueryParamInfo.getSummaryQueryParamInfo();
        if (summaryQueryParamInfo == null) {
            summaryQueryParamInfo = new SummaryQueryParamInfo(false, 0, false);
        } else {
            summaryQueryParamInfo.setSummaryQueryBatchNo(summaryQueryParamInfo.getSummaryQueryBatchNo() + 1);
        }
        if (summaryQueryParamInfo.getSummaryQueryBatchNo() > 200) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u670d\u52a1\u6279\u6b21\u8d85\u8fc7200\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        virtualEntityQueryParamInfo.setSummaryQueryParamInfo(summaryQueryParamInfo);
        TotalRowValueInfo totalRow = this.virtualEntityService.getTotalRow(virtualEntityQueryParamInfo);
        LOGGER.info("ReportQueryPlanByService queryDataSet elapsed time\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        if (totalRow == null || totalRow.getDataSet() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u670d\u52a1\u8fd4\u56de\u6570\u636e\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        LOGGER.info("ReportQueryPlanByService queryDataSet response title {}", (Object)Arrays.toString(totalRow.getDataSet().getRowMeta().getFields()));
        virtualEntityQueryParamInfo.getSummaryQueryParamInfo().setAllData(totalRow.isAllData());
        Set<String> queryFieldSet = virtualEntityQueryParamInfo.getSelectedFieldInfoList().stream().map(VirtualFieldInfo::getNumber).collect(Collectors.toSet());
        this.checkDataSet(queryFieldSet, totalRow.getDataSet());
        return this.fillFunctionField(totalRow.getDataSet());
    }

    @Override
    public DataSet queryDataSet(int start, int limit) {
        DataSet dataSet;
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = this.getContext().getVirtualEntityQueryParamInfo();
        virtualEntityQueryParamInfo.setLimit(limit);
        if (start < 0) {
            start = 0;
        }
        virtualEntityQueryParamInfo.setStart(start);
        LOGGER.info("ReportQueryPlanByService queryDataSet param {}", (Object)virtualEntityQueryParamInfo);
        long startTime = System.currentTimeMillis();
        if ("1".equals(this.getContext().getQueryMode())) {
            dataSet = this.virtualEntityService.getDetailReportData(virtualEntityQueryParamInfo);
        } else {
            SummaryQueryParamInfo summaryQueryParamInfo = virtualEntityQueryParamInfo.getSummaryQueryParamInfo();
            if (summaryQueryParamInfo == null) {
                summaryQueryParamInfo = new SummaryQueryParamInfo(false, 0, false);
            } else {
                summaryQueryParamInfo.setSummaryQueryBatchNo(summaryQueryParamInfo.getSummaryQueryBatchNo() + 1);
            }
            virtualEntityQueryParamInfo.setSummaryQueryParamInfo(summaryQueryParamInfo);
            if (summaryQueryParamInfo.getSummaryQueryBatchNo() > 200) {
                throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u670d\u52a1\u6279\u6b21\u8d85\u8fc7200\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_5", (String)"hrmp-hbp-business", (Object[])new Object[0]));
            }
            SummaryQueryResultInfo summaryQueryResultInfo = this.virtualEntityService.getSummaryReportData(virtualEntityQueryParamInfo);
            virtualEntityQueryParamInfo.getSummaryQueryParamInfo().setAllData(summaryQueryResultInfo.isAllData());
            dataSet = summaryQueryResultInfo.getDataSet();
        }
        LOGGER.info("ReportQueryPlanByService queryDataSet elapsed time\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        if (dataSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u670d\u52a1\u8fd4\u56de\u6570\u636e\u9519\u8bef\u3002", (String)"ReportQueryPlanByService_2", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        LOGGER.info("ReportQueryPlanByService queryDataSet response title {}", (Object)Arrays.toString(dataSet.getRowMeta().getFields()));
        Set<String> queryFieldSet = virtualEntityQueryParamInfo.getSelectedFieldInfoList().stream().map(VirtualFieldInfo::getNumber).collect(Collectors.toSet());
        this.checkDataSet(queryFieldSet, dataSet);
        return this.fillFunctionField(dataSet);
    }

    private void checkDataSet(Set<String> shouldExistsField, DataSet dataSet) {
        List<String> dataSetFields = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        for (String field : shouldExistsField) {
            if (dataSetFields.contains(field)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u7f3a\u5c11:%s\u3002", (String)"ReportQueryPlanByService_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), field));
        }
    }

    @Override
    public List<Map<String, Object>> queryMap() {
        DataSet dataSet = this.queryDataSet();
        return this.dataSetToListMap(dataSet);
    }

    @Override
    public List<Map<String, Object>> queryMap(int start, int limit) {
        DataSet dataSet = this.queryDataSet(start, limit);
        return this.dataSetToListMap(dataSet);
    }

    @Override
    public long queryDataCount(int start, int limit) {
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = this.getContext().getVirtualEntityQueryParamInfo();
        virtualEntityQueryParamInfo.setStart(start);
        virtualEntityQueryParamInfo.setLimit(limit);
        return this.virtualEntityService.getTotalCount(virtualEntityQueryParamInfo);
    }

    @Override
    public List<Map<String, DimensionData>> queryDimensionData() {
        VirtualEntityQueryParamInfo virtualEntityQueryParamInfo = this.getContext().getVirtualEntityQueryParamInfo();
        long startTime = System.currentTimeMillis();
        List<List<DimensionValueInfo>> dimensionDatas = this.virtualEntityService.getSummaryReportColumnDimensionData(virtualEntityQueryParamInfo);
        LOGGER.info("ReportQueryPlanByService getSummaryReportColumnDimensionData elapsed time\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        List columnDimensionList = virtualEntityQueryParamInfo.getColumnDimensionList();
        this.checkDimensionDatas(dimensionDatas, columnDimensionList);
        Set sortFieldAliasSet = this.getContext().getSortFieldInfoList().stream().filter(sortFieldInfo -> SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())).map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet());
        ArrayList<Map<String, DimensionData>> rstData = new ArrayList<Map<String, DimensionData>>(dimensionDatas.size());
        for (List<DimensionValueInfo> dimensionData : dimensionDatas) {
            HashMap<String, DimensionData> data = new HashMap<String, DimensionData>(columnDimensionList.size());
            for (int index = 0; index < columnDimensionList.size(); ++index) {
                VirtualFieldInfo virtualFieldInfo = (VirtualFieldInfo)columnDimensionList.get(index);
                DimensionValueInfo dimensionValueInfo = dimensionData.get(index);
                String number = virtualFieldInfo.getNumber();
                data.put(number, new DimensionData(dimensionValueInfo.getId(), dimensionValueInfo.getName(), sortFieldAliasSet.contains(number), dimensionValueInfo.getReferToOrderValue()));
            }
            rstData.add(data);
        }
        if (!this.getContext().isTransferField()) {
            this.dataTypeConvert(columnDimensionList, rstData);
        }
        return rstData;
    }

    @Override
    public List<OrderField> getOrderFields() {
        return this.virtualEntityService.getOrderFields();
    }

    protected void dataTypeConvert(List<VirtualFieldInfo> columnDimensionList, List<Map<String, DimensionData>> listDB) {
        EntityPropParseUtil propParseUtil = new EntityPropParseUtil();
        TimeZone timeZone = KDDateUtils.getTimeZone();
        for (VirtualFieldInfo virtualFieldInfo : columnDimensionList) {
            if (!virtualFieldInfo.isCommonField() || StringUtils.isBlank((CharSequence)virtualFieldInfo.getFieldPath())) continue;
            String fullPath = virtualFieldInfo.getFieldPath();
            DynamicProperty property = propParseUtil.getVirtDynamicProperty(fullPath);
            for (Map<String, DimensionData> map : listDB) {
                DimensionData dimensionData = map.get(virtualFieldInfo.getNumber());
                Object entityVal = QueryEntityUtil.getEntityProp((Object)property, (Object)dimensionData.getValue(), (TimeZone)timeZone, (HRComplexObjContext)this.getContext());
                dimensionData.setValue(entityVal);
                map.put(virtualFieldInfo.getNumber(), dimensionData);
            }
        }
    }

    private void checkDimensionDatas(List<List<DimensionValueInfo>> dimensionDatas, List<VirtualFieldInfo> columnDimensionList) {
        for (List<DimensionValueInfo> dimensionData : dimensionDatas) {
            if (dimensionData.size() == columnDimensionList.size()) continue;
            LOGGER.error("getSummaryReportColumnDimensionData column:{},data:{}", columnDimensionList, dimensionData);
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5b9e\u4f53\u7ef4\u5ea6\u6570\u636e\u67e5\u8be2\u51fa\u9519\u3002", (String)"ReportQueryPlanByService_4", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
    }

    private DataSet fillFunctionField(DataSet dataSet) {
        List calFieldList = this.getContext().getComplexObjFieldInfoList().stream().filter(af -> !af.getFieldType().equals("1")).collect(Collectors.toList());
        String mainEntityNumber = this.getContext().getEntityNumber();
        Map<String, String> relEntityMap = this.getContext().getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityNumber, HRComplexObjJoinRelation::getRelEntityAlias, (key1, key2) -> key2));
        if (CollectionUtils.isNotEmpty(calFieldList)) {
            for (HRComplexObjFieldInfo hrComplexObjFieldInfo : calFieldList) {
                ArrayList<HRComplexObjFieldInfo> tmpList = new ArrayList<HRComplexObjFieldInfo>();
                tmpList.add(hrComplexObjFieldInfo);
                dataSet = dataSet.map((MapFunction)new CalculateFieldMap(tmpList, dataSet.getRowMeta(), mainEntityNumber, relEntityMap, this.getContext().getComplexObjFieldInfoList(), this.getContext()));
            }
        }
        if (!this.getContext().isTransferField()) {
            dataSet = dataSet.map((MapFunction)new FieldTransferVirtualMapFunction(dataSet.getRowMeta(), this.getContext()));
        }
        dataSet = dataSet.copy();
        return dataSet;
    }

    private List<Map<String, Object>> dataSetToListMap(DataSet dataSet) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            Row rs = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String fieldName : fieldNames) {
                Object val = rs.get(fieldName);
                resultMap.put(fieldName, val);
            }
            resultList.add(resultMap);
        }
        return resultList;
    }
}

