/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.IReportQueryPlan;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByAlgoX;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByKSql;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanByService;
import kd.hr.hbp.business.service.complexobj.ReportQueryPlanProxyFactory;
import kd.hr.hbp.business.service.complexobj.model.DimensionData;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjRouteUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;

public class ReportQueryService {
    private static final Log LOGGER = LogFactory.getLog(ReportQueryService.class);
    private IReportQueryPlan reportQueryPlan;
    private final HRComplexObjContext context;

    public ReportQueryService(HRComplexObjContext context) {
        this.context = context;
        LOGGER.info("ReportQueryService query param:{}", (Object)context);
        this.initQueryPlan();
    }

    private void initQueryPlan() {
        if (this.context.getVirtualEntity().booleanValue()) {
            LOGGER.info("complexobj query by VirtualEntityQueryService");
            this.reportQueryPlan = new ReportQueryPlanByService(this.context);
            return;
        }
        String queryScheme = this.context.getQueryScheme();
        boolean useAlgoX = ComplexObjRouteUtil.useAlgoXQuery(queryScheme, this.context);
        long startTime = System.currentTimeMillis();
        if (useAlgoX) {
            LOGGER.info("[complexobj-route]:route to ALGOX");
            this.reportQueryPlan = ReportQueryPlanProxyFactory.getProxyInstance(new ReportQueryPlanByAlgoX(this.context));
        } else {
            LOGGER.info("[complexobj-route]:route to KSQL");
            this.reportQueryPlan = ReportQueryPlanProxyFactory.getProxyInstance(new ReportQueryPlanByKSql(this.context));
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("complexobj query scheme route elapsed time:{}", (Object)(endTime - startTime));
    }

    public DataSet queryDataSet() {
        return this.reportQueryPlan.queryDataSet();
    }

    public DataSet queryDataSet(int start, int limit) {
        return this.reportQueryPlan.queryDataSet(start, limit);
    }

    public List<Map<String, Object>> queryMap() {
        return this.reportQueryPlan.queryMap();
    }

    public List<Map<String, Object>> queryMap(int start, int limit) {
        return this.reportQueryPlan.queryMap(start, limit);
    }

    public long queryDataCount(int start, int limit) {
        return this.reportQueryPlan.queryDataCount(start, limit);
    }

    public List<Map<String, DimensionData>> queryDimensionData() {
        return this.reportQueryPlan.queryDimensionData();
    }
}

