/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.IAlgoXQueryService;
import kd.hr.hbp.business.service.complexobj.algox.constants.AlgoXConstants;
import kd.hr.hbp.business.service.complexobj.algox.func.AlgoXFieldTransferMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.CalculateMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.CustomOrderMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.JoinDataSetRowMetaFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.TransferFieldValueMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.algo.SelectFieldMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXInputParam;
import kd.hr.hbp.business.service.complexobj.algox.output.AlgoxOutputHelper;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXPagingOptimizeParser;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.plugin.QueryPluginFieldService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.paging.Partition;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.flink.api.java.tuple.Tuple2;

@ExcludeFromJacocoGeneratedReport
public class AlgoXQueryService
implements IAlgoXQueryService,
AlgoXConstants {
    private static final Log LOGGER = LogFactory.getLog(AlgoXQueryService.class);
    protected AlgoXParser algoxParser;
    protected HRComplexObjContext context;
    protected AlgoxOutputHelper algoxOutputHelper;
    protected Partition partition;
    protected AlgoXPagingOptimizeParser algoXPagingOptimizeParser;

    protected AlgoXQueryService(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.algoxOutputHelper = new AlgoxOutputHelper(context.getAlgoxJobKey());
        this.partition = new Partition(this.algoxParser.getRealMainEntityNumber(), this.algoxParser.getRealMainEntityAlias(), -1, -1);
        this.algoXPagingOptimizeParser = new AlgoXPagingOptimizeParser(this.context, this.algoxParser, this.partition);
    }

    public AlgoXQueryService(HRComplexObjContext context) {
        this.context = context;
        this.algoxParser = new AlgoXParser(context);
        this.algoxOutputHelper = new AlgoxOutputHelper(context.getAlgoxJobKey());
        this.partition = new Partition(this.algoxParser.getRealMainEntityNumber(), this.algoxParser.getRealMainEntityAlias(), -1, -1);
        this.algoXPagingOptimizeParser = new AlgoXPagingOptimizeParser(this.context, this.algoxParser, this.partition);
    }

    @Override
    public DataSetX query4DataSetX() {
        return this.query4DataSetX(dataSetX -> dataSetX, false);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public DataSetX query4DataSetX(int start, int limit) {
        this.checkPagingParam(start, limit);
        DataSet dataSet = this.query4DataSet(start, limit, false);
        return this.getSession().fromInput((Input)new DataSetInput(dataSet));
    }

    @ExcludeFromJacocoGeneratedReport
    public DataSetX query4DataSetX(DataSetX dataSetX, int start, int limit) {
        DataSet dataSet = this.query4DataSet(dataSetX, start, limit, false);
        return this.getSession().fromInput((Input)new DataSetInput(dataSet));
    }

    protected DataSetX query4DataSetX(Function<DataSetX, DataSetX> func, boolean isCount) {
        DataSetX mainDataSetX = this.createRelationDataSetX();
        mainDataSetX = this.addFieldTransferDataSetX(mainDataSetX);
        mainDataSetX = this.addPluginField(mainDataSetX);
        mainDataSetX = this.addCalculateField(mainDataSetX);
        mainDataSetX = this.addWhereFilter(mainDataSetX);
        if (!isCount) {
            mainDataSetX = this.addTransferDataSetX(mainDataSetX);
            mainDataSetX = func.apply(mainDataSetX);
            mainDataSetX = this.addDistinct(mainDataSetX);
            mainDataSetX = this.addOrderBy(mainDataSetX);
        }
        mainDataSetX = this.addTopDataSetX(mainDataSetX);
        return mainDataSetX;
    }

    protected DataSetX createRelationDataSetX() {
        DataSetX mainDataSetX = this.createMainDataSetX();
        List<HRComplexObjJoinRelation> hasFieldRelEntityAliasList = this.algoxParser.getHasFieldRelEntityAliasList();
        if (!CollectionUtils.isEmpty(hasFieldRelEntityAliasList)) {
            for (HRComplexObjJoinRelation joinRelation : hasFieldRelEntityAliasList) {
                mainDataSetX = this.createJoinDataSetX(mainDataSetX, joinRelation);
            }
        }
        return mainDataSetX;
    }

    @Override
    public DataSet query4DataSet() {
        return this.query4DataSet(true);
    }

    @Override
    public DataSet query4DataSet(boolean mappingField) {
        DataSetX mainDataSetX = this.query4DataSetX();
        return this.query4DataSet(mainDataSetX, mappingField);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public DataSet query4DataSet(int start, int limit) {
        this.checkPagingParam(start, limit);
        return this.query4DataSet(start, limit, true);
    }

    @Override
    public DataSet query4DataSet(int start, int limit, boolean mappingField) {
        this.checkPagingParam(start, limit);
        DataSetX mainDataSetX = this.query4DataSetX();
        return this.query4DataSet(mainDataSetX, start, limit, mappingField);
    }

    protected DataSet query4DataSet(DataSetX dataSetX, boolean mappingField) {
        return this.query4DataSet(dataSetX, -1, -1, mappingField);
    }

    protected DataSet query4DataSet(DataSetX dataSetX, int start, int limit, boolean mappingField) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("[repCalculate-AlgoX] query4DataSet algoXJobKey:{}, param[start:{}, limit:{}]", new Object[]{this.context.getAlgoxJobKey(), start, limit});
        DataSet dataSetAll = this.algoxOutputHelper.dataSetOutput(dataSetX);
        DataSet dataSet = null;
        if (start >= 0 && limit > 0) {
            dataSet = dataSetAll.range(start, limit);
            dataSetAll.close();
        } else {
            dataSet = dataSetAll;
        }
        if (mappingField) {
            dataSet = this.convertSelectField(dataSet);
        }
        long calculateTime = System.currentTimeMillis();
        LOGGER.info("[repCalculate-AlgoX] query4DataSet algoXJobKey:{}, elapsed time:{}", (Object)this.context.getAlgoxJobKey(), (Object)(calculateTime - startTime));
        return dataSet;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap() {
        DataSetX mainDataSetX = this.query4DataSetX();
        return this.query4ListMap(mainDataSetX);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap(int start, int limit) {
        this.checkPagingParam(start, limit);
        DataSetX mainDataSetX = this.query4DataSetX();
        return this.query4ListMap(mainDataSetX, start, limit);
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Map<String, Object>> query4ListMap(DataSetX dataSetX) {
        return this.query4ListMap(dataSetX, -1, -1);
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Map<String, Object>> query4ListMap(DataSetX dataSetX, int start, int limit) {
        DataSet dataSet = this.query4DataSet(dataSetX, start, limit, true);
        return this.getDataSetMaps(dataSet);
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<Map<String, Object>> getDataSetMaps(DataSet dataSet) {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            Row rs = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String fieldName : fieldNames) {
                resultMap.put(fieldName, rs.get(fieldName));
            }
            resultList.add(resultMap);
        }
        return resultList;
    }

    protected DataSetX createMainDataSetX() {
        String mainEntityNumber = this.context.getEntityNumber();
        List<QFilter> mainQFilterList = this.getMainEntityFilterList();
        this.checkIfAddOnFilter(mainQFilterList, 0, JoinType.RIGHT);
        RowMeta mainRowMeta = this.algoxParser.getMainRowMeta();
        Input algoXInput = this.getAlgoXInput(new AlgoXInputParam(mainEntityNumber, mainEntityNumber, mainRowMeta, mainQFilterList, this.partition.getEntityStart(mainEntityNumber), this.partition.getEntityLimit(mainEntityNumber)));
        DataSetX mainDataSetX = this.getSession().fromInput(algoXInput);
        LOGGER.info("createMainDataSetX_entityNumber_{},qFilter_{}", (Object)mainEntityNumber, mainQFilterList);
        return this.addFieldAliasChangeDataSetX(mainDataSetX);
    }

    protected DataSetX createJoinDataSetX(DataSetX mainDataSetX, HRComplexObjJoinRelation joinRelation) {
        String relEntityAlias = joinRelation.getRelEntityAlias();
        RowMeta relRowMeta = this.algoxParser.getRelRowMeta(relEntityAlias);
        return this.createJoinDataSetX(mainDataSetX, joinRelation, relRowMeta);
    }

    protected DataSetX createJoinDataSetX(DataSetX mainDataSetX, HRComplexObjJoinRelation joinRelation, RowMeta relRowMeta) {
        String relEntityNumber = joinRelation.getRelEntityNumber();
        String relEntityAlias = joinRelation.getRelEntityAlias();
        String joinType = joinRelation.getJoinType();
        List<QFilter> relQFilterList = JoinType.LEFT.getName().equals(joinType) || JoinType.INNER.getName().equals(joinType) ? this.getRelJoinAndWhereQFilterList(relEntityAlias) : this.getRelWhereQFilterList(relEntityAlias);
        Input algoXInput = this.getAlgoXInput(new AlgoXInputParam(relEntityNumber, relEntityAlias, relRowMeta, relQFilterList, this.partition.getEntityStart(relEntityAlias), this.partition.getEntityLimit(relEntityAlias)));
        DataSetX relDataSetX = this.getSession().fromInput(algoXInput);
        LOGGER.info("createJoinDataSetX_entityNumber_{},qFilter_{}", (Object)relEntityNumber, relQFilterList);
        relDataSetX = this.addFieldAliasChangeDataSetX(relDataSetX);
        if (this.algoxParser.containsCombineJoinEntity(relEntityAlias)) {
            return this.createCombineJoinDataSetX(mainDataSetX, relDataSetX, joinRelation);
        }
        return this.createSimpleJoinDataSetX(mainDataSetX, joinType, relDataSetX, relEntityAlias);
    }

    protected DataSetX createTempDataSetX(DataSetX mainDataSetX, DataSetX relDataSetX, HRComplexObjJoinRelation joinRelation) {
        JoinDataSetX joinDataSetX;
        String joinType = joinRelation.getJoinType();
        String entityAlias = joinRelation.getEntityAlias();
        String relEntityAlias = joinRelation.getRelEntityAlias();
        if (JoinType.LEFT.getName().equals(joinType)) {
            DataSetX tempMainDataSetX = this.context.getEntityNumber().equals(entityAlias) ? this.createTempMainDataSetX(this.algoxParser.getMainOnRelQFilterList(relEntityAlias)) : this.createTempRelDataSetX(entityAlias);
            joinDataSetX = tempMainDataSetX.leftJoin(relDataSetX);
            joinDataSetX = joinDataSetX.select(this.mergeFieldNameArray(tempMainDataSetX.getRowMeta().getFields(), Boolean.TRUE, new Field[][]{relDataSetX.getRowMeta().getFields()}));
        } else {
            DataSetX tempRelDataSetX = this.createTempRelDataSetX(relEntityAlias);
            joinDataSetX = mainDataSetX.rightJoin(tempRelDataSetX);
            joinDataSetX = joinDataSetX.select(this.mergeFieldNameArray(tempRelDataSetX.getRowMeta().getFields(), Boolean.FALSE, new Field[][]{mainDataSetX.getRowMeta().getFields()}));
        }
        return this.relEntityAliasOnAlgoXAliasRelate(relEntityAlias, joinDataSetX);
    }

    protected DataSetX createCombineJoinDataSetX(DataSetX mainDataSetX, DataSetX relDataSetX, HRComplexObjJoinRelation joinRelation) {
        String primaryAlias;
        JoinDataSetX joinDataSetX;
        String joinType = joinRelation.getJoinType();
        String entityAlias = joinRelation.getEntityAlias();
        String relEntityAlias = joinRelation.getRelEntityAlias();
        DataSetX tempDataSetX = this.createTempDataSetX(mainDataSetX, relDataSetX, joinRelation);
        if (JoinType.LEFT.getName().equals(joinType)) {
            joinDataSetX = mainDataSetX.leftJoin(tempDataSetX);
            primaryAlias = this.algoxParser.getPrimaryAlias(entityAlias);
            joinDataSetX = joinDataSetX.select(this.mergeFieldNameArray(mainDataSetX.getRowMeta().getFields(), Boolean.TRUE, new Field[][]{tempDataSetX.getRowMeta().getFields()}));
        } else if (JoinType.RIGHT.getName().equals(joinType)) {
            joinDataSetX = tempDataSetX.rightJoin(relDataSetX);
            primaryAlias = this.algoxParser.getPrimaryAlias(relEntityAlias);
            joinDataSetX = joinDataSetX.select(this.mergeFieldNameArray(relDataSetX.getRowMeta().getFields(), Boolean.FALSE, new Field[][]{tempDataSetX.getRowMeta().getFields()}));
        } else {
            throw new KDBizException("not support join type!");
        }
        joinDataSetX = joinDataSetX.on(primaryAlias, primaryAlias);
        return joinDataSetX;
    }

    protected DataSetX createSimpleJoinDataSetX(DataSetX mainDataSetX, String joinType, DataSetX relDataSetX, String relEntityAlias) {
        JoinDataSetX joinDataSetX;
        if (JoinType.LEFT.getName().equals(joinType)) {
            joinDataSetX = mainDataSetX.leftJoin(relDataSetX);
        } else if (JoinType.RIGHT.getName().equals(joinType)) {
            joinDataSetX = mainDataSetX.rightJoin(relDataSetX);
        } else if (JoinType.INNER.getName().equals(joinType)) {
            joinDataSetX = mainDataSetX.join(relDataSetX);
        } else {
            throw new KDBizException("not support join type!");
        }
        return this.relEntityAliasOnAlgoXAliasRelate(relEntityAlias, joinDataSetX);
    }

    protected JoinDataSetX relEntityAliasOnAlgoXAliasRelate(String relEntityAlias, JoinDataSetX joinDataSetX) {
        Set<Tuple2<String, String>> relEntityAliasOnAlgoxAliasSet = this.algoxParser.relEntityAliasOnAlgoXAliasSet(relEntityAlias);
        for (Tuple2<String, String> relEntityAliasOnAlgoxAlias : relEntityAliasOnAlgoxAliasSet) {
            joinDataSetX = joinDataSetX.on((String)relEntityAliasOnAlgoxAlias.f0, (String)relEntityAliasOnAlgoxAlias.f1);
        }
        return joinDataSetX;
    }

    protected DataSetX addWhereFilter(DataSetX mainDataSetX) {
        Tuple2<String, Map<String, Object>> joinEntityWhereFilterStrParam = this.algoxParser.getRelEntityWhereFilterStrParam();
        if (HRStringUtils.isNotEmpty((String)((String)joinEntityWhereFilterStrParam.f0))) {
            LOGGER.info("addWhereFilter_filter_left_{},right_{}", joinEntityWhereFilterStrParam.f0, joinEntityWhereFilterStrParam.f1);
            mainDataSetX = mainDataSetX.filter((String)joinEntityWhereFilterStrParam.f0, (Map)joinEntityWhereFilterStrParam.f1);
        }
        return mainDataSetX;
    }

    protected DataSetX addCalculateField(DataSetX mainDataSetX) {
        if (this.algoxParser.hasCalculateField()) {
            List<Field> calculateFieldList = this.algoxParser.getCalculateFieldList();
            LOGGER.info("addCalculateField_size_{}", (Object)calculateFieldList.size());
            LOGGER.info("addCalculateField_{}", calculateFieldList);
            mainDataSetX = mainDataSetX.addFields(calculateFieldList.toArray(new Field[0]), new Object[calculateFieldList.size()]);
            mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)new CalculateMapFunction(mainDataSetX.getRowMeta(), this.algoxParser, this.context));
        }
        return mainDataSetX;
    }

    protected DataSetX addPluginField(DataSetX mainDataSetX) {
        if (this.algoxParser.hasPluginField()) {
            Map<String, AlgoXFieldInfo> pluginFieldInfoMap = this.algoxParser.getPluginFieldInfoMap();
            LOGGER.info("addPluginField_getPluginFieldInfoMap_size_{}", (Object)pluginFieldInfoMap.size());
            LOGGER.info("addPluginField_getPluginFieldInfoMap_{}", pluginFieldInfoMap);
            for (AlgoXFieldInfo pluginFieldInfo : pluginFieldInfoMap.values()) {
                mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)QueryPluginFieldService.getPluginFieldAlgoXFunction(this.context, mainDataSetX.getRowMeta(), pluginFieldInfo.getFieldInfo()));
            }
        }
        return mainDataSetX;
    }

    protected DataSetX addOrderBy(DataSetX mainDataSetX) {
        Object[] orderByArr = this.algoxParser.getOrderByAlgoXAliasArr();
        if (this.context.isOrder() && orderByArr != null && orderByArr.length > 0) {
            mainDataSetX = this.addCustomOrderBy(mainDataSetX);
            LOGGER.info("order_by_{}", (Object)Arrays.toString(orderByArr));
            mainDataSetX = mainDataSetX.orderBy((String[])orderByArr);
        }
        return mainDataSetX;
    }

    protected DataSetX addCustomOrderBy(DataSetX mainDataSetX) {
        Map<String, Map<String, Integer>> customOrderMap = this.algoxParser.getCustomOrderMap();
        for (Map.Entry<String, Map<String, Integer>> orderEntry : customOrderMap.entrySet()) {
            Map<String, Integer> value = orderEntry.getValue();
            String newOrderFieldAlias = "CUSTOM_ORDER_" + AlgoXFieldInfo.replaceAlgoxAlias(orderEntry.getKey());
            RowMeta rowMeta = mainDataSetX.getRowMeta();
            int fieldIndex = rowMeta.getFieldIndex(newOrderFieldAlias, false);
            if (fieldIndex != -1) continue;
            mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)new CustomOrderMapFunction(rowMeta, orderEntry.getKey(), newOrderFieldAlias, value));
        }
        return mainDataSetX;
    }

    protected DataSetX addTopDataSetX(DataSetX mainDataSetX) {
        int start = this.algoxParser.getStart();
        int limit = this.algoxParser.getLimit();
        if (start >= 0 && limit >= 0) {
            mainDataSetX = mainDataSetX.top(start + limit);
        }
        return mainDataSetX;
    }

    @ExcludeFromJacocoGeneratedReport
    protected DataSetX addDistinct(DataSetX mainDataSetX) {
        List<String> distinctList = this.algoxParser.getDistinctAlgoXAliasList();
        LOGGER.info("addDistinct_getDistinctAlgoXAliasList_{}", distinctList);
        if (distinctList != null && !distinctList.isEmpty()) {
            LOGGER.info("addDistinct_getDistinctAlgoXAliasList_size_{}", (Object)distinctList.size());
            if (this.context.isReturnEnumOriginalValue()) {
                String[] fieldNames;
                RowMeta rowMeta = mainDataSetX.getRowMeta();
                for (String fieldName : fieldNames = rowMeta.getFieldNames()) {
                    if (!fieldName.startsWith("ORIGINAL_ENUM_VALUE_") || !distinctList.contains(fieldName.replaceFirst("ORIGINAL_ENUM_VALUE_", ""))) continue;
                    distinctList.add(fieldName);
                }
                if (mainDataSetX instanceof JoinDataSetX) {
                    mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)new JoinDataSetRowMetaFunction(rowMeta));
                }
            }
            LOGGER.info("addDistinct_distinctList_{}", distinctList);
            String[] distinctArray = distinctList.toArray(new String[0]);
            mainDataSetX = mainDataSetX.select(distinctArray).distinct(distinctArray);
        }
        return mainDataSetX;
    }

    protected DataSetX addTransferDataSetX(DataSetX mainDataSetX) {
        if (!this.context.isTransferField()) {
            mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)new AlgoXFieldTransferMapFunction(mainDataSetX.getRowMeta(), this.context, this.algoxParser));
        }
        return mainDataSetX;
    }

    protected DataSetX addFieldAliasChangeDataSetX(DataSetX mainDataSetX) {
        Field[] fields;
        RowMeta rowMeta = mainDataSetX.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            field.setName(field.getAlias());
        }
        return mainDataSetX;
    }

    protected DataSetX addFieldTransferDataSetX(DataSetX mainDataSetX) {
        Map<String, Set<String>> algoXAliasTransferFieldAliasMap = this.algoxParser.getAlgoXAliasTransferFieldAliasMap();
        if (!algoXAliasTransferFieldAliasMap.isEmpty()) {
            LOGGER.info("addFieldTransferDataSetX_getAlgoXAliasTransferFieldAliasMap_size_{}", (Object)algoXAliasTransferFieldAliasMap.size());
            LOGGER.info("addFieldTransferDataSetX_getAlgoXAliasTransferFieldAliasMap_{}", algoXAliasTransferFieldAliasMap);
            mainDataSetX = mainDataSetX.map((kd.bos.algox.MapFunction)new TransferFieldValueMapFunction(mainDataSetX.getRowMeta(), this.algoxParser));
        }
        return mainDataSetX;
    }

    @Override
    public AlgoXParser getAlgoXParser() {
        return this.algoxParser;
    }

    @Override
    public AlgoxOutputHelper getAlgoXOutputHelper() {
        return this.algoxOutputHelper;
    }

    @Override
    public JobSession getSession() {
        return this.algoxOutputHelper.getSession();
    }

    @Override
    public String getAlgoXJobKey() {
        return this.context.getAlgoxJobKey();
    }

    @Override
    public List<OrderField> getOrderFields() {
        return this.algoxParser.getOrderFields();
    }

    @Override
    public long queryDataCount(int start, int limit) {
        DataSetX mainDataSetX = this.query4DataSetX(dataSetX -> dataSetX, true);
        return this.getCount(mainDataSetX, start, limit);
    }

    protected long getCount(DataSetX mainDataSetX, int start, int limit) {
        String primaryAlias = this.algoxParser.getPrimaryAlias(this.algoxParser.getRealMainEntityAlias());
        DataSetX countDataSetX = mainDataSetX.count(primaryAlias);
        DataSet dataSet = this.algoxOutputHelper.dataSetOutput(countDataSetX);
        if (dataSet.hasNext()) {
            long count;
            Row row = dataSet.next();
            if (row == null) {
                return 0L;
            }
            Object countResult = row.get(primaryAlias);
            long l = count = countResult == null ? 0L : Long.parseLong(countResult.toString());
            if (start >= 0 && limit >= 0 && count > (long)limit) {
                return limit;
            }
            return count;
        }
        return 0L;
    }

    protected void checkIfAddOnFilter(List<QFilter> allFilters, int index, JoinType joinType) {
        HRComplexObjJoinRelation joinRelation;
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList) && index < joinRelationList.size() && (joinRelation = (HRComplexObjJoinRelation)joinRelationList.get(index)) != null) {
            String joinTypeName = joinRelation.getJoinType();
            if (joinType.getName().equals(joinTypeName)) {
                allFilters.addAll(this.algoxParser.getMainOnRelQFilterList(joinRelation.getRelEntityAlias()));
            }
        }
    }

    protected DataSetX createTempMainDataSetX(List<QFilter> onFilters) {
        String mainEntityNumber = this.context.getEntityNumber();
        ArrayList mainQFilterList = Lists.newArrayListWithExpectedSize((int)10);
        mainQFilterList.addAll(this.getMainEntityFilterList());
        if (onFilters != null && !onFilters.isEmpty()) {
            mainQFilterList.addAll(onFilters);
        }
        RowMeta mainRowMeta = this.algoxParser.getMainTempRowMeta();
        DataSetX tempMainDataSetX = this.getSession().fromInput(this.getAlgoXInput(new AlgoXInputParam(mainEntityNumber, mainEntityNumber, mainRowMeta, (List<QFilter>)mainQFilterList, this.partition.getEntityStart(mainEntityNumber), this.partition.getEntityLimit(mainEntityNumber), true)));
        return this.addFieldAliasChangeDataSetX(tempMainDataSetX);
    }

    protected DataSetX createTempRelDataSetX(String relEntityAlias) {
        String relEntityNumber = this.algoxParser.getRelEntityNumber(relEntityAlias);
        List<QFilter> relQFilters = this.getRelJoinAndWhereQFilterList(relEntityAlias);
        RowMeta relTempRowMeta = this.algoxParser.getRelTempRowMeta(relEntityAlias);
        DataSetX tempRelDataSetX = this.getSession().fromInput(this.getAlgoXInput(new AlgoXInputParam(relEntityNumber, relEntityAlias, relTempRowMeta, relQFilters, this.partition.getEntityStart(relEntityAlias), this.partition.getEntityLimit(relEntityAlias), true)));
        return this.addFieldAliasChangeDataSetX(tempRelDataSetX);
    }

    protected String[] mergeFieldNameArray(Field[] mainSelectFields, Boolean isLeft, Field[] ... fieldArrays) {
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet duplicateField = Sets.newHashSetWithExpectedSize((int)16);
        if (mainSelectFields != null && mainSelectFields.length > 0) {
            for (Field mainField : mainSelectFields) {
                String alias = mainField.getAlias();
                if (isLeft == null) {
                    fieldNameSet.add(alias);
                } else if (isLeft.booleanValue()) {
                    fieldNameSet.add("left." + alias);
                } else {
                    fieldNameSet.add("right." + alias);
                }
                duplicateField.add(alias);
            }
        }
        if (fieldArrays != null && fieldArrays.length > 0) {
            Field[] fieldArray = fieldArrays;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field fields;
                for (Field field : fields = fieldArray[i]) {
                    if (duplicateField.contains(field.getAlias())) continue;
                    fieldNameSet.add(field.getAlias());
                }
            }
        }
        return fieldNameSet.toArray(new String[0]);
    }

    protected Input getAlgoXInput(AlgoXInputParam inputParam) {
        RowMeta rowMeta = inputParam.getRowMeta();
        String selectFields = this.algoxParser.getSelectFieldStr(rowMeta);
        return new OrmInput(inputParam.getAlgoXKey(), inputParam.getEntityNumber(), selectFields, inputParam.getFilters().toArray(new QFilter[0]), rowMeta);
    }

    protected List<QFilter> getMainEntityFilterList() {
        List<QFilter> mainEntityFilterList = this.algoxParser.getMainEntityFilterList();
        List<QFilter> entityPagingFilterList = this.algoXPagingOptimizeParser.getEntityPagingFilterList(this.context.getEntityNumber());
        for (QFilter qFilter : entityPagingFilterList) {
            FilterUtils.addFilterAndMerge(mainEntityFilterList, qFilter);
        }
        return mainEntityFilterList;
    }

    @ExcludeFromJacocoGeneratedReport
    protected List<QFilter> getRelWhereQFilterList(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoxParser.getRelWhereQFilterList(relEntityAlias);
        List<QFilter> relEntityPagingFilterList = this.algoXPagingOptimizeParser.getEntityPagingFilterList(relEntityAlias);
        for (QFilter qFilter : relEntityPagingFilterList) {
            FilterUtils.addFilterAndMerge(relQFilterList, qFilter);
        }
        return relQFilterList;
    }

    public List<QFilter> getRelJoinAndWhereQFilterList(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoxParser.getRelJoinAndWhereQFilterList(relEntityAlias);
        List<QFilter> relEntityPagingFilterList = this.algoXPagingOptimizeParser.getEntityPagingFilterList(relEntityAlias);
        for (QFilter qFilter : relEntityPagingFilterList) {
            FilterUtils.addFilterAndMerge(relQFilterList, qFilter);
        }
        return relQFilterList;
    }

    protected DataSet convertSelectField(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        List<String> fieldAliasSelectFieldList = this.algoxParser.getSelectAliasFieldList(dataSet.getRowMeta().getFieldNames(), true);
        return dataSet.map((MapFunction)new SelectFieldMapFunction(rowMeta, fieldAliasSelectFieldList));
    }

    protected DataSetX printDataSetX(DataSetX dataSetX, String tag) {
        DataSet dataSetAll = this.algoxOutputHelper.dataSetOutput(dataSetX);
        DataSet copy = dataSetAll.copy();
        this.printDataSet(copy, tag);
        return this.algoxOutputHelper.getSession().fromInput((Input)new DataSetInput(dataSetAll));
    }

    private void printDataSet(DataSet dataSet, String tag) {
        int index = 0;
        LOGGER.info("print_out_{},head:{}", (Object)tag, (Object)Arrays.toString(dataSet.getRowMeta().getFieldNames()));
        while (dataSet.hasNext()) {
            LOGGER.info("print_out_{},detail:{}", (Object)tag, (Object)dataSet.next().toString());
            ++index;
        }
        LOGGER.info("print_out_{},count:{}", (Object)tag, (Object)index);
    }
}

