/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.algox.AlgoXQueryService;
import kd.hr.hbp.business.service.complexobj.algox.func.algo.ReplaceFieldMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.algo.SelectFieldMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXInputParam;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXPagingOptimizeParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXPagingOrderParser;
import kd.hr.hbp.business.service.complexobj.algox.utils.ComplexObjContextUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.complexobj.paging.AlgoXPagingConstants;
import kd.hr.hbp.common.model.complexobj.paging.Partition;

@ExcludeFromJacocoGeneratedReport
public class DetailAlgoXQueryService
extends AlgoXQueryService
implements AlgoXPagingConstants {
    private static final Log LOGGER = LogFactory.getLog(DetailAlgoXQueryService.class);
    private static final int MAX_PAGING_LIMIT = 100000;
    private static final int MAX_QUERY_TIMES = 5;
    private RowMeta rowMeta;
    private boolean isMoreThanMaxQuery;

    public DetailAlgoXQueryService(HRComplexObjContext context) {
        super(context);
    }

    public DetailAlgoXQueryService(HRComplexObjContext context, AlgoXParser algoxParser, Partition partition) {
        super(context, algoxParser);
        this.partition = partition;
        this.algoXPagingOptimizeParser = new AlgoXPagingOptimizeParser(context, algoxParser, partition);
    }

    @Override
    protected Input getAlgoXInput(AlgoXInputParam inputParam) {
        SortFieldInfo sortField;
        int limit = inputParam.getLimit();
        if (limit < 0) {
            return super.getAlgoXInput(inputParam);
        }
        long startTime = System.currentTimeMillis();
        HRComplexObjContext singleQueryContext = ComplexObjContextUtils.createSingleQueryContext(inputParam.getEntityNumber(), inputParam.getFilters().toArray(new QFilter[0]), inputParam.getRowMeta(), null);
        singleQueryContext.setAlgoXDetailOptimize(false);
        if (inputParam.getEntityAlias().equals(this.partition.getEntityAlias()) && (sortField = this.algoXPagingOptimizeParser.getRealMainEntitySortField(inputParam.getEntityAlias())) != null) {
            singleQueryContext.setSortFieldInfoList((List)Lists.newArrayList((Object[])new SortFieldInfo[]{sortField}));
        }
        ReportQueryService queryService = new ReportQueryService(singleQueryContext);
        DataSet dataSet = queryService.queryDataSet();
        if (!inputParam.isTemp() && inputParam.getEntityAlias().equals(this.partition.getEntityAlias())) {
            if (dataSet.isEmpty()) {
                this.setMainQueryEnd();
            }
            int count = this.getDataSetCount(dataSet);
            LOGGER.info("main_entity_count={}", (Object)count);
            if (inputParam.getLimit() != -1) {
                if (count < inputParam.getLimit() + 1) {
                    this.setMainQueryEnd();
                } else {
                    dataSet = dataSet.top(inputParam.getLimit());
                }
            }
        }
        LOGGER.info("getAlgoXInput_entityAlias={},cost={}", (Object)inputParam.getEntityAlias(), (Object)(System.currentTimeMillis() - startTime));
        return new DataSetInput(this.addAlgoAliasToAlgoXAlias(inputParam.getEntityAlias(), dataSet));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public DataSet query4DataSet(int start, int limit) {
        this.checkPagingParam(start, limit);
        return super.query4DataSet(start, limit);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public DataSet query4DataSet(int start, int limit, boolean mappingField) {
        this.checkPagingParam(start, limit);
        if (this.algoXPagingOptimizeParser.isEmptyPaging()) {
            if (this.rowMeta == null) {
                this.rowMeta = super.query4DataSetX(dataSetX -> dataSetX, false).getRowMeta();
            }
            String algoKey = "kd.hr.hbp.business.service.complexobj.algox.paging_empty_data_set";
            return Algo.create((String)algoKey).createDataSetBuilder(this.rowMeta).build();
        }
        DataSet dataSet = this.pagingGetDataSet(start, limit, 1);
        if (this.isMoreThanMaxQuery) {
            dataSet = super.query4DataSet(start, limit, mappingField);
        }
        if (mappingField) {
            RowMeta rowMeta = dataSet.getRowMeta();
            List<String> fieldAliasSelectFieldList = this.algoxParser.getSelectAliasFieldList(dataSet.getRowMeta().getFieldNames(), true);
            dataSet = dataSet.map((MapFunction)new SelectFieldMapFunction(rowMeta, fieldAliasSelectFieldList));
        }
        return dataSet;
    }

    @Override
    public DataSetX query4DataSetX(int start, int limit) {
        this.checkPagingParam(start, limit);
        DataSet dataSet = this.pagingGetDataSet(start, limit, 1);
        if (this.isMoreThanMaxQuery) {
            dataSet = super.query4DataSet(start, limit, false);
        }
        return this.getSession().fromInput((Input)new DataSetInput(dataSet));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap(int start, int limit) {
        this.checkPagingParam(start, limit);
        DataSet dataSet = this.query4DataSet(start, limit, true);
        ArrayList resultList = Lists.newArrayListWithCapacity((int)10);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            Row rs = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int index = 0; index < fieldNames.length; ++index) {
                resultMap.put(fieldNames[index], rs.get(index));
            }
            resultList.add(resultMap);
        }
        return resultList;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public long queryDataCount(int start, int limit) {
        if (start >= 0 && limit >= 0) {
            DataSet dataSet = this.query4DataSet(start, limit, true);
            int count = 0;
            for (Row row : dataSet) {
                ++count;
            }
            dataSet.close();
            return count;
        }
        return super.queryDataCount(start, limit);
    }

    private DataSet pagingGetDataSet(int start, int limit, int deepCount) {
        if (start < 0 && limit < 0) {
            return super.query4DataSet(start, limit, false);
        }
        if (!this.algoXPagingOptimizeParser.isCanPagingOptimize()) {
            return super.query4DataSet(start, limit, false);
        }
        long startTime = System.currentTimeMillis();
        ArrayList hitPartitions = Lists.newArrayListWithExpectedSize((int)10);
        int queryLimit = this.algoxParser.isAllOptimizeMainQFilter() ? limit : 2000;
        LOGGER.info("pagingGetDataSet_start={},queryLimit={}", (Object)start, (Object)queryLimit);
        int startDataCount = this.putHitPartitionAndGetStartDataCount(hitPartitions, start, queryLimit);
        List<Partition> mergeHitPartitions = this.mergeHitPartitions(hitPartitions);
        LOGGER.info("pagingGetDataSet_mergeHitPartitions={}", mergeHitPartitions);
        DataSet resultDataSet = this.getHitPartitionsDataSet(mergeHitPartitions);
        if (resultDataSet == null) {
            String algoKey = "kd.hr.hbp.business.service.complexobj.algox.DetailAlgoXQueryService_empty_data_set";
            return Algo.create((String)algoKey).createDataSetBuilder(super.query4DataSetX(dataSetX -> dataSetX, false).getRowMeta()).build();
        }
        int partitionDataCount = this.getPartitionDataCount(mergeHitPartitions);
        if (this.context.isOrderPartitionQuery()) {
            this.context.addOrderPartitions((List)hitPartitions);
        } else {
            this.context.addPartitions((List)hitPartitions);
        }
        int totalIndex = partitionDataCount + startDataCount;
        int end = start + limit;
        if (start > totalIndex) {
            if (this.needQueryNextPartition(totalIndex, end, hitPartitions)) {
                if (deepCount >= 5) {
                    this.isMoreThanMaxQuery = true;
                    return resultDataSet;
                }
                DataSet continueDataSet = this.pagingGetDataSet(start, limit, deepCount + 1);
                if (continueDataSet != null) {
                    resultDataSet.close();
                    resultDataSet = continueDataSet;
                }
            }
        } else {
            int pageStart = partitionDataCount - (totalIndex - start);
            int dataLimit = Math.min(partitionDataCount - pageStart, limit);
            if (!resultDataSet.isEmpty()) {
                int orderIndex;
                if ((this.context.getSortFieldInfoList() == null || this.context.getSortFieldInfoList().isEmpty()) && (orderIndex = resultDataSet.getRowMeta().getFieldIndex("rptdbsortidx", false)) >= 0) {
                    resultDataSet = resultDataSet.orderBy(new String[]{"rptdbsortidx"});
                }
                resultDataSet = resultDataSet.range(pageStart, dataLimit);
            }
            if (this.needQueryNextPartition(totalIndex, end, hitPartitions)) {
                if (deepCount >= 5) {
                    this.isMoreThanMaxQuery = true;
                    return resultDataSet;
                }
                DataSet continueDataSet = this.pagingGetDataSet(totalIndex, limit - (partitionDataCount - pageStart), deepCount + 1);
                if (continueDataSet != null) {
                    LOGGER.info("pagingGetDataSet_continueDataSet_totalIndex={}_limit={}_dataSetFields={}", new Object[]{totalIndex, limit - (partitionDataCount - pageStart), Arrays.toString(continueDataSet.getRowMeta().getFieldNames())});
                    if (!continueDataSet.isEmpty()) {
                        resultDataSet = resultDataSet.union(continueDataSet);
                    }
                }
            }
        }
        LOGGER.info("pagingGetDataSet_costTime_start={}_limit={}_hitPartitions={},cost={}", new Object[]{start, queryLimit, String.valueOf(mergeHitPartitions), System.currentTimeMillis() - startTime});
        return resultDataSet;
    }

    private DataSet getHitPartitionsDataSet(List<Partition> mergeHitPartitions) {
        DataSet resultDataSet = null;
        LOGGER.info("pagingGetDataSet_mergeHitPartitions={}", mergeHitPartitions);
        for (Partition partition : mergeHitPartitions) {
            DetailAlgoXQueryService queryService = new DetailAlgoXQueryService(this.context, this.algoxParser, partition);
            this.algoxParser.setStart(0);
            this.algoxParser.setLimit(100000);
            DataSet dataSet = queryService.query4DataSet(-1, -1, false);
            if (this.rowMeta == null) {
                this.rowMeta = dataSet.getRowMeta();
            }
            if (partition.getDataCount() == null) {
                int count = 0;
                DataSet copy = dataSet.copy();
                for (Row row : copy) {
                    ++count;
                }
                copy.close();
                LOGGER.info("pagingGetDataSet_partition={},count={}", (Object)partition.getUniqueKey(), (Object)count);
                partition.setDataCount(Integer.valueOf(count));
            }
            if (resultDataSet == null) {
                resultDataSet = dataSet;
                continue;
            }
            if (dataSet.isEmpty()) continue;
            resultDataSet = resultDataSet.union(dataSet);
        }
        return resultDataSet;
    }

    @ExcludeFromJacocoGeneratedReport
    private List<Partition> mergeHitPartitions(List<Partition> hitPartitions) {
        ArrayList runHitPartitions = Lists.newArrayListWithExpectedSize((int)hitPartitions.size());
        if (hitPartitions.size() > 1) {
            ArrayList temp = Lists.newArrayListWithExpectedSize((int)hitPartitions.size());
            int tempDataCount = 0;
            for (Partition hitPartition : hitPartitions) {
                Partition tempAllPartition;
                Integer dataCount = hitPartition.getDataCount();
                if (dataCount != null) {
                    if ((tempDataCount += dataCount.intValue()) > 2000) {
                        temp.add(hitPartition);
                        tempAllPartition = this.mergeTempPartitions(temp);
                        runHitPartitions.add(tempAllPartition);
                        tempDataCount = 0;
                        temp = Lists.newArrayListWithExpectedSize((int)hitPartitions.size());
                        continue;
                    }
                    temp.add(hitPartition);
                    continue;
                }
                if (!temp.isEmpty()) {
                    tempAllPartition = this.mergeTempPartitions(temp);
                    runHitPartitions.add(tempAllPartition);
                    tempDataCount = 0;
                    temp = Lists.newArrayListWithExpectedSize((int)hitPartitions.size());
                }
                runHitPartitions.add(hitPartition);
            }
            if (!temp.isEmpty()) {
                Partition tempAllPartition = this.mergeTempPartitions(temp);
                runHitPartitions.add(tempAllPartition);
            }
        } else {
            runHitPartitions.addAll(hitPartitions);
        }
        return runHitPartitions;
    }

    @ExcludeFromJacocoGeneratedReport
    private Partition mergeTempPartitions(List<Partition> temp) {
        Integer tempStart = null;
        Partition tempAllPartition = new Partition();
        tempAllPartition.setDataCount(Integer.valueOf(0));
        tempAllPartition.setMainLimit(0);
        for (Partition tempPartition : temp) {
            if (tempStart == null) {
                tempStart = tempPartition.getMainEntityStart();
            }
            tempAllPartition.setDataCount(Integer.valueOf(tempAllPartition.getDataCount() + tempPartition.getDataCount()));
            tempAllPartition.setMainLimit(tempAllPartition.getMainLimit() + tempPartition.getMainLimit());
            tempAllPartition.setEntityNumber(tempPartition.getEntityNumber());
            tempAllPartition.setEntityAlias(tempPartition.getEntityAlias());
            if (!tempPartition.isMainEnd()) continue;
            tempAllPartition.setMainEnd(true);
        }
        if (tempStart != null) {
            tempAllPartition.setMainEntityStart(tempStart.intValue());
        } else {
            tempAllPartition.setMainEntityStart(0);
        }
        return tempAllPartition;
    }

    private int putHitPartitionAndGetStartDataCount(List<Partition> hitPartitions, int start, int limit) {
        Partition lastPartition;
        List partitions;
        List list = partitions = this.context.isOrderPartitionQuery() ? this.context.getOrderPartitions() : this.context.getPartitions();
        if (partitions.isEmpty()) {
            hitPartitions.add(new Partition(this.algoxParser.getRealMainEntityNumber(), this.algoxParser.getRealMainEntityAlias(), 0, limit));
            return 0;
        }
        int startCount = 0;
        int dataTotalCount = 0;
        int end = start + limit;
        for (Partition partition : partitions) {
            Integer count = partition.getDataCount();
            if (count == null) {
                hitPartitions.add(partition);
                break;
            }
            if (count == 0) continue;
            if (start < (dataTotalCount += count.intValue())) {
                hitPartitions.add(partition);
            } else {
                startCount += count.intValue();
            }
            if (end >= dataTotalCount) continue;
            break;
        }
        if (end > dataTotalCount && (lastPartition = !hitPartitions.isEmpty() ? hitPartitions.get(hitPartitions.size() - 1) : (Partition)partitions.get(partitions.size() - 1)).getDataCount() != null && !lastPartition.isMainEnd()) {
            hitPartitions.add(lastPartition.createNextPartition(limit));
        }
        return startCount;
    }

    public int getPartitionDataCount(List<Partition> partitions) {
        int count = 0;
        for (Partition partition : partitions) {
            Integer dataCount = partition.getDataCount();
            if (dataCount == null) {
                return count;
            }
            count += dataCount.intValue();
        }
        return count;
    }

    protected DataSet addAlgoAliasToAlgoXAlias(String entityAlias, DataSet dataSet) {
        String fieldNamePrefix = "";
        if (!this.context.getEntityNumber().equals(entityAlias)) {
            fieldNamePrefix = entityAlias + ".";
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        HashMap inverse = Maps.newHashMapWithExpectedSize((int)16);
        for (Field field : fields) {
            inverse.put(field.getAlias(), AlgoXFieldInfo.replaceAlgoxAlias(fieldNamePrefix + field.getAlias()));
        }
        return dataSet.map((MapFunction)new ReplaceFieldMapFunction(inverse, rowMeta));
    }

    protected boolean needQueryNextPartition(int totalIndex, int end, List<Partition> hitPartitions) {
        return totalIndex < end && !hitPartitions.get(hitPartitions.size() - 1).isMainEnd();
    }

    private void setMainQueryEnd() {
        AlgoXPagingOrderParser algoXPagingOrderParser = this.algoXPagingOptimizeParser.getAlgoXPagingOrderParser();
        if (algoXPagingOrderParser != null) {
            List<Object> ids = algoXPagingOrderParser.getIds(this.partition.getMainEntityStart(), this.partition.getMainLimit());
            if (ids == null || ids.isEmpty() || ids.size() < this.partition.getMainLimit()) {
                this.partition.setMainEnd(true);
            }
        } else {
            this.partition.setMainEnd(true);
        }
    }

    private int getDataSetCount(DataSet dataSet) {
        DataSet copy = dataSet.copy();
        int count = 0;
        for (Row row : copy) {
            ++count;
        }
        return count;
    }
}

