/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.MapFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.AlgoXQueryService;
import kd.hr.hbp.business.service.complexobj.algox.func.DimCalculateMapFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.DimDistinctReduceFunction;
import kd.hr.hbp.business.service.complexobj.algox.func.DimPagingFilterMap;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.plugin.QueryPluginFieldService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.model.report.DateTransUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DimensionAlgoXQueryService
extends AlgoXQueryService {
    private static final Log LOGGER = LogFactory.getLog(DimensionAlgoXQueryService.class);

    public DimensionAlgoXQueryService(HRComplexObjContext context) {
        super(context);
    }

    @Override
    public DataSetX query4DataSetX(int start, int limit) {
        this.checkPagingParam(start, limit);
        return super.query4DataSetX(dataSetX -> dataSetX, false);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public DataSet query4DataSet(int start, int limit) {
        this.checkPagingParam(start, limit);
        DataSetX dataSetX = this.query4DataSetX(start, limit);
        return this.query4DataSet(dataSetX, -1, -1, true);
    }

    @Override
    public DataSet query4DataSet(int start, int limit, boolean mappingField) {
        this.checkPagingParam(start, limit);
        DataSetX dataSetX = this.query4DataSetX(start, limit);
        return this.query4DataSet(dataSetX, -1, -1, mappingField);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<Map<String, Object>> query4ListMap(int start, int limit) {
        this.checkPagingParam(start, limit);
        return this.getDataSetMaps(this.query4DataSet(start, limit));
    }

    public DataSet query4DimDataSet(boolean mappingField) {
        if (this.isOnlyDataSplitDimQuery()) {
            LOGGER.info("query4DimDataSet_OnlyDataSplitDimQuery");
            return this.getDateSpiltDimQuery(mappingField);
        }
        LOGGER.info("query4DimDataSet_notOnlyDataSplitDimQuery");
        DataSetX dimDataSetX = this.query4DimDataSetX(false);
        return this.query4DataSet(dimDataSetX, -1, -1, mappingField);
    }

    @Override
    protected DataSetX addTopDataSetX(DataSetX mainDataSetX) {
        int start = this.algoxParser.getStart();
        int limit = this.algoxParser.getLimit();
        if (start >= 0 && limit >= 0) {
            mainDataSetX.setSingleParallel(true);
            List<String> dimDistinctAlgoXAliasArr = this.algoxParser.getDimDistinctAlgoXAliasArr();
            LOGGER.info("addTopDataSetX_getDimDistinctAlgoXAliasArr_size_{}", (Object)dimDistinctAlgoXAliasArr.size());
            LOGGER.info("addTopDataSetX_getDimDistinctAlgoXAliasArr_{}", dimDistinctAlgoXAliasArr);
            mainDataSetX = mainDataSetX.filter((FilterFunction)new DimPagingFilterMap(start, limit, dimDistinctAlgoXAliasArr, mainDataSetX.getRowMeta()));
            mainDataSetX.setSingleParallel(false);
        }
        return mainDataSetX;
    }

    protected DataSetX addDimDistinct(DataSetX mainDataSetX) {
        List<String> distinctFieldList = this.algoxParser.getDimDistinctAlgoXAliasArr();
        LOGGER.info("addDimDistinct_field_count_{}", (Object)distinctFieldList.size());
        LOGGER.info("addDimDistinct_field_{}", (Object)String.valueOf(distinctFieldList));
        mainDataSetX = mainDataSetX.groupBy(distinctFieldList.toArray(new String[0])).reduceGroup((GroupReduceFunction)new DimDistinctReduceFunction(mainDataSetX.getRowMeta(), this.getOrderFields()));
        return mainDataSetX;
    }

    private DataSetX createDimRelationDataSetX() {
        DataSetX dimMainDataSetX = this.createDimMainDataSetX();
        List<HRComplexObjJoinRelation> hasDimFieldRelEntityAliasList = this.algoxParser.getHasDimFieldRelEntityAliasList();
        if (!CollectionUtils.isEmpty(hasDimFieldRelEntityAliasList)) {
            for (HRComplexObjJoinRelation joinRelation : hasDimFieldRelEntityAliasList) {
                dimMainDataSetX = this.createJoinDimDataSetX(dimMainDataSetX, joinRelation);
            }
        }
        return dimMainDataSetX;
    }

    private DataSetX createDimMainDataSetX() {
        String mainEntityNumber = this.context.getEntityNumber();
        RowMeta mainDimRowMeta = this.algoxParser.getMainDimRowMeta();
        String mainSelectFieldStr = this.algoxParser.getSelectFieldStr(mainDimRowMeta);
        List<QFilter> mainQFilterList = this.algoxParser.getMainEntityFilterList();
        this.checkIfAddOnFilter(mainQFilterList, 0, JoinType.RIGHT);
        DataSetX dimMainDataSetX = this.getSession().fromInput((Input)new OrmInput("HR_REPORT" + mainEntityNumber, mainEntityNumber, mainSelectFieldStr, mainQFilterList.toArray(new QFilter[0]), mainDimRowMeta));
        LOGGER.info("createDimMainDataSetX_entityNumber_{},qFilter_{}", (Object)mainEntityNumber, mainQFilterList);
        return this.addDimFieldAliasChangeDataSetX(dimMainDataSetX);
    }

    private DataSetX createJoinDimDataSetX(DataSetX mainDataSetX, HRComplexObjJoinRelation joinRelation) {
        String relEntityAlias = joinRelation.getRelEntityAlias();
        RowMeta relDimRowMeta = this.algoxParser.getRelDimRowMeta(relEntityAlias);
        return this.createJoinDataSetX(mainDataSetX, joinRelation, relDimRowMeta);
    }

    private DataSetX addDimCalculateField(DataSetX mainDataSetX) {
        List<Field> calculateFieldList = this.algoxParser.getDimCalculateFieldList();
        if (!calculateFieldList.isEmpty()) {
            mainDataSetX = mainDataSetX.addFields(calculateFieldList.toArray(new Field[0]), new Object[calculateFieldList.size()]);
            mainDataSetX = mainDataSetX.map((MapFunction)new DimCalculateMapFunction(mainDataSetX.getRowMeta(), this.algoxParser, this.context));
        }
        return mainDataSetX;
    }

    private DataSetX addDimPluginField(DataSetX mainDataSetX) {
        List<AlgoXFieldInfo> dimPluginFieldInfoList = this.algoxParser.getDimPluginFieldInfoList();
        for (AlgoXFieldInfo pluginFieldInfo : dimPluginFieldInfoList) {
            mainDataSetX = mainDataSetX.map((MapFunction)QueryPluginFieldService.getPluginFieldAlgoXFunction(this.context, mainDataSetX.getRowMeta(), pluginFieldInfo.getFieldInfo()));
        }
        return mainDataSetX;
    }

    protected DataSetX addDimFieldAliasChangeDataSetX(DataSetX mainDataSetX) {
        Field[] fields;
        RowMeta rowMeta = mainDataSetX.getRowMeta();
        for (Field field : fields = rowMeta.getFields()) {
            field.setName(field.getAlias());
        }
        return mainDataSetX;
    }

    protected DataSetX addDimTopDataSetX(DataSetX mainDataSetX) {
        int start = this.algoxParser.getStart();
        int limit = this.algoxParser.getLimit();
        if (start >= 0 && limit >= 0) {
            mainDataSetX = mainDataSetX.top(start + limit);
        }
        this.algoxParser.setStart(-1);
        this.algoxParser.setLimit(-1);
        return mainDataSetX;
    }

    @ExcludeFromJacocoGeneratedReport
    private DataSetX addDimOrderBy(DataSetX mainDataSetX) {
        Object[] orderByArr = this.algoxParser.getDimOrderByStrArr();
        if (this.context.isOrder() && orderByArr != null && orderByArr.length > 0) {
            mainDataSetX = this.addCustomOrderBy(mainDataSetX);
            LOGGER.info("order_by_{}", (Object)Arrays.toString(orderByArr));
            mainDataSetX = mainDataSetX.orderBy((String[])orderByArr);
        }
        return mainDataSetX;
    }

    @Override
    public long queryDataCount(int start, int limit) {
        DataSetX mainDataSetX = this.query4DimDataSetX(true);
        return this.getCount(mainDataSetX, start, limit);
    }

    protected DataSetX query4DimDataSetX(boolean isCount) {
        DataSetX dimMainDataSetX = this.createDimRelationDataSetX();
        dimMainDataSetX = this.addFieldTransferDataSetX(dimMainDataSetX);
        dimMainDataSetX = this.addDimCalculateField(dimMainDataSetX);
        dimMainDataSetX = this.addDimPluginField(dimMainDataSetX);
        dimMainDataSetX = this.addWhereFilter(dimMainDataSetX);
        dimMainDataSetX = this.addTransferDataSetX(dimMainDataSetX);
        dimMainDataSetX = this.addDimDistinct(dimMainDataSetX);
        if (isCount) {
            String primaryAlias = this.algoxParser.getPrimaryAlias(this.context.getEntityNumber());
            int index = dimMainDataSetX.getRowMeta().getFieldIndex(primaryAlias, false);
            if (index == -1) {
                dimMainDataSetX = dimMainDataSetX.addFields(new Field[]{new Field(primaryAlias, (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ONE});
            }
        } else {
            dimMainDataSetX = this.addDimOrderBy(dimMainDataSetX);
        }
        dimMainDataSetX = this.addDimTopDataSetX(dimMainDataSetX);
        return dimMainDataSetX;
    }

    protected boolean isOnlyDataSplitDimQuery() {
        String type = this.getOnlyDateSplitDimType();
        if (HRStringUtils.isEmpty((String)type)) {
            return false;
        }
        return DateTransUtils.QUICK_SHOW_ALL_VALUE_SPLIT_TYPE.contains(type);
    }

    protected String getOnlyDateSplitDimType() {
        List groupFieldList = this.context.getGroupFieldList();
        List sortFieldInfoList = this.context.getSortFieldInfoList();
        if (groupFieldList != null && groupFieldList.size() == 1 && (sortFieldInfoList == null || sortFieldInfoList.size() == 1)) {
            SortFieldInfo sortFieldInfo;
            HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)groupFieldList.get(0);
            String alias = fieldInfo.getAlias();
            if (sortFieldInfoList != null && !(sortFieldInfo = (SortFieldInfo)sortFieldInfoList.get(0)).getFieldAlias().equals(alias)) {
                return null;
            }
            if (alias.contains("!")) {
                String[] split = alias.split("!");
                return split[1];
            }
        }
        return null;
    }

    protected DataSet getDateSpiltDimQuery(boolean mappingField) {
        String splitDimType = this.getOnlyDateSplitDimType();
        List allDate = DateTransUtils.getAllDate((String)splitDimType);
        List groupFieldList = this.context.getGroupFieldList();
        HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)groupFieldList.get(0);
        String alias = fieldInfo.getAlias();
        if (!mappingField) {
            alias = AlgoXFieldInfo.replaceAlgoxAlias(alias);
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field(alias, (DataType)DateType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)"DateSpiltDimQuery").createDataSetBuilder(rowMeta);
        for (String date : allDate) {
            dataSetBuilder.append(new Object[]{date});
        }
        return dataSetBuilder.build();
    }
}

