/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.QueryEntityUtil;
import kd.hr.hbp.common.util.ReportTimeZoneUtil;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class AlgoXFieldTransferMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5818491646587609431L;
    private RowMeta rowMeta;
    private RowMeta newRowMeta;
    private Map<String, Integer> fieldAliasIndexMap;
    private Map<String, DynamicProperty> transferFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private final HRComplexObjContext complexObjCont;
    private Set<String> notTransFields = Sets.newHashSetWithExpectedSize((int)16);

    public AlgoXFieldTransferMapFunction(RowMeta rowMeta, HRComplexObjContext complexObjCont, AlgoXParser algoxParser) {
        this.rowMeta = rowMeta;
        this.complexObjCont = complexObjCont;
        this.initTransferFieldMap(rowMeta, complexObjCont, algoxParser);
        this.newRowMeta = this.buildNewRowMeta(rowMeta, this.transferFieldMap);
        Field[] fields = this.newRowMeta.getFields();
        this.fieldAliasIndexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            this.fieldAliasIndexMap.put(fields[index].getAlias(), index);
        }
    }

    public RowX map(RowX rowX) {
        RowX result = new RowX(this.newRowMeta.getFieldCount());
        for (int index = 0; index < this.rowMeta.getFieldCount(); ++index) {
            Field field = this.rowMeta.getField(index);
            String fieldEntityAlias = field.getAlias();
            Object originalValue = rowX.get(index);
            int newFieldIndex = this.fieldAliasIndexMap.get(fieldEntityAlias);
            DynamicProperty property = this.transferFieldMap.get(fieldEntityAlias);
            if (field.getDataType().equals((Object)DataType.TimestampType)) {
                if (property == null) {
                    property = new DateProp();
                }
            } else if (field.getDataType().equals((Object)DataType.BooleanType)) {
                property = new BooleanProp();
            }
            if (originalValue != null && property != null && !this.notTransFields.contains(fieldEntityAlias)) {
                TimeZone dateTimeFieldTimeZone = ReportTimeZoneUtil.transferDateTimeFieldTimeZone((List)this.complexObjCont.getComplexObjFieldInfoList(), (String)field.getAlias());
                Object value = QueryEntityUtil.getEntityProp((Object)property, (Object)originalValue, (TimeZone)dateTimeFieldTimeZone, (HRComplexObjContext)this.complexObjCont);
                result.set(newFieldIndex, value);
                int originalFieldIndex = this.fieldAliasIndexMap.get("ORIGINAL_ENUM_VALUE_" + fieldEntityAlias);
                result.set(originalFieldIndex, originalValue);
                continue;
            }
            result.set(newFieldIndex, originalValue);
        }
        return result;
    }

    private void initTransferFieldMap(RowMeta oldRowMeta, HRComplexObjContext complexObjCont, AlgoXParser algoxParser) {
        Map<String, String> relEntityMap = complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber, (key1, key2) -> key2));
        String entityNumber = complexObjCont.getEntityNumber();
        EntityPropParseUtil propParseUtil = new EntityPropParseUtil();
        for (Field field : oldRowMeta.getFields()) {
            Object property;
            String fieldEntityAlias = field.getAlias();
            AlgoXFieldInfo algoXFieldInfo = algoxParser.getAlgoXFieldInfoByAlgoXAlias(fieldEntityAlias);
            if (algoXFieldInfo == null) continue;
            HRComplexObjFieldInfo fieldInfo = algoXFieldInfo.getFieldInfo();
            if ("1".equals(fieldInfo.getFieldType())) {
                property = propParseUtil.convertFullFieldName(entityNumber, algoXFieldInfo.getFullPath());
                if (property == null) {
                    String value;
                    Iterator<String> iterator = relEntityMap.values().iterator();
                    while (iterator.hasNext() && (property = propParseUtil.convertFullFieldName(value = iterator.next(), algoXFieldInfo.getFullPath())) == null) {
                    }
                }
            } else {
                DataTypeEnum dataType = fieldInfo.getDataType();
                property = DataTypeEnum.BOOLEAN == dataType ? new BooleanProp() : (DataTypeEnum.DATETIME == dataType ? new DateProp() : null);
            }
            if (property != null && QueryEntityUtil.checkEntityEnumProp((Object)property)) {
                this.transferFieldMap.put(fieldEntityAlias, (DynamicProperty)property);
            }
            if (fieldInfo.isTransfer()) continue;
            this.notTransFields.add(fieldEntityAlias);
        }
    }

    private RowMeta buildNewRowMeta(RowMeta oldRowMeta, Map<String, DynamicProperty> transferFieldMap) {
        Field[] originalFields = oldRowMeta.getFields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)(originalFields.length + transferFieldMap.size()));
        for (Field originalField : originalFields) {
            DynamicProperty property = transferFieldMap.get(originalField.getAlias());
            DataType originalDataType = originalField.getDataType();
            if (originalDataType.equals((Object)DataType.TimestampType) || originalDataType.equals((Object)DataType.BooleanType)) {
                property = new BooleanProp();
            }
            if (property != null && !this.notTransFields.contains(originalField.getAlias())) {
                fields.add(new Field("ORIGINAL_ENUM_VALUE_" + originalField.getAlias(), originalDataType));
                if (property instanceof BooleanProp || property instanceof DateTimeProp) {
                    fields.add(new Field(originalField.getName(), originalField.getAlias(), (DataType)DataType.StringType, false));
                    continue;
                }
                fields.add(originalField);
                continue;
            }
            fields.add(originalField);
        }
        return new RowMeta(fields.toArray(new Field[0]));
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

