/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.hr.hbp.business.service.complexobj.RptLRUCache;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.business.service.complexobj.util.ReportFunctionExecuteByCache;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class CalculateMapFunction
extends MapFunction {
    private static final long serialVersionUID = -3149802223036010412L;
    protected RowMeta rowMeta;
    protected AlgoXParser algoxParser;
    protected Map<String, List<AlgoXFieldInfo>> calFieldRefFieldAliasMap;
    protected Map<String, DynamicProperty> enumFieldMap;
    private RptLRUCache<String, Object> lruCache = new RptLRUCache(1000);
    private ReportFunctionExecuteByCache reportFunctionExecuteByCache;
    private HRComplexObjContext complexObjCont;

    public CalculateMapFunction(RowMeta rowMeta, AlgoXParser algoxParser, HRComplexObjContext complexObjCont) {
        this.rowMeta = rowMeta;
        this.algoxParser = algoxParser;
        this.calFieldRefFieldAliasMap = this.initRefMap();
        this.enumFieldMap = this.initConvertFullField(complexObjCont);
        this.complexObjCont = complexObjCont;
        this.reportFunctionExecuteByCache = new ReportFunctionExecuteByCache(complexObjCont, complexObjCont.getComplexObjFieldInfoList());
    }

    private Map<String, DynamicProperty> initConvertFullField(HRComplexObjContext complexObjCont) {
        HashMap enumFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        String mainEntityNumber = complexObjCont.getEntityNumber();
        Map<String, String> relEntityMap = complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityNumber, HRComplexObjJoinRelation::getRelEntityAlias, (key1, key2) -> key2));
        Map<String, AlgoXFieldInfo> calculateFieldInfoMap = this.getCalculateFieldInfoMap();
        for (Map.Entry<String, AlgoXFieldInfo> calculateFieldInfoEntry : calculateFieldInfoMap.entrySet()) {
            List<AlgoXFieldInfo> algoXFieldInfoList = this.calFieldRefFieldAliasMap.get(calculateFieldInfoEntry.getKey());
            for (AlgoXFieldInfo fieldInfo : algoXFieldInfoList) {
                DynamicProperty property = new EntityPropParseUtil().getDynamicProperty(mainEntityNumber, relEntityMap, fieldInfo.getFullPath());
                if (property == null || !QueryEntityUtil.checkEntityEnumProp((Object)property)) continue;
                enumFieldMap.put(fieldInfo.getAlias(), property);
            }
        }
        return enumFieldMap;
    }

    public RowX map(RowX row) {
        Map<String, AlgoXFieldInfo> calculateFieldInfoMap = this.getCalculateFieldInfoMap();
        for (Map.Entry<String, AlgoXFieldInfo> calculateFieldInfoEntry : calculateFieldInfoMap.entrySet()) {
            List<AlgoXFieldInfo> algoXFieldInfoList = this.calFieldRefFieldAliasMap.get(calculateFieldInfoEntry.getKey());
            AlgoXFieldInfo calculateFieldInfo = calculateFieldInfoEntry.getValue();
            HRComplexObjFieldInfo complexObjFieldInfo = calculateFieldInfo.getFieldInfo();
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)algoXFieldInfoList.size());
            for (AlgoXFieldInfo fieldInfo : algoXFieldInfoList) {
                int fieldIndex = this.rowMeta.getFieldIndex(fieldInfo.getAlgoXAlias());
                String alias = fieldInfo.getAlias();
                if ("4".equals(fieldInfo.getFieldInfo().getFieldType())) {
                    alias = alias.replaceFirst("PLUGIN_FIELD_ALIAS_PREFIX_", "");
                }
                paramMap.put(alias, row.get(fieldIndex));
            }
            Object val = this.reportFunctionExecuteByCache.getFormulaVal(this.lruCache, complexObjFieldInfo.getFullPath(), paramMap);
            int fieldIndex = this.rowMeta.getFieldIndex(calculateFieldInfo.getAlgoXAlias());
            DataType dataType = this.rowMeta.getDataType(fieldIndex);
            val = this.dataTypeCompatible(dataType, val);
            row.set(fieldIndex, this.checkTypeAndReplaceData(val));
        }
        return row;
    }

    @ExcludeFromJacocoGeneratedReport
    private Object checkTypeAndReplaceData(Object val) {
        if (val instanceof StringBuilder) {
            return ((StringBuilder)val).toString();
        }
        return val;
    }

    protected Map<String, AlgoXFieldInfo> getCalculateFieldInfoMap() {
        return this.algoxParser.getCalculateFieldInfoMap();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Map<String, List<AlgoXFieldInfo>> initRefMap() {
        Map<String, AlgoXFieldInfo> calculateFieldInfoMap = this.getCalculateFieldInfoMap();
        HashMap refFieldMap = Maps.newHashMapWithExpectedSize((int)calculateFieldInfoMap.size());
        for (Map.Entry<String, AlgoXFieldInfo> calculateFieldInfoEntry : calculateFieldInfoMap.entrySet()) {
            AlgoXFieldInfo calculateFieldInfo = calculateFieldInfoEntry.getValue();
            HRComplexObjFieldInfo complexObjFieldInfo = calculateFieldInfo.getFieldInfo();
            Set refFieldAliasSet = complexObjFieldInfo.getRefFieldAliasSet();
            List<AlgoXFieldInfo> algoXFieldInfoList = this.algoxParser.getAlgoXFieldInfoListWithCalculate(refFieldAliasSet);
            refFieldMap.put(calculateFieldInfoEntry.getKey(), algoXFieldInfoList);
        }
        return refFieldMap;
    }

    private Object dataTypeCompatible(DataType dataType, Object oldValue) {
        Object returnValue = oldValue;
        if (DataType.LongType.equals((Object)dataType)) {
            if (oldValue instanceof Integer || oldValue instanceof BigDecimal || oldValue instanceof Double || oldValue instanceof Float) {
                BigDecimal temp = new BigDecimal(String.valueOf(oldValue));
                returnValue = temp.longValue();
            }
        } else if (DataType.BigDecimalType.equals((Object)dataType)) {
            if (oldValue instanceof Integer || oldValue instanceof Long || oldValue instanceof Double || oldValue instanceof Float) {
                returnValue = new BigDecimal(String.valueOf(oldValue));
            }
        } else if (DataType.IntegerType.equals((Object)dataType) && (oldValue instanceof Long || oldValue instanceof BigDecimal || oldValue instanceof Double || oldValue instanceof Float)) {
            BigDecimal temp = new BigDecimal(String.valueOf(oldValue));
            returnValue = temp.intValue();
        }
        returnValue = QueryEntityUtil.convertDataValueType((DataTypeEnum)AlgoDataTypeTransUtil.getDataTypeEnum(dataType), (Object)returnValue, null, (HRComplexObjContext)this.complexObjCont);
        return returnValue;
    }
}

