/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class CustomOrderMapFunction
extends MapFunction {
    private static final long serialVersionUID = 3786796908622208071L;
    private final String orderFieldAlias;
    private final Map<String, Integer> customOrderValueMap;
    private final RowMeta oldRowMeta;
    private final RowMeta newRowMeta;

    public CustomOrderMapFunction(RowMeta rowMeta, String orderFieldAlias, String newOrderFieldAlias, Map<String, Integer> customOrderValueMap) {
        this.oldRowMeta = rowMeta;
        this.orderFieldAlias = orderFieldAlias;
        this.customOrderValueMap = customOrderValueMap;
        this.newRowMeta = this.initRowMeta(newOrderFieldAlias, rowMeta);
    }

    public RowX map(RowX rowX) {
        int fieldCount = this.oldRowMeta.getFieldCount();
        if (fieldCount == this.newRowMeta.getFieldCount()) {
            return rowX;
        }
        RowX result = new RowX(fieldCount + 1);
        for (int index = 0; index < fieldCount; ++index) {
            Field field = this.oldRowMeta.getField(index);
            Object value = rowX.get(index);
            result.set(index, value);
            if (!this.orderFieldAlias.equals(field.getAlias())) continue;
            if (this.customOrderValueMap != null) {
                Integer order = this.customOrderValueMap.get(String.valueOf(value));
                if (order == null) {
                    order = Integer.MAX_VALUE;
                }
                result.set(fieldCount, (Object)order);
                continue;
            }
            result.set(fieldCount, (Object)0);
        }
        return result;
    }

    private RowMeta initRowMeta(String newOrderFieldAlias, RowMeta oldRowMeta) {
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)(oldRowMeta.getFieldCount() + 1));
        HashSet fieldAliasSet = Sets.newHashSetWithExpectedSize((int)oldRowMeta.getFieldCount());
        for (Field field : oldRowMeta.getFields()) {
            fieldAliasSet.add(field.getAlias());
            fieldList.add(field);
        }
        if (!fieldAliasSet.contains(newOrderFieldAlias)) {
            fieldList.add(new Field(newOrderFieldAlias, (DataType)DataType.IntegerType));
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

