/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.util.ObjectComparable;

public class DimDistinctReduceFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1527380811486028022L;
    private final RowMeta rowMeta;
    private final Map<String, Integer> fieldIndexMap;
    private final Map<String, OrderField> orderFieldMap;

    public DimDistinctReduceFunction(RowMeta rowMeta, List<OrderField> orderFields) {
        this.rowMeta = rowMeta;
        String[] fieldNames = this.rowMeta.getFieldNames();
        this.fieldIndexMap = Maps.newHashMapWithExpectedSize((int)fieldNames.length);
        for (int index = 0; index < fieldNames.length; ++index) {
            this.fieldIndexMap.put(fieldNames[index], index);
        }
        this.orderFieldMap = orderFields == null ? null : orderFields.stream().collect(Collectors.toMap(orderField -> AlgoXFieldInfo.replaceAlgoxAlias(orderField.getAlias()), orderField -> orderField, (x, y) -> x));
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        String[] fieldNames = this.rowMeta.getFieldNames();
        RowX resultRowX = new RowX(fieldNames.length);
        for (RowX rowX : iterable) {
            for (String alias : fieldNames) {
                Integer index = this.fieldIndexMap.get(alias);
                if (this.orderFieldMap != null) {
                    OrderField orderField = this.orderFieldMap.get(alias);
                    if (orderField != null) {
                        Object newValue = rowX.get(index.intValue());
                        Object oldValue = resultRowX.get(index.intValue());
                        if (newValue == null) continue;
                        Object value = newValue;
                        if (oldValue != null && !oldValue.equals(newValue)) {
                            String order = orderField.getOrder();
                            Object headMostObject = ObjectComparable.getHeadMostObject(newValue, oldValue, order);
                            value = headMostObject == null ? value : headMostObject;
                        }
                        resultRowX.set(index.intValue(), value);
                        continue;
                    }
                    resultRowX.set(index.intValue(), rowX.get(index.intValue()));
                    continue;
                }
                resultRowX.set(index.intValue(), rowX.get(index.intValue()));
            }
        }
        collector.collect(resultRowX);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

