/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func.algo;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.service.complexobj.util.EntityPropParseUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.virtulentity.VirtualFieldInfo;
import kd.hr.hbp.common.util.QueryEntityUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

@ExcludeFromJacocoGeneratedReport
public class FieldTransferVirtualMapFunction
extends MapFunction {
    private static final long serialVersionUID = 5818491646587609431L;
    private final RowMeta rowMeta;
    private final RowMeta newRowMeta;
    private final Map<String, Integer> fieldAliasIndexMap;
    private final TimeZone timeZone = KDDateUtils.getTimeZone();
    private final Map<String, DynamicProperty> transferFieldMap = Maps.newHashMapWithExpectedSize((int)16);
    private final HRComplexObjContext complexObjCont;

    public FieldTransferVirtualMapFunction(RowMeta rowMeta, HRComplexObjContext complexObjCont) {
        this.rowMeta = rowMeta;
        this.initTransferFieldMap(rowMeta, complexObjCont);
        this.newRowMeta = this.buildNewRowMeta(rowMeta, this.transferFieldMap);
        Field[] fields = this.newRowMeta.getFields();
        this.fieldAliasIndexMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        this.complexObjCont = complexObjCont;
        for (int index = 0; index < fields.length; ++index) {
            this.fieldAliasIndexMap.put(fields[index].getAlias(), index);
        }
    }

    public Object[] map(Row row) {
        Object[] objects = new Object[this.newRowMeta.getFieldCount()];
        for (Field field : this.rowMeta.getFields()) {
            String fieldEntityAlias = field.getAlias();
            int newFieldIndex = this.fieldAliasIndexMap.get(fieldEntityAlias);
            Object originalValue = row.get(fieldEntityAlias);
            DynamicProperty property = this.transferFieldMap.get(fieldEntityAlias);
            if (field.getDataType().equals((Object)DataType.TimestampType)) {
                property = new DateProp();
            } else if (field.getDataType().equals((Object)DataType.BooleanType)) {
                property = new BooleanProp();
            }
            if (originalValue != null && property != null) {
                objects[newFieldIndex] = QueryEntityUtil.getEntityProp((Object)property, (Object)originalValue, (TimeZone)this.timeZone, (HRComplexObjContext)this.complexObjCont);
                int originalFieldIndex = this.fieldAliasIndexMap.get("ORIGINAL_ENUM_VALUE_" + fieldEntityAlias);
                objects[originalFieldIndex] = originalValue;
                continue;
            }
            objects[newFieldIndex] = originalValue;
        }
        return objects;
    }

    private void initTransferFieldMap(RowMeta oldRowMeta, HRComplexObjContext complexObjCont) {
        EntityPropParseUtil propParseUtil = new EntityPropParseUtil();
        List selectedFieldInfoList = complexObjCont.getVirtualEntityQueryParamInfo().getSelectedFieldInfoList();
        for (Field field : oldRowMeta.getFields()) {
            DynamicProperty property;
            String fieldEntityAlias = field.getAlias();
            Optional<VirtualFieldInfo> firstVirtualField = selectedFieldInfoList.stream().filter(info -> fieldEntityAlias.equalsIgnoreCase(info.getNumber())).findFirst();
            VirtualFieldInfo virtualFieldInfo = firstVirtualField.orElse(null);
            if (virtualFieldInfo == null || !virtualFieldInfo.isCommonField() || !StringUtils.isNotEmpty((CharSequence)virtualFieldInfo.getFieldPath()) || (property = propParseUtil.getVirtDynamicProperty(virtualFieldInfo.getFieldPath())) == null || !QueryEntityUtil.checkEntityEnumProp((Object)property)) continue;
            this.transferFieldMap.put(fieldEntityAlias, property);
        }
    }

    private RowMeta buildNewRowMeta(RowMeta oldRowMeta, Map<String, DynamicProperty> transferFieldMap) {
        Field[] originalFields = oldRowMeta.getFields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)(originalFields.length + transferFieldMap.size()));
        for (Field originalField : originalFields) {
            DynamicProperty property = transferFieldMap.get(originalField.getAlias());
            DataType originalDataType = originalField.getDataType();
            if (originalDataType.equals((Object)DataType.TimestampType) || originalDataType.equals((Object)DataType.BooleanType)) {
                property = new BooleanProp();
            }
            if (property != null) {
                fields.add(new Field("ORIGINAL_ENUM_VALUE_" + originalField.getAlias(), originalDataType));
                if (property instanceof BooleanProp || property instanceof DateTimeProp) {
                    fields.add(new Field(originalField.getName(), originalField.getAlias(), (DataType)DataType.StringType, false));
                    continue;
                }
                fields.add(originalField);
                continue;
            }
            fields.add(originalField);
        }
        return new RowMeta(fields.toArray(new Field[0]));
    }

    public RowMeta getResultRowMeta() {
        return this.newRowMeta;
    }
}

