/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.func.algo;

import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.common.util.HRStringUtils;

public class ReplaceFieldMapFunction
extends MapFunction {
    private static final long serialVersionUID = -6831479279261780486L;
    private Map<String, String> replaceAliasMap;
    private RowMeta originalRowMeta;
    private RowMeta resultRowMeta;

    public ReplaceFieldMapFunction(Map<String, String> replaceAliasMap, RowMeta originalRowMeta) {
        this.replaceAliasMap = replaceAliasMap;
        this.originalRowMeta = originalRowMeta;
    }

    public Object[] map(Row row) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        Object[] objects = new Object[resultRowMeta.getFieldCount()];
        for (int i = 0; i < resultRowMeta.getFieldCount(); ++i) {
            objects[i] = row.get(i);
        }
        return objects;
    }

    public RowMeta getResultRowMeta() {
        if (this.resultRowMeta != null) {
            return this.resultRowMeta;
        }
        Field[] fields = this.originalRowMeta.getFields();
        Field[] rstField = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            String alias = this.replaceAliasMap.get(name);
            if (HRStringUtils.isNotEmpty((String)alias)) {
                field.setName(alias);
                field.setAlias(alias);
            }
            rstField[i] = field;
        }
        this.resultRowMeta = new RowMeta(rstField);
        return this.resultRowMeta;
    }
}

