/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;

public class AlgoXFieldInfo
implements Serializable {
    private static final long serialVersionUID = -1850613955835342929L;
    public static final String ALGO_X_ALIAS_UNIQUE_CODE_SPLIT_SYMBOL = "_UNI_CODE_SPLIT_";
    public static final String ALGO_X_TRANSFER_ALIAS_SPLIT_SYMBOL = "_TRANSFER_ALIAS_SPLIT_";
    public static final String ALGO_X_DOT_REPLACE_SYMBOL = "_DOC_SPLIT_";
    public static final String AS = " as ";
    protected HRComplexObjFieldInfo fieldInfo;
    protected String realFieldName;
    protected String algoXAlias;
    protected boolean isDepend;

    public static AlgoXFieldInfo createMainFieldInfo(HRComplexObjFieldInfo fieldInfo) {
        return AlgoXFieldInfo.createMainFieldInfo(fieldInfo, AlgoXFieldInfo.replaceAlgoxAlias(fieldInfo.getAlias()), fieldInfo.getFullPath());
    }

    public static AlgoXFieldInfo createRelFieldInfo(HRComplexObjFieldInfo fieldInfo) {
        return AlgoXFieldInfo.createMainFieldInfo(fieldInfo, AlgoXFieldInfo.replaceAlgoxAlias(fieldInfo.getAlias()), AlgoXFieldInfo.replaceRealFieldName(fieldInfo.getFullPath()));
    }

    public static AlgoXFieldInfo createCalculateFieldInfo(HRComplexObjFieldInfo fieldInfo) {
        return AlgoXFieldInfo.createMainFieldInfo(fieldInfo, AlgoXFieldInfo.replaceAlgoxAlias(fieldInfo.getAlias()), fieldInfo.getFullPath());
    }

    public static AlgoXFieldInfo createPluginFieldInfo(HRComplexObjFieldInfo fieldInfo) {
        return AlgoXFieldInfo.createMainFieldInfo(fieldInfo, AlgoXFieldInfo.replaceAlgoxAlias(fieldInfo.getAlias()), fieldInfo.getAlias());
    }

    private static AlgoXFieldInfo createMainFieldInfo(HRComplexObjFieldInfo fieldInfo, String algoXAlias, String realFieldName) {
        AlgoXFieldInfo algoxFieldInfo = new AlgoXFieldInfo();
        algoxFieldInfo.fieldInfo = fieldInfo;
        algoxFieldInfo.algoXAlias = algoXAlias;
        algoxFieldInfo.realFieldName = realFieldName;
        if (fieldInfo != null) {
            algoxFieldInfo.isDepend = fieldInfo.isDependField();
        }
        return algoxFieldInfo;
    }

    public static AlgoXFieldInfo createCalculateFieldInfo(String fullPath, String alias, String algoxAlias) {
        AlgoXFieldInfo algoxFieldInfo = new AlgoXFieldInfo();
        algoxFieldInfo.fieldInfo = new HRComplexObjFieldInfo(fullPath, alias);
        algoxFieldInfo.algoXAlias = algoxAlias;
        algoxFieldInfo.realFieldName = fullPath;
        algoxFieldInfo.isDepend = false;
        return algoxFieldInfo;
    }

    public static String replaceAlgoxAlias(String alias) {
        return alias.replace("\u03b4", ALGO_X_ALIAS_UNIQUE_CODE_SPLIT_SYMBOL).replace(".", ALGO_X_DOT_REPLACE_SYMBOL).replace("!", ALGO_X_TRANSFER_ALIAS_SPLIT_SYMBOL);
    }

    public static String algoXAliasReturnAlias(String algoXAlias) {
        return algoXAlias.replace(ALGO_X_ALIAS_UNIQUE_CODE_SPLIT_SYMBOL, "\u03b4").replace(ALGO_X_DOT_REPLACE_SYMBOL, ".").replace(ALGO_X_TRANSFER_ALIAS_SPLIT_SYMBOL, "!");
    }

    public static String replaceRealFieldName(String fullPath) {
        return fullPath.substring(fullPath.indexOf(46) + 1);
    }

    @SafeVarargs
    public static List<Field> mergeSelectFieldList(Collection<AlgoXFieldInfo> ... entityFieldInfoSets) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> algoXAliasSet = new HashSet<String>();
        if (entityFieldInfoSets != null && entityFieldInfoSets.length > 0) {
            for (Collection<AlgoXFieldInfo> entityAlgoxFieldInfoSet : entityFieldInfoSets) {
                for (AlgoXFieldInfo algoxFieldInfo : entityAlgoxFieldInfoSet) {
                    if (algoXAliasSet.contains(algoxFieldInfo.getAlgoXAlias())) continue;
                    HRComplexObjFieldInfo fieldInfo = algoxFieldInfo.fieldInfo;
                    DataType dataType = AlgoDataTypeTransUtil.getDataType(fieldInfo.getDataType());
                    fieldList.add(new Field(algoxFieldInfo.getRealFieldName(), algoxFieldInfo.getAlgoXAlias(), dataType, false));
                    algoXAliasSet.add(algoxFieldInfo.getAlgoXAlias());
                }
            }
        }
        return fieldList;
    }

    public String selectAliasField() {
        return this.algoXAlias + AS + this.fieldInfo.getAlias();
    }

    public Field buildAlgoField() {
        DataType dataType = AlgoDataTypeTransUtil.getDataType(this.fieldInfo.getDataType());
        return new Field(this.algoXAlias, dataType);
    }

    public HRComplexObjFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public String getFullPath() {
        return this.fieldInfo.getFullPath();
    }

    public String getAlias() {
        return this.fieldInfo.getAlias();
    }

    public String getAlgoXAlias() {
        return this.algoXAlias;
    }

    public String getRealFieldName() {
        return this.realFieldName;
    }

    public boolean isDepend() {
        return this.isDepend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgoXFieldInfo that = (AlgoXFieldInfo)o;
        return Objects.equals(this.algoXAlias, that.algoXAlias);
    }

    public int hashCode() {
        return Objects.hash(this.algoXAlias);
    }

    public String toString() {
        return "AlgoXFieldInfo{fieldInfo=" + this.fieldInfo + ", realFieldName='" + this.realFieldName + '\'' + ", algoxAlias='" + this.algoXAlias + '\'' + '}';
    }
}

