/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.optimization.rules;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.algox.optimization.Rule;
import kd.hr.hbp.business.service.complexobj.algox.optimization.rules.AlgoXFilterRuleParam;
import kd.hr.hbp.business.service.complexobj.algox.utils.FilterUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.util.HRStringUtils;

public class DataCountRule
implements Rule<String> {
    private static final Log LOGGER = LogFactory.getLog(DataCountRule.class);
    private HRComplexObjContext context;
    private static final HRBaseServiceHelper DIM_COUNT_HELPER = new HRBaseServiceHelper("hrptmc_dimcount");
    private final Map<String, Integer> entityAliasToCount;

    public DataCountRule(HRComplexObjContext context, List<AlgoXFilterRuleParam> params) {
        this.context = context;
        this.entityAliasToCount = this.initCount(params);
        LOGGER.info("DataCountRule_entityAliasToCount_{}", (Object)String.valueOf(this.entityAliasToCount));
    }

    @Override
    public boolean execute() {
        Set<Map.Entry<String, Integer>> entrySet = this.entityAliasToCount.entrySet();
        for (Map.Entry<String, Integer> entityAliasToCountEntry : entrySet) {
            Integer count = entityAliasToCountEntry.getValue();
            if (count != null && this.context.getAlgoXOptimizedDataCount() > count) {
                LOGGER.info("DataCountRule_Hit_entityAlias={},count={}", (Object)entityAliasToCountEntry.getKey(), (Object)count);
                return true;
            }
            LOGGER.info("DataCountRule_not_Hit_entityAlias={},count={}", (Object)entityAliasToCountEntry.getKey(), (Object)count);
        }
        return false;
    }

    @Override
    public boolean executeWithParam(String entityAlias) {
        Integer count = this.entityAliasToCount.get(entityAlias);
        if (count != null && this.context.getAlgoXOptimizedDataCount() > count) {
            LOGGER.info("DataCountRule_Hit_entityAlias={},count={}", (Object)entityAlias, (Object)count);
            return true;
        }
        LOGGER.info("DataCountRule_not_Hit_entityAlias={},count={}", (Object)entityAlias, (Object)count);
        return false;
    }

    private Map<String, Integer> getDataCount(Collection<String> entityNumbers) {
        HashMap tableToIdMap = Maps.newHashMapWithExpectedSize((int)entityNumbers.size());
        HashMap tableNameToNumberMap = Maps.newHashMapWithExpectedSize((int)entityNumbers.size());
        for (String entityNumber : entityNumbers) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            tableNameToNumberMap.put(dataEntityType.getAlias(), entityNumber);
            if (HRStringUtils.isNotEmpty((String)primaryKey.getAlias())) {
                tableToIdMap.put(dataEntityType.getAlias(), primaryKey.getAlias());
                continue;
            }
            LOGGER.warn("DataCountRule_table_{}_primary_key_is_empty", (Object)dataEntityType.getAlias());
        }
        QFilter tableNameQFilter = new QFilter("tablename", "in", tableToIdMap.keySet());
        tableNameQFilter.and("fieldname", "in", (Object)Sets.newHashSet(tableToIdMap.values()));
        String selectFields = "tablename,fieldname,dimcount";
        DynamicObject[] countDys = DIM_COUNT_HELPER.queryOriginalArray(selectFields, new QFilter[]{tableNameQFilter});
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)countDys.length);
        for (DynamicObject countDy : countDys) {
            String dbIdAlias;
            String tableName = countDy.getString("tablename");
            String idAlias = (String)tableToIdMap.get(tableName);
            if (!idAlias.equals(dbIdAlias = countDy.getString("fieldname"))) continue;
            int count = countDy.getInt("dimcount");
            String entityNumber = (String)tableNameToNumberMap.get(tableName);
            countMap.put(entityNumber, count);
        }
        return countMap;
    }

    private boolean checkNeedQueryDb(AlgoXFilterRuleParam param) {
        List<HRComplexObjJoinRelation> joinRelations = param.getJoinRelations();
        return !FilterUtils.checkQFilterIsEmpty(param.getqFilterList()) && joinRelations != null;
    }

    private Map<String, Integer> initCount(List<AlgoXFilterRuleParam> params) {
        HashMap aliasToNumberMap = Maps.newHashMapWithExpectedSize((int)params.size());
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (AlgoXFilterRuleParam param : params) {
            if (!this.checkNeedQueryDb(param)) continue;
            aliasToNumberMap.put(param.getEntityAlias(), param.getEntityNumber());
        }
        if (!aliasToNumberMap.isEmpty()) {
            Map<String, Integer> entityNumberToCount = this.getDataCount(aliasToNumberMap.values());
            for (Map.Entry entry : aliasToNumberMap.entrySet()) {
                countMap.put(entry.getKey(), entityNumberToCount.get(entry.getValue()));
            }
        }
        return countMap;
    }
}

