/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.constants.AlgoXConstants;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXDimFieldParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXFilterParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXOrderFieldParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXRelEntityParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.specific.AlgoXSelectFieldParser;
import kd.hr.hbp.business.service.complexobj.model.OrderField;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.flink.api.java.tuple.Tuple2;

public class AlgoXParser
implements IAlgoXParser,
AlgoXConstants {
    private static final long serialVersionUID = 1319565039704071899L;
    protected final HRComplexObjContext context;
    protected AlgoXSelectFieldParser algoXSelectFieldParser;
    protected AlgoXOrderFieldParser algoXOrderFieldParser;
    protected AlgoXDimFieldParser algoXDimFieldParser;
    protected AlgoXFilterParser algoXFilterParser;
    protected AlgoXRelEntityParser algoXRelEntityParser;
    protected final Map<String, String> relEntityMap = new LinkedHashMap<String, String>();
    private final Map<String, AlgoXFieldInfo> allFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, AlgoXFieldInfo> calculateFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, AlgoXFieldInfo> pluginFieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, AlgoXFieldInfo> presetIndexFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, AlgoXFieldInfo> allFieldInfoAlgoXAliasMap = Maps.newHashMapWithExpectedSize((int)10);
    private final Map<String, AlgoXFieldInfo> calculateFieldInfoAlgoXAliasMap = Maps.newHashMapWithExpectedSize((int)10);
    private final Map<String, AlgoXFieldInfo> pluginFieldInfoAlgoXAliasMap = Maps.newHashMapWithExpectedSize((int)16);
    private final Map<String, MainEntityType> entityAliasToMetaCache = new HashMap<String, MainEntityType>();
    private final Map<String, Set<String>> algoXAliasTransferFieldAliasMap = Maps.newHashMapWithExpectedSize((int)16);
    private int start = -1;
    private int limit = -1;

    public AlgoXParser(HRComplexObjContext context) {
        this.context = context;
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        this.entityAliasToMetaCache.put(this.context.getEntityNumber(), EntityMetadataCache.getDataEntityType((String)this.context.getEntityNumber()));
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                String relEntityNumber = joinRelation.getRelEntityNumber();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)relEntityNumber);
                this.relEntityMap.put(joinRelation.getRelEntityAlias(), relEntityNumber);
                this.entityAliasToMetaCache.put(joinRelation.getRelEntityAlias(), dataEntityType);
            });
        }
        this.algoXSelectFieldParser = new AlgoXSelectFieldParser(this.context, this);
        this.algoXOrderFieldParser = new AlgoXOrderFieldParser(this.context, this);
        this.algoXDimFieldParser = new AlgoXDimFieldParser(this.context, this);
        this.algoXRelEntityParser = new AlgoXRelEntityParser(this.context, this);
        this.algoXFilterParser = new AlgoXFilterParser(this.context, this);
        this.algoXFilterParser.initOptimizeFilterData();
    }

    public RowMeta getMainRowMeta() {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXSelectFieldParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXOrderFieldParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXRelEntityParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXFilterParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXDimFieldParser.getMainEntityAlgoxFieldInfoCollection());
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public RowMeta getMainTempRowMeta() {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXRelEntityParser.getEntityPrimaryFieldInfoCollection(this.context.getEntityNumber()), this.algoXRelEntityParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXFilterParser.getMainEntityAlgoxFieldInfoCollection());
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public RowMeta getRelRowMeta(String relEntityAlias) {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXSelectFieldParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXOrderFieldParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXRelEntityParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXFilterParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXDimFieldParser.getRelEntityFieldInfoCollection(relEntityAlias));
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    @ExcludeFromJacocoGeneratedReport
    public RowMeta getRelTempRowMeta(String relEntityAlias) {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXRelEntityParser.getEntityPrimaryFieldInfoCollection(relEntityAlias), this.algoXRelEntityParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXFilterParser.getRelEntityFieldInfoCollection(relEntityAlias));
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public String getSelectFieldStr(RowMeta rowMeta) {
        return Arrays.stream(rowMeta.getFields()).map(Field::getName).collect(Collectors.joining(","));
    }

    public List<HRComplexObjJoinRelation> getHasFieldRelEntityAliasList() {
        ArrayList<HRComplexObjJoinRelation> relEntityAliasList = new ArrayList<HRComplexObjJoinRelation>();
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            HashSet driveEntityAliases = Sets.newHashSetWithExpectedSize((int)joinRelationList.size());
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                String joinType = joinRelation.getJoinType();
                if (JoinType.LEFT.getName().equals(joinType)) {
                    driveEntityAliases.add(joinRelation.getEntityAlias());
                    continue;
                }
                if (JoinType.RIGHT.getName().equals(joinType)) {
                    driveEntityAliases.add(joinRelation.getRelEntityAlias());
                    continue;
                }
                driveEntityAliases.add(joinRelation.getEntityAlias());
                driveEntityAliases.add(joinRelation.getRelEntityAlias());
            }
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                if (!(!driveEntityAliases.contains(relEntityAlias) && this.algoXSelectFieldParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty() && this.algoXOrderFieldParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty() && this.algoXDimFieldParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty() && this.algoXFilterParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty())) {
                    relEntityAliasList.add(joinRelation);
                    continue;
                }
                String joinType = joinRelation.getJoinType();
                if (JoinType.LEFT.getName().equals(joinType) || JoinType.INNER.getName().equals(joinType)) {
                    if (this.algoXRelEntityParser.checkIsMultiToOne(relEntityAlias).booleanValue()) continue;
                    relEntityAliasList.add(joinRelation);
                    continue;
                }
                relEntityAliasList.add(joinRelation);
            }
        }
        return relEntityAliasList;
    }

    public boolean checkIsMultiToOne(String relEntityAlias) {
        return this.algoXRelEntityParser.checkIsMultiToOne(relEntityAlias);
    }

    public boolean containsRelEntity(String relEntityAlias) {
        return this.relEntityMap.containsKey(relEntityAlias);
    }

    public String getRelEntityNumber(String relEntityAlias) {
        return this.relEntityMap.get(relEntityAlias);
    }

    public void parseAndAddEntityFieldInfo(List<HRComplexObjFieldInfo> complexObjFieldInfoList, Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap, Map<String, AlgoXFieldInfo> mainEntityAlgoXFieldInfoMap) {
        Set<String> calculateFieldSet = this.getContext().getComplexObjFieldInfoList().stream().filter(complexObjFieldInfo -> !HRStringUtils.equals((String)complexObjFieldInfo.getFieldType(), (String)"1")).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        Set pluginFieldAliasSet = this.getContext().getComplexObjFieldInfoList().stream().filter(field -> HRStringUtils.equals((String)field.getFieldType(), (String)"4")).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        Set anObjPivotIndexSet = complexObjFieldInfoList.stream().filter(HRComplexObjFieldInfo::isAnObjPivotIndex).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
        for (HRComplexObjFieldInfo complexObjFieldInfo2 : complexObjFieldInfoList) {
            if (HRStringUtils.equals((String)complexObjFieldInfo2.getFieldType(), (String)"1")) {
                this.addEntityFieldInfo(complexObjFieldInfo2, relEntityAliasFieldInfoMap, mainEntityAlgoXFieldInfoMap, true);
                continue;
            }
            if (HRStringUtils.equals((String)complexObjFieldInfo2.getFieldType(), (String)"4")) {
                this.addPluginFieldInfo(complexObjFieldInfo2);
                continue;
            }
            Set refFieldAliasSet = complexObjFieldInfo2.getRefFieldAliasSet();
            for (String refFieldAlias : refFieldAliasSet) {
                if (this.isCalculateField(refFieldAlias, calculateFieldSet) || anObjPivotIndexSet.contains(refFieldAlias) || complexObjFieldInfo2.getRefFieldIsAnObjPivotIndexSet().contains(refFieldAlias) || pluginFieldAliasSet.contains("PLUGIN_FIELD_ALIAS_PREFIX_" + refFieldAlias)) continue;
                this.addEntityFieldInfo(refFieldAlias, relEntityAliasFieldInfoMap, mainEntityAlgoXFieldInfoMap);
            }
            HashSet reAddAlias = Sets.newHashSetWithExpectedSize((int)refFieldAliasSet.size());
            Iterator iterator = refFieldAliasSet.iterator();
            while (iterator.hasNext()) {
                String refFieldAlias = (String)iterator.next();
                if (!pluginFieldAliasSet.contains("PLUGIN_FIELD_ALIAS_PREFIX_" + refFieldAlias)) continue;
                iterator.remove();
                reAddAlias.add("PLUGIN_FIELD_ALIAS_PREFIX_" + refFieldAlias);
            }
            refFieldAliasSet.addAll(reAddAlias);
            this.addCalculateFieldInfo(complexObjFieldInfo2);
        }
    }

    public void addEntityFieldInfo(String alias, Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap, Map<String, AlgoXFieldInfo> mainEntityAlgoXFieldInfoMap) {
        String fullPath = this.parseAliasReturnFullPath(alias);
        DataTypeEnum dataTypeEnum = AlgoDataTypeTransUtil.getDataTypeEnum(this.getFieldDataType(alias));
        this.addEntityFieldInfo(new HRComplexObjFieldInfo(fullPath, dataTypeEnum, alias), relEntityAliasFieldInfoMap, mainEntityAlgoXFieldInfoMap, false);
    }

    public void addEntityFieldInfo(HRComplexObjFieldInfo fieldInfo, Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap, Map<String, AlgoXFieldInfo> mainEntityAlgoXFieldInfoMap, boolean needResetDataType) {
        String prefixAlias;
        String alias;
        String originalAlias = alias = fieldInfo.getAlias();
        boolean isTransfer = false;
        if (alias.contains("!")) {
            DataTypeEnum dataTypeEnum = fieldInfo.getDataType();
            if (needResetDataType) {
                dataTypeEnum = AlgoDataTypeTransUtil.getDataTypeEnum(this.getFieldDataType(alias));
            }
            alias = alias.split("!")[0];
            HRComplexObjFieldInfo newFieldInfo = new HRComplexObjFieldInfo(alias, fieldInfo.getFieldType(), alias, dataTypeEnum, fieldInfo.getRefFieldAliasSet());
            newFieldInfo.setDependField(fieldInfo.isDependField());
            newFieldInfo.setAnObjPivotIndex(fieldInfo.isAnObjPivotIndex());
            newFieldInfo.setRefFieldIsAnObjPivotIndexSet(fieldInfo.getRefFieldIsAnObjPivotIndexSet());
            fieldInfo = newFieldInfo;
            isTransfer = true;
        }
        Map<String, AlgoXFieldInfo> entityAlgoxFieldInfoMap = this.containsRelEntity(prefixAlias = this.parseAliasReturnRelEntityAlias(alias)) ? relEntityAliasFieldInfoMap.get(prefixAlias) : mainEntityAlgoXFieldInfoMap;
        AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(alias);
        if (algoxFieldInfo == null) {
            algoxFieldInfo = this.containsRelEntity(prefixAlias) ? AlgoXFieldInfo.createRelFieldInfo(fieldInfo) : AlgoXFieldInfo.createMainFieldInfo(fieldInfo);
            this.allFieldInfoMap.put(alias, algoxFieldInfo);
            this.allFieldInfoAlgoXAliasMap.put(algoxFieldInfo.getAlgoXAlias(), algoxFieldInfo);
        }
        if (isTransfer) {
            String[] aliasArray = originalAlias.split("!");
            HashSet transferAliases = this.algoXAliasTransferFieldAliasMap.get(algoxFieldInfo.getAlgoXAlias());
            if (transferAliases == null) {
                transferAliases = Sets.newHashSetWithExpectedSize((int)16);
            }
            transferAliases.add(aliasArray[1]);
            this.algoXAliasTransferFieldAliasMap.put(algoxFieldInfo.getAlgoXAlias(), transferAliases);
        }
        if (!this.containsEntityField(alias, entityAlgoxFieldInfoMap)) {
            entityAlgoxFieldInfoMap.put(alias, algoxFieldInfo);
        }
    }

    private boolean containsEntityField(String alias, Map<String, AlgoXFieldInfo> entityAlgoXFieldInfoMap) {
        return entityAlgoXFieldInfoMap.containsKey(alias);
    }

    private String parseAliasReturnFullPath(String alias) {
        String prefixAlias = this.parseAliasReturnRelEntityAlias(alias);
        return this.parseAliasReturnFullPath(prefixAlias, alias);
    }

    public String parseAliasReturnFullPath(String relEntityAlias, String fieldAlias) {
        if (this.containsRelEntity(relEntityAlias)) {
            String entityNumber = this.getRelEntityNumber(relEntityAlias);
            return entityNumber + fieldAlias.substring(relEntityAlias.length());
        }
        return fieldAlias;
    }

    public void addCalculateFieldInfo(HRComplexObjFieldInfo complexObjFieldInfo) {
        AlgoXFieldInfo calculateFieldInfo = AlgoXFieldInfo.createCalculateFieldInfo(complexObjFieldInfo);
        this.calculateFieldInfoMap.put(complexObjFieldInfo.getAlias(), calculateFieldInfo);
        this.calculateFieldInfoAlgoXAliasMap.put(calculateFieldInfo.getAlgoXAlias(), calculateFieldInfo);
    }

    public void addPluginFieldInfo(HRComplexObjFieldInfo complexObjFieldInfo) {
        AlgoXFieldInfo pluginFieldInfo = AlgoXFieldInfo.createPluginFieldInfo(complexObjFieldInfo);
        this.pluginFieldInfoMap.put(complexObjFieldInfo.getAlias(), pluginFieldInfo);
        this.pluginFieldInfoAlgoXAliasMap.put(pluginFieldInfo.getAlgoXAlias(), pluginFieldInfo);
    }

    public void addPresetIndexFieldInfo(HRComplexObjFieldInfo complexObjFieldInfo) {
        this.presetIndexFieldInfoMap.put(complexObjFieldInfo.getAlias(), AlgoXFieldInfo.createCalculateFieldInfo(complexObjFieldInfo));
    }

    public boolean hasPresetIndex() {
        return !this.presetIndexFieldInfoMap.isEmpty();
    }

    public boolean hasCalculateField() {
        return !this.calculateFieldInfoMap.isEmpty();
    }

    public boolean hasPluginField() {
        return !this.pluginFieldInfoMap.isEmpty();
    }

    public boolean containsCalculateField(String refFieldAlias) {
        return this.calculateFieldInfoMap.containsKey(refFieldAlias);
    }

    public boolean containsPluginField(String refFieldAlias) {
        return this.pluginFieldInfoMap.containsKey(refFieldAlias);
    }

    public boolean isCalculateField(String refFieldAlias, Set<String> calculateFieldSet) {
        return calculateFieldSet.contains(refFieldAlias);
    }

    public String getAlgoXAliasByAlias(String alias) {
        AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(alias);
        if (algoxFieldInfo == null) {
            algoxFieldInfo = this.calculateFieldInfoMap.get(alias);
        }
        if (algoxFieldInfo == null) {
            algoxFieldInfo = this.pluginFieldInfoMap.get(alias);
        }
        if (algoxFieldInfo == null && alias.contains("!")) {
            return AlgoXFieldInfo.replaceAlgoxAlias(alias);
        }
        if (algoxFieldInfo == null) {
            return null;
        }
        return algoxFieldInfo.getAlgoXAlias();
    }

    public AlgoXFieldInfo getAlgoXFieldInfoByAlgoXAlias(String algoXAlias) {
        AlgoXFieldInfo algoXFieldInfo = this.allFieldInfoAlgoXAliasMap.get(algoXAlias);
        if (algoXFieldInfo == null) {
            algoXFieldInfo = this.calculateFieldInfoAlgoXAliasMap.get(algoXAlias);
        }
        if (algoXFieldInfo == null) {
            algoXFieldInfo = this.pluginFieldInfoAlgoXAliasMap.get(algoXAlias);
        }
        return algoXFieldInfo;
    }

    @ExcludeFromJacocoGeneratedReport
    public String getRealFileNameByAlias(String alias) {
        AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(alias);
        if (algoxFieldInfo == null) {
            algoxFieldInfo = this.calculateFieldInfoMap.get(alias);
        }
        if (algoxFieldInfo == null) {
            algoxFieldInfo = this.pluginFieldInfoMap.get(alias);
        }
        if (algoxFieldInfo == null) {
            return alias;
        }
        return algoxFieldInfo.getRealFieldName();
    }

    public List<String> getSelectAliasFieldList(String[] algoXAliasArr, boolean returnOnlySelectField) {
        Map<String, AlgoXFieldInfo> allFieldAlgoXAliasMap = this.getSelectAliasFieldAllMap(returnOnlySelectField);
        return Arrays.stream(algoXAliasArr).filter(algoXAlias -> {
            if (this.getContext().isReturnEnumOriginalValue() && algoXAlias.startsWith("ORIGINAL_ENUM_VALUE_")) {
                algoXAlias = algoXAlias.replace("ORIGINAL_ENUM_VALUE_", "");
            } else if (algoXAlias.contains("_TRANSFER_ALIAS_SPLIT_")) {
                algoXAlias = algoXAlias.split("_TRANSFER_ALIAS_SPLIT_")[0];
            }
            return allFieldAlgoXAliasMap.containsKey(algoXAlias);
        }).map(algoXAlias -> {
            if (this.getContext().isReturnEnumOriginalValue() && algoXAlias.startsWith("ORIGINAL_ENUM_VALUE_")) {
                return algoXAlias + " as " + algoXAlias;
            }
            if (algoXAlias.contains("_TRANSFER_ALIAS_SPLIT_")) {
                return algoXAlias + " as " + AlgoXFieldInfo.algoXAliasReturnAlias(algoXAlias);
            }
            return ((AlgoXFieldInfo)allFieldAlgoXAliasMap.get(algoXAlias)).selectAliasField();
        }).collect(Collectors.toList());
    }

    private Map<String, AlgoXFieldInfo> getSelectAliasFieldAllMap(boolean returnOnlySelectField) {
        HashMap allFieldAlgoXAliasMap = Maps.newHashMapWithExpectedSize((int)16);
        if (returnOnlySelectField) {
            allFieldAlgoXAliasMap.putAll(this.algoXSelectFieldParser.getAllSelectFieldAlgoxAliasMap());
        } else {
            allFieldAlgoXAliasMap.putAll(this.allFieldInfoMap.values().stream().collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, fieldInfo -> fieldInfo)));
        }
        allFieldAlgoXAliasMap.putAll(this.algoXOrderFieldParser.getAllOrderFieldInfoAlgoXAliasMap());
        allFieldAlgoXAliasMap.putAll(this.calculateFieldInfoMap.values().stream().collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, calculateFieldInfo -> calculateFieldInfo)));
        allFieldAlgoXAliasMap.putAll(this.pluginFieldInfoMap.values().stream().collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, pluginFieldInfo -> pluginFieldInfo)));
        return allFieldAlgoXAliasMap;
    }

    public List<Field> getCalculateFieldList() {
        ArrayList<Field> fieldList = new ArrayList<Field>(this.calculateFieldInfoMap.size());
        for (Map.Entry<String, AlgoXFieldInfo> calculateFieldInfoEntry : this.calculateFieldInfoMap.entrySet()) {
            AlgoXFieldInfo calculateFieldInfo = calculateFieldInfoEntry.getValue();
            fieldList.add(calculateFieldInfo.buildAlgoField());
        }
        return fieldList;
    }

    public Map<String, AlgoXFieldInfo> getAllFieldInfoMap() {
        return this.allFieldInfoMap;
    }

    public AlgoXFieldInfo getNormalAlgoXFieldInfo(String alias) {
        return this.allFieldInfoMap.get(alias);
    }

    public Map<String, AlgoXFieldInfo> getCalculateFieldInfoMap() {
        return this.calculateFieldInfoMap;
    }

    public Map<String, AlgoXFieldInfo> getPluginFieldInfoMap() {
        return this.pluginFieldInfoMap;
    }

    public AlgoXFieldInfo getCalculateFieldInfo(String alias) {
        return this.calculateFieldInfoMap.get(alias);
    }

    public AlgoXFieldInfo getPluginFieldInfo(String alias) {
        return this.pluginFieldInfoMap.get(alias);
    }

    public List<AlgoXFieldInfo> getAlgoXFieldInfoListWithCalculate(Set<String> refFieldAliasSet) {
        ArrayList<AlgoXFieldInfo> resultList = new ArrayList<AlgoXFieldInfo>(refFieldAliasSet.size());
        for (String refFieldAlias : refFieldAliasSet) {
            AlgoXFieldInfo algoxFieldInfo = this.allFieldInfoMap.get(refFieldAlias);
            if (algoxFieldInfo == null) {
                AlgoXFieldInfo calculateFieldInfo = this.calculateFieldInfoMap.get(refFieldAlias);
                algoxFieldInfo = calculateFieldInfo != null ? AlgoXFieldInfo.createCalculateFieldInfo(calculateFieldInfo.getFullPath(), refFieldAlias, calculateFieldInfo.getAlgoXAlias()) : this.pluginFieldInfoMap.get(refFieldAlias);
            }
            resultList.add(algoxFieldInfo);
        }
        return resultList;
    }

    public List<String> getDistinctAlgoXAliasList() {
        return this.context.isDistinct() ? this.algoXSelectFieldParser.getDistinctAlgoXAliasList() : Lists.newArrayListWithExpectedSize((int)0);
    }

    public List<String> getDistinctAlgoXAliasList(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        ArrayList<String> distinctAlgoXAliasList = new ArrayList<String>(complexObjFieldInfoList.size());
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            String algoXAlias;
            String alias = complexObjFieldInfo.getAlias();
            AlgoXFieldInfo algoxFieldInfo = this.getNormalAlgoXFieldInfo(alias);
            if (algoxFieldInfo == null) {
                algoxFieldInfo = this.getCalculateFieldInfo(alias);
            }
            if (algoxFieldInfo == null) {
                algoxFieldInfo = this.getPluginFieldInfo(alias);
            }
            if (distinctAlgoXAliasList.contains(algoXAlias = algoxFieldInfo != null ? algoxFieldInfo.getAlgoXAlias() : AlgoXFieldInfo.replaceAlgoxAlias(alias)) || this.algoXOrderFieldParser.isDependSortField(algoXAlias)) continue;
            distinctAlgoXAliasList.add(algoXAlias);
        }
        return distinctAlgoXAliasList;
    }

    public List<String> getDistinctAlgoXAliasListWithDepend(List<HRComplexObjFieldInfo> complexObjFieldInfoList) {
        ArrayList<String> distinctAlgoXAliasList = new ArrayList<String>(complexObjFieldInfoList.size());
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            AlgoXFieldInfo algoxFieldInfo;
            String alias = complexObjFieldInfo.getAlias();
            String transSuffix = null;
            if (alias.contains("!")) {
                String[] splitArray = alias.split("!");
                alias = splitArray[0];
                transSuffix = splitArray[1];
            }
            if ((algoxFieldInfo = this.getNormalAlgoXFieldInfo(alias)) == null) {
                algoxFieldInfo = this.getCalculateFieldInfo(alias);
            }
            if (algoxFieldInfo == null) {
                algoxFieldInfo = this.getPluginFieldInfo(alias);
            }
            String algoXAlias = algoxFieldInfo.getAlgoXAlias();
            if (transSuffix != null) {
                algoXAlias = algoXAlias + "_TRANSFER_ALIAS_SPLIT_" + transSuffix;
            }
            if (distinctAlgoXAliasList.contains(algoXAlias)) continue;
            distinctAlgoXAliasList.add(algoXAlias);
        }
        return distinctAlgoXAliasList;
    }

    public String[] getOrderByAlgoXAliasArr() {
        return this.algoXOrderFieldParser.getOrderByAlgoXAliasArr();
    }

    public List<QFilter> getMainEntityFilterList() {
        return this.algoXFilterParser.getMainEntityFilterList();
    }

    public List<QFilter> getMainEntityFilterListWithQueryEmpty() {
        return this.algoXFilterParser.getMainEntityFilterListWithQueryEmpty();
    }

    public List<QFilter> getMainEntityFilterListByRelData() {
        return this.algoXFilterParser.getMainEntityFilterListByRelData();
    }

    public Tuple2<String, Map<String, Object>> getRelEntityWhereFilterStrParam() {
        return this.algoXFilterParser.getRelEntityWhereFilterStrParam();
    }

    public String filterToExp(QFilter qFilter, Map<String, Object> params) {
        return this.algoXFilterParser.filterToExp(qFilter, params);
    }

    public boolean containsCombineJoinEntity(String relEntityAlias) {
        return this.algoXRelEntityParser.containsCombineJoinEntity(relEntityAlias);
    }

    public List<QFilter> getRelJoinAndWhereQFilterList(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoXRelEntityParser.getRelJoinQFilterList(relEntityAlias, false);
        relQFilterList.addAll(this.algoXFilterParser.getRelEntityFilterList(relEntityAlias));
        return this.algoXFilterParser.replaceAliasToRealFileNameWithRelQFilterList(relQFilterList);
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getRelWhereQFilterList(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoXFilterParser.getRelEntityFilterList(relEntityAlias);
        return this.algoXFilterParser.replaceAliasToRealFileNameWithRelQFilterList(relQFilterList);
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getRelWhereQFilterListWithQueryEmpty(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoXFilterParser.getRelEntityFilterListWithQueryEmpty(relEntityAlias);
        return this.algoXFilterParser.replaceAliasToRealFileNameWithRelQFilterList(relQFilterList);
    }

    @ExcludeFromJacocoGeneratedReport
    public List<QFilter> getRelWhereQFilterListByMainData(String relEntityAlias) {
        return this.algoXFilterParser.getRelEntityFilterListByMainData(relEntityAlias);
    }

    public List<QFilter> getMainOnRelQFilterList(String relEntityAlias) {
        List<QFilter> relQFilterList = this.algoXRelEntityParser.getMainJoinQFilterList(relEntityAlias);
        return this.algoXFilterParser.replaceAliasToRealFileNameWithRelQFilterList(relQFilterList);
    }

    public Set<Tuple2<String, String>> relEntityAliasOnAlgoXAliasSet(String relEntityAlias) {
        return this.algoXRelEntityParser.relEntityAliasOnAlgoXAliasSet(relEntityAlias);
    }

    public Set<Tuple2<String, String>> relEntityAliasOnRealFileNameSet(String relEntityAlias) {
        return this.algoXRelEntityParser.relEntityAliasOnRealFileNameSet(relEntityAlias);
    }

    public RowMeta getMainDimRowMeta() {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXSelectFieldParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXDimFieldParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXOrderFieldParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXRelEntityParser.getMainEntityAlgoxFieldInfoCollection(), this.algoXFilterParser.getMainEntityAlgoxFieldInfoCollection());
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public RowMeta getRelDimRowMeta(String relEntityAlias) {
        List<Field> fieldList = AlgoXFieldInfo.mergeSelectFieldList(this.algoXSelectFieldParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXDimFieldParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXOrderFieldParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXRelEntityParser.getRelEntityFieldInfoCollection(relEntityAlias), this.algoXFilterParser.getRelEntityFieldInfoCollection(relEntityAlias));
        return new RowMeta(fieldList.toArray(new Field[0]));
    }

    public List<HRComplexObjJoinRelation> getHasDimFieldRelEntityAliasList() {
        ArrayList<HRComplexObjJoinRelation> relEntityAliasList = new ArrayList<HRComplexObjJoinRelation>();
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                if (HRStringUtils.equals((String)JoinType.RIGHT.getName(), (String)joinRelation.getJoinType())) {
                    relEntityAliasList.add(joinRelation);
                    continue;
                }
                if (!(this.algoXOrderFieldParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty() && this.algoXDimFieldParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty() && this.algoXFilterParser.getRelEntityFieldInfoMap(relEntityAlias).isEmpty())) {
                    relEntityAliasList.add(joinRelation);
                    continue;
                }
                if (this.algoXRelEntityParser.checkIsMultiToOne(relEntityAlias).booleanValue()) continue;
                relEntityAliasList.add(joinRelation);
            }
        }
        return relEntityAliasList;
    }

    public List<Field> getDimCalculateFieldList() {
        return this.algoXDimFieldParser.getDimCalculateFieldList();
    }

    public List<AlgoXFieldInfo> getDimPluginFieldInfoList() {
        return this.algoXDimFieldParser.getDimPluginFieldInfoList();
    }

    public List<String> getDimDistinctAlgoXAliasArr() {
        return this.algoXDimFieldParser.getDimDistinctAlgoXAliasList();
    }

    public Map<String, AlgoXFieldInfo> getDimCalculateFieldInfoMap() {
        return this.algoXDimFieldParser.getDimCalculateFieldInfoMap();
    }

    public String[] getDimOrderByStrArr() {
        List<String> orderByAlgoXAliasList = this.algoXSelectFieldParser.getDistinctAlgoXAliasListWithDepend();
        return this.algoXOrderFieldParser.getOrderByAlgoXAliasArr(orderByAlgoXAliasList);
    }

    public HRComplexObjContext getContext() {
        return this.context;
    }

    public DataType getFieldDataType(String alias) {
        String entityNumber = this.context.getEntityNumber();
        String prefixAlias = this.parseAliasReturnRelEntityAlias(alias);
        String joinEntityNumber = this.getRelEntityNumber(prefixAlias);
        if (HRStringUtils.isNotEmpty((String)joinEntityNumber)) {
            entityNumber = joinEntityNumber;
            alias = alias.substring(prefixAlias.length() + 1);
        }
        if (alias.contains("!")) {
            alias = alias.split("!")[0];
        }
        if (this.containsCalculateField(alias)) {
            AlgoXFieldInfo calculateFieldInfo = this.getCalculateFieldInfo(alias);
            DataTypeEnum dataType = calculateFieldInfo.getFieldInfo().getDataType();
            return AlgoDataTypeTransUtil.getDataType(dataType);
        }
        if (this.containsPluginField(alias)) {
            AlgoXFieldInfo pluginFieldInfo = this.getPluginFieldInfo(alias);
            DataTypeEnum dataType = pluginFieldInfo.getFieldInfo().getDataType();
            return AlgoDataTypeTransUtil.getDataType(dataType);
        }
        RowMeta rowMeta = ORM.create().createRowMeta(entityNumber, alias);
        return rowMeta.getFieldDataType(0);
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @ExcludeFromJacocoGeneratedReport
    public Tuple2<String, Map<String, Object>> qFilterToTuple2(List<QFilter> qFilters) {
        ArrayList<String> exprList = new ArrayList<String>(10);
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        for (QFilter qFilter : qFilters) {
            exprList.add(this.filterToExp(qFilter, params));
        }
        String expr = String.join((CharSequence)" and ", exprList);
        return new Tuple2((Object)expr, (Object)params);
    }

    public String getPrimaryAlias(String entityAlias) {
        AlgoXFieldInfo entityPrimaryFieldInfo = this.algoXRelEntityParser.getEntityPrimaryFieldInfo(entityAlias);
        if (entityPrimaryFieldInfo != null) {
            return entityPrimaryFieldInfo.getAlgoXAlias();
        }
        return null;
    }

    public Map<String, Map<String, Integer>> getCustomOrderMap() {
        return this.algoXOrderFieldParser.getCustomOrderMap();
    }

    public Map<String, AlgoXFieldInfo> getAllSelectFieldAlgoXAliasMap(Map<String, AlgoXFieldInfo> mainEntityAlgoXAliasFieldInfoMap, Map<String, Map<String, AlgoXFieldInfo>> relEntityAlgoXAliasFieldInfoMap) {
        HashMap<String, AlgoXFieldInfo> resultMap = new HashMap<String, AlgoXFieldInfo>(mainEntityAlgoXAliasFieldInfoMap.values().stream().filter(fieldInfo -> !fieldInfo.isDepend()).collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, fieldInfo -> fieldInfo, (x, y) -> y)));
        relEntityAlgoXAliasFieldInfoMap.values().forEach(relMap -> resultMap.putAll(relMap.values().stream().filter(fieldInfo -> !fieldInfo.isDepend()).collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, fieldInfo -> fieldInfo, (x, y) -> y))));
        return resultMap;
    }

    public Map<String, AlgoXFieldInfo> getAllFieldAlgoXAliasMap(Map<String, AlgoXFieldInfo> mainEntityAlgoXAliasFieldInfoMap, Map<String, Map<String, AlgoXFieldInfo>> relEntityAlgoXAliasFieldInfoMap) {
        HashMap<String, AlgoXFieldInfo> resultMap = new HashMap<String, AlgoXFieldInfo>(mainEntityAlgoXAliasFieldInfoMap.values().stream().collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, fieldInfo -> fieldInfo, (x, y) -> y)));
        relEntityAlgoXAliasFieldInfoMap.values().forEach(relMap -> resultMap.putAll(relMap.values().stream().collect(Collectors.toMap(AlgoXFieldInfo::getAlgoXAlias, fieldInfo -> fieldInfo, (x, y) -> y))));
        return resultMap;
    }

    public void addTempSelectFieldInfo(String entityAlias, List<AlgoXFieldInfo> tempSelectFieldInfo, boolean isLeft) {
        HashSet tempSelectFields = Sets.newHashSetWithExpectedSize((int)16);
        Set<Tuple2<String, String>> tuple2Set2 = this.relEntityAliasOnAlgoXAliasSet(entityAlias);
        for (Tuple2<String, String> tuple2 : tuple2Set2) {
            AlgoXFieldInfo algoXFieldInfo = this.getAlgoXFieldInfoByAlgoXAlias(isLeft ? (String)tuple2.f0 : (String)tuple2.f1);
            if (algoXFieldInfo == null || tempSelectFields.contains(algoXFieldInfo.getRealFieldName())) continue;
            tempSelectFields.add(algoXFieldInfo.getRealFieldName());
            tempSelectFieldInfo.add(algoXFieldInfo);
        }
    }

    public String getRealMainEntityAlias() {
        return this.algoXRelEntityParser.getRealMainEntityAlias();
    }

    public String getRealMainEntityNumber() {
        return this.algoXRelEntityParser.getRealMainEntityNumber();
    }

    public List<OrderField> getOrderFields() {
        return this.algoXOrderFieldParser.getOrderFields();
    }

    public SortFieldInfo getFirstSortFieldInfo() {
        return this.algoXOrderFieldParser.getFirstSortField();
    }

    public List<QFilter> replaceQFilterAliasToRealFileName(List<QFilter> qFilters) {
        return this.algoXFilterParser.replaceAliasToRealFileNameWithRelQFilterList(qFilters);
    }

    public MainEntityType getEntityTypeByAlias(String entityAlias) {
        return this.entityAliasToMetaCache.get(entityAlias);
    }

    public boolean isAllOptimizeMainQFilter() {
        return this.algoXFilterParser.isAllOptimizeMainQFilter();
    }

    public Set<String> getAlgoXAliasTransferFieldAliases(String algoXAlias) {
        return this.algoXAliasTransferFieldAliasMap.getOrDefault(algoXAlias, Sets.newHashSetWithExpectedSize((int)0));
    }

    public Map<String, Set<String>> getAlgoXAliasTransferFieldAliasMap() {
        return this.algoXAliasTransferFieldAliasMap;
    }
}

