/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;

public class AlgoXDimFieldParser
implements IAlgoXParser {
    private static final long serialVersionUID = 4150472841524338118L;
    private final Map<String, AlgoXFieldInfo> mainEntityAlgoxFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap = new HashMap<String, Map<String, AlgoXFieldInfo>>();
    private final HRComplexObjContext context;
    private final AlgoXParser algoxParser;

    public AlgoXDimFieldParser(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                Map cfr_ignored_0 = this.relEntityAliasFieldInfoMap.put(joinRelation.getRelEntityAlias(), new LinkedHashMap());
            });
        }
        this.parseDim();
    }

    private void parseDim() {
        List groupFieldList = this.context.getGroupFieldList();
        if (!CollectionUtils.isEmpty((Collection)groupFieldList)) {
            this.algoxParser.parseAndAddEntityFieldInfo(groupFieldList, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
        }
    }

    public List<Field> getDimCalculateFieldList() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> calculateFieldSet = new HashSet<String>();
        List complexObjFieldInfoList = this.context.getGroupFieldList();
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            String alias;
            AlgoXFieldInfo calculateFieldInfo;
            if (!"2".equals(complexObjFieldInfo.getFieldType()) && !"3".equals(complexObjFieldInfo.getFieldType()) || (calculateFieldInfo = this.algoxParser.getCalculateFieldInfo(alias = complexObjFieldInfo.getAlias())) == null || !calculateFieldSet.add(calculateFieldInfo.getAlgoXAlias())) continue;
            fieldList.add(calculateFieldInfo.buildAlgoField());
            Set refFieldAliasSet = complexObjFieldInfo.getRefFieldAliasSet();
            if (refFieldAliasSet == null) continue;
            for (String refFieldAlias : refFieldAliasSet) {
                AlgoXFieldInfo refCalFieldInfo = this.algoxParser.getCalculateFieldInfo(refFieldAlias);
                if (refCalFieldInfo == null || !calculateFieldSet.add(refCalFieldInfo.getAlgoXAlias())) continue;
                fieldList.add(refCalFieldInfo.buildAlgoField());
            }
        }
        return fieldList;
    }

    public List<AlgoXFieldInfo> getDimPluginFieldInfoList() {
        List complexObjFieldInfoList = this.context.getGroupFieldList();
        ArrayList fieldInfos = Lists.newArrayListWithExpectedSize((int)complexObjFieldInfoList.size());
        HashSet<String> pluginFieldSet = new HashSet<String>();
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            String alias;
            AlgoXFieldInfo pluginFieldInfo;
            if (!"4".equals(complexObjFieldInfo.getFieldType()) || (pluginFieldInfo = this.algoxParser.getPluginFieldInfo(alias = complexObjFieldInfo.getAlias())) == null || !pluginFieldSet.add(pluginFieldInfo.getAlgoXAlias())) continue;
            fieldInfos.add(pluginFieldInfo);
        }
        return fieldInfos;
    }

    public List<String> getDimDistinctAlgoXAliasList() {
        List complexObjFieldInfoList = this.context.getGroupFieldList();
        return this.algoxParser.getDistinctAlgoXAliasList(complexObjFieldInfoList);
    }

    public Map<String, AlgoXFieldInfo> getDimCalculateFieldInfoMap() {
        HashMap<String, AlgoXFieldInfo> resultMap = new HashMap<String, AlgoXFieldInfo>(16);
        List complexObjFieldInfoList = this.context.getGroupFieldList();
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            if (!"2".equals(complexObjFieldInfo.getFieldType()) && !"3".equals(complexObjFieldInfo.getFieldType())) continue;
            String alias = complexObjFieldInfo.getAlias();
            AlgoXFieldInfo calculateFieldInfo = this.algoxParser.getCalculateFieldInfo(alias);
            resultMap.put(alias, calculateFieldInfo);
            Set refFieldAliasSet = complexObjFieldInfo.getRefFieldAliasSet();
            if (refFieldAliasSet == null) continue;
            for (String refFieldAlias : refFieldAliasSet) {
                AlgoXFieldInfo refCalFieldInfo = this.algoxParser.getCalculateFieldInfo(refFieldAlias);
                if (refCalFieldInfo == null) continue;
                resultMap.put(refFieldAlias, refCalFieldInfo);
            }
        }
        return resultMap;
    }

    public Map<String, AlgoXFieldInfo> getDimPluginFieldInfoMap() {
        HashMap<String, AlgoXFieldInfo> resultMap = new HashMap<String, AlgoXFieldInfo>(16);
        List complexObjFieldInfoList = this.context.getGroupFieldList();
        for (HRComplexObjFieldInfo complexObjFieldInfo : complexObjFieldInfoList) {
            if (!"4".equals(complexObjFieldInfo.getFieldType())) continue;
            String alias = complexObjFieldInfo.getAlias();
            AlgoXFieldInfo pluginFieldInfo = this.algoxParser.getPluginFieldInfo(alias);
            resultMap.put(alias, pluginFieldInfo);
        }
        return resultMap;
    }

    public Collection<AlgoXFieldInfo> getMainEntityAlgoxFieldInfoCollection() {
        return this.mainEntityAlgoxFieldInfoMap.values();
    }

    public Map<String, AlgoXFieldInfo> getRelEntityFieldInfoMap(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias);
    }

    public Collection<AlgoXFieldInfo> getRelEntityFieldInfoCollection(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias).values();
    }
}

