/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.parser.specific;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.parser.AlgoXParser;
import kd.hr.hbp.business.service.complexobj.algox.parser.IAlgoXParser;
import kd.hr.hbp.business.service.complexobj.util.JoinExprUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.flink.api.java.tuple.Tuple2;

public class AlgoXRelEntityParser
implements IAlgoXParser {
    private static final long serialVersionUID = 4150472841524338118L;
    private final Map<String, Set<Tuple2<String, String>>> relEntityAliasOnAlgoxAliasMap = new HashMap<String, Set<Tuple2<String, String>>>();
    private final Map<String, Set<HRComplexObjConditionRow>> relEntityAliasAndConditionRowMap = new HashMap<String, Set<HRComplexObjConditionRow>>();
    private final Map<String, Set<HRComplexObjConditionRow>> mainEntityToRelAliasAndMainConditionRowMap = new HashMap<String, Set<HRComplexObjConditionRow>>();
    private final Map<String, Boolean> isMultiToOneCheckMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> combineJoinEntityMap = new HashMap<String, Boolean>();
    private final Map<String, AlgoXFieldInfo> mainEntityAlgoxFieldInfoMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final Map<String, Map<String, AlgoXFieldInfo>> relEntityAliasFieldInfoMap = new HashMap<String, Map<String, AlgoXFieldInfo>>();
    private final Map<String, AlgoXFieldInfo> entityNumberToPrimaryKeyMap = new LinkedHashMap<String, AlgoXFieldInfo>();
    private final HRComplexObjContext context;
    private final AlgoXParser algoxParser;
    private String realMainEntityAlias;
    private String realMainEntityNumber;

    public AlgoXRelEntityParser(HRComplexObjContext context, AlgoXParser algoxParser) {
        this.context = context;
        this.algoxParser = algoxParser;
        this.realMainEntityAlias = context.getEntityNumber();
        this.realMainEntityNumber = context.getEntityNumber();
        this.init();
    }

    @Override
    public final void init() {
        List joinRelationList = this.context.getJoinRelationList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.context.getEntityNumber());
        mainEntityType.getPrimaryKey().getName();
        this.algoxParser.addEntityFieldInfo(mainEntityType.getPrimaryKey().getName(), this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
        this.entityNumberToPrimaryKeyMap.put(this.context.getEntityNumber(), this.algoxParser.getNormalAlgoXFieldInfo(mainEntityType.getPrimaryKey().getName()));
        if (!CollectionUtils.isEmpty((Collection)joinRelationList)) {
            joinRelationList.forEach(joinRelation -> {
                String relEntityAlias = joinRelation.getRelEntityAlias();
                this.relEntityAliasOnAlgoxAliasMap.put(relEntityAlias, new HashSet());
                this.relEntityAliasAndConditionRowMap.put(relEntityAlias, new HashSet());
                this.combineJoinEntityMap.put(relEntityAlias, false);
                this.relEntityAliasFieldInfoMap.put(relEntityAlias, new LinkedHashMap());
            });
            this.parseJoinRelationList(joinRelationList);
        }
    }

    private void parseJoinRelationList(List<HRComplexObjJoinRelation> joinRelationList) {
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            List complexObjConditionRowList = joinRelation.getCondition();
            String relEntityAlias = joinRelation.getRelEntityAlias();
            String joinType = joinRelation.getJoinType();
            String relEntityNumber = this.algoxParser.getRelEntityNumber(relEntityAlias);
            MainEntityType relEntityType = mainEntityTypeUtil.getMainEntityType(relEntityNumber);
            ISimpleProperty primaryKey = relEntityType.getPrimaryKey();
            String relPrimaryAlias = relEntityAlias + "." + primaryKey.getName();
            this.algoxParser.addEntityFieldInfo(relPrimaryAlias, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
            this.entityNumberToPrimaryKeyMap.put(relEntityAlias, this.algoxParser.getNormalAlgoXFieldInfo(relPrimaryAlias));
            for (HRComplexObjConditionRow conditionRow : complexObjConditionRowList) {
                if (conditionRow.isRightFieldItem()) {
                    String fieldName;
                    Set<Tuple2<String, String>> joinEntityAliasOnFieldSet = this.relEntityAliasOnAlgoxAliasMap.get(relEntityAlias);
                    String leftItem = conditionRow.getLeftItem();
                    String rightItem = conditionRow.getRightItem();
                    String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(leftItem);
                    if (HRStringUtils.equals((String)prefixAlias, (String)relEntityAlias)) {
                        joinEntityAliasOnFieldSet.add((Tuple2<String, String>)new Tuple2((Object)rightItem, (Object)leftItem));
                        fieldName = leftItem.substring(relEntityAlias.length() + 1);
                        if (primaryKey.getName().equals(fieldName)) {
                            this.isMultiToOneCheckMap.put(relEntityAlias, Boolean.TRUE);
                        }
                    } else {
                        joinEntityAliasOnFieldSet.add((Tuple2<String, String>)new Tuple2((Object)leftItem, (Object)rightItem));
                        if (rightItem.contains(relEntityAlias)) {
                            fieldName = rightItem.substring(relEntityAlias.length() + 1);
                            if (primaryKey.getName().equals(fieldName)) {
                                this.isMultiToOneCheckMap.put(relEntityAlias, Boolean.TRUE);
                            }
                        }
                    }
                    this.algoxParser.addEntityFieldInfo(leftItem, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
                    this.algoxParser.addEntityFieldInfo(rightItem, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
                    continue;
                }
                String leftItem = conditionRow.getLeftItem();
                String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(leftItem);
                if (JoinType.LEFT.getName().equals(joinType) && !HRStringUtils.equals((String)prefixAlias, (String)relEntityAlias)) {
                    this.combineJoinEntityMap.put(relEntityAlias, true);
                } else if (JoinType.RIGHT.getName().equals(joinType) && HRStringUtils.equals((String)prefixAlias, (String)relEntityAlias)) {
                    this.combineJoinEntityMap.put(relEntityAlias, true);
                }
                if (!HRStringUtils.equals((String)prefixAlias, (String)relEntityAlias)) {
                    this.mainEntityToRelAliasAndMainConditionRowMap.putIfAbsent(relEntityAlias, new HashSet());
                    this.mainEntityToRelAliasAndMainConditionRowMap.computeIfPresent(relEntityAlias, (key, set) -> {
                        set.add(conditionRow);
                        return set;
                    });
                }
                this.relEntityAliasAndConditionRowMap.get(relEntityAlias).add(conditionRow);
                this.algoxParser.addEntityFieldInfo(leftItem, this.relEntityAliasFieldInfoMap, this.mainEntityAlgoxFieldInfoMap);
            }
            if (JoinType.RIGHT.getName().equals(joinType)) {
                this.realMainEntityAlias = joinRelation.getRelEntityAlias();
                this.realMainEntityNumber = joinRelation.getRelEntityNumber();
                continue;
            }
            if (JoinType.INNER.getName().equals(joinType)) {
                SortFieldInfo firstSortFieldInfo = this.algoxParser.getFirstSortFieldInfo();
                if (firstSortFieldInfo != null) {
                    String entityAlias = this.algoxParser.parseAliasReturnEntityAlias(firstSortFieldInfo.getFieldAlias());
                    if (joinRelation.getRelEntityAlias().equals(entityAlias)) {
                        this.realMainEntityAlias = joinRelation.getRelEntityAlias();
                        this.realMainEntityNumber = joinRelation.getRelEntityNumber();
                        continue;
                    }
                    this.realMainEntityAlias = this.context.getEntityNumber();
                    this.realMainEntityNumber = this.context.getEntityNumber();
                    continue;
                }
                this.realMainEntityAlias = this.context.getEntityNumber();
                this.realMainEntityNumber = this.context.getEntityNumber();
                continue;
            }
            this.realMainEntityAlias = this.context.getEntityNumber();
            this.realMainEntityNumber = this.context.getEntityNumber();
        }
    }

    public Set<Tuple2<String, String>> relEntityAliasOnAlgoXAliasSet(String relEntityAlias) {
        Set<Tuple2<String, String>> relEntityAliasOnFieldSet = this.relEntityAliasOnAlgoxAliasMap.get(relEntityAlias);
        Map<String, AlgoXFieldInfo> allFieldInfoMap = this.algoxParser.getAllFieldInfoMap();
        return relEntityAliasOnFieldSet.stream().map(joinEntityAliasOnField -> new Tuple2((Object)((AlgoXFieldInfo)allFieldInfoMap.get(joinEntityAliasOnField.f0)).getAlgoXAlias(), (Object)((AlgoXFieldInfo)allFieldInfoMap.get(joinEntityAliasOnField.f1)).getAlgoXAlias())).collect(Collectors.toSet());
    }

    public Set<Tuple2<String, String>> relEntityAliasOnRealFileNameSet(String relEntityAlias) {
        Set<Tuple2<String, String>> relEntityAliasOnFieldSet = this.relEntityAliasOnAlgoxAliasMap.get(relEntityAlias);
        Map<String, AlgoXFieldInfo> allFieldInfoMap = this.algoxParser.getAllFieldInfoMap();
        return relEntityAliasOnFieldSet.stream().map(joinEntityAliasOnField -> new Tuple2((Object)((AlgoXFieldInfo)allFieldInfoMap.get(joinEntityAliasOnField.f0)).getRealFieldName(), (Object)((AlgoXFieldInfo)allFieldInfoMap.get(joinEntityAliasOnField.f1)).getRealFieldName())).collect(Collectors.toSet());
    }

    public List<QFilter> getRelJoinQFilterList(String relEntityAlias, boolean isAllFilter) {
        ArrayList<QFilter> relQFilterList = new ArrayList<QFilter>();
        Set<HRComplexObjConditionRow> conditionRowSet = this.relEntityAliasAndConditionRowMap.get(relEntityAlias);
        for (HRComplexObjConditionRow conditionRow : conditionRowSet) {
            String leftItem = conditionRow.getLeftItem();
            String prefixAlias = this.algoxParser.parseAliasReturnRelEntityAlias(leftItem);
            if (!isAllFilter && !relEntityAlias.equals(prefixAlias)) continue;
            QFilter qFilter = this.conditionTransToQfilter(conditionRow);
            qFilter.__setProperty(leftItem);
            relQFilterList.add(qFilter);
        }
        this.addRelExtraQFilters(relEntityAlias, relQFilterList, false);
        return relQFilterList;
    }

    private QFilter conditionTransToQfilter(HRComplexObjConditionRow conditionRow) {
        QFilter qFilter;
        String leftItem = conditionRow.getLeftItem();
        String rightItemVal = conditionRow.getRightItem();
        String compareOp = conditionRow.getCompareOp();
        if ("in".equals(compareOp) || "not in".equals(compareOp)) {
            String[] split = rightItemVal.split(",");
            String firstFilterVal = split[0];
            if (JoinExprUtil.isDateExpr(firstFilterVal)) {
                ArrayList<Date> filterDateList = new ArrayList<Date>(split.length);
                for (String filterDateStr : split) {
                    Date date;
                    try {
                        date = JoinExprUtil.exprToDate(filterDateStr);
                    }
                    catch (ParseException e) {
                        throw new KDBizException("date error:" + rightItemVal);
                    }
                    filterDateList.add(date);
                }
                qFilter = new QFilter(this.algoxParser.getAlgoXAliasByAlias(leftItem), compareOp, filterDateList);
            } else {
                qFilter = QFilter.of((String)(this.algoxParser.getAlgoXAliasByAlias(leftItem) + " " + compareOp + " (" + rightItemVal + ")"), (Object[])new Object[0]);
            }
        } else if ("=".equals(compareOp) || "!=".equals(compareOp)) {
            if (JoinExprUtil.isDateExpr(rightItemVal)) {
                Date date;
                try {
                    date = JoinExprUtil.exprToDate(rightItemVal);
                }
                catch (ParseException e) {
                    throw new KDBizException("date error:" + rightItemVal);
                }
                qFilter = new QFilter(this.algoxParser.getAlgoXAliasByAlias(leftItem), compareOp, (Object)date);
            } else {
                qFilter = QFilter.of((String)(this.algoxParser.getAlgoXAliasByAlias(leftItem) + " " + compareOp + " " + rightItemVal), (Object[])new Object[0]);
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6bd4\u8f83\u7b26\u7c7b\u578b\uff1a%1$s\u3002", (String)"AlgoXRelEntityParser_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), compareOp));
        }
        return qFilter;
    }

    private void addRelExtraQFilters(String relEntityAlias, List<QFilter> relQFilterList, boolean isMain) {
        Set<Tuple2<String, String>> tuple2Set = this.relEntityAliasOnAlgoxAliasMap.get(relEntityAlias);
        String entityAlias = isMain ? this.context.getEntityNumber() : relEntityAlias;
        MainEntityType entityType = this.algoxParser.getEntityTypeByAlias(entityAlias);
        for (Tuple2<String, String> tuple2 : tuple2Set) {
            String relFieldName;
            String string = relFieldName = isMain ? (String)tuple2.f0 : ((String)tuple2.f1).substring(relEntityAlias.length() + 1);
            if (relFieldName.contains(".")) {
                String[] split = relFieldName.split("\\.");
                Map allEntities = entityType.getAllEntities();
                EntityType entryType = (EntityType)allEntities.get(split[0]);
                DynamicProperty property = entryType != null ? entryType.getProperty(split[1]) : entityType.getProperty(split[0]);
                this.addQFilterByPropertyType(property, relQFilterList, relFieldName);
                continue;
            }
            DynamicProperty property = entityType.getProperty(relFieldName);
            this.addQFilterByPropertyType(property, relQFilterList, relFieldName);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void addQFilterByPropertyType(DynamicProperty property, List<QFilter> relQFilterList, String relFieldName) {
        if (property instanceof BasedataProp) {
            IDataEntityType complexType = ((BasedataProp)property).getComplexType();
            ISimpleProperty primaryKey = complexType.getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                if (relFieldName.endsWith(".id")) {
                    relQFilterList.add(new QFilter(relFieldName, ">", (Object)0L));
                } else {
                    relQFilterList.add(new QFilter(relFieldName.substring(0, relFieldName.lastIndexOf(46)) + ".id", ">", (Object)0L));
                }
            } else {
                relQFilterList.add(new QFilter(relFieldName, "is not null", null));
            }
        } else if (property instanceof LongProp) {
            relQFilterList.add(new QFilter(relFieldName, ">", (Object)0L));
        } else {
            relQFilterList.add(new QFilter(relFieldName, "is not null", null));
        }
    }

    public List<QFilter> getMainJoinQFilterList(String relEntityAlias) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Set<HRComplexObjConditionRow> conditionRowSet = this.mainEntityToRelAliasAndMainConditionRowMap.get(relEntityAlias);
        if (conditionRowSet != null) {
            for (HRComplexObjConditionRow conditionRow : conditionRowSet) {
                String leftItem = conditionRow.getLeftItem();
                QFilter qFilter = this.conditionTransToQfilter(conditionRow);
                qFilter.__setProperty(leftItem);
                qFilterList.add(qFilter);
            }
        }
        this.addRelExtraQFilters(relEntityAlias, qFilterList, true);
        return qFilterList;
    }

    public Boolean checkIsMultiToOne(String relEntityAlias) {
        return this.isMultiToOneCheckMap.getOrDefault(relEntityAlias, Boolean.FALSE);
    }

    public boolean containsCombineJoinEntity(String relEntityAlias) {
        return this.combineJoinEntityMap.get(relEntityAlias);
    }

    public Collection<AlgoXFieldInfo> getMainEntityAlgoxFieldInfoCollection() {
        return this.mainEntityAlgoxFieldInfoMap.values();
    }

    public Collection<AlgoXFieldInfo> getRelEntityFieldInfoCollection(String relEntityAlias) {
        return this.relEntityAliasFieldInfoMap.get(relEntityAlias).values();
    }

    public AlgoXFieldInfo getEntityPrimaryFieldInfo(String entityAlias) {
        return this.entityNumberToPrimaryKeyMap.get(entityAlias);
    }

    public Collection<AlgoXFieldInfo> getEntityPrimaryFieldInfoCollection(String entityAlias) {
        return Lists.newArrayList((Object[])new AlgoXFieldInfo[]{this.getEntityPrimaryFieldInfo(entityAlias)});
    }

    public String getRealMainEntityAlias() {
        return this.realMainEntityAlias;
    }

    public String getRealMainEntityNumber() {
        return this.realMainEntityNumber;
    }
}

