/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.algox.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.algox.utils.ComplexObjContextUtils;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.ObjectUtils;

public class FilterUtils {
    public static Map<String, Set<Object>> getFilterData(List<AlgoXFieldInfo> selectFieldInfos, String entityNumber, List<QFilter> qFilters) {
        return FilterUtils.getFilterData(selectFieldInfos, entityNumber, qFilters, -1, -1, true, null);
    }

    public static Map<String, Set<Object>> getFilterData(List<AlgoXFieldInfo> selectFieldInfos, String entityNumber, List<QFilter> qFilters, int start, int limit, boolean distinct, SortFieldInfo sortFieldInfo) {
        if (qFilters == null) {
            qFilters = new ArrayList<QFilter>(0);
        }
        Field[] fields = (Field[])selectFieldInfos.stream().map(fieldInfo -> new Field(fieldInfo.getRealFieldName(), fieldInfo.getRealFieldName(), AlgoDataTypeTransUtil.getDataType(fieldInfo.getFieldInfo().getDataType()), false)).toArray(Field[]::new);
        HRComplexObjContext singleQueryContext = ComplexObjContextUtils.createSingleQueryContext(entityNumber, qFilters.toArray(new QFilter[0]), new RowMeta(fields), sortFieldInfo);
        if (distinct) {
            singleQueryContext.setDistinct(true);
        }
        singleQueryContext.setAlgoXDetailOptimize(false);
        ReportQueryService queryService = new ReportQueryService(singleQueryContext);
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dataSet = queryService.queryDataSet(start, limit);){
            for (Row row : dataSet) {
                for (Field field : fields) {
                    Object value = row.get(field.getAlias());
                    data.putIfAbsent(field.getAlias(), Sets.newHashSetWithExpectedSize((int)16));
                    data.computeIfPresent(field.getAlias(), (key, oldSet) -> {
                        oldSet.add(value);
                        return oldSet;
                    });
                }
            }
        }
        return data;
    }

    public static List<QFilter> addFilterAndMerge(List<QFilter> qFilterList, QFilter filter) {
        QFilter copy;
        if (qFilterList == null) {
            qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        }
        String filterProperty = filter.getProperty();
        Object filterOriginValue = filter.getOriginValue();
        boolean isMerge = false;
        for (int index = 0; index < qFilterList.size(); ++index) {
            Object originValue;
            QFilter qFilter = (QFilter)qFilterList.get(index);
            String property = qFilter.getProperty();
            if (!property.equals(filterProperty) || !((originValue = (copy = qFilter.copy()).getOriginValue()) instanceof Collection) || !(filterOriginValue instanceof Collection) || !filter.getCP().equals(copy.getCP())) continue;
            HashSet newSet = new HashSet((Collection)originValue);
            if ("in".equals(filter.getCP())) {
                newSet.retainAll((Collection)filterOriginValue);
            } else {
                newSet.addAll((Collection)filterOriginValue);
            }
            newSet.remove(null);
            copy.__setValue(newSet);
            isMerge = true;
            qFilterList.set(index, copy);
            break;
        }
        if (!isMerge) {
            boolean find = false;
            block1: for (QFilter qFilter : qFilterList) {
                copy = qFilter.__copy(false);
                if (FilterUtils.QFilterEquals(copy, filter)) {
                    find = true;
                    break;
                }
                List nests = qFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    String op = nest.getOp();
                    if (!"AND".equals(op) || !FilterUtils.QFilterEquals(nest.getFilter(), filter)) continue;
                    find = true;
                    continue block1;
                }
            }
            if (!find) {
                qFilterList.add(filter);
            }
        }
        return qFilterList;
    }

    public static boolean checkQFilterIsEmpty(Collection<QFilter> qFilterList) {
        if (qFilterList == null || qFilterList.isEmpty()) {
            return true;
        }
        for (QFilter temp : qFilterList) {
            if (temp == null) continue;
            if (HRStringUtils.equals((String)temp.getProperty(), (String)"1")) {
                List nests = temp.getNests(true);
                if (nests == null) continue;
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    if (nestFilter == null || HRStringUtils.equals((String)nestFilter.getProperty(), (String)"1")) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean QFilterEquals(QFilter qFilter1, QFilter qFilter2) {
        if (qFilter1 == null && qFilter2 != null) {
            return false;
        }
        if (qFilter1 != null && qFilter2 == null) {
            return false;
        }
        if (qFilter1 == null) {
            return true;
        }
        String property1 = qFilter1.getProperty();
        String cp1 = qFilter1.getCP();
        Object value1 = qFilter1.getValue();
        String property2 = qFilter2.getProperty();
        String cp2 = qFilter2.getCP();
        Object value2 = qFilter2.getValue();
        if (!ObjectUtils.equals((Object)property1, (Object)property2)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)cp1, (Object)cp2)) {
            return false;
        }
        return ObjectUtils.equals((Object)value1, (Object)value2);
    }
}

