/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.datatype;

import com.alibaba.fastjson.JSONArray;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.hr.hbp.business.service.complexobj.datatype.ObjectArrayType;

public class LongArrayType
extends ObjectArrayType {
    private static final long serialVersionUID = -6214936514807880347L;
    public static final LongArrayType INSTANCE = new LongArrayType();

    protected LongArrayType() {
        super(1, "LongArray");
    }

    @Override
    public int getFixedSize() {
        return 0;
    }

    @Override
    public int getSqlType() {
        return 1111;
    }

    @Override
    public Class<?> getJavaType() {
        return long[].class;
    }

    @Override
    public boolean acceptsType(DataType dataType) {
        return dataType instanceof LongArrayType;
    }

    @Override
    public void write(Object value, DataOutputStream output) throws IOException {
        this.write(value, (DataOutput)output);
    }

    @Override
    public Object read(DataInputStream input) throws IOException {
        return this.read((DataInput)input);
    }

    @Override
    public void write(Object value, DataOutput target) throws IOException {
        if (value == null) {
            target.writeInt(0);
        } else {
            long[] longArray = (long[])value;
            target.writeInt(longArray.length + 1);
            for (long longValue : longArray) {
                target.writeLong(longValue);
            }
        }
    }

    @Override
    public Object read(DataInput source) throws IOException {
        int len = source.readInt();
        if (len == 0) {
            return null;
        }
        long[] longArray = new long[len - 1];
        for (int index = 0; index < longArray.length; ++index) {
            longArray[index] = source.readLong();
        }
        return longArray;
    }

    public Object convertValue(Object value) {
        if (this.ordinal == 1) {
            if (value instanceof long[] || value instanceof Long[]) {
                return JSONArray.toJSONString((Object)value);
            }
            throw new AlgoException("Can't cast %s to %s", new Object[]{String.valueOf(value), this.name});
        }
        return super.convertValue(value);
    }

    public static LongArrayType getInstance() {
        return INSTANCE;
    }
}

