/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.privacy.PrivacyDataQuery;
import kd.hr.hbp.business.service.complexobj.ksql.ComplexSpecialFielder;
import kd.hr.hbp.business.service.complexobj.model.ComplexTableInfo;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class ComplexPrivacyFiledLoader
extends ComplexSpecialFielder {
    private static final Log LOGGER = LogFactory.getLog(ComplexPrivacyFiledLoader.class);

    public ComplexPrivacyFiledLoader(boolean needLoad) {
        super(needLoad);
    }

    @Override
    protected Map<String, Map<Object, Object>> getSpecialFileData(ComplexTableInfo queryTableInfo) {
        String table = queryTableInfo.getTable();
        Set<String> specialFieldAliasSet = queryTableInfo.getDbDecFieldAliasSet();
        if (specialFieldAliasSet.isEmpty() || HRStringUtils.isEmpty((String)table)) {
            return Collections.emptyMap();
        }
        HashSet<String> fieldAliasSet = new HashSet<String>(specialFieldAliasSet);
        Set<String> mulFields = queryTableInfo.getMulFields();
        fieldAliasSet.removeAll(mulFields);
        MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(queryTableInfo.getEntityName());
        ArrayList<Object> pkLists = new ArrayList<Object>(queryTableInfo.getPkList());
        HashMap<String, Map<Object, Object>> specialFileDataMap = new HashMap<String, Map<Object, Object>>(16);
        if (pkLists.isEmpty()) {
            return specialFileDataMap;
        }
        try {
            Map values = PrivacyDataQuery.getValues((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)table, pkLists, fieldAliasSet, mulFields);
            for (Map.Entry idEntry : values.entrySet()) {
                String pkStr = (String)idEntry.getKey();
                Map entryFieldMap = (Map)idEntry.getValue();
                for (Map.Entry fieldEntry : entryFieldMap.entrySet()) {
                    Object primaryKey;
                    String fieldKey = (String)fieldEntry.getKey();
                    String[] fieldKeys = fieldKey.split("#\\$");
                    String filed = fieldKeys[0];
                    Map<Object, Object> fieldMap = MapCacheUtil.getMapMapVal(specialFileDataMap, filed);
                    Long pkLong = null;
                    try {
                        pkLong = Long.parseLong(pkStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Object object = primaryKey = pkLong != null ? pkLong : pkStr;
                    if (mulFields.contains(filed) && "GLang".equals(fieldKeys[1])) {
                        fieldMap.computeIfAbsent(primaryKey, ks -> fieldEntry.getValue());
                    } else {
                        fieldMap.put(primaryKey, fieldEntry.getValue());
                    }
                    specialFileDataMap.put(filed, fieldMap);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u9690\u79c1\u4e2d\u5fc3\u52a0\u5bc6\u5b57\u6bb5\u67e5\u8be2\u5931\u8d25\u3002", (String)"ComplexPrivacyFiledLoader_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return specialFileDataMap;
    }

    @Override
    public void setValue(Map<String, Object> dataMap, ComplexTableInfo complexTableInfo, String fieldName, Object fieldVal) {
        if (HRObjectUtils.isEmpty((Object)fieldVal)) {
            return;
        }
        dataMap.put(fieldName, fieldVal);
    }

    @Override
    protected Predicate<? super EntityFieldInfo> fieldFilter() {
        return EntityFieldInfo::isPrivacyField;
    }

    @Override
    public String specialCondition() {
        return null;
    }
}

