/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.model.ComplexTableInfo;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public abstract class ComplexSpecialFielder {
    private static final Log LOGGER = LogFactory.getLog(ComplexSpecialFielder.class);
    private final boolean needLoad;
    public MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public ComplexSpecialFielder(boolean needLoad) {
        this.needLoad = needLoad;
    }

    public boolean isNeedLoad() {
        return this.needLoad;
    }

    public void reloadSpecialField(List<Map<String, Object>> listDB, HRComplexObjContext complexObjCont, List<EntityFieldInfo> fieldInfoList) {
        if (!this.isNeedLoad()) {
            return;
        }
        List<ComplexTableInfo> queryTableInfoList = this.parseQuerySpecialField(complexObjCont.getEntityNumber(), fieldInfoList);
        this.setSpecialTbPkField(listDB, queryTableInfoList);
        this.querySpecialFiledData(queryTableInfoList);
        this.fillDyoCollSpecialFielData(listDB, queryTableInfoList);
    }

    private void fillDyoCollSpecialFielData(List<Map<String, Object>> listDB, List<ComplexTableInfo> complexTableInfoList) {
        for (ComplexTableInfo complexTableInfo : complexTableInfoList) {
            String pkField = complexTableInfo.getPkAlias();
            Map<String, Map<Object, Object>> dbDecFieldVal = complexTableInfo.getDbDecFieldVal();
            dbDecFieldVal.forEach((fieldAlias, idData) -> {
                String realField = complexTableInfo.getDbDecFieldAliasMap().get(fieldAlias);
                for (Map dataMap : listDB) {
                    Object pkObj = dataMap.get(pkField);
                    if (pkObj == null) continue;
                    Object fieldVal = idData.get(Long.valueOf((String)pkObj));
                    if (fieldVal == null) {
                        fieldVal = idData.get(pkObj);
                    }
                    this.setValue(dataMap, complexTableInfo, realField, fieldVal);
                }
            });
        }
    }

    public abstract void setValue(Map<String, Object> var1, ComplexTableInfo var2, String var3, Object var4);

    protected abstract Predicate<? super EntityFieldInfo> fieldFilter();

    protected String getFieldTable(EntityFieldInfo fieldInfo) {
        return fieldInfo.getTable();
    }

    private List<ComplexTableInfo> parseQuerySpecialField(String mainEntityNumber, List<EntityFieldInfo> fieldInfos) {
        List fieldInfoList = fieldInfos.stream().filter(this.fieldFilter()).collect(Collectors.toList());
        HashMap<String, ComplexTableInfo> tableFieldMap = new HashMap<String, ComplexTableInfo>(fieldInfoList.size());
        for (EntityFieldInfo fieldInfo : fieldInfoList) {
            String fieldEntityAlias;
            String tableName = this.getFieldTable(fieldInfo);
            ComplexTableInfo complexTableInfo = (ComplexTableInfo)tableFieldMap.get(tableName);
            if (Objects.isNull(complexTableInfo)) {
                complexTableInfo = new ComplexTableInfo(fieldInfo.getFieldEntityNumber(), tableName, fieldInfo.getPkField(), fieldInfo.getPkDbField());
                complexTableInfo.setDbDecFieldAliasSet(new HashSet<String>(16));
                complexTableInfo.setMulFields(new HashSet<String>(16));
                complexTableInfo.setDbDecFieldAliasMap(new HashMap<String, String>(16));
            }
            fieldEntityAlias = mainEntityNumber.equals(fieldEntityAlias = fieldInfo.getFieldEntityAlias()) ? "" : fieldEntityAlias + ".";
            complexTableInfo.setPkAlias(fieldEntityAlias + fieldInfo.getPkField());
            complexTableInfo.setFieldAliasPrex(fieldEntityAlias);
            complexTableInfo.getDbDecFieldAliasSet().add(fieldInfo.getDbField());
            complexTableInfo.getDbDecFieldAliasMap().put(fieldInfo.getDbField(), fieldInfo.getAlias());
            if (fieldInfo.isMultiLangField()) {
                complexTableInfo.getMulFields().add(fieldInfo.getDbField());
            }
            tableFieldMap.put(tableName, complexTableInfo);
        }
        return new ArrayList<ComplexTableInfo>(tableFieldMap.values());
    }

    private void setSpecialTbPkField(List<Map<String, Object>> listDB, List<ComplexTableInfo> complexTableInfoList) {
        for (ComplexTableInfo complexTableInfo : complexTableInfoList) {
            HashSet<Object> pkList = new HashSet<Object>(listDB.size());
            for (Map<String, Object> dataMap : listDB) {
                Object pkObj = dataMap.get(complexTableInfo.getPkAlias());
                if (pkObj == null) continue;
                Long pk = Long.valueOf((String)pkObj);
                pkList.add(pk);
            }
            complexTableInfo.setPkList(pkList);
        }
    }

    private void querySpecialFiledData(List<ComplexTableInfo> complexTableInfoList) {
        for (ComplexTableInfo complexTableInfo : complexTableInfoList) {
            Map<String, Map<Object, Object>> dbDecFieldValMap = this.getSpecialFileData(complexTableInfo);
            complexTableInfo.setDbDecFieldVal(dbDecFieldValMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<Object, Object>> getSpecialFileData(ComplexTableInfo queryTableInfo) {
        HashMap<String, Map<Object, Object>> dbDecFieldValMap = new HashMap<String, Map<Object, Object>>(16);
        if (!(queryTableInfo.getDbDecFieldAliasSet().isEmpty() || HRStringUtils.isEmpty((String)queryTableInfo.getTable()) || CollectionUtils.isEmpty(queryTableInfo.getPkList()))) {
            MainEntityType entityType = this.mainEntityTypeUtil.getMainEntityType(queryTableInfo.getEntityName());
            String idString = this.stringJoin(queryTableInfo.getPkList(), ",");
            String selectField = String.join((CharSequence)",", queryTableInfo.getDbDecFieldAliasSet());
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" select ").append(queryTableInfo.getPkDbField()).append(", ").append(selectField);
            selectSql.append(" from ").append(queryTableInfo.getTable());
            try (PKTempTable tempTable = null;){
                String inSQL = "";
                if (queryTableInfo.getPkList().size() >= 5000) {
                    tempTable = PKTempTables.createPKLong((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()));
                    tempTable.insert(queryTableInfo.getPkList());
                    inSQL = " in (SELECT FID FROM " + tempTable.getName() + ") ";
                } else {
                    inSQL = " in ( " + idString + " ) ";
                }
                selectSql.append(" where ").append(queryTableInfo.getPkDbField()).append(inSQL);
                selectSql.append(this.specialCondition());
                HRDBUtil.query((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)selectSql.toString(), null, resultSet -> {
                    while (resultSet.next()) {
                        Object idVal = resultSet.getObject(queryTableInfo.getPkDbField());
                        for (String decField : queryTableInfo.getDbDecFieldAliasSet()) {
                            HashMap<Object, Object> idDataMap = (HashMap<Object, Object>)dbDecFieldValMap.get(decField);
                            if (idDataMap == null) {
                                idDataMap = new HashMap<Object, Object>();
                            }
                            idDataMap.put(idVal, resultSet.getObject(decField));
                            dbDecFieldValMap.put(decField, idDataMap);
                        }
                    }
                    return null;
                });
            }
        }
        return dbDecFieldValMap;
    }

    public abstract String specialCondition();

    private String stringJoin(Set<Object> set, String spliter) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        boolean isString = false;
        for (Object object : set) {
            if (index == 0) {
                if (object instanceof String) {
                    isString = true;
                }
                if (isString) {
                    sb.append("'").append(object).append("'");
                } else {
                    sb.append(object);
                }
            } else if (isString) {
                sb.append(',').append("'").append(object).append("'");
            } else {
                sb.append(',').append(object);
            }
            ++index;
        }
        return sb.toString();
    }
}

