/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.Collection;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.CustomSortInfo;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;
import org.apache.commons.collections.CollectionUtils;

public class KSqlCustomSortParser {
    private static final Log LOGGER = LogFactory.getLog(KSqlCustomSortParser.class);
    private final KSqlParser kSqlParser;

    public KSqlCustomSortParser(KSqlParser kSqlParser) {
        this.kSqlParser = kSqlParser;
    }

    public String getCustomSortSql() {
        StringBuilder joinSql = new StringBuilder(" ");
        List sortFieldInfoList = this.kSqlParser.getComplexObjCont().getSortFieldInfoList();
        if (CollectionUtils.isEmpty((Collection)sortFieldInfoList)) {
            return joinSql.toString();
        }
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        for (EntityFieldInfo fieldInfo : entityFieldInfoList) {
            CustomSortInfo customSortInfo = fieldInfo.getCustomSortInfo();
            if (customSortInfo == null) continue;
            Long customSortPk = customSortInfo.getCustomSortPk();
            if (customSortPk == null) {
                LOGGER.warn("custom_sort customSortPk is null: {} ", (Object)customSortInfo);
                continue;
            }
            String sortTable = customSortInfo.getSortTable();
            String customTbAlias = "custom_sort" + customSortInfo.getSeq();
            String valueType = customSortInfo.getValueType();
            String joinField = valueType.equals("long") ? "flong" : "fstring";
            String tableAlias = this.kSqlParser.getTableAlias(fieldInfo.getFieldEntityAlias(), fieldInfo.getTable());
            joinSql.append(' ').append(KsqlJoinHint.LEFTJOIN.getJoin()).append(' ').append(sortTable).append(' ').append(customTbAlias).append(" ON ").append(customTbAlias).append('.').append("fentitysortfieldid").append(" = ").append(customSortPk).append(" AND ").append(customTbAlias).append('.').append(joinField).append(" = ").append(tableAlias).append('.').append(fieldInfo.getDbField()).append(' ');
        }
        return joinSql.toString();
    }
}

