/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlTableParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.JoinConditionRowDetail;
import kd.hr.hbp.business.service.complexobj.model.JoinEntityRelation;
import kd.hr.hbp.business.service.complexobj.model.JoinFieldDetail;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.JoinExprUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.QUnknownValue;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;

public class KSqlFromParser {
    private final HRComplexObjContext complexObjCont;
    private final KSqlParser kSqlParser;
    private final KSqlTableParser tableParser;
    private final Map<String, EntityFieldInfo> entityFieldInfoMap;
    private final Map<String, String> splitTbJoinCondMap;
    private static final String conditionOn = " ON ";
    private static final String conditionAnd = " AND ";
    private static final String conditionLocalId = "FLOCALEID = ";
    private static final int tmpTableThresh = 1000;

    public KSqlFromParser(HRComplexObjContext complexObjCont, KSqlParser kSqlParser) {
        this.complexObjCont = complexObjCont;
        this.kSqlParser = kSqlParser;
        this.tableParser = new KSqlTableParser(complexObjCont, kSqlParser);
        this.entityFieldInfoMap = kSqlParser.getEntityFieldInfoList().stream().collect(Collectors.toMap(EntityFieldInfo::getAlias, Function.identity(), (x, y) -> x));
        this.splitTbJoinCondMap = new HashMap<String, String>(10);
    }

    public String getTableFromSql(Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        HashMap<String, Set<String>> loadRecordAliasMap = new HashMap<String, Set<String>>();
        return this.getMustTableFromSql(loadRecordAliasMap, tmpTableSQLOfSyncMap) + this.genMuliLangTableSql(loadRecordAliasMap) + this.genTableGroupSql(loadRecordAliasMap);
    }

    private String getMustTableFromSql(Map<String, Set<String>> loadRecordAliasMap, Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        StringBuilder fromSqlSb = new StringBuilder(" FROM ");
        String editEntityTable = this.complexObjCont.getEntityTable();
        String editEntityTableAlias = this.kSqlParser.getTableAlias(this.complexObjCont.getEntityNumber(), editEntityTable);
        fromSqlSb.append(this.composeSimpleFromSql(editEntityTable, "", editEntityTableAlias, ""));
        HashSet<String> mainTbSet = new HashSet<String>(5);
        mainTbSet.add(this.complexObjCont.getEntityTable());
        loadRecordAliasMap.put(this.complexObjCont.getEntityNumber(), mainTbSet);
        fromSqlSb.append(this.genJoinRelationSql(loadRecordAliasMap, tmpTableSQLOfSyncMap));
        fromSqlSb.append(this.genEntryTableSql(loadRecordAliasMap));
        fromSqlSb.append(this.genSubEntryParentTableSql(loadRecordAliasMap));
        fromSqlSb.append(this.genSubEntryTableSql(loadRecordAliasMap));
        return fromSqlSb.toString();
    }

    private String genJoinRelationSql(Map<String, Set<String>> loadRecordAliasMap, Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        List joinRelationList = this.complexObjCont.getJoinRelationList();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        StringBuilder joinSql = new StringBuilder(" ");
        for (HRComplexObjJoinRelation anObjJoinRelation : joinRelationList) {
            joinSql.append(this.genJoinSql(this.complexObjCont.getEntityNumber(), anObjJoinRelation, loadRecordAliasMap, entityTableAlias, tmpTableSQLOfSyncMap));
        }
        return joinSql.toString();
    }

    private String genJoinSql(String mainEntityNumber, HRComplexObjJoinRelation anObjJoinRelation, Map<String, Set<String>> loadRecordAliasMap, Map<String, Map<String, String>> entityTableAlias, Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        JoinEntityRelation joinEntityRelation = JoinExprUtil.conditionTrans(mainEntityNumber, anObjJoinRelation, this.kSqlParser.getRelEntityMap(), this.entityFieldInfoMap);
        LinkedHashMap<String, String> joinSqlMap = new LinkedHashMap<String, String>(16);
        Set<String> mainEntityLoadCache = MapCacheUtil.getMapSetVal(loadRecordAliasMap, anObjJoinRelation.getEntityAlias());
        StringBuilder rstSql = new StringBuilder(" ");
        List<JoinConditionRowDetail> joinRowList = joinEntityRelation.getJoinRowList();
        if (joinEntityRelation.isJoinAble()) {
            joinRowList.sort(Comparator.comparingInt(JoinConditionRowDetail::getJoinNum));
        } else {
            joinRowList.sort(Comparator.comparingInt(JoinConditionRowDetail::getJoinNum).reversed());
        }
        String firstJoinTb = null;
        for (JoinConditionRowDetail joinConditionRowDetail : joinRowList) {
            String mainJoinSqlStr = this.tryJoinMainTableSpliTb(anObjJoinRelation, entityTableAlias, mainEntityLoadCache, joinConditionRowDetail);
            rstSql.append(mainJoinSqlStr);
            firstJoinTb = this.genJoinFieldItemSql(loadRecordAliasMap, entityTableAlias, joinEntityRelation, joinSqlMap, firstJoinTb, joinConditionRowDetail);
        }
        for (JoinConditionRowDetail joinConditionRowDetail : joinRowList) {
            this.genJoinFieldFilterSql(entityTableAlias, joinSqlMap, firstJoinTb, joinConditionRowDetail, tmpTableSQLOfSyncMap);
        }
        loadRecordAliasMap.put(anObjJoinRelation.getEntityAlias(), mainEntityLoadCache);
        for (String value : joinSqlMap.values()) {
            rstSql.append(value);
        }
        return rstSql.toString();
    }

    private void genJoinFieldFilterSql(Map<String, Map<String, String>> entityTableAlias, LinkedHashMap<String, String> joinSqlMap, String firstJoinTb, JoinConditionRowDetail joinConditionRowDetail, Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        if (joinConditionRowDetail.getConditionRow().isRightFieldItem()) {
            return;
        }
        JoinFieldDetail leftField = joinConditionRowDetail.getLeftField();
        String rightItemStr = joinConditionRowDetail.getConditionRow().getRightItem();
        StringBuilder conditionAndSql = new StringBuilder(conditionAnd);
        if (QUnknownValue.value.toString().equals(rightItemStr)) {
            conditionAndSql.append("1!=1");
        } else {
            Map<String, String> tableAliasMap = entityTableAlias.get(leftField.getFieldInfo().getFieldEntityAlias());
            String fieldTbAlias = tableAliasMap.get(leftField.getFieldRealTable());
            conditionAndSql.append(fieldTbAlias).append(".").append(leftField.getFieldInfo().getDbField()).append(" ");
            String compareOp = joinConditionRowDetail.getConditionRow().getCompareOp();
            conditionAndSql.append(compareOp);
            conditionAndSql.append(" ");
            if ("like".equals(compareOp) || "not like".equals(compareOp)) {
                if (rightItemStr.endsWith("'")) {
                    rightItemStr = rightItemStr.substring(0, rightItemStr.lastIndexOf("'"));
                    rightItemStr = rightItemStr + "%'";
                }
                conditionAndSql.append(rightItemStr);
            } else if ("in".equals(compareOp) || "not in".equals(compareOp)) {
                Object[] split = rightItemStr.split(",");
                if (split.length < 1000) {
                    conditionAndSql.append("(");
                    conditionAndSql.append(rightItemStr);
                    conditionAndSql.append(")");
                } else {
                    String param1 = split[0];
                    Date date = null;
                    try {
                        date = HRDateTimeUtils.parseDate((String)param1.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNumeric((String)split[0])) {
                        Object[] params = Arrays.stream(split).map(Long::parseLong).toArray();
                        String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(this.kSqlParser.getDBRoute(), params, tmpTableSQLOfSyncMap);
                        conditionAndSql.append(tmpTableName);
                    } else if (split[0].startsWith("'") && split[0].endsWith("\u2018")) {
                        Object[] params = Arrays.stream(split).map(str -> str.substring(1, str.length() - 1)).toArray();
                        String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(this.kSqlParser.getDBRoute(), params, tmpTableSQLOfSyncMap);
                        conditionAndSql.append(tmpTableName);
                    } else {
                        String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(this.kSqlParser.getDBRoute(), split, tmpTableSQLOfSyncMap, date != null);
                        conditionAndSql.append(tmpTableName);
                    }
                }
            } else {
                conditionAndSql.append(rightItemStr);
            }
            conditionAndSql.append(" ");
        }
        String joinTb = leftField.getFieldRealTable();
        if (leftField.isMainEntityField()) {
            joinTb = firstJoinTb;
        }
        String condiTionStr = conditionAndSql.toString();
        String joinSql = joinSqlMap.get(joinTb);
        if (joinSql == null) {
            String joinCondSql = this.splitTbJoinCondMap.get(joinTb);
            joinCondSql = joinCondSql == null ? " " : joinCondSql;
            this.splitTbJoinCondMap.put(joinTb, joinCondSql + condiTionStr);
        } else {
            joinSqlMap.put(joinTb, joinSql + condiTionStr);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String genJoinFieldItemSql(Map<String, Set<String>> loadRecordAliasMap, Map<String, Map<String, String>> entityTableAlias, JoinEntityRelation joinEntityRelation, LinkedHashMap<String, String> joinSqlMap, String firstJoinTb, JoinConditionRowDetail joinConditionRowDetail) {
        String joinConditionSql;
        Set<String> rightFieldCache;
        if (!joinConditionRowDetail.getConditionRow().isRightFieldItem()) {
            return firstJoinTb;
        }
        JoinFieldDetail leftField = joinConditionRowDetail.getLeftField();
        JoinFieldDetail rightField = joinConditionRowDetail.getRightField();
        if (!leftField.isMainEntityField() && rightField.isMainEntityField()) {
            JoinFieldDetail temp = rightField;
            rightField = leftField;
            leftField = temp;
        }
        if (firstJoinTb == null) {
            firstJoinTb = rightField.getFieldRealTable();
        }
        StringBuilder conditionSql = new StringBuilder();
        Map<String, String> tableAliasMap = entityTableAlias.get(leftField.getFieldInfo().getFieldEntityAlias());
        String fieldTbAlias = tableAliasMap.get(leftField.getFieldRealTable());
        conditionSql.append(fieldTbAlias).append(".").append(leftField.getFieldInfo().getDbField()).append(" ");
        conditionSql.append(joinConditionRowDetail.getConditionRow().getCompareOp());
        conditionSql.append(" ");
        tableAliasMap = entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias());
        String rightJoinTb = rightField.getFieldRealTable();
        fieldTbAlias = tableAliasMap.get(rightJoinTb);
        conditionSql.append(fieldTbAlias).append(".").append(rightField.getFieldInfo().getDbField()).append(" ");
        if (rightField.isMulangField()) {
            conditionSql.append(conditionAnd).append(fieldTbAlias).append(".").append(conditionLocalId).append("#{flocalid}").append(' ');
        }
        if ((rightFieldCache = loadRecordAliasMap.get(rightField.getFieldInfo().getFieldEntityAlias())) == null) {
            rightFieldCache = new HashSet<String>(16);
        }
        String mainTbJoinSql = null;
        if (HRStringUtils.isNotEmpty((String)rightField.getSplitTable())) {
            if (rightFieldCache.contains(rightField.getMainTable())) {
                conditionSql.append(conditionAnd).append(fieldTbAlias).append(".").append(rightField.getFieldInfo().getPkDbField()).append(" = ").append(tableAliasMap.get(rightField.getMainTable())).append(".").append(rightField.getFieldInfo().getPkDbField());
            } else {
                String mainTbJoinCondition = conditionOn + fieldTbAlias + "." + rightField.getFieldInfo().getPkDbField() + " = " + tableAliasMap.get(rightField.getMainTable()) + "." + rightField.getFieldInfo().getPkDbField();
                mainTbJoinSql = this.composeSimpleFromSql(rightField.getMainTable(), joinEntityRelation.getJoinRelation().getJoinType(), entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias()).get(rightField.getMainTable()), mainTbJoinCondition);
            }
        }
        if (HRStringUtils.isEmpty((String)(joinConditionSql = joinSqlMap.get(rightJoinTb)))) {
            conditionSql.insert(0, conditionOn);
            String composeSimpleFromSql = this.composeSimpleFromSql(rightJoinTb, joinEntityRelation.getJoinRelation().getJoinType(), entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias()).get(rightJoinTb), conditionSql.toString());
            joinSqlMap.put(rightJoinTb, composeSimpleFromSql);
        } else {
            conditionSql.insert(0, conditionAnd);
            String composeSimpleFromSql = joinConditionSql + conditionSql;
            joinSqlMap.put(rightJoinTb, composeSimpleFromSql);
        }
        rightFieldCache.add(rightJoinTb);
        if (mainTbJoinSql != null) {
            joinSqlMap.put(rightField.getMainTable(), mainTbJoinSql);
            rightFieldCache.add(rightField.getMainTable());
        }
        loadRecordAliasMap.put(rightField.getFieldInfo().getFieldEntityAlias(), rightFieldCache);
        return firstJoinTb;
    }

    @ExcludeFromJacocoGeneratedReport
    private String tryJoinMainTableSpliTb(HRComplexObjJoinRelation anObjJoinRelation, Map<String, Map<String, String>> entityTableAlias, Set<String> mainEntityLoadCache, JoinConditionRowDetail joinConditionRowDetail) {
        String splitTable;
        JoinFieldDetail mainJoinDetail = null;
        String joinSqlStr = "";
        if (joinConditionRowDetail.getLeftField().isMainEntityField()) {
            mainJoinDetail = joinConditionRowDetail.getLeftField();
        } else if (joinConditionRowDetail.getConditionRow().isRightFieldItem() && joinConditionRowDetail.getRightField().isMainEntityField()) {
            mainJoinDetail = joinConditionRowDetail.getRightField();
        }
        if (mainJoinDetail != null && HRStringUtils.isNotEmpty((String)mainJoinDetail.getSplitTable()) && !mainEntityLoadCache.contains(splitTable = mainJoinDetail.getSplitTable())) {
            joinSqlStr = mainJoinDetail.isMulangField() ? this.composeMuliLangFromSql(splitTable, mainJoinDetail.getMainTable(), mainJoinDetail.getMainTablePk(), entityTableAlias.get(anObjJoinRelation.getEntityAlias())) : this.composeSplitTableFromSql(splitTable, mainJoinDetail.getMainTable(), mainJoinDetail.getMainTablePk(), mainJoinDetail.getMainTablePk(), entityTableAlias.get(anObjJoinRelation.getEntityAlias()));
            mainEntityLoadCache.add(splitTable);
        }
        return joinSqlStr;
    }

    @ExcludeFromJacocoGeneratedReport
    private String genSubEntryTableSql(Map<String, Set<String>> loadRecordAliasMap) {
        List entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList().stream().filter(EntityFieldInfo::isSubEntryField).filter(fi -> !fi.isMultiLangField()).collect(Collectors.toList());
        StringBuilder entryFromSql = new StringBuilder();
        Map<String, String> relEntityMap = this.kSqlParser.getRelEntityMap();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            String fieldEntityAlias;
            String fieldAlias = entityFieldInfo.getAlias();
            String entityAlias = fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, fieldAlias);
            if (!HRStringUtils.isNotEmpty((String)fieldEntityAlias)) {
                entityAlias = this.complexObjCont.getEntityNumber();
            }
            Set<String> tableRecordSet = loadRecordAliasMap.get(entityAlias);
            if (tableRecordSet == null) {
                tableRecordSet = new HashSet<String>();
            }
            if (tableRecordSet.contains(entityFieldInfo.getTable())) continue;
            entryFromSql.append(this.composeSplitTableFromSql(entityFieldInfo.getTable(), entityFieldInfo.getSubEntryParentTb(), entityFieldInfo.getSubEntryParentTbPk(), entityFieldInfo.getSubEntryParentTbPk(), entityTableAlias.get(entityAlias)));
            tableRecordSet.add(entityFieldInfo.getTable());
            loadRecordAliasMap.put(entityAlias, tableRecordSet);
        }
        return entryFromSql.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    private String genSubEntryParentTableSql(Map<String, Set<String>> loadRecordAliasMap) {
        List entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList().stream().filter(EntityFieldInfo::isSubEntryField).filter(fi -> !fi.isMultiLangField()).collect(Collectors.toList());
        StringBuilder entryFromSql = new StringBuilder();
        Map<String, String> relEntityMap = this.kSqlParser.getRelEntityMap();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            String fieldAlias = entityFieldInfo.getAlias();
            String fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, fieldAlias);
            String entityNumber = this.complexObjCont.getEntityNumber();
            String entityAlias = fieldEntityAlias;
            if (HRStringUtils.isNotEmpty((String)fieldEntityAlias)) {
                entityNumber = relEntityMap.get(fieldEntityAlias);
            } else {
                entityAlias = this.complexObjCont.getEntityNumber();
            }
            Set<String> tableRecordSet = loadRecordAliasMap.get(entityAlias);
            if (tableRecordSet == null) {
                tableRecordSet = new HashSet<String>();
            }
            if (tableRecordSet.contains(entityFieldInfo.getSubEntryParentTb())) continue;
            MainEntityType dataEntityType = this.kSqlParser.entityTypeUtil.getMainEntityType(entityNumber);
            String mainTbPk = dataEntityType.getPrimaryKey().getAlias();
            entryFromSql.append(this.composeSplitTableFromSql(entityFieldInfo.getSubEntryParentTb(), dataEntityType.getAlias(), mainTbPk, mainTbPk, entityTableAlias.get(entityAlias)));
            tableRecordSet.add(entityFieldInfo.getSubEntryParentTb());
            loadRecordAliasMap.put(entityAlias, tableRecordSet);
        }
        return entryFromSql.toString();
    }

    private String genEntryTableSql(Map<String, Set<String>> loadRecordAliasMap) {
        List entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList().stream().filter(EntityFieldInfo::isEntryField).filter(fi -> !fi.isMultiLangField()).collect(Collectors.toList());
        StringBuilder entryFromSql = new StringBuilder();
        Map<String, String> relEntityMap = this.kSqlParser.getRelEntityMap();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            String fieldAlias = entityFieldInfo.getAlias();
            String fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, fieldAlias);
            String entityNumber = this.complexObjCont.getEntityNumber();
            String entityAlias = fieldEntityAlias;
            if (HRStringUtils.isNotEmpty((String)fieldEntityAlias)) {
                entityNumber = relEntityMap.get(fieldEntityAlias);
            } else {
                entityAlias = this.complexObjCont.getEntityNumber();
            }
            Set<String> tableRecordSet = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            if (tableRecordSet.contains(entityFieldInfo.getTable())) continue;
            MainEntityType dataEntityType = this.kSqlParser.entityTypeUtil.getMainEntityType(entityNumber);
            String mainTbPk = dataEntityType.getPrimaryKey().getAlias();
            entryFromSql.append(this.composeSplitTableFromSql(entityFieldInfo.getTable(), dataEntityType.getAlias(), mainTbPk, mainTbPk, entityTableAlias.get(entityAlias)));
            tableRecordSet.add(entityFieldInfo.getTable());
            loadRecordAliasMap.put(entityAlias, tableRecordSet);
        }
        return entryFromSql.toString();
    }

    private String genMuliLangTableSql(Map<String, Set<String>> loadRecordAliasMap) {
        String mainTable;
        StringBuilder mulTableSql = new StringBuilder();
        Map<String, Set<String>> mlTableMap = this.tableParser.getMLTables();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        Map<String, Set<String>> unIgnoreTable = this.kSqlParser.getUnIgnoreTable();
        for (Map.Entry<String, Set<String>> entry : mlTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            if (this.isSkipJoinMulTableForDataExtract(entityAlias)) continue;
            Set<String> multiLangTbSet = entry.getValue();
            Map<String, String> tableAlias = entityTableAlias.get(entityAlias);
            Set<String> unIgnoreTbSet = MapCacheUtil.getMapSetVal(unIgnoreTable, entityAlias);
            Iterator<String> iterator = multiLangTbSet.iterator();
            while (iterator.hasNext()) {
                String mulLangTable = iterator.next();
                mainTable = mulLangTable.substring(0, mulLangTable.length() - 2);
                if (!tableAlias.containsKey(mainTable)) {
                    iterator.remove();
                    continue;
                }
                if (unIgnoreTbSet.contains(mulLangTable)) continue;
                iterator.remove();
            }
        }
        Map<String, String> tablePkMap = this.kSqlParser.getTablePk();
        for (Map.Entry<String, Set<String>> entry : mlTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            if (this.isSkipJoinMulTableForDataExtract(entityAlias)) continue;
            Set<String> loadRecordTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            Set<String> tableSet = entry.getValue();
            for (String mulTb : tableSet) {
                if (loadRecordTable.contains(mulTb)) continue;
                mainTable = mulTb.substring(0, mulTb.length() - 2);
                String pkField = tablePkMap.get(mainTable);
                mulTableSql.append(this.composeMuliLangFromSql(mulTb, mainTable, pkField, entityTableAlias.get(entityAlias)));
                loadRecordTable.add(mulTb);
            }
            loadRecordAliasMap.put(entityAlias, loadRecordTable);
        }
        return mulTableSql.toString();
    }

    private boolean isSkipJoinMulTableForDataExtract(String entityAlias) {
        if (!this.complexObjCont.isDataExtractQuery()) {
            return false;
        }
        return entityAlias.equals(this.complexObjCont.getEntityNumber()) && HRStringUtils.equals((String)Lang.zh_CN.getLangTag(), (String)RequestContext.get().getLang().getLangTag());
    }

    private String composeMuliLangFromSql(String muliLangTable, String mainTable, String pkField, Map<String, String> entityTableAlias) {
        String muliLangTbAlias = entityTableAlias.get(muliLangTable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + muliLangTable + " " + muliLangTbAlias + conditionOn + "(" + mainTbAlias + "." + pkField + " = " + muliLangTbAlias + "." + pkField + conditionAnd + muliLangTbAlias + "." + conditionLocalId + "#{flocalid}" + ") ";
    }

    @ExcludeFromJacocoGeneratedReport
    private String genTableGroupSql(Map<String, Set<String>> loadRecordAliasMap) {
        StringBuilder splitTbSql = new StringBuilder();
        Map<String, Set<String>> splitTableMap = this.tableParser.getSplitTables();
        Map<String, Map<String, String>> entityTableAlias = this.kSqlParser.getTableAliasMap();
        Map<String, String> tablePkMap = this.kSqlParser.getTablePk();
        for (Map.Entry<String, Set<String>> entry : splitTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            Set<String> loadRecordTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            Set<String> tableSet = entry.getValue();
            Map<String, String> tableAlias = entityTableAlias.get(entityAlias);
            for (String splitTb : tableSet) {
                if (loadRecordTable.contains(splitTb)) continue;
                String mainTb = splitTb.substring(0, splitTb.lastIndexOf("_"));
                String pkField = tablePkMap.get(mainTb);
                if (!tableAlias.containsKey(mainTb)) continue;
                splitTbSql.append(this.composeSplitTableFromSql(splitTb, mainTb, pkField, pkField, entityTableAlias.get(entityAlias)));
                String joinCondSql = this.splitTbJoinCondMap.get(splitTb);
                joinCondSql = joinCondSql == null ? " " : joinCondSql;
                splitTbSql.append(joinCondSql);
                loadRecordTable.add(splitTb);
            }
            loadRecordAliasMap.put(entityAlias, loadRecordTable);
        }
        return splitTbSql.toString();
    }

    private String composeSplitTableFromSql(String splittable, String mainTable, String pkField, String fkField, Map<String, String> entityTableAlias) {
        String splitTbAlias = entityTableAlias.get(splittable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + splittable + " " + splitTbAlias + conditionOn + mainTbAlias + "." + pkField + " = " + splitTbAlias + "." + fkField + " ";
    }

    private String composeSimpleFromSql(String tableName, String joinType, String tableAlias, String conditionSql) {
        String join = KsqlJoinHint.of((String)joinType).getJoin();
        return join + " " + tableName + " " + tableAlias + " " + conditionSql + " ";
    }
}

