/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.ksql.BaseDataTableJoinParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlCustomSortParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlFieldParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlFromParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlOrderByParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlSelectListParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlTableParser;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlWhereParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.EntityFieldTransfer;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import org.apache.commons.collections.CollectionUtils;

public class KSqlParser {
    private final Map<String, Set<String>> unIgnoreTable = new HashMap<String, Set<String>>(16);
    private final HRComplexObjContext complexObjCont;
    private List<EntityFieldInfo> entityFieldInfoList;
    private final Set<String> extraField4TbJoin = new HashSet<String>(16);
    private final Set<String> extraFieldAliasSet = new HashSet<String>(16);
    private final Map<String, String> relEntityMap;
    private Map<String, Map<String, String>> entityTableAliasMap;
    private Map<String, String> tablePk;
    private boolean processDateByDb = false;
    private final KSqlFromParser fromParser;
    private final KSqlSelectListParser selectListParser;
    private final KSqlWhereParser whereParser;
    private final KSqlFieldParser fieldParser;
    private final KSqlOrderByParser orderByParser;
    private final BaseDataTableJoinParser bdTableJoinParser;
    private final KSqlCustomSortParser kSqlCustomSortParser;
    public MainEntityTypeUtil entityTypeUtil = new MainEntityTypeUtil();

    public KSqlSelectListParser getSelectListParser() {
        return this.selectListParser;
    }

    public KSqlParser(HRComplexObjContext complexObjCont) {
        this.complexObjCont = complexObjCont;
        this.relEntityMap = this.complexObjCont.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        this.initQfilterFieldList();
        this.initJoinOnField();
        this.initFieldInfo();
        this.fromParser = new KSqlFromParser(complexObjCont, this);
        this.selectListParser = new KSqlSelectListParser(complexObjCont, this);
        this.whereParser = new KSqlWhereParser(complexObjCont, this);
        this.fieldParser = new KSqlFieldParser(this);
        this.orderByParser = new KSqlOrderByParser(complexObjCont, this);
        this.bdTableJoinParser = new BaseDataTableJoinParser(this);
        this.kSqlCustomSortParser = new KSqlCustomSortParser(this);
    }

    private void initJoinOnField() {
        List joinRelationList = this.complexObjCont.getJoinRelationList();
        joinRelationList.forEach(joinRelation -> joinRelation.getCondition().forEach(row -> {
            this.extraField4TbJoin.add(row.getLeftItem());
            if (row.isRightFieldItem()) {
                this.extraField4TbJoin.add(row.getRightItem());
            }
        }));
    }

    private void initQfilterFieldList() {
        List qFilterList = this.complexObjCont.getQfilterList();
        if (qFilterList == null) {
            return;
        }
        for (QFilter qFilter : qFilterList) {
            this.findQfilterProp(qFilter);
        }
    }

    private void findQfilterProp(QFilter qFilter) {
        List nests;
        if (qFilter == null) {
            return;
        }
        if (!qFilter.getProperty().equals("1")) {
            this.extraField4TbJoin.add(qFilter.getProperty());
        }
        if (CollectionUtils.isEmpty((Collection)(nests = qFilter.getNests(false)))) {
            return;
        }
        for (QFilter.QFilterNest nest : nests) {
            this.findQfilterProp(nest.getFilter());
        }
    }

    private void initFieldInfo() {
        this.tablePk = new HashMap<String, String>(16);
        EntityFieldTransfer fieldTransfer = new EntityFieldTransfer(this, this.complexObjCont);
        this.entityFieldInfoList = fieldTransfer.transfer(this.tablePk, this.extraFieldAliasSet, this.extraField4TbJoin);
    }

    public DBRoute getDBRoute() {
        MainEntityType dataEntityType = this.entityTypeUtil.getMainEntityType(this.complexObjCont.getEntityNumber());
        return new DBRoute(dataEntityType.getDBRouteKey());
    }

    public String getMainEntityAppNumber() {
        MainEntityType dataEntityType = this.entityTypeUtil.getMainEntityType(this.complexObjCont.getEntityNumber());
        return dataEntityType.getBizAppNumber();
    }

    public Map<String, String> getPropMap() {
        return this.fieldParser.getAllFields();
    }

    public Map<String, String> getOriginalPropMap() {
        return this.fieldParser.getExcludeExtraFields();
    }

    public Map<String, Map<String, String>> getTableAliasMap() {
        if (this.entityTableAliasMap == null) {
            KSqlTableParser tableParser = new KSqlTableParser(this.complexObjCont, this);
            this.entityTableAliasMap = tableParser.getTableAlias();
        }
        return this.entityTableAliasMap;
    }

    public String getTableAlias(String entityAlias, String table) {
        return this.getTableAliasMap().get(entityAlias).get(table);
    }

    public String getSqlStr(Map<String, PKTempTable> tmpTableSQLOfSyncMap, int start, int limit) {
        String whereSql = this.whereParser.genWhereSql(tmpTableSQLOfSyncMap);
        HashBasedTable aliasToOrderByField = HashBasedTable.create();
        String orderBy = this.orderByParser.transforOrderBy((Table<String, String, String>)aliasToOrderByField);
        StringBuilder selectListSql = new StringBuilder(this.selectListParser.getSelectListSql());
        for (Table.Cell orderCell : aliasToOrderByField.cellSet()) {
            String orderByFieldStr = (String)orderCell.getColumnKey();
            String orderByAsFieldStr = (String)orderCell.getValue();
            if (orderByFieldStr == null || orderByAsFieldStr == null) continue;
            selectListSql.append(", ").append(orderByFieldStr).append(" as ").append(orderByAsFieldStr).append(' ');
        }
        StringBuilder sql = new StringBuilder("select ");
        if (start >= 0 && limit > 0) {
            sql.append(" top ").append(limit).append(',').append(start).append(' ');
        }
        sql.append((CharSequence)selectListSql).append(this.fromParser.getTableFromSql(tmpTableSQLOfSyncMap)).append(this.bdTableJoinParser.getBaseDataJoinSql()).append(this.kSqlCustomSortParser.getCustomSortSql()).append(" where 1 = 1 ").append(whereSql);
        if (orderBy.length() > 0) {
            sql.append(" order by ").append(orderBy);
        }
        return sql.toString();
    }

    public String getCountSqlStr(Map<String, PKTempTable> tmpTableSQLOfSyncMap, int start, int limit) {
        StringBuilder sql = new StringBuilder("select count(1) from ( select ");
        if (start >= 0 && limit > 0) {
            sql.append(" top ").append(limit).append(',').append(start).append(' ');
        }
        sql.append(" 1 ");
        String whereSql = this.whereParser.genWhereSql(tmpTableSQLOfSyncMap);
        sql.append(this.fromParser.getTableFromSql(tmpTableSQLOfSyncMap)).append(" where 1 = 1 ").append(whereSql).append(") AS COUNTTBALIAS ");
        return sql.toString();
    }

    public String getSqlStr(Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        return this.getSqlStr(tmpTableSQLOfSyncMap, -1, -1);
    }

    public String getDistinctSqlStr(Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        String whereSql = this.whereParser.genWhereSql(tmpTableSQLOfSyncMap);
        HashBasedTable aliasToOrderByField = HashBasedTable.create();
        String orderBy = this.orderByParser.transforOrderBy((Table<String, String, String>)aliasToOrderByField);
        StringBuilder selectListSql = new StringBuilder(this.selectListParser.getSelectListSql(true));
        for (Table.Cell orderCell : aliasToOrderByField.cellSet()) {
            String orderByFieldStr = (String)orderCell.getColumnKey();
            String orderByAsFieldStr = (String)orderCell.getValue();
            if (orderByFieldStr == null || orderByAsFieldStr == null) continue;
            selectListSql.append(", ").append(orderByFieldStr).append(" as ").append(orderByAsFieldStr).append(' ');
        }
        StringBuilder sql = new StringBuilder("select distinct ");
        sql.append((CharSequence)selectListSql).append(this.fromParser.getTableFromSql(tmpTableSQLOfSyncMap)).append(this.bdTableJoinParser.getBaseDataJoinSql()).append(this.kSqlCustomSortParser.getCustomSortSql()).append(" where 1 = 1 ").append(whereSql);
        if (orderBy.length() > 0) {
            sql.append(" order by ").append(orderBy);
        }
        return sql.toString();
    }

    public String getDistinctCountSqlStr(Map<String, PKTempTable> tmpTableSQLOfSyncMap, int start, int limit) {
        StringBuilder sql = new StringBuilder("select");
        sql.append(" count(1) from (select distinct ");
        if (start >= 0 && limit > 0) {
            sql.append(" top ").append(limit).append(',').append(start).append(' ');
        }
        String whereSql = this.whereParser.genWhereSql(tmpTableSQLOfSyncMap);
        sql.append(this.selectListParser.getSelectListSql(true, false, true, false)).append(this.fromParser.getTableFromSql(tmpTableSQLOfSyncMap)).append(" where 1 = 1 ").append(whereSql).append(") AS COUNTTBALIAS ");
        return sql.toString();
    }

    public void addUnIgnoreTable(String entityAlias, String tableName) {
        Set<String> tableSet = MapCacheUtil.getMapSetVal(this.unIgnoreTable, entityAlias);
        tableSet.add(tableName);
        this.unIgnoreTable.put(entityAlias, tableSet);
    }

    public List<EntityFieldInfo> getEntityFieldInfoList() {
        return this.entityFieldInfoList;
    }

    public Map<String, String> getRelEntityMap() {
        return this.relEntityMap;
    }

    public Map<String, String> getTablePk() {
        return this.tablePk;
    }

    public Map<String, Set<String>> getUnIgnoreTable() {
        return this.unIgnoreTable;
    }

    public Set<String> getExtraFieldAliasSet() {
        return this.extraFieldAliasSet;
    }

    public Set<String> getExtraField4TbJoin() {
        return this.extraField4TbJoin;
    }

    public HRComplexObjContext getComplexObjCont() {
        return this.complexObjCont;
    }

    public boolean isProcessDateByDb() {
        return this.processDateByDb;
    }

    public void setProcessDateByDb(boolean processDateByDb) {
        this.processDateByDb = processDateByDb;
    }

    public Table<String, String, String> getAliasToOrderFieldTable() {
        HashBasedTable aliasToOrderByField = HashBasedTable.create();
        this.orderByParser.transforOrderBy((Table<String, String, String>)aliasToOrderByField);
        return aliasToOrderByField;
    }
}

