/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.FieldQueryAliasUtil;
import kd.hr.hbp.business.service.complexobj.util.KSqlFuncUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class KSqlSelectListParser {
    private HRComplexObjContext complexObjCont;
    private KSqlParser kSqlParser;

    public KSqlSelectListParser(HRComplexObjContext complexObjCont, KSqlParser kSqlParser) {
        this.complexObjCont = complexObjCont;
        this.kSqlParser = kSqlParser;
    }

    public String getSelectListSql() {
        return this.getSelectListSql(false, true);
    }

    public String getSelectListSql(boolean excludeExtraField) {
        return this.getSelectListSql(excludeExtraField, true);
    }

    public String getSelectListSql(boolean excludeExtraField, boolean userAlias) {
        return this.getSelectListSql(excludeExtraField, userAlias, false, false);
    }

    public String getSelectListSql(boolean excludeExtraField, boolean userAlias, boolean excludeDependField, boolean onlyAlias) {
        Set dependSet;
        StringBuilder selectList = new StringBuilder();
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        if (excludeExtraField) {
            entityFieldInfoList = entityFieldInfoList.stream().filter(field -> !this.kSqlParser.getExtraFieldAliasSet().contains(field.getAlias())).collect(Collectors.toList());
        }
        if (excludeDependField && !(dependSet = this.kSqlParser.getComplexObjCont().getComplexObjFieldInfoList().stream().filter(HRComplexObjFieldInfo::isDependField).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet())).isEmpty()) {
            entityFieldInfoList = entityFieldInfoList.stream().filter(field -> !dependSet.contains(field.getAlias())).collect(Collectors.toList());
        }
        entityFieldInfoList = entityFieldInfoList.stream().filter(field -> !this.kSqlParser.getExtraField4TbJoin().contains(field.getAlias())).collect(Collectors.toList());
        HashSet<String> recordFieldAlias = new HashSet<String>();
        for (EntityFieldInfo entityFieldInfo : entityFieldInfoList) {
            String convertField = entityFieldInfo.getAlias();
            String[] fieldAliasArr = convertField.split("\\.");
            String firstField = fieldAliasArr[0];
            String relEntityNumber = this.kSqlParser.getRelEntityMap().get(firstField);
            String entityAlias = HRStringUtils.isEmpty((String)relEntityNumber) ? this.complexObjCont.getEntityNumber() : firstField;
            selectList.append(this.genSimpleSelectList(this.kSqlParser.getTableAliasMap().get(entityAlias), entityFieldInfo, recordFieldAlias, userAlias, onlyAlias));
        }
        String selectSql = selectList.toString();
        if (HRStringUtils.isNotEmpty((String)selectSql)) {
            selectSql = selectSql.substring(0, selectSql.lastIndexOf(","));
        }
        return selectSql;
    }

    private String genSimpleSelectList(Map<String, String> tableAliasMap, EntityFieldInfo fieldInfo, Set<String> recordFieldAlias, boolean userAlias, boolean onlyAlias) {
        String convertField;
        String cacheKey = convertField = fieldInfo.getConvertField();
        SplitDateTypeEnum splitDateType = fieldInfo.getSplitDateType();
        if (!this.kSqlParser.isProcessDateByDb()) {
            splitDateType = null;
        }
        if (splitDateType != null) {
            cacheKey = cacheKey + "!" + splitDateType.getKey();
        }
        if (convertField == null || recordFieldAlias.contains(cacheKey)) {
            return "";
        }
        String selectFieldSql = onlyAlias ? FieldQueryAliasUtil.genFieldQueryAliasNoQuotation(convertField, splitDateType) + "," : (userAlias ? this.composeSimpleSelectList(tableAliasMap.get(fieldInfo.getTable()), fieldInfo.getDbField(), FieldQueryAliasUtil.genFieldQueryAlias(convertField, splitDateType), splitDateType) : this.composeSimpleSelectListNoAlias(tableAliasMap.get(fieldInfo.getTable()), fieldInfo.getDbField(), splitDateType));
        recordFieldAlias.add(cacheKey);
        return selectFieldSql;
    }

    private String composeSimpleSelectList(String tableAlias, String selectField, String fieldAlias, SplitDateTypeEnum splitDateType) {
        if (HRStringUtils.isEmpty((String)selectField)) {
            return " ''  as " + fieldAlias + ",";
        }
        return KSqlFuncUtil.substitutionFunc(tableAlias + "." + selectField, splitDateType) + " as " + fieldAlias + ",";
    }

    private String composeSimpleSelectListNoAlias(String tableAlias, String selectField, SplitDateTypeEnum splitDateType) {
        String queryExpr;
        if (HRStringUtils.isEmpty((String)selectField)) {
            return " '' ,";
        }
        String express = tableAlias + "." + selectField;
        if (express.equals(queryExpr = KSqlFuncUtil.substitutionFunc(express, splitDateType))) {
            return express + ",";
        }
        return queryExpr + " as " + selectField + ",";
    }
}

