/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.FieldStoreInfo;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.complexobj.util.MulTableAliasUtil;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;

public class KSqlTableParser {
    private final HRComplexObjContext complexObjCont;
    private final KSqlParser kSqlParser;

    public KSqlTableParser(HRComplexObjContext complexObjCont, KSqlParser kSqlParser) {
        this.complexObjCont = complexObjCont;
        this.kSqlParser = kSqlParser;
    }

    public Map<String, Map<String, String>> getTableAlias() {
        return MulTableAliasUtil.genTableAlias(this.getAllTable());
    }

    private Map<String, Set<String>> getAllTable() {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        HashSet<String> mainEntityTable = new HashSet<String>(16);
        mainEntityTable.add(this.complexObjCont.getEntityTable());
        aliasMap.put(this.complexObjCont.getEntityNumber(), mainEntityTable);
        this.mergeMap(aliasMap, this.getJoinTables());
        this.mergeMap(aliasMap, this.getMLTables());
        this.mergeMap(aliasMap, this.getSplitTables());
        this.mergeMap(aliasMap, this.getEntryTables());
        this.mergeMap(aliasMap, this.getSubEntryTables());
        this.mergeMap(aliasMap, this.getBaseDataTables());
        return aliasMap;
    }

    private void mergeMap(Map<String, Set<String>> rstMap, Map<String, Set<String>> bMap) {
        for (Map.Entry<String, Set<String>> entry : bMap.entrySet()) {
            Set<String> set = rstMap.get(entry.getKey());
            if (set == null) {
                set = entry.getValue();
            } else {
                set.addAll((Collection<String>)entry.getValue());
            }
            rstMap.put(entry.getKey(), set);
        }
    }

    public Map<String, Set<String>> getJoinTables() {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List joinRelationList = this.complexObjCont.getJoinRelationList();
        for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
            String tableName = HREntityHelper.getTableName(joinRelation.getRelEntityNumber());
            HashSet<String> tableSet = new HashSet<String>(16);
            tableSet.add(tableName);
            aliasMap.put(joinRelation.getRelEntityAlias(), tableSet);
        }
        return aliasMap;
    }

    public Map<String, Set<String>> getEntryTables() {
        Map<String, Set<String>> map = this.getPredicateTables(EntityFieldInfo::isEntrySelfField);
        return this.getAllSubParentTb(map);
    }

    public Map<String, Set<String>> getSubEntryTables() {
        return this.getPredicateTables(EntityFieldInfo::isSubEntrySelfField);
    }

    public Map<String, Set<String>> getBaseDataTables() {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        if (entityFieldInfoList != null) {
            List objFieldInfoList = entityFieldInfoList.stream().filter(field -> field.getFieldStoreInfo() != null).collect(Collectors.toList());
            for (EntityFieldInfo objFieldInfo : objFieldInfoList) {
                String fieldEntityAlias = objFieldInfo.getFieldEntityAlias();
                Set<String> entityAliasTable = MapCacheUtil.getMapSetVal(aliasMap, fieldEntityAlias);
                FieldStoreInfo fieldStoreInfo = objFieldInfo.getFieldStoreInfo();
                entityAliasTable.add(fieldStoreInfo.getAliasAndTable());
                if (fieldStoreInfo.getReference() != null) {
                    entityAliasTable.add(fieldStoreInfo.getReference().getAliasAndTable());
                }
                aliasMap.put(fieldEntityAlias, entityAliasTable);
            }
        }
        return aliasMap;
    }

    public Map<String, Set<String>> getMLTables() {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        if (entityFieldInfoList != null) {
            List objFieldInfoList = entityFieldInfoList.stream().filter(EntityFieldInfo::isMultiLangField).collect(Collectors.toList());
            for (EntityFieldInfo objFieldInfo : objFieldInfoList) {
                String fieldEntityAlias = objFieldInfo.getFieldEntityAlias();
                Set<String> entityAliasTable = MapCacheUtil.getMapSetVal(aliasMap, fieldEntityAlias);
                entityAliasTable.add(objFieldInfo.getMultiLanguageTb());
                aliasMap.put(fieldEntityAlias, entityAliasTable);
            }
        }
        return aliasMap;
    }

    public Map<String, Set<String>> getSplitTables() {
        return this.getPredicateTables(EntityFieldInfo::isSplitField);
    }

    private Map<String, Set<String>> getPredicateTables(Predicate<? super EntityFieldInfo> predicate) {
        HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(16);
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        if (entityFieldInfoList != null) {
            List objFieldInfoList = entityFieldInfoList.stream().filter(predicate).collect(Collectors.toList());
            for (EntityFieldInfo objFieldInfo : objFieldInfoList) {
                String fieldEntityAlias = objFieldInfo.getFieldEntityAlias();
                Set<String> entityAliasTable = MapCacheUtil.getMapSetVal(aliasMap, fieldEntityAlias);
                entityAliasTable.add(objFieldInfo.getTable());
                aliasMap.put(fieldEntityAlias, entityAliasTable);
            }
        }
        return aliasMap;
    }

    private Map<String, Set<String>> getAllSubParentTb(Map<String, Set<String>> aliasMap) {
        List<EntityFieldInfo> entityFieldInfoList = this.kSqlParser.getEntityFieldInfoList();
        if (entityFieldInfoList != null) {
            List objFieldInfoList = entityFieldInfoList.stream().filter(EntityFieldInfo::isSubEntrySelfField).collect(Collectors.toList());
            for (EntityFieldInfo objFieldInfo : objFieldInfoList) {
                String fieldEntityAlias = objFieldInfo.getFieldEntityAlias();
                Set<String> entityAliasTable = MapCacheUtil.getMapSetVal(aliasMap, fieldEntityAlias);
                entityAliasTable.add(objFieldInfo.getSubEntryParentTb());
                aliasMap.put(fieldEntityAlias, entityAliasTable);
            }
        }
        return aliasMap;
    }
}

