/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.ksql;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.OrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.service.complexobj.ComplexConstant;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.ksql.QFilterTransFunction;
import kd.hr.hbp.business.service.complexobj.util.QFilterOptimizeUtil;
import kd.hr.hbp.business.service.complexobj.util.QFilterUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;

public class KSqlWhereParser {
    private static final Log LOGGER = LogFactory.getLog(KSqlWhereParser.class);
    private HRComplexObjContext complexObjCont;
    private KSqlParser kSqlParser;
    private int tmpTableThresh;

    public KSqlWhereParser(HRComplexObjContext complexObjCont, KSqlParser kSqlParser) {
        this.complexObjCont = complexObjCont;
        this.kSqlParser = kSqlParser;
        this.initTmpTableThresh();
    }

    public String genWhereSql(Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        List qFilterList = this.complexObjCont.getQfilterList();
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        QFilter[] qFiltersCopy = new QFilter[qFilters.length];
        for (int i = 0; i < qFilters.length; ++i) {
            if (qFilters[i] == null) continue;
            qFiltersCopy[i] = qFilters[i].copy();
        }
        long time0 = System.currentTimeMillis();
        StringBuilder whereSql = this.transferQFilter(qFiltersCopy, true, tmpTableSQLOfSyncMap);
        long time1 = System.currentTimeMillis();
        LOGGER.info("genWhereSql_time:{}", (Object)(time1 - time0));
        return whereSql.toString();
    }

    public StringBuilder transferQFilter(QFilter[] filterArr, boolean bTmpTable, Map<String, PKTempTable> tmpTableSQLOfSyncMap) {
        long time0 = System.currentTimeMillis();
        QFilterTransFunction sqltf = new QFilterTransFunction(this.complexObjCont, this.kSqlParser);
        StringBuilder whereSqlBuilder = new StringBuilder();
        if (filterArr == null) {
            return whereSqlBuilder;
        }
        QFilter[] qFiltersCopy = QFilterUtil.copyQFilters(filterArr);
        int n = qFiltersCopy.length;
        for (int i = 0; i < n; ++i) {
            if (qFiltersCopy[i] == null) continue;
            qFiltersCopy[i] = qFiltersCopy[i].trans((Function)sqltf);
        }
        long time1 = System.currentTimeMillis();
        LOGGER.info("transferQFilter_trans_time:{}", (Object)(time1 - time0));
        qFiltersCopy = QFilterOptimizeUtil.optimize(qFiltersCopy);
        long time2 = System.currentTimeMillis();
        LOGGER.info("transferQFilter_optimize_time:{}", (Object)(time2 - time1));
        for (QFilter filter : qFiltersCopy) {
            if (!filter.getProperty().equals("1") || !filter.toString().equals("1 != 1")) continue;
            throw new KDBizException(ComplexConstant.NO_QUERY, new Object[0]);
        }
        int n2 = qFiltersCopy.length;
        for (int i = 0; i < n2; ++i) {
            if (qFiltersCopy[i] == null) continue;
            String sqlStr = QFilterUtil.toQFilterString(qFiltersCopy[i], true, bTmpTable, tmpTableSQLOfSyncMap, this.kSqlParser, this.tmpTableThresh);
            whereSqlBuilder.append(" and ").append(sqlStr);
        }
        long time3 = System.currentTimeMillis();
        LOGGER.info("transferQFilter_toQFilterString_time:{}", (Object)(time3 - time2));
        return whereSqlBuilder;
    }

    private void initTmpTableThresh() {
        OrgService orgService = new OrgService();
        long orgId = RequestContext.get().getOrgId() == 0L ? orgService.getRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("2VKJ94YEM7AU", Long.valueOf(orgId));
        Map sysConfigMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object tmpTableThresh = sysConfigMap.get("tmptablethresh");
        this.tmpTableThresh = tmpTableThresh == null || (Integer)tmpTableThresh == 0 ? 10000 : (Integer)tmpTableThresh;
    }
}

