/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.complexobj.algox.model.AlgoXFieldInfo;
import kd.hr.hbp.business.service.complexobj.model.DimensionDataMapConfig;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DimensionData {
    private final String id;
    private String value;
    private final boolean isCustomOrder;
    private String referToOrderValue;

    public DimensionData(Object id, boolean isCustomOrder, String referToOrderValue) {
        this(id, id, isCustomOrder, referToOrderValue);
    }

    public DimensionData(Object id, Object value, boolean isCustomOrder, String referToOrderValue) {
        this.id = String.valueOf(id);
        this.value = String.valueOf(value);
        this.isCustomOrder = isCustomOrder;
        this.referToOrderValue = referToOrderValue;
    }

    public DimensionData(String id, String value, boolean isCustomOrder, String referToOrderValue) {
        this.id = id;
        this.value = value;
        this.isCustomOrder = isCustomOrder;
        this.referToOrderValue = referToOrderValue;
    }

    public String getId() {
        return this.id;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(Object value) {
        this.value = String.valueOf(value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCustomOrder() {
        return this.isCustomOrder;
    }

    public String getReferToOrderValue() {
        return this.referToOrderValue;
    }

    public void setReferToOrderValue(String referToOrderValue) {
        this.referToOrderValue = referToOrderValue;
    }

    public static int sortCompareTo(String fieldType, String sort, Object fieldValue1, Object fieldValue2) {
        int compareResult;
        if (fieldValue1 != null && fieldValue2 != null) {
            if (DataTypeEnum.DATETIME.getDataTypeKey().equals(fieldType)) {
                Date fieldDateValue1 = DimensionData.convertDate(String.valueOf(fieldValue1));
                Date fieldDateValue2 = DimensionData.convertDate(String.valueOf(fieldValue2));
                compareResult = fieldDateValue1.compareTo(fieldDateValue2);
            } else {
                compareResult = DataTypeEnum.BOOLEAN.getDataTypeKey().equals(fieldType) ? Boolean.valueOf(String.valueOf(fieldValue1)).compareTo(Boolean.valueOf(String.valueOf(fieldValue2))) : (DataTypeEnum.BIGDECIMAL.getDataTypeKey().equals(fieldType) ? new BigDecimal(String.valueOf(fieldValue1)).compareTo(new BigDecimal(String.valueOf(fieldValue2))) : (fieldValue1 instanceof Integer && fieldValue2 instanceof Integer ? ((Integer)fieldValue1).compareTo((Integer)fieldValue2) : String.valueOf(fieldValue1).compareTo(String.valueOf(fieldValue2))));
            }
        } else {
            compareResult = fieldValue1 == null && fieldValue2 == null ? 0 : (fieldValue1 == null ? 1 : -1);
        }
        if (compareResult != 0 && SortFieldInfo.SORTORD_DESC.equals(sort)) {
            compareResult *= -1;
        }
        return compareResult;
    }

    public String toString() {
        return "DimensionData{id='" + this.id + '\'' + ", value='" + this.value + '\'' + ", isCustomOrder=" + this.isCustomOrder + ", referToOrderValue='" + this.referToOrderValue + '\'' + '}';
    }

    public static List<Map<String, DimensionData>> convertToDimensionDataMap(DataSet dataSet, List<SortFieldInfo> sortFieldInfoList) {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
        Set customSortFieldAliasSet = sortFieldInfoList.stream().filter(sortFieldInfo -> SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())).map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet());
        Map<String, String> sourceFieldToReferOrderFieldMap = DimensionData.initSourceFieldToReferOrderFieldMap(sortFieldInfoList);
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        DimensionDataMapConfig config = new DimensionDataMapConfig(fieldNames, sortFieldInfoList);
        while (dataSet.hasNext()) {
            String referOrderFieldValue;
            Row rs = dataSet.next();
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            for (String string : config.getEnumIdFieldNameSet()) {
                String enumFieldName = string.replaceFirst("ORIGINAL_ENUM_VALUE_", "");
                int fieldIndex = rowMeta.getFieldIndex(enumFieldName, false);
                if (fieldIndex == -1 && (fieldIndex = rowMeta.getFieldIndex(enumFieldName = AlgoXFieldInfo.algoXAliasReturnAlias(enumFieldName), false)) == -1) {
                    throw new KDBizException(MessageFormat.format("rowMeta_can_not_find_enum_show_value_field:{0}", string));
                }
                String referOrderFieldValue2 = DimensionData.getReferOrderFieldValue(rs, sourceFieldToReferOrderFieldMap, enumFieldName);
                resultMap.put(enumFieldName, new DimensionData(rs.getString(string), rs.getString(enumFieldName), customSortFieldAliasSet.contains(enumFieldName), referOrderFieldValue2));
            }
            for (Map.Entry entry : config.getBaseFieldNameToIdMap().entrySet()) {
                referOrderFieldValue = DimensionData.getReferOrderFieldValue(rs, sourceFieldToReferOrderFieldMap, (String)entry.getKey());
                resultMap.put(entry.getKey(), new DimensionData(rs.get((String)entry.getValue()), rs.get((String)entry.getKey()), customSortFieldAliasSet.contains(entry.getKey()), referOrderFieldValue));
            }
            for (String string : config.getOtherFieldNames()) {
                referOrderFieldValue = DimensionData.getReferOrderFieldValue(rs, sourceFieldToReferOrderFieldMap, string);
                resultMap.putIfAbsent(string, new DimensionData(rs.getString(string), customSortFieldAliasSet.contains(string), referOrderFieldValue));
            }
            resultList.add(resultMap);
        }
        return resultList;
    }

    public static List<Map<String, DimensionData>> convertToDimensionDataMap(List<Map<String, Object>> objMapList, String[] fieldNames, List<SortFieldInfo> sortFieldInfoList) {
        Set customSortFieldAliasSet = sortFieldInfoList.stream().filter(sortFieldInfo -> SortFieldInfo.SORTORD_USER_DEFINED.equals(sortFieldInfo.getSortord())).map(SortFieldInfo::getFieldAlias).collect(Collectors.toSet());
        Map<String, String> sourceFieldToReferOrderFieldMap = DimensionData.initSourceFieldToReferOrderFieldMap(sortFieldInfoList);
        ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
        DimensionDataMapConfig config = new DimensionDataMapConfig(fieldNames, sortFieldInfoList);
        for (Map<String, Object> data : objMapList) {
            String referOrderFieldValue;
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)data.size());
            for (String string : config.getEnumIdFieldNameSet()) {
                String enumFieldName = string.replaceFirst("ORIGINAL_ENUM_VALUE_", "");
                if (!data.containsKey(enumFieldName) && !data.containsKey(enumFieldName = enumFieldName.replaceFirst("_DOC_SPLIT_", "."))) {
                    throw new KDBizException(MessageFormat.format("rowMeta_can_not_find_enum_show_value_field:{0}", string));
                }
                referOrderFieldValue = DimensionData.getReferOrderFieldValue(data, sourceFieldToReferOrderFieldMap, enumFieldName);
                resultMap.put(enumFieldName, new DimensionData(data.get(string), data.get(enumFieldName), customSortFieldAliasSet.contains(enumFieldName), referOrderFieldValue));
            }
            for (Map.Entry entry : config.getBaseFieldNameToIdMap().entrySet()) {
                String referOrderFieldValue2 = DimensionData.getReferOrderFieldValue(data, sourceFieldToReferOrderFieldMap, (String)entry.getKey());
                resultMap.put(entry.getKey(), new DimensionData(data.get(entry.getValue()), data.get(entry.getKey()), customSortFieldAliasSet.contains(entry.getKey()), referOrderFieldValue2));
            }
            for (String string : config.getOtherFieldNames()) {
                Object value = data.get(string);
                if (value == null) continue;
                referOrderFieldValue = DimensionData.getReferOrderFieldValue(data, sourceFieldToReferOrderFieldMap, string);
                resultMap.putIfAbsent(string, new DimensionData(data.get(string), customSortFieldAliasSet.contains(string), referOrderFieldValue));
            }
            resultList.add(resultMap);
        }
        return resultList;
    }

    private static Map<String, String> initSourceFieldToReferOrderFieldMap(List<SortFieldInfo> sortFieldInfoList) {
        HashMap sourceFieldToReferOrderFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            if (!sortFieldInfo.isDependSort()) continue;
            List dependSortSourceFields = sortFieldInfo.getDependSortSourceFields();
            for (String dependSortSourceField : dependSortSourceFields) {
                sourceFieldToReferOrderFieldMap.put(dependSortSourceField, sortFieldInfo.getFieldAlias());
            }
        }
        return sourceFieldToReferOrderFieldMap;
    }

    private static String getReferOrderFieldValue(Row rs, Map<String, String> sourceFieldToReferOrderFieldMap, String sourceFieldName) {
        String referOrderFieldName = sourceFieldToReferOrderFieldMap.get(sourceFieldName);
        String referOrderFieldValue = null;
        if (HRStringUtils.isNotEmpty((String)referOrderFieldName)) {
            referOrderFieldValue = rs.getString(referOrderFieldName);
        }
        return referOrderFieldValue;
    }

    private static String getReferOrderFieldValue(Map<String, Object> data, Map<String, String> sourceFieldToReferOrderFieldMap, String sourceFieldName) {
        Object value;
        String referOrderFieldName = sourceFieldToReferOrderFieldMap.get(sourceFieldName);
        String referOrderFieldValue = null;
        if (HRStringUtils.isNotEmpty((String)referOrderFieldName) && (value = data.get(referOrderFieldName)) != null) {
            referOrderFieldValue = String.valueOf(value);
        }
        return referOrderFieldValue;
    }

    private static Date convertDate(String value) {
        try {
            return HRDateTimeUtils.parseDate((String)String.valueOf(value));
        }
        catch (ParseException e) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5931\u8d25\u3002\u65e5\u671f\u4e3a\u201c%1$s\u201d\u3002", (String)"DimensionData_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), value));
        }
    }
}

