/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;

class DimensionDataMapConfig {
    private final Set<String> enumIdFieldNameSet;
    private final Map<String, String> baseFieldNameToIdMap;
    private final Set<String> otherFieldNames;

    public DimensionDataMapConfig(String[] fieldNames, List<SortFieldInfo> sortFieldInfoList) {
        HashSet referToOrderFieldNames = Sets.newHashSetWithExpectedSize((int)sortFieldInfoList.size());
        HashSet realOrderFieldNames = Sets.newHashSetWithExpectedSize((int)sortFieldInfoList.size());
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            if (sortFieldInfo.isDependSort()) {
                referToOrderFieldNames.add(sortFieldInfo.getFieldAlias());
                continue;
            }
            realOrderFieldNames.add(sortFieldInfo.getFieldAlias());
        }
        referToOrderFieldNames.removeAll(realOrderFieldNames);
        this.enumIdFieldNameSet = Sets.newHashSetWithExpectedSize((int)fieldNames.length);
        HashSet baseIdKeySet = Sets.newHashSetWithExpectedSize((int)fieldNames.length);
        this.baseFieldNameToIdMap = Maps.newHashMapWithExpectedSize((int)fieldNames.length);
        HashSet abandonFieldNames = Sets.newHashSetWithExpectedSize((int)fieldNames.length);
        for (String fieldName2 : fieldNames) {
            if (fieldName2.startsWith("ORIGINAL_ENUM_VALUE_")) {
                this.enumIdFieldNameSet.add(fieldName2);
                abandonFieldNames.add(fieldName2.replaceFirst("ORIGINAL_ENUM_VALUE_", ""));
                continue;
            }
            if (!fieldName2.endsWith(".id") && !fieldName2.endsWith("_id")) continue;
            baseIdKeySet.add(fieldName2);
            abandonFieldNames.add(fieldName2);
        }
        for (String idFieldName : baseIdKeySet) {
            String baseDataIdPrefix = idFieldName.substring(0, idFieldName.length() - 3);
            for (String fieldName3 : fieldNames) {
                String fieldPrefix;
                int dotIndex = fieldName3.lastIndexOf(".");
                if (dotIndex <= 0 || !(fieldPrefix = fieldName3.substring(0, dotIndex)).equals(baseDataIdPrefix) || fieldName3.equals(idFieldName)) continue;
                this.baseFieldNameToIdMap.put(fieldName3, idFieldName);
            }
        }
        this.otherFieldNames = Arrays.stream(fieldNames).filter(fieldName -> !this.enumIdFieldNameSet.contains(fieldName) && !this.baseFieldNameToIdMap.containsKey(fieldName) && !abandonFieldNames.contains(fieldName) && !referToOrderFieldNames.contains(fieldName)).collect(Collectors.toSet());
    }

    public Set<String> getEnumIdFieldNameSet() {
        return this.enumIdFieldNameSet;
    }

    public Map<String, String> getBaseFieldNameToIdMap() {
        return this.baseFieldNameToIdMap;
    }

    public Set<String> getOtherFieldNames() {
        return this.otherFieldNames;
    }
}

