/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;

public abstract class PluginAlgoFunction
extends MapFunction {
    private static final long serialVersionUID = 5838309842227736837L;
    protected final HRComplexObjContext context;
    protected final RowMeta oldRowMeta;
    protected final HRComplexObjFieldInfo pluginFieldInfo;
    protected final RowMeta newRowMeta;
    protected final Map<String, Integer> fieldAliasIndexMap;
    protected final String pluginFieldAlgoXAlias;
    protected final DataType pluginFieldDataType;

    public PluginAlgoFunction(HRComplexObjContext context, RowMeta oldRowMeta, HRComplexObjFieldInfo pluginFieldInfo) {
        this.context = context;
        this.oldRowMeta = oldRowMeta;
        this.pluginFieldInfo = pluginFieldInfo;
        this.pluginFieldDataType = AlgoDataTypeTransUtil.getDataType(pluginFieldInfo.getDataType());
        this.newRowMeta = this.getResultRowMeta();
        Field[] newFields = this.newRowMeta.getFields();
        this.fieldAliasIndexMap = Maps.newHashMapWithExpectedSize((int)newFields.length);
        for (int index = 0; index < newFields.length; ++index) {
            Field newField = newFields[index];
            this.fieldAliasIndexMap.put(newField.getAlias(), index);
        }
        this.pluginFieldAlgoXAlias = pluginFieldInfo.getAlias();
    }

    public abstract Object getPluginFieldValue(Row var1);

    public Object[] map(Row row) {
        Field[] fields;
        Object[] result = new Object[this.newRowMeta.getFieldCount()];
        for (Field field : fields = this.newRowMeta.getFields()) {
            Object value;
            String alias = field.getAlias();
            Integer index = this.fieldAliasIndexMap.get(alias);
            if (this.pluginFieldAlgoXAlias.equals(alias)) {
                value = this.getPluginFieldValue(row);
                value = this.pluginFieldDataType.convertValue(value);
            } else {
                value = row.get(index.intValue());
            }
            result[index.intValue()] = value;
        }
        return result;
    }

    public final RowMeta getResultRowMeta() {
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)(this.oldRowMeta.getFieldCount() + 1));
        fields.addAll(Arrays.asList(this.oldRowMeta.getFields()));
        fields.add(new Field(this.pluginFieldInfo.getAlias(), this.pluginFieldDataType));
        return new RowMeta(fields.toArray(new Field[0]));
    }
}

