/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.complexobj.ExtendSortService;
import kd.hr.hbp.business.service.complexobj.enums.ReportSortTypeEnum;
import kd.hr.hbp.business.service.complexobj.util.ComplexObjQFilterUtils;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.business.service.complexobj.util.FieldFullPathParseUtil;
import kd.hr.hbp.business.service.complexobj.util.JoinExprUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjConditionRow;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.complexobj.SortFieldInfo;
import kd.hr.hbp.common.util.HRStringUtils;

public class ComplexObjRouteUtil {
    private static final Log LOGGER = LogFactory.getLog(ComplexObjRouteUtil.class);
    private static final ErrorCode notSupportError = new ErrorCode("not_support", "not_support");

    public static boolean useAlgoXQuery(String queryScheme, HRComplexObjContext context) {
        boolean useAlgoX = false;
        if ("2".equals(queryScheme)) {
            useAlgoX = true;
        } else if (!context.getVirtualEntity().booleanValue() && "0".equals(queryScheme) && !context.isEsQuery()) {
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            DBConfigUtil dbConfigUtil = new DBConfigUtil();
            useAlgoX = ComplexObjRouteUtil.isDiffDbRoute(context, mainEntityTypeUtil, dbConfigUtil) || ComplexObjRouteUtil.groupByFieldExistsThirdBd(context) || ComplexObjRouteUtil.hasCalFieldQFilter(context) || ComplexObjRouteUtil.hasPluginField(context) || ComplexObjRouteUtil.hasFieldEqualsFieldQFilter(context) || !ComplexObjRouteUtil.sortFieldByKSqlEnable(context, mainEntityTypeUtil) || ComplexObjRouteUtil.joinRelationExistsEntry(context) || ComplexObjRouteUtil.joinConditionDiffDb(context, mainEntityTypeUtil, dbConfigUtil) || !ComplexObjRouteUtil.supportCustomSort(context, mainEntityTypeUtil) || ComplexObjRouteUtil.existsPrivacyField(context, mainEntityTypeUtil) || ComplexObjRouteUtil.hasDateSplitAndUserTimeZoneField(context);
        }
        return useAlgoX;
    }

    private static boolean groupByFieldExistsThirdBd(HRComplexObjContext context) {
        if ("2".equals(context.getQueryMode())) {
            List groupFieldList = context.getGroupFieldList();
            Set joinEntityAliasSet = context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
            for (HRComplexObjFieldInfo fieldInfo : groupFieldList) {
                if (!"1".equals(fieldInfo.getFieldType())) {
                    LOGGER.info("complexobj query route: exists calculate group field");
                    return true;
                }
                String[] split = fieldInfo.getFullPath().split("\\.");
                boolean isJoinEntityField = joinEntityAliasSet.contains(split[0]);
                if ((!isJoinEntityField || split.length <= 3) && (isJoinEntityField || split.length <= 2)) continue;
                LOGGER.info("complexobj query route: exists 3 layer basedata group field >> " + fieldInfo.getFullPath());
                return true;
            }
        }
        return false;
    }

    private static boolean sortFieldByKSqlEnable(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        boolean needSync;
        block3: {
            needSync = false;
            try {
                needSync = ComplexObjRouteUtil.sortDataNeedSync(context, mainEntityTypeUtil);
            }
            catch (KDBizException kdExc) {
                if (!notSupportError.equals((Object)kdExc.getErrorCode())) break block3;
                LOGGER.info("not support multilayer basedata sort");
                return false;
            }
        }
        if (!needSync) {
            return true;
        }
        String mainEntityNumber = context.getEntityNumber();
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(mainEntityNumber);
        String dbRouteKey = dataEntityType.getDBRouteKey();
        ExtendSortService extendSortService = new ExtendSortService();
        String sortTable = extendSortService.getBizSortTableByDbRouteKey(dataEntityType.getBizAppNumber(), dbRouteKey, ReportSortTypeEnum.COMMON_SORT.getSortType());
        LOGGER.info("complexobj query route: dbRouteKey:{}, sortTable:{}", (Object)dbRouteKey, (Object)sortTable);
        return HRStringUtils.isNotEmpty((String)sortTable) && extendSortService.checkSortTable(dbRouteKey, sortTable);
    }

    private static boolean supportCustomSort(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        List sortFieldInfoList = context.getSortFieldInfoList();
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            if (sortFieldInfo.isSqlSort()) continue;
            String mainEntityNumber = context.getEntityNumber();
            MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(mainEntityNumber);
            String dbRouteKey = dataEntityType.getDBRouteKey();
            ExtendSortService extendSortService = new ExtendSortService();
            String sortTable = extendSortService.getBizSortTableByDbRouteKey(dataEntityType.getBizAppNumber(), dbRouteKey, ReportSortTypeEnum.SELF_SORT.getSortType());
            return HRStringUtils.isNotEmpty((String)sortTable) && extendSortService.checkSortTable(dbRouteKey, sortTable);
        }
        return true;
    }

    private static boolean sortDataNeedSync(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        ArrayList sortFieldInfoList = new ArrayList(10);
        sortFieldInfoList.addAll(context.getSortFieldInfoList());
        sortFieldInfoList.addAll(context.getColumnSortFieldInfoList());
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            MainEntityType dataEntityType;
            String entityNumber;
            if (sortFieldInfo.isCustomSort()) continue;
            String fieldAlias = sortFieldInfo.getFieldAlias();
            String fieldEntityAlias = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, fieldAlias);
            if (fieldEntityAlias == null) {
                entityNumber = context.getEntityNumber();
            } else {
                entityNumber = relEntityMap.get(fieldEntityAlias);
                fieldAlias = fieldAlias.replaceFirst(fieldEntityAlias + "\\.", "");
            }
            if (!ComplexObjRouteUtil.sortFieldNeedSync((DynamicObjectType)(dataEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber)), fieldAlias)) continue;
            return true;
        }
        return false;
    }

    public static boolean sortFieldNeedSync(DynamicObjectType dataEntityType, String fieldAlias) throws KDBizException {
        String[] split = fieldAlias.split("\\.");
        DynamicProperty property = dataEntityType.getProperty(split[0]);
        String entityDBRouteKey = dataEntityType.getDBRouteKey();
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            fieldAlias = fieldAlias.replaceFirst(split[0] + "\\.", "");
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            if (split.length >= 3 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                fieldAlias = fieldAlias.replaceFirst(split[1] + "\\.", "");
            }
            return ComplexObjRouteUtil.sortFieldNeedSync(entryProp, fieldAlias);
        }
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObjectType complexPropertyType = basedataProp.getDynamicComplexPropertyType();
            String dbRouteKey = ComplexObjRouteUtil.getBaseDataDBRoute(property);
            DynamicProperty secondProp = complexPropertyType.getProperty(split[1]);
            if (dbRouteKey != null && !entityDBRouteKey.equals(dbRouteKey)) {
                if (secondProp instanceof BasedataProp) {
                    throw new KDBizException(notSupportError, new Object[0]);
                }
                LOGGER.info("complexobj query route: entity sort basedata dbRoute difference");
                return true;
            }
            dbRouteKey = ComplexObjRouteUtil.getBaseDataDBRoute(secondProp);
            if (dbRouteKey != null && !entityDBRouteKey.equals(dbRouteKey)) {
                throw new KDBizException(notSupportError, new Object[0]);
            }
        } else {
            return property instanceof ComboProp;
        }
        return false;
    }

    private static String getBaseDataDBRoute(DynamicProperty property) {
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            DynamicObjectType complexPropertyType = basedataProp.getDynamicComplexPropertyType();
            return complexPropertyType.getDBRouteKey();
        }
        return null;
    }

    private static boolean existsPrivacyField(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        List groupFieldList = context.getGroupFieldList();
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        if (groupFieldList.isEmpty() && context.isRouteByPrivacy()) {
            groupFieldList = context.getComplexObjFieldInfoList().stream().filter(field -> !field.isNumber()).collect(Collectors.toList());
        }
        for (HRComplexObjFieldInfo fieldInfo : groupFieldList) {
            String alias = fieldInfo.getAlias();
            if (!ComplexObjRouteUtil.fieldIsPrivacy(context, mainEntityTypeUtil, relEntityMap, alias)) continue;
            return true;
        }
        List sortFieldInfoList = context.getSortFieldInfoList();
        for (SortFieldInfo sortFieldInfo : sortFieldInfoList) {
            String alias = sortFieldInfo.getFieldAlias();
            if (!ComplexObjRouteUtil.fieldIsPrivacy(context, mainEntityTypeUtil, relEntityMap, alias)) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldIsPrivacy(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil, Map<String, String> relEntityMap, String alias) {
        MainEntityType dataEntityType;
        IDataEntityProperty property;
        if (alias.contains("!")) {
            String[] propAliaSplit = alias.split("!");
            alias = propAliaSplit[0];
        }
        String[] fieldAliasArr = alias.split("\\.");
        String firstField = fieldAliasArr[0];
        String entityNumber = context.getEntityNumber();
        if (relEntityMap.get(firstField) != null) {
            entityNumber = relEntityMap.get(firstField);
            alias = alias.replace(firstField + ".", "");
        }
        if ((property = ComplexObjRouteUtil.getFieldRealProperty((DynamicObjectType)(dataEntityType = mainEntityTypeUtil.getMainEntityType(entityNumber)), alias, mainEntityTypeUtil)) instanceof ISimpleProperty && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property)) {
            LOGGER.info("complexobj query route: entity field is privacy field");
            return true;
        }
        return false;
    }

    private static boolean joinConditionDiffDb(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil, DBConfigUtil dbConfigUtil) {
        if (context.getVirtualEntity().booleanValue()) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)context.getJoinRelationList())) {
            return false;
        }
        for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
            List conditionRowList = joinRelation.getCondition();
            for (HRComplexObjConditionRow conditionRow : conditionRowList) {
                if (!conditionRow.isRightFieldItem()) continue;
                String leftItem = conditionRow.getLeftItem();
                String rightItem = conditionRow.getRightItem();
                if (ComplexObjRouteUtil.fieldAndEntityInOneLDB(leftItem, context, mainEntityTypeUtil, dbConfigUtil) && ComplexObjRouteUtil.fieldAndEntityInOneLDB(rightItem, context, mainEntityTypeUtil, dbConfigUtil)) continue;
                LOGGER.info("complexobj query route: entity join cross db ");
                return true;
            }
        }
        return false;
    }

    private static boolean fieldAndEntityInOneLDB(String fieldAlias, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil, DBConfigUtil dbConfigUtil) {
        String curEntityNumber;
        String mainEntityNumber = context.getEntityNumber();
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        String relEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
        if (HRStringUtils.isEmpty((String)relEntityNumber)) {
            curEntityNumber = mainEntityNumber;
        } else {
            curEntityNumber = relEntityNumber;
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String relEntityAlias = fieldAliasArr[0];
            fieldAlias = fieldAlias.replaceFirst(relEntityAlias + "\\.", "");
        }
        MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        return ComplexObjRouteUtil.entityFieldInOneLDB((DynamicObjectType)entityType, fieldAlias, dbConfigUtil);
    }

    private static boolean entityFieldInOneLDB(DynamicObjectType dynamicObjectType, String fieldName, DBConfigUtil dbConfigUtil) {
        if (HRStringUtils.isEmpty((String)fieldName)) {
            return true;
        }
        String[] fieldAliasArr = fieldName.split("\\.");
        DynamicProperty property = dynamicObjectType.getProperty(fieldAliasArr[0]);
        if (property instanceof DynamicComplexProperty) {
            DynamicObjectType complexPropertyType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            String dbRouteKey = complexPropertyType.getDBRouteKey();
            String mainDbRouteKey = dynamicObjectType.getDBRouteKey();
            if (mainDbRouteKey.equals(dbRouteKey) || dbConfigUtil.getDBConfigSharingId(mainDbRouteKey).equals(dbConfigUtil.getDBConfigSharingId(dbRouteKey))) {
                fieldName = fieldName.replaceFirst(fieldAliasArr[0] + "\\.", "");
                return ComplexObjRouteUtil.entityFieldInOneLDB(complexPropertyType, fieldName, dbConfigUtil);
            }
            return false;
        }
        return true;
    }

    public static boolean inOneLDB(String entityNumberA, String entityNumberB, MainEntityTypeUtil mainEntityTypeUtil, DBConfigUtil dbConfigUtil) {
        String dbRouteKeyB;
        if (entityNumberA.equals(entityNumberB)) {
            return true;
        }
        String dbRouteKeyA = mainEntityTypeUtil.getMainEntityType(entityNumberA).getDBRouteKey();
        if (dbRouteKeyA.equals(dbRouteKeyB = mainEntityTypeUtil.getMainEntityType(entityNumberB).getDBRouteKey())) {
            return true;
        }
        String dbSchemaA = dbConfigUtil.getDBConfigSharingId(dbRouteKeyA);
        String dbSchemaB = dbConfigUtil.getDBConfigSharingId(dbRouteKeyB);
        return dbSchemaA.equals(dbSchemaB);
    }

    private static boolean isDiffDbRoute(HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil, DBConfigUtil dbConfigUtil) {
        if (context.getVirtualEntity().booleanValue()) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)context.getJoinRelationList())) {
            return false;
        }
        String mainEntityNumber = context.getEntityNumber();
        for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
            String relEntityNumber = joinRelation.getRelEntityNumber();
            boolean inOneLDB = ComplexObjRouteUtil.inOneLDB(mainEntityNumber, relEntityNumber, mainEntityTypeUtil, dbConfigUtil);
            if (inOneLDB) continue;
            return true;
        }
        return false;
    }

    private static boolean joinRelationExistsEntry(HRComplexObjContext context) {
        for (HRComplexObjJoinRelation joinRelation : context.getJoinRelationList()) {
            if (!JoinExprUtil.conditionContainEntrySplit(joinRelation)) continue;
            LOGGER.info("complexobj query route: join condition exists entry");
            return true;
        }
        return false;
    }

    private static IDataEntityProperty getFieldRealProperty(DynamicObjectType entityType, String originField, MainEntityTypeUtil mainEntityTypeUtil) {
        String[] split = originField.split("\\.");
        if (1 > split.length || split.length > 5) {
            return null;
        }
        if (split.length == 1) {
            return entityType.getProperty(split[0]);
        }
        DynamicProperty property = entityType.getProperty(split[0]);
        if (property instanceof EntryProp) {
            DynamicProperty tempProp;
            DynamicObjectType entryProp = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            originField = originField.replaceFirst(split[0] + "\\.", "");
            if (split.length >= 3 && (tempProp = entryProp.getProperty(split[1])) instanceof SubEntryProp) {
                entryProp = ((SubEntryProp)tempProp).getDynamicCollectionItemPropertyType();
                originField = originField.replaceFirst(split[1] + "\\.", "");
            }
            return ComplexObjRouteUtil.getFieldRealProperty(entryProp, originField, mainEntityTypeUtil);
        }
        if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            String newProp = originField.replaceFirst(split[0] + "\\.", "");
            return ComplexObjRouteUtil.getFieldRealProperty((DynamicObjectType)mainEntityTypeUtil.getMainEntityType(basedataProp.getBaseEntityId()), newProp, mainEntityTypeUtil);
        }
        return property;
    }

    private static boolean hasCalFieldQFilter(HRComplexObjContext context) {
        Map calFieldInfoMap = context.getComplexObjFieldInfoList().stream().filter(field -> "2".equals(field.getFieldType()) || "3".equals(field.getFieldType())).collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, Function.identity(), (x, y) -> y));
        List qFilterList = context.getQfilterList();
        for (QFilter filter : qFilterList) {
            String property = filter.getProperty();
            HRComplexObjFieldInfo fieldInfo = (HRComplexObjFieldInfo)calFieldInfoMap.get(property);
            if (fieldInfo != null) {
                return true;
            }
            List nests = filter.getNests(true);
            if (nests.isEmpty()) continue;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (calFieldInfoMap.get(nestFilter.getProperty()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPluginField(HRComplexObjContext context) {
        return context.getComplexObjFieldInfoList().stream().anyMatch(field -> "4".equals(field.getFieldType()));
    }

    private static boolean hasFieldEqualsFieldQFilter(HRComplexObjContext context) {
        List qFilterList = context.getQfilterList();
        for (QFilter filter : qFilterList) {
            if (!ComplexObjQFilterUtils.fieldEqualsQFilterCheck(filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDateSplitAndUserTimeZoneField(HRComplexObjContext context) {
        List fieldInfoList = context.getComplexObjFieldInfoList();
        List dateSpFieldList = fieldInfoList.stream().filter(fieldInfo -> fieldInfo.getAlias().contains("!")).collect(Collectors.toList());
        TimeZone sysTimeZone = KDDateUtils.getTimeZone();
        for (HRComplexObjFieldInfo fieldInfo2 : dateSpFieldList) {
            if (fieldInfo2.getTimeZoneInfo() == null || fieldInfo2.getTimeZoneInfo().getTimeZoneTransType() != 1 || HRStringUtils.equals((String)sysTimeZone.getID(), (String)fieldInfo2.getTimeZoneInfo().getTimeZone())) continue;
            return true;
        }
        return false;
    }
}

