/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.model.EntityFieldInfo;
import kd.hr.hbp.business.service.complexobj.util.AlgoDataTypeTransUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjFieldInfo;

public class DataSetTransUtil {
    public static DataSet convertToDataSet(HRComplexObjContext context, List<Map<String, Object>> dataList, List<EntityFieldInfo> fieldInfoList, List<HRComplexObjFieldInfo> calFieldList, Table<String, String, String> aliasToOrderFieldTable) {
        if (dataList == null || fieldInfoList == null) {
            return null;
        }
        Map<String, DataType> aliasDataTypeMap = DataSetTransUtil.getFieldAliasDataTypeMap(fieldInfoList);
        aliasDataTypeMap.putAll(DataSetTransUtil.getCalFieldAliasDataTypeMap(calFieldList));
        aliasDataTypeMap.putAll(DataSetTransUtil.getOrderFieldAliasDataTypeMap(aliasToOrderFieldTable));
        if (!context.isTransferField()) {
            Set notTransferFields = context.getComplexObjFieldInfoList().stream().filter(field -> !field.isTransfer()).map(HRComplexObjFieldInfo::getAlias).collect(Collectors.toSet());
            for (Map.Entry<String, DataType> aliasDataTypeEntry : aliasDataTypeMap.entrySet()) {
                DataType value;
                if (notTransferFields.contains(aliasDataTypeEntry.getKey()) || !DataType.BooleanType.equals((Object)(value = aliasDataTypeEntry.getValue())) && !DataType.TimestampType.equals((Object)value)) continue;
                aliasDataTypeEntry.setValue((DataType)DataType.StringType);
            }
        }
        RowMeta rowMeta = DataSetTransUtil.genRowMeta(aliasDataTypeMap);
        Set<String> columns = aliasDataTypeMap.keySet();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>(10);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            ArrayList value = new ArrayList(10);
            Object rowNumObj = dataMap.get("rptdbsortidx");
            if (rowNumObj == null) {
                value.add(i + 1);
            } else {
                value.add(Integer.valueOf(rowNumObj.toString()));
            }
            for (String column : columns) {
                value.add(dataMap.get(column));
            }
            rowList.add(value.toArray());
        }
        String algoKey = "kd.hr.hbp.business.service.complexobj.util.DataSetTransUtil_";
        DataSetBuilder dataSetBuilder = Algo.create((String)algoKey).createDataSetBuilder(rowMeta);
        for (Object[] objects : rowList) {
            dataSetBuilder.append(objects);
        }
        DataSet dataSet = dataSetBuilder.build();
        return dataSet;
    }

    private static RowMeta genRowMeta(Map<String, DataType> aliasDataTypeMap) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>(aliasDataTypeMap.size());
        ArrayList<IntegerType> dataTypes = new ArrayList<IntegerType>(aliasDataTypeMap.size());
        columns.add("rptdbsortidx");
        dataTypes.add(DataType.IntegerType);
        aliasDataTypeMap.forEach((key, value) -> {
            columns.add((String)key);
            dataTypes.add((IntegerType)value);
        });
        DataType[] dataTypeArr = dataTypes.toArray(new DataType[0]);
        String[] columnArr = columns.toArray(new String[0]);
        return RowMetaFactory.createRowMeta((String[])columnArr, (DataType[])dataTypeArr);
    }

    private static Map<String, DataType> getFieldAliasDataTypeMap(List<EntityFieldInfo> fieldInfoList) {
        Map dataTypeMap = fieldInfoList.stream().collect(Collectors.toMap(EntityFieldInfo::getAlias, fieldInfo -> AlgoDataTypeTransUtil.getDataType(fieldInfo.getDataType()), (k1, k2) -> k1, () -> new HashMap(fieldInfoList.size())));
        return dataTypeMap;
    }

    private static Map<String, DataType> getCalFieldAliasDataTypeMap(List<HRComplexObjFieldInfo> calFieldList) {
        if (CollectionUtils.isEmpty(calFieldList)) {
            return new HashMap<String, DataType>(0);
        }
        return calFieldList.stream().collect(Collectors.toMap(HRComplexObjFieldInfo::getAlias, fieldInfo -> AlgoDataTypeTransUtil.getDataType(fieldInfo.getDataType()), (k1, k2) -> k1));
    }

    private static Map<String, DataType> getOrderFieldAliasDataTypeMap(Table<String, String, String> aliasToOrderFieldTable) {
        if (aliasToOrderFieldTable == null || aliasToOrderFieldTable.isEmpty()) {
            return new HashMap<String, DataType>(0);
        }
        return aliasToOrderFieldTable.values().stream().filter(orderField -> orderField.startsWith("custom_sort")).collect(Collectors.toMap(orderField -> orderField, orderField -> DataType.IntegerType, (k1, k2) -> k1));
    }
}

